/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemAxe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicEntities;
import tragicneko.tragicmc.entity.miniboss.EntityMagmox;
import tragicneko.tragicmc.entity.miniboss.TragicMiniBoss;
import tragicneko.tragicmc.entity.mob.TragicMob;
import tragicneko.tragicmc.entity.projectile.EntitySpore;
import tragicneko.tragicmc.items.weapons.ItemScythe;
import tragicneko.tragicmc.worldgen.biome.BiomeGenPaintedForest;

public class EntityTox
extends TragicMob {
    public static final int DW_TOX_TYPE = 20;
    public static final int DW_FIRING_TICKS = 21;
    public static final int DW_ATTACK_TIME = 22;
    public static final int DW_WIGGLE_TIME = 23;

    public EntityTox(World par1World) {
        super(par1World);
        this.field_70728_aV = 60;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 0.05, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 64.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 32.0f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, playerTarget));
        if (this.superiorForm == null && !(this instanceof TragicMiniBoss)) {
            this.superiorForm = EntityMagmox.class;
        }
    }

    @Override
    public boolean isMobVariant() {
        return this.getToxType() == 1;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    public byte getToxType() {
        return this.field_70180_af.func_75683_a(20);
    }

    protected void setToxType(byte b) {
        this.field_70180_af.func_75692_b(20, (Object)b);
    }

    public int getFiringTicks() {
        return this.field_70180_af.func_75679_c(21);
    }

    protected void setFiringTicks(int i) {
        this.field_70180_af.func_75692_b(21, (Object)i);
    }

    protected void decrementFiringTicks() {
        int pow = this.getFiringTicks();
        this.setFiringTicks(--pow);
    }

    public boolean isFiring() {
        return this.getFiringTicks() > 0;
    }

    public int getAttackTime() {
        return this.field_70180_af.func_75679_c(22);
    }

    protected void setAttackTime(int i) {
        this.field_70180_af.func_75692_b(22, (Object)i);
    }

    protected void decrementAttackTime() {
        int pow = this.getAttackTime();
        this.setAttackTime(--pow);
    }

    public int getWiggleTime() {
        return this.field_70180_af.func_75679_c(23);
    }

    protected void setWiggleTime(int i) {
        this.field_70180_af.func_75692_b(23, (Object)i);
    }

    protected void decrementWiggleTime() {
        int pow = this.getWiggleTime();
        this.setWiggleTime(--pow);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        return this.getToxType() == 1 ? 0xF000F0 : super.func_70070_b(par1);
    }

    public float func_70013_c(float par1) {
        return this.getToxType() == 1 ? 1.0f : super.func_70013_c(par1);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return TragicEntities.Natural;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] stats = TragicConfig.getMobStat(this.getToxType() == 0 ? "toxStats" : "poxStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(stats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(stats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(stats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(stats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(stats[4]);
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70181_x > 0.0) {
                this.field_70181_x = -0.1;
            }
            if (Math.abs(this.field_70159_w) > 0.25) {
                this.field_70159_w *= 0.225;
            }
            if (Math.abs(this.field_70179_y) > 0.25) {
                this.field_70179_y *= 0.225;
            }
            if (this.func_70644_a(Potion.field_76436_u)) {
                this.func_82170_o(Potion.field_76436_u.field_76415_H);
            }
        }
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.getToxType() == 0) {
                if ((this.getWiggleTime() > 0 || this.isFiring() || this.getAttackTime() > 0) && !this.func_70045_F()) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB_AMBIENT, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.5, (this.field_70146_Z.nextDouble() - 0.6) * 0.1, this.field_70146_Z.nextDouble() * 0.1, (this.field_70146_Z.nextDouble() - 0.6) * 0.1, new int[0]);
                }
            } else if (this.getWiggleTime() > 0 || this.isFiring() || this.getAttackTime() > 0) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SLIME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.5, (this.field_70146_Z.nextDouble() - 0.6) * 0.1, this.field_70146_Z.nextDouble() * 0.1, (this.field_70146_Z.nextDouble() - 0.6) * 0.1, new int[0]);
            }
        } else {
            int rate;
            if (this.getWiggleTime() > 0) {
                this.decrementWiggleTime();
                if (this.func_70638_az() != null) {
                    this.setWiggleTime(0);
                }
            }
            if (this.isFiring()) {
                this.decrementFiringTicks();
            }
            if (this.getAttackTime() > 0) {
                this.decrementAttackTime();
            }
            if (this.field_70173_aa % 60 == 0 && this.field_70146_Z.nextInt(4) == 0 && this.func_70638_az() == null) {
                this.setWiggleTime(20);
            }
            if (this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) >= 2.0f && this.field_70173_aa % 20 == 0 && this.field_70146_Z.nextInt(4) == 0 && !this.isFiring()) {
                this.setFiringTicks(120);
            }
            int n = rate = this.getToxType() == 0 ? 10 : 5;
            if (this.getFiringTicks() >= 40 && this.field_70173_aa % rate == 0 && this.func_70638_az() != null && this.func_70685_l((Entity)this.func_70638_az()) && this.func_70032_d((Entity)this.func_70638_az()) >= 2.0f) {
                this.shootProjectiles();
            }
            if (this.field_70173_aa % 60 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(3.0f);
            }
        }
    }

    protected void shootProjectiles() {
        this.fireProjectileAtEntity(new EntitySpore(this.field_70170_p), (Entity)this.func_70638_az(), 0.0f);
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        boolean result;
        EntityPlayer player;
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.isFiring()) {
            this.setFiringTicks(19);
        }
        if (this.getWiggleTime() > 0) {
            this.setWiggleTime(0);
        }
        if (par1DamageSource.func_76346_g() != null && par1DamageSource.func_76346_g() instanceof EntityPlayer && (player = (EntityPlayer)par1DamageSource.func_76346_g()).func_71045_bC() != null && (player.func_71045_bC().func_77973_b() instanceof ItemScythe || player.func_71045_bC().func_77973_b() instanceof ItemAxe)) {
            par2 = (float)((double)par2 * 1.425);
        }
        if (par1DamageSource.func_76347_k()) {
            par2 = (float)((double)par2 * 1.625);
        }
        if (result = super.func_70097_a(par1DamageSource, par2)) {
            this.setAttackTime(5);
        }
        return result;
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        boolean result = super.func_70652_k(par1Entity);
        if (result && par1Entity instanceof EntityLivingBase && this.field_70146_Z.nextInt(16) == 0 && !this.func_70045_F()) {
            ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 600, 1));
        }
        return result;
    }

    public int func_70658_aO() {
        return this.isFiring() ? 0 : TragicConfig.getMobStat(this.getToxType() == 0 ? "toxStats" : "poxStats").getArmorValue();
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("toxType")) {
            this.setToxType(tag.func_74771_c("toxType"));
        }
        if (tag.func_74764_b("firingTicks")) {
            this.setFiringTicks(tag.func_74762_e("firingTicks"));
        }
        if (tag.func_74764_b("attackTime")) {
            this.setAttackTime(tag.func_74762_e("attackTime"));
        }
        if (tag.func_74764_b("wiggleTime")) {
            this.setWiggleTime(tag.func_74762_e("wiggleTime"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74774_a("toxType", this.getToxType());
        tag.func_74768_a("firingTicks", this.getFiringTicks());
        tag.func_74768_a("attackTime", this.getAttackTime());
        tag.func_74768_a("wiggleTime", this.getWiggleTime());
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance ins, IEntityLivingData data) {
        BiomeGenBase biome = this.field_70170_p.func_180494_b(new BlockPos((int)this.field_70165_t, 0, (int)this.field_70161_v));
        this.setToxType(biome instanceof BiomeGenPaintedForest ? (byte)1 : 0);
        return super.func_180482_a(ins, data);
    }

    @Override
    protected boolean isChangeAllowed() {
        return this.getToxType() == 0 && TragicConfig.getBoolean("allowMagmox");
    }

    public String func_70639_aQ() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.tox.living" : null;
    }

    public String func_70621_aR() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.tox.hurt" : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.tox.hurt" : null;
    }

    public float func_70647_i() {
        return this.getToxType() == 1 ? 1.4f : 1.0f;
    }

    public float func_70599_aP() {
        return 0.9f + this.field_70146_Z.nextFloat();
    }

    public int func_70627_aG() {
        return super.func_70627_aG();
    }

    protected void func_180429_a(BlockPos pos, Block block) {
    }

    @Override
    public String getVariantName() {
        return "TragicMC.Pox";
    }

    @Override
    protected void updateSize() {
        if (this.getToxType() == 0) {
            this.func_70105_a(0.625f, 1.965f);
        } else {
            this.field_70728_aV = 6;
            this.func_70105_a(0.396875f, 1.247775f);
        }
    }
}

