/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import com.google.common.base.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.entity.mob.EntityNeko;
import tragicneko.tragicmc.util.DamageHelper;

public class EntityScienceNeko
extends EntityNeko {
    private static final int DW_TARGET_ID = 25;
    public static final Predicate undeadTarget = new Predicate(){

        public boolean apply(Object input) {
            return this.canApply((Entity)input);
        }

        public boolean canApply(Entity entity) {
            return entity instanceof EntityMob && ((EntityMob)entity).func_70668_bt() == EnumCreatureAttribute.UNDEAD;
        }
    };

    public EntityScienceNeko(World par1World) {
        super(par1World);
        this.func_70105_a(0.577125f, 1.6202251f);
        this.field_70728_aV = 50;
        if (TragicConfig.getBoolean("scienceNekoTargetsUndead")) {
            this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 0, true, false, undeadTarget));
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(25, (Object)0);
    }

    public int getTargetID() {
        return this.field_70180_af.func_75679_c(25);
    }

    private void setTargetID(int i) {
        this.field_70180_af.func_75692_b(25, (Object)i);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] scienceNekoStats = TragicConfig.getMobStat("scienceNekoStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(scienceNekoStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(scienceNekoStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(scienceNekoStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(scienceNekoStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(scienceNekoStats[4]);
    }

    public int func_70658_aO() {
        return TragicConfig.getMobStat("scienceNekoStats").getArmorValue();
    }

    @Override
    public void func_70636_d() {
        for (int i = 0; i < 256; ++i) {
            if (Potion.field_76425_a[i] == null || !this.func_82165_m(i)) continue;
            this.func_82170_o(i);
        }
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            Entity entity;
            if (this.getFiringTicks() == 40 && (entity = this.field_70170_p.func_73045_a(this.getTargetID())) != null && (double)this.func_70032_d(entity) > 4.0) {
                double d0 = entity.field_70165_t - this.field_70165_t;
                double d1 = entity.field_70163_u - this.field_70163_u;
                double d2 = entity.field_70161_v - this.field_70161_v;
                for (int l = 0; l < 8; l = (int)((byte)(l + 1))) {
                    double d3 = 0.123 * (double)l + this.field_70146_Z.nextDouble() * 0.125;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + d0 * d3, this.field_70163_u + d1 * d3 + 1.25, this.field_70161_v + d2 * d3, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            return;
        }
        if (this.func_70638_az() != null && !this.isProperDate()) {
            if (this.getFlickTime() > 0) {
                this.setFlickTime(0);
            }
            this.setTargetID(this.func_70638_az().func_145782_y());
            if (this.getFiringTicks() == 40 && this.func_70685_l((Entity)this.func_70638_az()) && (double)this.func_70032_d((Entity)this.func_70638_az()) <= 16.0 && (double)this.func_70032_d((Entity)this.func_70638_az()) >= 4.0) {
                if (TragicConfig.getBoolean("scienceNekoLaser")) {
                    this.doMissleAttack();
                }
            } else if (this.hasFired() && this.getFiringTicks() % 40 == 0 && this.getAttackTime() == 0 && this.field_70146_Z.nextBoolean() && (double)this.func_70032_d((Entity)this.func_70638_az()) >= 5.0 && (double)this.func_70032_d((Entity)this.func_70638_az()) <= 12.0 && TragicConfig.getBoolean("scienceNekoPotions")) {
                this.throwRandomProjectile();
                this.setThrowingTicks(20);
            }
            if (this.field_70146_Z.nextInt(16) == 0 && this.canFire() && this.field_70173_aa % 10 == 0 && this.getAttackTime() == 0 && this.func_70032_d((Entity)this.func_70638_az()) >= 3.0f) {
                this.setFiringTicks(0);
            }
        }
        if (this.func_70638_az() == null) {
            this.setTargetID(0);
        }
    }

    @Override
    protected void doMissleAttack() {
        if (TragicConfig.getBoolean("allowMobSounds")) {
            this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.aegar.laser", 0.4f, 1.8f);
            this.field_70170_p.func_72956_a((Entity)this.func_70638_az(), "tragicmc:boss.aegar.laser", 0.4f, 1.8f);
        }
        this.func_70638_az().func_70097_a(DamageHelper.causeArmorPiercingDamageToEntity((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
    }

    @Override
    protected void throwRandomProjectile() {
        int i = this.field_70146_Z.nextInt(32) == 0 ? 8 : (this.field_70146_Z.nextInt(16) == 0 ? 4 : 42);
        EntityPotion theProjectile = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, new ItemStack((Item)Items.field_151068_bn, 1, i));
        theProjectile.field_70159_w = (this.func_70638_az().field_70165_t - this.field_70165_t) * 0.335;
        theProjectile.field_70179_y = (this.func_70638_az().field_70161_v - this.field_70161_v) * 0.335;
        theProjectile.field_70181_x = (this.func_70638_az().field_70163_u - this.field_70163_u) * 0.335;
        this.field_70170_p.func_72838_d((Entity)theProjectile);
    }

    @Override
    public String func_70639_aQ() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.scienceneko.living" : null;
    }

    @Override
    public String func_70621_aR() {
        return TragicConfig.getBoolean("allowMobSounds") && this.field_70146_Z.nextInt(6) == 0 ? "tragicmc:mob.scienceneko.hurt" : super.func_70621_aR();
    }

    @Override
    public String func_70673_aS() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.scienceneko.death" : null;
    }

    @Override
    public float func_70647_i() {
        return 1.0f;
    }

    @Override
    public float func_70599_aP() {
        return 0.65f;
    }

    @Override
    public int func_70627_aG() {
        return 320 + this.field_70146_Z.nextInt(120);
    }
}

