/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import com.google.common.base.Predicate;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicEntities;
import tragicneko.tragicmc.entity.mob.TragicMob;

public class EntityPirah
extends TragicMob {
    public static final int DW_AIR_TICKS = 20;
    public static final int DW_TEXTURE_ID = 21;
    public static final Predicate nonSpeciesTarget = new Predicate(){

        public boolean apply(Object input) {
            return this.canApply((Entity)input);
        }

        public boolean canApply(Entity entity) {
            return !(entity instanceof EntityPirah);
        }
    };

    public EntityPirah(World par1World) {
        super(par1World);
        this.field_70728_aV = 40;
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.7));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 32.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 32.0f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, false, nonSpeciesTarget));
    }

    @Override
    public boolean isMobVariant() {
        return this.getTextureID() == 7;
    }

    @Override
    public boolean canCorrupt() {
        return false;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return TragicEntities.Beast;
    }

    public boolean func_70072_I() {
        if (this.func_70027_ad()) {
            this.func_70066_B();
        }
        return false;
    }

    public void func_70050_g(int i) {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        boolean flag = this.getTextureID() == 7 && TragicConfig.getBoolean("pirahGolden");
        double[] stats = TragicConfig.getMobStat(flag ? "goldenPirahStats" : "pirahStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(stats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(stats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(stats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(stats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(stats[4]);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
    }

    protected void setAirTicks(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    public int getAirTicks() {
        return this.field_70180_af.func_75679_c(20);
    }

    protected void incrementAirTicks() {
        int pow = this.getAirTicks();
        this.setAirTicks(++pow);
    }

    protected void decrementAirTicks() {
        int pow = this.getAirTicks();
        this.setAirTicks(--pow);
    }

    protected void setTextureID(byte b) {
        this.field_70180_af.func_75692_b(21, (Object)b);
        if (b == 7 && TragicConfig.getBoolean("pirahGolden")) {
            this.field_70728_aV = 12;
        }
    }

    public byte getTextureID() {
        return this.field_70180_af.func_75683_a(21);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.func_70055_a(this.getMaterial())) {
                // empty if block
            }
        } else if (this.func_70055_a(this.getMaterial())) {
            if (this.func_70638_az() != null && !this.func_70638_az().func_70055_a(this.getMaterial())) {
                this.func_70624_b(null);
            }
            this.field_70143_R = 0.0f;
            if (this.field_70173_aa % 5 == 0) {
                this.field_70181_x += (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble() + 0.625) * 0.725;
                this.field_70159_w += (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.825;
                this.field_70179_y += (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.825;
                if (this.func_70638_az() == null) {
                    if (this.field_70173_aa % 10 == 0) {
                        this.field_70159_w = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.625;
                        this.field_70181_x = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.435;
                        this.field_70179_y = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.625;
                    }
                } else {
                    double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                    double d1 = this.func_70638_az().field_70163_u - this.field_70163_u;
                    double d2 = this.func_70638_az().field_70161_v - this.field_70161_v;
                    float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    this.field_70159_w = d0 / (double)f2 * 0.75 * 0.150000011920929 + this.field_70159_w * (double)0.2f;
                    this.field_70181_x = d1 * 0.10000000298023223;
                    this.field_70179_y = d2 / (double)f2 * 0.75 * 0.150000011920929 + this.field_70179_y * (double)0.2f;
                    if (this.func_70638_az().field_70128_L) {
                        this.func_70624_b(null);
                    }
                }
            }
            if (this.getAirTicks() < 100) {
                this.incrementAirTicks();
            }
        } else {
            this.func_70624_b(null);
            if (this.getAirTicks() > 0) {
                this.decrementAirTicks();
            }
            if (this.field_70173_aa % 20 == 0 && this.getAirTicks() == 0) {
                this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
            if (this.field_70173_aa % 4 == 0 && this.field_70181_x <= 0.0 && World.func_175683_a((IBlockAccess)this.field_70170_p, (BlockPos)new BlockPos((int)this.field_70165_t, MathHelper.func_76143_f((double)this.field_70163_u) - 1, (int)this.field_70161_v))) {
                this.field_70181_x = 0.35 + this.field_70146_Z.nextDouble() * 0.25;
            }
            this.field_70159_w = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
            this.field_70179_y = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
        }
    }

    public void func_70091_d(double d0, double d1, double d2) {
        if (this.func_70055_a(this.getMaterial())) {
            super.func_70091_d(d0, d1, d2);
        } else {
            super.func_70091_d(d0 * 0.315, d1, d2 * 0.315);
        }
    }

    public int func_70658_aO() {
        boolean flag = this.getTextureID() == 7 && TragicConfig.getBoolean("pirahGolden");
        return TragicConfig.getMobStat(flag ? "goldenPirahStats" : "pirahStats").getArmorValue();
    }

    protected Material getMaterial() {
        return Material.field_151586_h;
    }

    public boolean func_70601_bi() {
        return this.field_70163_u > 35.0 && this.field_70163_u < 65.0 && this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_72945_a((Entity)this, this.func_174813_aQ()).isEmpty() && this.func_70055_a(this.getMaterial());
    }

    public void func_180430_e(float dist, float multi) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.func_70055_a(this.getMaterial())) {
            this.field_70159_w = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
            this.field_70179_y = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
            this.field_70181_x = this.field_70146_Z.nextDouble();
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("airTicks")) {
            this.setAirTicks(tag.func_74762_e("airTicks"));
        }
        if (tag.func_74764_b("textureID")) {
            this.setTextureID(tag.func_74771_c("textureID"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("airTicks", this.getAirTicks());
        tag.func_74774_a("textureID", this.getTextureID());
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance ins, IEntityLivingData data) {
        if (!this.field_70170_p.field_72995_K) {
            byte i = (byte)this.field_70146_Z.nextInt(8);
            if (i == 7) {
                i = (byte)this.field_70146_Z.nextInt(8);
            }
            this.setTextureID(i);
        }
        return super.func_180482_a(ins, data);
    }

    @Override
    protected boolean isChangeAllowed() {
        return false;
    }

    @Override
    public String getVariantName() {
        return "TragicMC.GoldenPirah";
    }

    @Override
    protected void updateSize() {
        float w = 0.325f;
        float h = 0.515f;
        if (this.getTextureID() == 7 && TragicConfig.getBoolean("pirahGolden")) {
            w *= 1.5f;
            h *= 1.5f;
        }
        this.func_70105_a(w, h);
    }
}

