/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicEntities;
import tragicneko.tragicmc.entity.miniboss.EntityJarra;
import tragicneko.tragicmc.entity.miniboss.TragicMiniBoss;
import tragicneko.tragicmc.entity.mob.TragicMob;
import tragicneko.tragicmc.properties.PropertyDoom;
import tragicneko.tragicmc.worldgen.biome.BiomeGenPaintedForest;

public class EntityJabba
extends TragicMob {
    public static final int DW_ANGER_TICKS = 20;
    public static final int DW_JABBA_TYPE = 21;
    public static final int DW_ATTACK_TICKS = 22;
    public static final int DW_WORM_TICKS = 23;
    private static AttributeModifier lowHealthDamageBoost = new AttributeModifier(UUID.fromString("8c159dc4-aacf-461f-b3e9-66dc9fbf6e99"), "jabbaLowHealthDamageBoost", TragicConfig.modifier[6], 0);

    public EntityJabba(World par1World) {
        super(par1World);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 50;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.65));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 32.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 32.0f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, playerTarget));
        if (this.superiorForm == null && !(this instanceof TragicMiniBoss)) {
            this.superiorForm = EntityJarra.class;
        }
    }

    @Override
    protected boolean canCorrupt() {
        return this.getJabbaType() == 0;
    }

    @Override
    public boolean isMobVariant() {
        return this.getJabbaType() == 1;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    protected void setAngerTicks(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    public int getAngerTicks() {
        return this.field_70180_af.func_75679_c(20);
    }

    protected void incrementAngerTicks() {
        int pow = this.getAngerTicks();
        this.setAngerTicks(++pow);
    }

    protected void decrementAngerTicks() {
        int pow = this.getAngerTicks();
        this.setAngerTicks(--pow);
    }

    public byte getJabbaType() {
        return this.field_70180_af.func_75683_a(21);
    }

    protected void setJabbaType(byte b) {
        this.field_70180_af.func_75692_b(21, (Object)b);
    }

    public int getAttackTicks() {
        return this.field_70180_af.func_75679_c(22);
    }

    protected void setAttackTicks(int i) {
        this.field_70180_af.func_75692_b(22, (Object)i);
    }

    protected void decrementAttackTicks() {
        int pow = this.getAttackTicks();
        this.setAttackTicks(--pow);
    }

    public int getWormTicks() {
        return this.field_70180_af.func_75679_c(23);
    }

    protected void setWormTicks(int i) {
        this.field_70180_af.func_75692_b(23, (Object)i);
    }

    protected void decrementWormTicks() {
        int pow = this.getWormTicks();
        this.setWormTicks(--pow);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return TragicEntities.Natural;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        return 0xF000F0;
    }

    public float func_70013_c(float par1) {
        return 1.0f;
    }

    public boolean func_90999_ad() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] stats = TragicConfig.getMobStat(this.getJabbaType() == 0 ? "jabbaStats" : "jannaStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(stats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(stats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(stats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(stats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(stats[4]);
    }

    public int func_70658_aO() {
        return TragicConfig.getMobStat(this.getJabbaType() == 0 ? "jabbaStats" : "jannaStats").getArmorValue();
    }

    @Override
    public void func_70636_d() {
        if (this.getWormTicks() > 0) {
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
        }
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            this.doParticleEffects();
        } else {
            EntityPlayer player;
            if (this.func_70638_az() != null && this.getWormTicks() > 0) {
                this.setWormTicks(0);
            }
            if (this.getWormTicks() > 0) {
                this.decrementWormTicks();
            }
            if (this.getAttackTicks() > 0) {
                this.decrementAttackTicks();
            }
            if (this.getJabbaType() == 0 && TragicConfig.getBoolean("jabbaAnger")) {
                if (this.func_70638_az() != null) {
                    this.incrementAngerTicks();
                    if (this.isCorrupted()) {
                        this.incrementAngerTicks();
                    }
                } else if (this.getAngerTicks() > 0) {
                    this.decrementAngerTicks();
                }
            } else {
                this.setAngerTicks(0);
            }
            if (this.getAngerTicks() >= 400 && this.func_70638_az() != null) {
                if (this.field_70173_aa % 100 == 0) {
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.5f * this.field_70146_Z.nextFloat(), false);
                }
                if (this.field_70173_aa % 40 == 0) {
                    this.spawnProjectiles();
                }
                if (this.getAttackTicks() == 0) {
                    this.setAttackTicks(10);
                }
            }
            if (this.func_70026_G()) {
                this.func_70097_a(DamageSource.field_76369_e, 5.0f);
            }
            if (this.field_70173_aa % 20 == 0 && this.field_70146_Z.nextInt(3) == 0 && (player = this.field_70170_p.func_72890_a((Entity)this, 10.0)) != null && TragicConfig.getBoolean("allowDoom") && this.func_70685_l((Entity)player)) {
                PropertyDoom doom = PropertyDoom.get(player);
                int i = this.field_70170_p.func_175659_aa().func_151525_a();
                if (doom != null) {
                    doom.increaseDoom(-((this.field_70146_Z.nextInt(3) + 1) * i));
                }
            }
            if (this.func_70638_az() == null && this.field_70173_aa % 60 == 0 && this.field_70146_Z.nextInt(32) == 0 && this.getAttackTicks() == 0) {
                this.setAttackTicks(60);
            }
            if (this.func_70638_az() == null && this.field_70173_aa % 10 == 0 && this.field_70146_Z.nextInt(48) == 0 && this.getWormTicks() == 0) {
                this.setWormTicks(60);
            }
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(lowHealthDamageBoost);
            if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(lowHealthDamageBoost);
            }
        }
    }

    protected void doParticleEffects() {
        EnumParticleTypes s1 = this.getJabbaType() == 0 ? EnumParticleTypes.DRIP_LAVA : EnumParticleTypes.SLIME;
        for (int k = 0; k < 3; k = (int)((byte)(k + 1))) {
            this.field_70170_p.func_175688_a(s1, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 0.95, this.field_70163_u + this.field_70146_Z.nextDouble() * 0.15, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 0.95, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.func_110143_aJ() > this.func_110138_aP() / 2.0f) {
            return;
        }
        EnumParticleTypes s = this.getJabbaType() == 0 ? EnumParticleTypes.FLAME : EnumParticleTypes.SLIME;
        for (int l = 0; l < 3; l = (int)((byte)(l + 1))) {
            this.field_70170_p.func_175688_a(s, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.5, (this.field_70146_Z.nextDouble() - 0.6) * 0.1, this.field_70146_Z.nextDouble() * 0.1, (this.field_70146_Z.nextDouble() - 0.6) * 0.1, new int[0]);
        }
    }

    protected void spawnProjectiles() {
        if (!TragicConfig.getBoolean("jabbaProjectiles")) {
            return;
        }
        EntityLivingBase entity = this.func_70638_az();
        double d0 = entity.field_70165_t - this.field_70165_t;
        double d1 = entity.func_174813_aQ().field_72338_b + (double)(entity.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
        double d2 = entity.field_70161_v - this.field_70161_v;
        float f1 = MathHelper.func_76129_c((float)this.func_70032_d((Entity)entity)) * 0.5f;
        for (int i = 0; i < 5; i = (int)((byte)(i + 1))) {
            EntitySmallFireball entitysmallfireball = new EntitySmallFireball(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
            entitysmallfireball.field_70163_u = this.field_70163_u + 0.5;
            this.field_70170_p.func_72838_d((Entity)entitysmallfireball);
            if (this.getAngerTicks() < 50) continue;
            this.setAngerTicks(this.getAngerTicks() - 50);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        Boolean result;
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
            par2 /= 2.0f;
        }
        if ((result = Boolean.valueOf(super.func_70097_a(par1DamageSource, par2))).booleanValue() && this.getWormTicks() > 0) {
            this.setWormTicks(0);
        }
        if (this.field_70146_Z.nextInt(8) == 0 && this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && result.booleanValue() && par1DamageSource.func_76346_g() != null && par1DamageSource.func_76346_g() instanceof EntityPlayer && !par1DamageSource.func_76352_a() && !par1DamageSource.func_82725_o() && !par1DamageSource.func_76347_k()) {
            EntityPlayer player = (EntityPlayer)par1DamageSource.func_76346_g();
            if (player.func_71045_bC() != null && !player.field_71075_bZ.field_75098_d && this.field_70146_Z.nextBoolean()) {
                player.func_71040_bB(true);
            } else if (this.field_70146_Z.nextInt(4) == 0) {
                player.func_70015_d(4 + this.field_70146_Z.nextInt(3));
            }
            if (!player.field_70122_E) {
                this.setAngerTicks(this.getAngerTicks() + 25);
            }
        }
        if (result.booleanValue() || par1DamageSource == DamageSource.field_76369_e) {
            this.setAngerTicks(this.getAngerTicks() + 50);
            this.setAttackTicks(5);
        }
        return result;
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        boolean result = super.func_70652_k(par1Entity);
        int i = MathHelper.func_76125_a((int)this.field_70170_p.func_175659_aa().func_151525_a(), (int)1, (int)3);
        if (this.field_70146_Z.nextInt(MathHelper.func_76143_f((double)(9 / i))) == 0 && result && par1Entity instanceof EntityLivingBase) {
            EntityPlayer player;
            if (this.getJabbaType() == 0) {
                if (this.field_70146_Z.nextInt(8) == 0) {
                    par1Entity.func_70015_d(2 * i);
                }
            } else if (this.field_70146_Z.nextInt(4) == 0) {
                ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 120 * i, i));
            }
            if (par1Entity instanceof EntityPlayer && i >= 3 && this.field_70146_Z.nextBoolean() && (player = (EntityPlayer)par1Entity).func_71045_bC() != null && !player.field_71075_bZ.field_75098_d) {
                player.func_71040_bB(true);
            }
        }
        if (result) {
            this.setAngerTicks(this.getAngerTicks() + 10);
            this.setAttackTicks(10);
        }
        return result;
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("jabbaType")) {
            this.setJabbaType(tag.func_74771_c("jabbaType"));
        }
        if (tag.func_74764_b("angerTicks")) {
            this.setAngerTicks(tag.func_74762_e("angerTicks"));
        }
        if (tag.func_74764_b("wormTicks")) {
            this.setWormTicks(tag.func_74762_e("wormTicks"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74774_a("jabbaType", this.getJabbaType());
        tag.func_74768_a("angerTicks", this.getAngerTicks());
        tag.func_74768_a("wormTicks", this.getWormTicks());
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance ins, IEntityLivingData data) {
        BiomeGenBase biome = this.field_70170_p.func_180494_b(new BlockPos((int)this.field_70165_t, 0, (int)this.field_70161_v));
        this.setJabbaType(biome instanceof BiomeGenPaintedForest ? (byte)1 : 0);
        return super.func_180482_a(ins, data);
    }

    @Override
    protected boolean isChangeAllowed() {
        return this.getJabbaType() == 0 && TragicConfig.getBoolean("allowJarra");
    }

    public String func_70639_aQ() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.jabba.squish" : null;
    }

    public String func_70621_aR() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.jabba.hurt" : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.jabba.hurt" : null;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        if (TragicConfig.getBoolean("allowMobSounds")) {
            this.func_85030_a("tragicmc:mob.jabba.squish", 0.45f, 1.0f);
        }
    }

    public float func_70647_i() {
        return this.getJabbaType() == 0 ? super.func_70647_i() : super.func_70647_i() + 0.4f + this.field_70146_Z.nextFloat();
    }

    public float func_70599_aP() {
        return 0.1f + this.field_70146_Z.nextFloat() * 0.1f;
    }

    @Override
    public String getVariantName() {
        return "TragicMC.Janna";
    }

    @Override
    public boolean getIllumination() {
        return true;
    }

    @Override
    protected void updateSize() {
        if (this.getJabbaType() == 0) {
            this.func_70105_a(1.425f, 0.625f);
            this.field_70178_ae = true;
        } else {
            this.func_70105_a(1.175625f, 0.515625f);
            this.field_70178_ae = false;
            this.field_70728_aV = 6;
        }
    }
}

