/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicEntities;
import tragicneko.tragicmc.entity.miniboss.EntityVoxStellarum;
import tragicneko.tragicmc.entity.miniboss.TragicMiniBoss;
import tragicneko.tragicmc.entity.mob.TragicMob;
import tragicneko.tragicmc.util.DamageHelper;
import tragicneko.tragicmc.worldgen.biome.BiomeGenStarlitPrarie;

public class EntityCryse
extends TragicMob {
    public static final int DW_SPIN_TICKS = 20;
    public static final int DW_CRYSE_TYPE = 21;
    public static final int DW_TEXTURE_ID = 22;
    public static final int DW_ATTACK_TIME = 23;
    public static final int DW_FLUTTER_TICKS = 24;

    public EntityCryse(World par1World) {
        super(par1World);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 50;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.75));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 48.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 48.0f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, playerTarget));
        if (this.superiorForm == null && !(this instanceof TragicMiniBoss)) {
            this.superiorForm = EntityVoxStellarum.class;
        }
    }

    @Override
    public boolean isMobVariant() {
        return this.getCryseType() == 1;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return TragicEntities.Natural;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        return 0xF000F0;
    }

    public float func_70013_c(float par1) {
        return 1.0f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
    }

    public int getSpinTicks() {
        return this.field_70180_af.func_75679_c(20);
    }

    protected void decrementSpinTicks() {
        int pow = this.getSpinTicks();
        this.setSpinTicks(--pow);
    }

    protected void setSpinTicks(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    public boolean isSpinning() {
        return this.getSpinTicks() > 0;
    }

    public byte getCryseType() {
        return this.field_70180_af.func_75683_a(21);
    }

    protected void setCryseType(byte b) {
        this.field_70180_af.func_75692_b(21, (Object)b);
    }

    public byte getTextureID() {
        return this.field_70180_af.func_75683_a(22);
    }

    protected void setTextureID(byte b) {
        this.field_70180_af.func_75692_b(22, (Object)b);
    }

    public int getAttackTime() {
        return this.field_70180_af.func_75679_c(23);
    }

    protected void setAttackTime(int i) {
        this.field_70180_af.func_75692_b(23, (Object)i);
    }

    private void decrementAttackTime() {
        int pow = this.getAttackTime();
        this.setAttackTime(--pow);
    }

    public int getFlutterTicks() {
        return this.field_70180_af.func_75679_c(24);
    }

    protected void setFlutterTicks(int i) {
        this.field_70180_af.func_75692_b(24, (Object)i);
    }

    private void decrementFlutterTicks() {
        int pow = this.getFlutterTicks();
        this.setFlutterTicks(--pow);
    }

    public boolean isFluttering() {
        return this.getFlutterTicks() > 0;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] stats = TragicConfig.getMobStat(this.getCryseType() == 0 ? "cryseStats" : "starCryseStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(stats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(stats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(stats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(stats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(stats[4]);
    }

    @Override
    protected void updateSize() {
        if (this.getCryseType() == 0) {
            this.func_70105_a(0.425f, 1.375f);
        } else {
            this.field_70728_aV = 6;
            this.func_70105_a(0.328125f, 0.859375f);
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.isSpinning()) {
                this.decrementSpinTicks();
            }
            if (this.getAttackTime() > 0) {
                this.decrementAttackTime();
            }
            if (this.isFluttering()) {
                this.decrementFlutterTicks();
            }
            if (this.field_70173_aa % 120 == 0 && this.func_70638_az() == null && this.field_70146_Z.nextBoolean() && !this.isSpinning() && !this.isFluttering()) {
                if (this.field_70146_Z.nextBoolean()) {
                    this.setSpinTicks(120);
                } else {
                    this.setFlutterTicks(60);
                }
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        boolean result;
        EntityPlayer player;
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.isSpinning()) {
            this.field_70180_af.func_75692_b(20, (Object)0);
        }
        if (this.isFluttering()) {
            this.setFlutterTicks(0);
        }
        if (par1DamageSource.func_76347_k()) {
            par2 = par2 * 4.175f - 1.0f;
        }
        if (par1DamageSource.func_76346_g() != null && par1DamageSource.func_76346_g() instanceof EntityPlayer && (player = (EntityPlayer)par1DamageSource.func_76346_g()).func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemPickaxe) {
            par2 = (float)((double)par2 * 1.275);
        }
        if (result = super.func_70097_a(par1DamageSource, par2)) {
            this.setAttackTime(10);
        }
        if (result && par1DamageSource.func_76346_g() != null && this.field_70146_Z.nextInt(4) == 0 && TragicConfig.getBoolean("cryseReflection")) {
            if (TragicConfig.getBoolean("allowMobSounds")) {
                this.field_70170_p.func_72956_a((Entity)this, "tragicmc:mob.cryse.deflect", 1.0f, 1.9f);
            }
            par1DamageSource.func_76346_g().func_70097_a(DamageHelper.causeModMagicDamageToEntity((EntityLivingBase)this), par2 / 4.0f);
        }
        return result;
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        boolean result = super.func_70652_k(par1Entity);
        EnumDifficulty dif = this.field_70170_p.func_175659_aa();
        int x = 2;
        if (dif == EnumDifficulty.NORMAL) {
            x = 3;
        } else if (dif == EnumDifficulty.HARD) {
            x = 4;
        }
        if (result) {
            if (this.isSpinning()) {
                this.setSpinTicks(0);
            }
            if (this.getFlutterTicks() > 0) {
                this.setFlutterTicks(0);
            }
            if (par1Entity instanceof EntityLivingBase) {
                if (this.field_70146_Z.nextInt(16 / x) == 0) {
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 100 + this.field_70146_Z.nextInt(140), 1 + this.field_70146_Z.nextInt(2)));
                }
                if (this.field_70146_Z.nextInt(32 / x) == 0) {
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 100 + this.field_70146_Z.nextInt(140), 1 + this.field_70146_Z.nextInt(2)));
                }
            }
        }
        return result;
    }

    public int func_70658_aO() {
        return TragicConfig.getMobStat(this.getCryseType() == 0 ? "cryseStats" : "starCryseStats").getArmorValue();
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("texture")) {
            this.setTextureID(tag.func_74771_c("texture"));
        }
        if (tag.func_74764_b("cryseType")) {
            this.setCryseType(tag.func_74771_c("cryseType"));
        }
        if (tag.func_74764_b("spinTicks")) {
            this.setSpinTicks(tag.func_74762_e("spinTicks"));
        }
        if (tag.func_74764_b("attackTime")) {
            this.setAttackTime(tag.func_74762_e("attackTime"));
        }
        if (tag.func_74764_b("flutterTicks")) {
            this.setFlutterTicks(tag.func_74762_e("flutterTicks"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74774_a("texture", this.getTextureID());
        tag.func_74774_a("cryseType", this.getCryseType());
        tag.func_74768_a("spinTicks", this.getSpinTicks());
        tag.func_74768_a("attackTime", this.getAttackTime());
        tag.func_74768_a("flutterTicks", this.getFlutterTicks());
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance ins, IEntityLivingData data) {
        if (!this.field_70170_p.field_72995_K) {
            BiomeGenBase biome = this.field_70170_p.func_180494_b(new BlockPos((int)this.field_70165_t, 0, (int)this.field_70161_v));
            this.setCryseType(biome instanceof BiomeGenStarlitPrarie ? (byte)1 : 0);
            this.setTextureID((byte)this.field_70146_Z.nextInt(8));
        }
        return super.func_180482_a(ins, data);
    }

    @Override
    protected boolean isChangeAllowed() {
        return this.getCryseType() == 1 && TragicConfig.getBoolean("allowMegaCryse");
    }

    public String func_70639_aQ() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.cryse.glass" : null;
    }

    public String func_70621_aR() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.cryse.hit" : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.cryse.break" : null;
    }

    public float func_70647_i() {
        return 1.0f;
    }

    public float func_70599_aP() {
        return 0.6f;
    }

    public int func_70627_aG() {
        return super.func_70627_aG();
    }

    protected void func_180429_a(BlockPos pos, Block block) {
    }

    @Override
    public String getVariantName() {
        return "TragicMC.StarCryse";
    }
}

