/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.entity.mob.TragicMob;
import tragicneko.tragicmc.items.challenge.ItemChallenge;
import tragicneko.tragicmc.util.EntityDropHelper;

public class EntityAvris
extends TragicMob {
    public int rarity = 1;
    private int timeAlive = 0;
    public static final Predicate golemTarget = new Predicate(){

        public boolean apply(Object input) {
            return this.canApply((Entity)input);
        }

        public boolean canApply(Entity entity) {
            return entity instanceof EntityGolem;
        }
    };

    public EntityAvris(World par1World) {
        super(par1World);
        this.func_70105_a(1.26f, 2.76f);
        this.field_70728_aV = 30;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, playerTarget, 12.0f, 0.6, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityGolem.class, golemTarget, 12.0f, 0.8, 1.4));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.85));
        this.field_70138_W = 1.0f;
        this.field_70178_ae = true;
    }

    @Override
    protected boolean isChangeAllowed() {
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_110143_aJ() > 0.0f) {
            ++this.timeAlive;
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N, 0.0, (double)(0.155f * this.field_70146_Z.nextFloat()), 0.0, new int[0]);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 4 == 0 && this.timeAlive >= 2400 - this.rarity * 400 && this.func_110143_aJ() > 0.0f) {
            List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(64.0, 64.0, 64.0));
            boolean flag = true;
            for (Entity e : entities) {
                if (!(e instanceof EntityLivingBase) || !this.func_70685_l(e)) continue;
                flag = false;
            }
            if (this.timeAlive >= 3600 && TragicConfig.getBoolean("avrisDespawnTime")) {
                flag = true;
            }
            if (flag && TragicConfig.getBoolean("avrisDespawnTime")) {
                this.func_70106_y();
                if (TragicConfig.getBoolean("avrisAnnouncements")) {
                    List list = this.field_70170_p.func_72872_a(EntityPlayerMP.class, this.func_174813_aQ().func_72314_b(48.0, 48.0, 48.0));
                    for (EntityPlayerMP mp : list) {
                        mp.func_145747_a((IChatComponent)new ChatComponentText("The Avris has eluded pursuers!"));
                    }
                }
            }
        }
    }

    @Override
    public void func_70645_a(DamageSource src) {
        super.func_70645_a(src);
        if (!this.field_70170_p.field_72995_K) {
            if (TragicConfig.getBoolean("avrisAnnouncements")) {
                List list = this.field_70170_p.func_72872_a(EntityPlayerMP.class, this.func_174813_aQ().func_72314_b(48.0, 48.0, 48.0));
                for (EntityPlayerMP mp : list) {
                    mp.func_145747_a((IChatComponent)new ChatComponentText("The Avris has been slain!"));
                }
            }
            int x = 7;
            if (src.func_76346_g() != null && src.func_76346_g() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)src.func_76346_g();
                if (player.func_71045_bC() != null) {
                    ItemStack weapon = player.field_71071_by.func_70448_g();
                    x += EnchantmentHelper.func_77506_a((int)Enchantment.field_77335_o.field_77352_x, (ItemStack)weapon);
                }
                if (player instanceof EntityPlayerMP && TragicConfig.getBoolean("allowAchievements")) {
                    ((EntityPlayerMP)player).func_71029_a((StatBase)TragicAchievements.avris);
                }
            }
            int drops = 0;
            for (int i = 0; i < x; ++i) {
                ItemStack drop;
                if (this.field_70146_Z.nextInt(100) <= TragicConfig.getInt("commonMobDropChance") + x * 4) {
                    drop = ((EntityDropHelper.EntityDrop)WeightedRandom.func_76271_a((Random)this.field_70146_Z, Arrays.asList(this.getDropsFromRarity()))).getStack();
                    if (drop != null) {
                        this.func_70099_a(drop.func_77946_l(), 0.4f);
                    }
                    ++drops;
                }
                if (this.field_70718_bc > 0 && this.field_70146_Z.nextInt(100) <= TragicConfig.getInt("rareMobDropChance") + x) {
                    drop = ((EntityDropHelper.EntityDrop)WeightedRandom.func_76271_a((Random)this.field_70146_Z, Arrays.asList(this.getDropsFromRarity()))).getStack();
                    if (drop != null) {
                        this.func_70099_a(drop.func_77946_l(), 0.4f);
                    }
                    ++drops;
                }
                if ((double)drops > (double)x * 2.5) break;
            }
        }
    }

    private EntityDropHelper.EntityDrop[] getDropsFromRarity() {
        return this.rarity >= 3 ? ItemChallenge.rewards : (this.rarity == 2 ? ItemChallenge.cheapRewards : ItemChallenge.badRewards);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] avrisStats = TragicConfig.getMobStat("avrisStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(avrisStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(avrisStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(avrisStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(avrisStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(avrisStats[4]);
    }

    public int func_70658_aO() {
        return TragicConfig.getMobStat("avrisStats").getArmorValue();
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance ins, IEntityLivingData data) {
        if (!this.field_70170_p.field_72995_K) {
            this.rarity = this.field_70146_Z.nextInt(3) + 1;
            if (TragicConfig.getBoolean("avrisAnnouncements")) {
                List list = this.field_70170_p.func_72872_a(EntityPlayerMP.class, this.func_174813_aQ().func_72314_b(48.0, 48.0, 48.0));
                for (EntityPlayerMP mp : list) {
                    mp.func_145747_a((IChatComponent)new ChatComponentText("An Avris has appeared nearby!"));
                }
            }
        }
        return super.func_180482_a(ins, data);
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.field_70146_Z.nextInt(32) == 0;
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        boolean flag = super.func_70097_a(par1DamageSource, par2);
        if (flag && par1DamageSource.func_76346_g() != null) {
            par1DamageSource.func_76346_g().func_70015_d(4 + this.field_70146_Z.nextInt(4));
        }
        return flag;
    }

    public String func_70639_aQ() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.avris.laugh" : null;
    }

    public String func_70621_aR() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.avris.hurt" : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.avris.death" : null;
    }

    public float func_70647_i() {
        return 1.0f;
    }

    public float func_70599_aP() {
        return 1.0f;
    }

    @Override
    public boolean getIllumination() {
        return true;
    }
}

