/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicEntities;
import tragicneko.tragicmc.entity.mob.EntityIre;
import tragicneko.tragicmc.entity.mob.TragicMob;
import tragicneko.tragicmc.util.DamageHelper;
import tragicneko.tragicmc.util.WorldHelper;

public class EntityArchangel
extends TragicMob {
    public static final int DW_HOVER_TICKS = 20;
    public static final int DW_TARGET_ID = 21;
    public int hoverBuffer = 120;
    public double wayDifference = 0.0;
    public double prevWaypoint = 0.0;

    public EntityArchangel(World par1World) {
        super(par1World);
        this.func_70105_a(1.725f, 1.625f);
        this.field_70765_h = new FlyingMoveHelper((EntityLiving)this);
        this.field_70178_ae = true;
        this.field_70728_aV = 100;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, false, EntityIre.nonLightEntityTarget));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] archangelStats = TragicConfig.getMobStat("archangelStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(archangelStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(archangelStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(archangelStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(archangelStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(archangelStats[4]);
    }

    public int func_70658_aO() {
        return TragicConfig.getMobStat("archangelStats").getArmorValue();
    }

    public EnumCreatureAttribute func_70668_bt() {
        return TragicEntities.Natural;
    }

    @Override
    protected boolean canCorrupt() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        return 0xF000F0;
    }

    public float func_70013_c(float par1) {
        return 1.0f;
    }

    public boolean func_90999_ad() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
    }

    private void setHoverTicks(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    public int getHoverTicks() {
        return this.field_70180_af.func_75679_c(20);
    }

    private void setTargetId(int i) {
        this.field_70180_af.func_75692_b(21, (Object)i);
    }

    public int getTargetId() {
        return this.field_70180_af.func_75679_c(21);
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        boolean result = super.func_70097_a(par1DamageSource, par2);
        if (result && this.getHoverTicks() > 0) {
            this.setHoverTicks(0);
            this.hoverBuffer = 120;
        }
        return result;
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        if (!this.field_70170_p.field_72995_K) {
            par1Entity.func_70015_d(4 + this.field_70146_Z.nextInt(4));
        }
        return super.func_70652_k(par1Entity);
    }

    @Override
    public void func_70636_d() {
        if (this.getHoverTicks() > 0) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        }
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            Entity entity = this.field_70170_p.func_73045_a(this.getTargetId());
            if (entity != null && this.getHoverTicks() > 10) {
                double d0 = entity.field_70165_t - this.field_70165_t;
                double d1 = entity.field_70163_u - this.field_70163_u;
                double d2 = entity.field_70161_v - this.field_70161_v;
                for (int l = 0; l < 4; l = (int)((byte)(l + 1))) {
                    double d3 = 0.23 * (double)l + this.field_70146_Z.nextDouble() * 0.25;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, this.field_70165_t + d0 * d3, this.field_70163_u + d1 * d3 + 0.75, this.field_70161_v + d2 * d3, 0.0, 0.0, 0.0, new int[0]);
                    if (this.getHoverTicks() > 120) continue;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + d0 * d3, this.field_70163_u + d1 * d3 + 0.75, this.field_70161_v + d2 * d3, 0.0, 0.0, 0.0, new int[0]);
                }
                if (this.getHoverTicks() <= 120) {
                    for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), this.field_70163_u + 0.75 + this.field_70146_Z.nextDouble() * 0.5, this.field_70161_v + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
            if (this.field_70173_aa % 5 == 0 && this.field_70146_Z.nextBoolean()) {
                for (int l = 0; l < 2; l = (int)((byte)(l + 1))) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.5, (this.field_70146_Z.nextDouble() - 0.6) * 0.1, this.field_70146_Z.nextDouble() * 0.1, (this.field_70146_Z.nextDouble() - 0.6) * 0.1, new int[0]);
                }
            }
            return;
        }
        if (this.hoverBuffer > 0) {
            --this.hoverBuffer;
        }
        if (this.getHoverTicks() <= 0) {
            double d2;
            double d1;
            double d0 = this.func_70605_aq().func_179917_d() - this.field_70165_t;
            double d3 = d0 * d0 + (d1 = this.func_70605_aq().func_179919_e() - this.field_70163_u) * d1 + (d2 = this.func_70605_aq().func_179918_f() - this.field_70161_v) * d2;
            if (!Double.isNaN(d3)) {
                this.wayDifference = Math.abs(d3 - this.prevWaypoint);
                this.prevWaypoint = d3;
            }
            if (d3 < 1.0 || d3 > 400.0 || this.wayDifference < 10.0) {
                if (this.func_70638_az() != null) {
                    d0 = this.func_70638_az().field_70165_t + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    d1 = this.func_70638_az().field_70163_u + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    d2 = this.func_70638_az().field_70161_v + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
                } else {
                    d0 = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    d1 = this.field_70163_u + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    d2 = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    int y = WorldHelper.getDistanceToGround((Entity)this);
                    if (d1 - (double)y >= 20.0) {
                        d1 -= (double)(y / 2);
                    }
                }
                this.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
            }
            double d4 = this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
            if (this.func_70638_az() != null && this.func_70638_az().func_70068_e((Entity)this) < d4 * d4 && this.func_70638_az().func_70032_d((Entity)this) > 6.0f && this.getHoverTicks() == 0 && this.field_70146_Z.nextInt(16) == 0 && this.func_70685_l((Entity)this.func_70638_az()) && this.hoverBuffer == 0) {
                this.setHoverTicks(250);
            }
            if ((double)WorldHelper.getDistanceToGround((Entity)this) <= 1.5) {
                this.field_70181_x = 0.1;
            }
        } else {
            this.setHoverTicks(this.getHoverTicks() - 1);
            this.hoverBuffer = 80 + (int)(120.0f * (this.func_110143_aJ() / this.func_110138_aP()));
            if (this.getHoverTicks() > 10 && this.getHoverTicks() <= 120 && this.func_70638_az() != null && this.func_70685_l((Entity)this.func_70638_az())) {
                this.func_70638_az().func_70097_a(DamageHelper.causeArmorPiercingDamageToEntity((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
            }
            if (this.getHoverTicks() % 15 == 0 && TragicConfig.getBoolean("allowMobSounds")) {
                this.func_85030_a("tragicmc:mob.archangel.low", 0.4f, 1.0f);
                if (this.func_70638_az() != null) {
                    this.field_70170_p.func_72956_a((Entity)this.func_70638_az(), "tragicmc:mob.archangel.low", 0.4f, 1.0f);
                }
            }
            if (this.func_70638_az() == null || this.func_70638_az().field_70128_L || !this.func_70685_l((Entity)this.func_70638_az())) {
                this.setHoverTicks(0);
            }
        }
        if (this.func_70638_az() != null && this.func_70638_az().field_70128_L) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() != null) {
            this.setTargetId(this.func_70638_az().func_145782_y());
        } else {
            this.setTargetId(0);
        }
        if (this.func_70638_az() != null) {
            double d5 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d7 = this.func_70638_az().field_70161_v - this.field_70161_v;
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(d5, d7)) * 180.0f / (float)Math.PI;
        } else {
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
        }
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    protected boolean isChangeAllowed() {
        return false;
    }

    public void func_180430_e(float dist, float multi) {
    }

    public void func_180433_a(double par1, boolean par2, Block block, BlockPos pos) {
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_70090_H()) {
            this.func_70060_a(strafe, forward, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.func_180799_ab()) {
            this.func_70060_a(strafe, forward, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            float f = 0.91f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            float f1 = 0.16277136f / (f * f * f);
            this.func_70060_a(strafe, forward, this.field_70122_E ? 0.1f * f1 : 0.02f);
            f = 0.91f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)f;
            this.field_70179_y *= (double)f;
        }
        this.field_70722_aY = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    public boolean func_70617_f_() {
        return false;
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("hoverBuffer")) {
            this.hoverBuffer = tag.func_74762_e("hoverBuffer");
        }
        if (tag.func_74764_b("hoverTicks")) {
            this.setHoverTicks(tag.func_74762_e("hoverTicks"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("hoverBuffer", this.hoverBuffer);
        tag.func_74768_a("hoverTicks", this.getHoverTicks());
    }

    public String func_70639_aQ() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.archangel.choir" : null;
    }

    public String func_70621_aR() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.archangel.vibrato" : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.archangel.triple" : null;
    }

    public float func_70647_i() {
        return 1.0f;
    }

    public float func_70599_aP() {
        return 0.4f;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
    }

    @Override
    public boolean getIllumination() {
        return true;
    }

    public static class FlyingMoveHelper
    extends EntityMoveHelper {
        private EntityLiving parentEntity;
        private int courseChangeCooldown;

        public FlyingMoveHelper(EntityLiving parent) {
            super(parent);
            this.parentEntity = parent;
        }

        public void func_75641_c() {
            if (this.field_75643_f && this.courseChangeCooldown-- <= 0) {
                double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                double d1 = this.field_75647_c - this.parentEntity.field_70163_u;
                double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                    this.parentEntity.field_70159_w += d0 / d3 * 0.1;
                    this.parentEntity.field_70181_x += d1 / d3 * 0.1;
                    this.parentEntity.field_70179_y += d2 / d3 * 0.1;
                } else {
                    this.field_75643_f = false;
                }
            }
        }

        private boolean isNotColliding(double wayX, double wayY, double wayZ, double dist) {
            double d0 = (wayX - this.parentEntity.field_70165_t) / dist;
            double d1 = (wayY - this.parentEntity.field_70163_u) / dist;
            double d2 = (wayZ - this.parentEntity.field_70161_v) / dist;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < dist) {
                if (!this.parentEntity.field_70170_p.func_72945_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

