/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.miniboss;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.entity.alpha.EntityOverlordCore;
import tragicneko.tragicmc.entity.miniboss.EntityGreaterStin;
import tragicneko.tragicmc.entity.mob.EntityStin;
import tragicneko.tragicmc.entity.projectile.EntityWebBomb;
import tragicneko.tragicmc.util.WorldHelper;

public class EntityStinQueen
extends EntityGreaterStin {
    public static final int DW_FIRING_TICKS = 25;

    public EntityStinQueen(World par1World) {
        super(par1World);
        this.field_70138_W = 1.5f;
        this.superiorForm = null;
        this.field_70728_aV = 270;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] stinQueenStats = TragicConfig.getMobStat("stinQueenStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(stinQueenStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(stinQueenStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(stinQueenStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(stinQueenStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(stinQueenStats[4]);
    }

    @Override
    public int func_70658_aO() {
        return TragicConfig.getMobStat("stinQueenStats").getArmorValue();
    }

    @Override
    public int getChargeTicks() {
        return 0;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(25, (Object)0);
    }

    public int getFiringTicks() {
        return this.field_70180_af.func_75679_c(25);
    }

    protected void setFiringTicks(int i) {
        this.field_70180_af.func_75692_b(25, (Object)i);
    }

    protected void decrementFiringTicks() {
        int pow = this.getFiringTicks();
        this.setFiringTicks(--pow);
    }

    public boolean isFiring() {
        return this.getFiringTicks() > 0;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (TragicConfig.getBoolean("allowStinBaby") && TragicConfig.getBoolean("stinQueenBabies")) {
            int la;
            int n = la = this.func_110143_aJ() <= this.func_110138_aP() / 2.0f ? 4 : 8;
            if (this.field_70173_aa % 30 == 0 && this.field_70146_Z.nextInt(la) == 0 && this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) >= 4.0f) {
                for (int i = 0; i < 4; ++i) {
                    this.spawnBabies();
                }
                ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(this.field_70170_p, 0.75, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                for (int i = 0; i < list.size(); ++i) {
                    BlockPos coords = list.get(i);
                    if (!EntityOverlordCore.replaceableBlocks.contains(this.field_70170_p.func_180495_p(coords).func_177230_c())) continue;
                    this.field_70170_p.func_175656_a(coords, Blocks.field_150321_G.func_176223_P());
                }
            }
        }
        if (this.isFiring()) {
            this.decrementFiringTicks();
            if (this.isCharging()) {
                this.setChargeTicks(0);
            }
            if (this.isGalloping()) {
                this.setGallopTicks(0);
            }
        }
        if (this.func_70638_az() != null && !this.isCharging() && !this.isFiring() && this.func_70032_d((Entity)this.func_70638_az()) >= 8.0f && this.field_70146_Z.nextInt(12) == 0 && this.field_70173_aa % 10 == 0 && TragicConfig.getBoolean("stinQueenWebBombs")) {
            this.setFiringTicks(50);
        }
        if (this.isFiring() && this.getFiringTicks() % 25 == 0 && this.func_70638_az() != null) {
            this.doMortorFire();
        }
    }

    private void doMortorFire() {
        if (!TragicConfig.getBoolean("stinQueenWebBombs")) {
            return;
        }
        double d0 = this.func_70638_az().field_70165_t - this.field_70165_t + (double)this.field_70146_Z.nextInt(5) - (double)this.field_70146_Z.nextInt(5);
        double d1 = this.func_70638_az().func_174813_aQ().field_72338_b + (double)(this.func_70638_az().field_70131_O / 3.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
        double d2 = this.func_70638_az().field_70161_v - this.field_70161_v + (double)this.field_70146_Z.nextInt(5) - (double)this.field_70146_Z.nextInt(5);
        float f1 = MathHelper.func_76129_c((float)this.func_70032_d((Entity)this.func_70638_az())) * 0.975f;
        EntityWebBomb mortor = new EntityWebBomb(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
        mortor.field_70163_u = this.field_70163_u + (double)this.field_70131_O + 0.5;
        mortor.field_70165_t += d0 * 0.04335;
        mortor.field_70161_v += d2 * 0.04335;
        mortor.field_70181_x += 0.66 * (double)f1;
        this.field_70170_p.func_72838_d((Entity)mortor);
    }

    public void spawnBabies() {
        if (!TragicConfig.getBoolean("allowStinBaby") || !TragicConfig.getBoolean("stinQueenBabies")) {
            return;
        }
        EntityStin baby = new EntityStin(this.field_70170_p);
        baby.setChild();
        baby.func_82149_j((Entity)this);
        double x = this.field_70165_t;
        double y = this.field_70163_u;
        double z = this.field_70161_v;
        for (int y1 = -2; y1 < 4; ++y1) {
            for (int z1 = -2; z1 < 3; ++z1) {
                for (int x1 = -2; x1 < 3; ++x1) {
                    if (!World.func_175683_a((IBlockAccess)this.field_70170_p, (BlockPos)new BlockPos((int)this.field_70165_t + x1, (int)this.field_70163_u + y1 - 1, (int)this.field_70161_v + z1)) || !this.field_70146_Z.nextBoolean()) continue;
                    baby.func_70107_b(x + (double)x1, y + (double)y1, z + (double)z1);
                    if (!this.field_70170_p.func_72855_b(baby.func_174813_aQ()) || !this.field_70170_p.func_72945_a((Entity)baby, baby.func_174813_aQ()).isEmpty() || this.field_70170_p.func_72953_d(baby.func_174813_aQ())) continue;
                    this.field_70170_p.func_72838_d((Entity)baby);
                    baby.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((int)this.field_70165_t + x1, (int)this.field_70163_u + y1 - 1, (int)this.field_70161_v + z1)), null);
                    if (this.func_70638_az() != null) {
                        baby.func_70624_b(this.func_70638_az());
                    }
                    return;
                }
            }
        }
    }

    @Override
    protected boolean teleportEnemyAway(EntityLivingBase entity, boolean flag) {
        super.teleportEnemyAway(entity, flag);
        if (!TragicConfig.getBoolean("stinQueenWebBombs")) {
            return flag;
        }
        ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(this.field_70170_p, 0.5, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        for (int i = 0; i < list.size(); ++i) {
            BlockPos coords = list.get(i);
            if (this.field_70170_p.func_180495_p(coords).func_177230_c() != Blocks.field_150350_a) continue;
            this.field_70170_p.func_175656_a(coords, Blocks.field_150321_G.func_176223_P());
        }
        return flag;
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        boolean flag = super.func_70652_k(par1Entity);
        if (flag && this.field_70146_Z.nextInt(8) == 0 && par1Entity instanceof EntityLivingBase && TragicConfig.getBoolean("allowStun")) {
            ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Stun.field_76415_H, 60, 0));
        }
        return flag;
    }

    @Override
    protected boolean isChangeAllowed() {
        return false;
    }

    @Override
    public Class getLesserForm() {
        return EntityGreaterStin.class;
    }

    @Override
    public float func_70647_i() {
        return 1.9f;
    }

    @Override
    protected void updateSize() {
        this.func_70105_a(1.755f, 3.15f);
    }
}

