/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.miniboss;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.entity.miniboss.EntityStinKing;
import tragicneko.tragicmc.entity.miniboss.EntityStinQueen;
import tragicneko.tragicmc.entity.miniboss.TragicMiniBoss;
import tragicneko.tragicmc.entity.mob.EntityStin;

public class EntityGreaterStin
extends EntityStin
implements TragicMiniBoss {
    public static final int DW_CHARGE_TICKS = 24;

    public EntityGreaterStin(World par1World) {
        super(par1World);
        this.field_70728_aV = 150;
        this.field_70138_W = 1.5f;
        if (this.superiorForm == null) {
            this.superiorForm = this.field_70146_Z.nextBoolean() && TragicConfig.getBoolean("allowStinKing") ? EntityStinKing.class : (TragicConfig.getBoolean("allowStinQueen") ? EntityStinQueen.class : null);
        }
    }

    @Override
    public boolean isMobVariant() {
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] greaterStinStats = TragicConfig.getMobStat("greaterStinStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(greaterStinStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(greaterStinStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(greaterStinStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(greaterStinStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(greaterStinStats[4]);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(24, (Object)0);
    }

    public int getChargeTicks() {
        return this.field_70180_af.func_75679_c(24);
    }

    protected void setChargeTicks(int i) {
        this.field_70180_af.func_75692_b(24, (Object)i);
    }

    protected void decrementChargeTicks() {
        int pow = this.getChargeTicks();
        this.setChargeTicks(--pow);
    }

    public boolean isCharging() {
        return this.getChargeTicks() > 0;
    }

    @Override
    public int func_70658_aO() {
        return TragicConfig.getMobStat("greaterStinStats").getArmorValue();
    }

    @Override
    public boolean isAdult() {
        return true;
    }

    @Override
    protected void growUp() {
    }

    @Override
    public void setChild() {
    }

    @Override
    public void func_70636_d() {
        if (this.isCharging() && this.getChargeTicks() > 170) {
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
        }
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.getChargeTicks() <= 170 && this.isCharging()) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.355, this.field_70163_u + 0.115 + this.field_70146_Z.nextDouble(), this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.355, 0.0, (double)(0.155f * this.field_70146_Z.nextFloat()), 0.0, new int[0]);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.isCharging()) {
            this.func_70031_b(true);
            if (this.isGalloping()) {
                this.setGallopTicks(0);
            }
            this.decrementChargeTicks();
            if (this.func_70638_az() == null || this.func_70638_az().field_70163_u >= this.field_70163_u + 4.5) {
                this.setChargeTicks(0);
            }
        } else {
            this.func_70031_b(false);
        }
        if (this.func_70638_az() != null && !this.isCharging() && !this.isGalloping() && this.func_70032_d((Entity)this.func_70638_az()) <= 12.0f && this.field_70173_aa % 10 == 0 && this.field_70146_Z.nextInt(12) == 0 && this.func_70638_az().field_70122_E && this.field_70122_E && this.func_70032_d((Entity)this.func_70638_az()) >= 3.0f && TragicConfig.getBoolean("greaterStinCharge")) {
            this.setChargeTicks(200);
        }
        if (this.func_70638_az() != null && this.isCharging()) {
            if (this.getChargeTicks() <= 170) {
                float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 30.0f;
                if (this.field_70123_F && f >= 2.0f) {
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, f / 2.0f * this.field_70146_Z.nextFloat() + f / 2.0f, this.getMobGriefing());
                    this.setChargeTicks(0);
                } else {
                    double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                    double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
                    float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                    this.field_70159_w += d0 / (double)f2 * 0.13 * 0.1100000011920929 + this.field_70159_w * 0.1000000298023224;
                    this.field_70179_y += d1 / (double)f2 * 0.13 * 0.1100000011920929 + this.field_70179_y * 0.1000000298023224;
                    this.field_70181_x = -0.1;
                }
            } else {
                this.field_70181_x = -0.1;
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.isCharging() && this.getChargeTicks() > 170) {
            this.setChargeTicks(0);
        }
        if (this.isCharging() && this.getChargeTicks() <= 170) {
            par2 /= 2.0f;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        if (this.isCharging() && this.getChargeTicks() > 170) {
            return false;
        }
        boolean flag = super.func_70652_k(par1Entity);
        if (flag && this.isCharging() && this.getChargeTicks() <= 170) {
            if (this.field_70146_Z.nextBoolean() && par1Entity instanceof EntityLivingBase) {
                ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 300, 0));
                if (TragicConfig.getBoolean("allowSubmission")) {
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Submission.field_76415_H, 300, 1 + this.field_70146_Z.nextInt(3)));
                }
            }
            par1Entity.field_70181_x += 1.222543;
            par1Entity.field_70159_w *= 1.65;
            par1Entity.field_70179_y *= 1.65;
        }
        return flag;
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("chargeTicks")) {
            this.setChargeTicks(tag.func_74762_e("chargeTicks"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("chargeTicks", this.getChargeTicks());
    }

    @Override
    protected boolean isChangeAllowed() {
        return this.superiorForm == EntityStinKing.class ? TragicConfig.getBoolean("allowStinKing") : TragicConfig.getBoolean("allowStinQueen");
    }

    public Class getLesserForm() {
        return EntityStin.class;
    }

    @Override
    public float func_70647_i() {
        return 0.4f;
    }

    @Override
    public int getDropAmount() {
        return 5;
    }

    @Override
    protected void updateSize() {
        this.func_70105_a(1.15f, 3.45f);
    }
}

