/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.boss;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.dimension.TragicWorldProvider;
import tragicneko.tragicmc.entity.alpha.EntityOverlordCore;
import tragicneko.tragicmc.entity.mob.TragicMob;
import tragicneko.tragicmc.util.EntityDropHelper;
import tragicneko.tragicmc.util.WorldHelper;

public abstract class TragicBoss
extends EntityMob
implements IBossDisplayData {
    private boolean hasDamagedEntity = false;
    private int xpAmount = 0;

    public TragicBoss(World par1World) {
        super(par1World);
        this.field_70728_aV = 1000;
    }

    protected void func_70628_a(boolean flag, int l) {
        int i;
        super.func_70628_a(flag, l);
        int x = 3 + l;
        int amt = 0;
        if (TragicConfig.getBoolean("allowExtraBossLoot")) {
            int amount = this.field_70146_Z.nextInt(6) + 4 * x;
            for (i = 0; i < amount; ++i) {
                if (this.field_70146_Z.nextBoolean()) {
                    ItemStack luxuryDrop = EntityDropHelper.getLuxuryDropForBoss();
                    if (luxuryDrop != null) {
                        this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, luxuryDrop));
                    }
                    ++amt;
                }
                if (amt >= 6 + x) break;
            }
        }
        int total = 0;
        for (i = 0; i < x + 3; ++i) {
            ItemStack drop;
            if (this.field_70146_Z.nextInt(100) <= TragicConfig.getInt("commonMobDropChance") + x * 4) {
                drop = EntityDropHelper.getDropFromEntity(((Object)((Object)this)).getClass(), true);
                if (drop != null) {
                    this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, drop));
                }
                ++total;
            }
            if (flag && this.field_70146_Z.nextInt(25) <= TragicConfig.getInt("rareMobDropChance") + x) {
                drop = EntityDropHelper.getDropFromEntity(((Object)((Object)this)).getClass(), false);
                if (drop != null) {
                    this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, drop));
                }
                ++total;
            }
            if ((double)total >= (double)x * 2.5) break;
        }
        if (flag) {
            ItemStack drop = EntityDropHelper.getDropFromEntity(((Object)((Object)this)).getClass(), false);
            if (drop != null) {
                this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, drop));
            }
            if (TragicConfig.getBoolean("allowNonMobItems")) {
                drop = new ItemStack(TragicItems.EtherealDistortion);
                this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, drop));
            }
        }
    }

    public void func_70645_a(DamageSource par1) {
        super.func_70645_a(par1);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(this.field_70170_p, 4.0, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        for (int i = 0; i < list.size(); ++i) {
            BlockPos coords = list.get(i);
            if (this.field_70170_p.func_180495_p(coords).func_177230_c().func_149688_o() != Material.field_151581_o) continue;
            this.field_70170_p.func_175698_g(coords);
        }
        if (par1.func_76346_g() != null && par1.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)par1.func_76346_g();
            if (TragicConfig.getBoolean("allowAchievements") && player instanceof EntityPlayerMP) {
                player.func_71029_a((StatBase)TragicAchievements.killBoss);
            }
            if (!this.hasDamagedEntity && TragicConfig.getBoolean("allowAchievements") && player instanceof EntityPlayerMP) {
                player.func_71029_a((StatBase)TragicAchievements.cantTouchThis);
            }
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("hasDamagedEntity")) {
            this.hasDamagedEntity = tag.func_74767_n("hasDamagedEntity");
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("hasDamagedEntity", this.hasDamagedEntity);
    }

    public void func_70636_d() {
        if (TragicConfig.getBoolean("allowCorruption") && this.func_70644_a(TragicPotion.Corruption)) {
            this.func_82170_o(TragicPotion.Corruption.field_76415_H);
        }
        super.func_70636_d();
        if (this.func_70638_az() != null && this.func_70638_az().field_70128_L) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() != null && !TragicConfig.getBoolean("allowMobInfighting") && (this.func_70638_az() instanceof TragicMob || this.func_70638_az() instanceof TragicBoss)) {
            this.func_70624_b(null);
        }
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.EASY && !TragicConfig.getBoolean("allowEasyBosses") || this.field_70163_u <= -30.0 || this.field_70163_u > 280.0) {
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K && this.getIllumination() && TragicConfig.getBoolean("allowMobIllumination") && this.field_70173_aa % 4 == 0) {
            BlockPos pos;
            int w = MathHelper.func_76141_d((float)this.field_70130_N);
            int h = MathHelper.func_76141_d((float)this.field_70131_O);
            if (w < 2) {
                w = 2;
            }
            if (h < 2) {
                h = 2;
            }
            if (EntityOverlordCore.replaceableBlocks.contains(WorldHelper.getBlock(this.field_70170_p, pos = WorldHelper.getBlockPos((Entity)this).func_177963_a((double)(this.field_70146_Z.nextInt(w) - this.field_70146_Z.nextInt(w)), (double)((float)(this.field_70146_Z.nextInt(h) - this.field_70146_Z.nextInt(h)) + this.field_70131_O * 2.0f / 3.0f), (double)(this.field_70146_Z.nextInt(w) - this.field_70146_Z.nextInt(w)))))) {
                this.field_70170_p.func_175656_a(pos, TragicBlocks.Luminescence.func_176223_P());
            }
        }
        if (!this.field_70170_p.field_72995_K && TragicConfig.getBoolean("bossesDenyFlight")) {
            List list = this.field_70170_p.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72314_b(64.0, 64.0, 64.0));
            for (EntityPlayerMP mp : list) {
                if (!mp.field_71075_bZ.field_75098_d) {
                    mp.field_71075_bZ.field_75101_c = false;
                }
                if (!TragicConfig.getBoolean("allowFlight") || !mp.func_70644_a(TragicPotion.Flight)) continue;
                mp.func_82170_o(TragicPotion.Flight.field_76415_H);
            }
        }
    }

    public boolean func_70601_bi() {
        if (this.field_70146_Z.nextInt(10) != 0) {
            return false;
        }
        if (this.field_70163_u <= 63.0) {
            switch (this.field_70170_p.field_73011_w.func_177502_q()) {
                case 0: {
                    return false;
                }
                case 1: {
                    return this.field_70146_Z.nextInt(4) == 0 ? false : super.func_70601_bi();
                }
                case -1: {
                    return false;
                }
            }
            if (this.field_70170_p.field_73011_w instanceof TragicWorldProvider) {
                return super.func_70601_bi();
            }
            return false;
        }
        return super.func_70601_bi();
    }

    public boolean func_70652_k(Entity par1Entity) {
        if (TragicConfig.getBoolean("allowStun") && this.func_70644_a(TragicPotion.Stun)) {
            return false;
        }
        boolean flag = super.func_70652_k(par1Entity);
        if (flag) {
            this.hasDamagedEntity = true;
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (par1DamageSource.func_76346_g() != null) {
            if (par1DamageSource.func_76346_g() instanceof EntityPlayer && par2 >= (float)TragicConfig.getInt("bossDamageCap")) {
                boolean flag;
                EntityPlayer player = (EntityPlayer)par1DamageSource.func_76346_g();
                boolean bl = player.func_71045_bC() == null ? false : (flag = player.func_71045_bC().func_77973_b() == TragicItems.BowOfJustice || player.func_71045_bC().func_77973_b() == TragicItems.SwordOfJustice);
                if (!player.field_71075_bZ.field_75098_d || !flag) {
                    par2 = MathHelper.func_76131_a((float)par2, (float)0.0f, (float)TragicConfig.getInt("bossDamageCap"));
                }
            }
            if (this.field_70146_Z.nextBoolean() && this.func_70638_az() != null && par1DamageSource.func_76346_g() instanceof EntityLivingBase && this.func_70638_az() != par1DamageSource.func_76346_g()) {
                this.func_70624_b((EntityLivingBase)par1DamageSource.func_76346_g());
            }
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean getMobGriefing() {
        return this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
    }

    public boolean getAllowLoot() {
        return this.field_70170_p.func_82736_K().func_82766_b("doMobLoot");
    }

    public boolean isEntityInRange(Entity entity, float min, float max) {
        float f = this.func_70032_d(entity);
        return f >= min && f <= max;
    }

    public int getIntegerInRange(int min, int max) {
        int cand = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)min, (int)max);
        return this.field_70146_Z.nextBoolean() ? cand : -cand;
    }

    public int getPlayersNearby() {
        return this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72314_b(64.0, 64.0, 64.0)).size();
    }

    public int getPlayersNearby(int min, int max) {
        return MathHelper.func_76125_a((int)this.getPlayersNearby(), (int)min, (int)max);
    }

    public int getPlayersNearby(double range) {
        return this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72314_b(range, range, range)).size();
    }

    public int getPlayersNearby(double range, int min, int max) {
        return MathHelper.func_76125_a((int)this.getPlayersNearby(range), (int)min, (int)max);
    }

    public void healByFactor(float factor) {
        int i = this.getPlayersNearby();
        this.func_70691_i(factor * (float)i);
    }

    public void healByFactorRanged(float factor, float min, float max) {
        int i = this.getPlayersNearby();
        float f = MathHelper.func_76131_a((float)(factor * (float)i), (float)min, (float)max);
        this.func_70691_i(f);
    }

    public int getHighestSolidBlock(int posX, int posY, int posZ) {
        while (this.field_70170_p.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c().func_149688_o() == Material.field_151579_a && posY > 0) {
            --posY;
        }
        return posY;
    }

    public boolean isHalloween() {
        Calendar calendar = this.field_70170_p.func_83015_S();
        return calendar.get(2) + 1 == 10 && calendar.get(5) > 29 || calendar.get(2) + 1 == 11 || calendar.get(5) < 3;
    }

    public boolean getIllumination() {
        return false;
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 24.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 24.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity par1Entity) {
        Vec3 vec3 = new Vec3(this.field_70165_t - par1Entity.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - par1Entity.field_70163_u + (double)par1Entity.func_70047_e(), this.field_70161_v - par1Entity.field_70161_v);
        vec3 = vec3.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72450_a * d0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3.field_72448_b * d0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72449_c * d0;
        return this.teleportTo(d1, d2, d3);
    }

    protected boolean teleportTo(double par1, double par3, double par5) {
        if (this.field_70128_L) {
            return false;
        }
        double d3 = this.field_70165_t;
        double d4 = this.field_70163_u;
        double d5 = this.field_70161_v;
        this.field_70165_t = par1;
        this.field_70163_u = par3;
        this.field_70161_v = par5;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70163_u);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        boolean flag2 = false;
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, new BlockPos(i, j, k)) <= this.getTeleportLight()) {
            flag2 = true;
        }
        if (this.field_70170_p.func_175667_e(new BlockPos(i, j, k)) && flag2) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = this.field_70170_p.func_180495_p(new BlockPos(i, j - 1, k)).func_177230_c();
                if (block.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.field_70165_t - d3) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d8 = d4 + (this.field_70163_u - d4) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double d9 = d5 + (this.field_70161_v - d5) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_175688_a(this.getTeleportParticle(), d7, d8, d9, (double)f, (double)f1, (double)f2, new int[0]);
        }
        this.field_70170_p.func_72908_a(d3, d4, d5, this.getTeleportSound(), 0.2f, 1.0f);
        this.func_85030_a(this.getTeleportSound(), 0.2f, 1.0f);
        this.onTeleport(d3, d4, d5);
        return true;
    }

    protected String getTeleportSound() {
        return "mob.endermen.portal";
    }

    protected EnumParticleTypes getTeleportParticle() {
        return EnumParticleTypes.PORTAL;
    }

    protected int getTeleportLight() {
        return 8;
    }

    protected void onTeleport(double x, double y, double z) {
    }

    protected boolean teleportPlayer(EntityPlayerMP mp) {
        if (mp.field_71075_bZ.field_75098_d) {
            return false;
        }
        double x = mp.field_70165_t;
        double y = mp.field_70163_u;
        double z = mp.field_70161_v;
        double x2 = this.field_70165_t;
        double y2 = this.field_70163_u;
        double z2 = this.field_70161_v;
        if (mp.field_71135_a.func_147362_b().func_150724_d() && this.field_70170_p == mp.field_70170_p) {
            if (mp.func_70115_ae()) {
                mp.func_70078_a(null);
            }
            mp.field_71135_a.func_147364_a(x2, y2, z2, mp.field_70177_z, mp.field_70125_A);
            int short1 = 128;
            for (int l = 0; l < short1; ++l) {
                double d6 = (double)l / ((double)short1 - 1.0);
                float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                double d7 = x + (x2 - x) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                double d8 = y + (y2 - y) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
                double d9 = z + (z2 - z) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                this.field_70170_p.func_175688_a(this.getTeleportParticle(), d7, d8, d9, (double)f, (double)f1, (double)f2, new int[0]);
            }
            mp.field_70143_R = 0.0f;
            this.field_70170_p.func_72956_a((Entity)mp, this.getTeleportSound(), 0.4f, 0.4f);
            return true;
        }
        return false;
    }

    protected void func_70609_aI() {
        int i;
        if (!TragicConfig.getBoolean("allowCustomBossDeathUpdate")) {
            super.func_70609_aI();
            return;
        }
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 1) {
            if (!this.field_70170_p.field_72995_K && this.field_70718_bc > 0) {
                this.xpAmount = this.func_70693_a(this.field_70717_bb);
            }
        } else if (this.field_70725_aQ < 60) {
            if (!this.field_70170_p.field_72995_K && this.field_70718_bc > 0 && this.xpAmount > 0) {
                int m = this.field_70146_Z.nextInt(32) + 1;
                if (m > this.xpAmount) {
                    m = this.xpAmount;
                }
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, m));
                this.xpAmount -= m;
            }
            for (i = 0; i < 3; i = (int)((byte)(i + 1))) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d3 = 10.0;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d0 * d3, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - d1 * d3, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d2 * d3, d0, d1, d2, new int[0]);
            }
        }
        if (this.field_70725_aQ == 60) {
            if (!this.field_70170_p.field_72995_K && this.field_70718_bc > 0) {
                int j;
                for (i = this.xpAmount; i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            this.func_70106_y();
            this.func_70656_aK();
        }
    }

    protected boolean spawnEntityNearby(EntityLiving entity, int hRange, int vRange, boolean withTarget) {
        for (int y1 = -vRange; y1 < vRange + 1; ++y1) {
            for (int z1 = -hRange; z1 < hRange + 1; ++z1) {
                for (int x1 = -vRange; x1 < hRange + 1; ++x1) {
                    if (!World.func_175683_a((IBlockAccess)this.field_70170_p, (BlockPos)new BlockPos((int)this.field_70165_t + x1, (int)this.field_70163_u + y1 - 1, (int)this.field_70161_v + z1)) || !this.field_70146_Z.nextBoolean()) continue;
                    entity.func_70107_b(this.field_70165_t + (double)x1, this.field_70163_u + (double)y1, this.field_70161_v + (double)z1);
                    if (!this.field_70170_p.func_72855_b(entity.func_174813_aQ()) || !this.field_70170_p.func_72945_a((Entity)entity, entity.func_174813_aQ()).isEmpty() || this.field_70170_p.func_72953_d(entity.func_174813_aQ())) continue;
                    this.field_70170_p.func_72838_d((Entity)entity);
                    entity.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos(this.field_70165_t + (double)x1, this.field_70163_u + (double)y1, this.field_70161_v + (double)z1)), null);
                    if (withTarget && this.func_70638_az() != null) {
                        entity.func_70624_b(this.func_70638_az());
                    }
                    this.field_70170_p.func_72956_a((Entity)this, "tragicmc:random.siren", 1.0f, 1.0f);
                    return true;
                }
            }
        }
        return false;
    }
}

