/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.boss;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.entity.EntityAIWatchTarget;
import tragicneko.tragicmc.entity.EntityMechaExo;
import tragicneko.tragicmc.entity.boss.TragicBoss;
import tragicneko.tragicmc.entity.mob.EntityAssaultNeko;
import tragicneko.tragicmc.entity.mob.EntityJetNeko;
import tragicneko.tragicmc.entity.mob.EntityNeko;
import tragicneko.tragicmc.entity.mob.EntityScienceNeko;
import tragicneko.tragicmc.entity.mob.EntityTragicNeko;
import tragicneko.tragicmc.util.WorldHelper;

public class EntityProfessorNekoid
extends TragicBoss {
    private static final int DW_BLASTER_TICKS = 20;
    private static final int DW_LOST_MECHA = 21;
    private static final int DW_MECHA_COMMAND = 22;
    private static final int DW_TITANFALL = 23;
    public static final Predicate nekoReleasedTarget = new Predicate(){

        public boolean apply(Object input) {
            return this.canApply((Entity)input);
        }

        public boolean canApply(Entity entity) {
            return entity instanceof EntityNeko && ((EntityNeko)entity).isReleased();
        }
    };
    private boolean lostStartingMech = false;

    public EntityProfessorNekoid(World par1World) {
        super(par1World);
        this.func_70105_a(0.475f, 1.895f);
        this.field_70728_aV = 500;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.75));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchTarget((EntityLiving)this, 48.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 48.0f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityNeko.class, 0, true, false, nekoReleasedTarget));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityGolem.class, 0, true, false, null));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] professorNekoidStats = TragicConfig.getMobStat("professorNekoidStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(professorNekoidStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(professorNekoidStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(professorNekoidStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(professorNekoidStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(professorNekoidStats[4]);
    }

    public int func_70658_aO() {
        return this.field_70154_o instanceof EntityMechaExo && TragicConfig.getBoolean("professorNekoidMechaArmor") ? 24 : TragicConfig.getMobStat("professorNekoidStats").getArmorValue();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)100);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)60);
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    public int getBlasterTicks() {
        return this.field_70180_af.func_75679_c(20);
    }

    private void setBlasterTicks(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    public int getCommandTicks() {
        return this.field_70180_af.func_75679_c(22);
    }

    private void setCommandTicks(int i) {
        this.field_70180_af.func_75692_b(22, (Object)i);
    }

    public boolean hasLostMecha() {
        return this.field_70180_af.func_75683_a(21) == 1;
    }

    private void setLostMecha(boolean flag) {
        this.field_70180_af.func_75692_b(21, (Object)(flag ? (byte)1 : 0));
    }

    public int getTitanfallTicks() {
        return this.field_70180_af.func_75679_c(23);
    }

    private void setTitanfallTicks(int i) {
        this.field_70180_af.func_75692_b(23, (Object)i);
    }

    @Override
    public void func_70636_d() {
        EntityMechaExo exo;
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70154_o != null && this.getBlasterTicks() == 220 || this.field_70154_o == null && this.getBlasterTicks() == 140) {
                MovingObjectPosition mop = WorldHelper.getMOPFromEntity((Entity)this, 10.0);
                double d0 = mop.field_72307_f.field_72450_a - this.field_70165_t;
                double d1 = mop.field_72307_f.field_72448_b - this.field_70163_u - (double)this.func_70047_e();
                double d2 = mop.field_72307_f.field_72449_c - this.field_70161_v;
                for (int b = 0; b < 16; b = (int)((byte)(b + 1))) {
                    for (int l = 0; l < 8; l = (int)((byte)(l + 1))) {
                        double d3 = 0.123 * (double)l + this.field_70146_Z.nextDouble() * 0.125;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, this.field_70165_t + d0 * d3 + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 4.0, this.field_70163_u + d1 * d3 + (double)this.func_70047_e() + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 2.0, this.field_70161_v + d2 * d3 + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 4.0, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
            return;
        }
        if (this.getCommandTicks() > 0) {
            this.setCommandTicks(this.getCommandTicks() - 1);
        }
        if (this.getBlasterTicks() > 0) {
            this.setBlasterTicks(this.getBlasterTicks() - 1);
        }
        if (this.getTitanfallTicks() > 0) {
            this.setTitanfallTicks(this.getTitanfallTicks() - 1);
        }
        if (this.hasLostMecha() && this.field_70154_o == null) {
            List list = this.field_70170_p.func_72872_a(EntityMechaExo.class, this.func_174813_aQ().func_72314_b(4.0, 4.0, 4.0));
            for (EntityMechaExo e : list) {
                if (e.field_70153_n != null) continue;
                this.func_70078_a((Entity)e);
                this.setLostMecha(false);
                break;
            }
        }
        if (this.func_70638_az() != null && (this.func_70638_az() == this.field_70154_o || this.func_70638_az() instanceof EntityNeko && !((EntityNeko)this.func_70638_az()).isReleased())) {
            this.func_70624_b(null);
            if (this.field_70154_o instanceof EntityMechaExo) {
                ((EntityLiving)this.field_70154_o).func_70624_b(null);
            }
        }
        if (!this.hasLostMecha() && (this.field_70154_o == null || this.field_70154_o.field_70128_L && this.field_70154_o instanceof EntityMechaExo)) {
            this.setLostMecha(true);
            this.setTitanfallTicks(360);
            this.lostStartingMech = true;
        }
        if (this.getTitanfallTicks() == 0 && this.hasLostMecha() && this.field_70122_E && TragicConfig.getBoolean("professorNekoidTitanfall")) {
            exo = new EntityMechaExo(this.field_70170_p);
            double y = this.field_70163_u - (double)WorldHelper.getDistanceToGround((Entity)this);
            BlockPos pos = new BlockPos(this.field_70165_t, y + 1.0, this.field_70161_v);
            y = y + 50.0 > 256.0 ? 256.0 : (y += 50.0);
            if (this.canAreaSeeSky(pos.func_177981_b(2), 1)) {
                exo.func_70107_b(this.field_70165_t, y, this.field_70161_v);
                exo.titanfalled = true;
                this.field_70170_p.func_72838_d((Entity)exo);
                if (TragicConfig.getBoolean("allowMobSounds")) {
                    this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.professornekoid.titanfall", 1.7f, 1.0f);
                }
                exo.setVariant(true);
            }
            this.setTitanfallTicks(200);
        }
        if (this.field_70154_o != null && this.field_70154_o instanceof EntityMechaExo && this.func_70638_az() != null && this.getCommandTicks() == 0 && TragicConfig.getBoolean("professorNekoidUseMecha")) {
            exo = (EntityMechaExo)this.field_70154_o;
            boolean flag = this.field_70146_Z.nextBoolean();
            exo.useAttackViaMob(flag ? 1 : 0, this.func_70638_az());
            this.setCommandTicks(flag ? 100 : 50);
            if (this.func_70638_az() != exo.func_70643_av()) {
                exo.func_70624_b(this.func_70638_az());
            }
        }
        if (this.getBlasterTicks() == 0 && this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) <= 12.0f && this.field_70146_Z.nextInt(6) == 0 && this.field_70173_aa % 5 == 0 && !this.field_70128_L && TragicConfig.getBoolean("professorNekoidBlaster")) {
            MovingObjectPosition mop = WorldHelper.getMOPFromEntity((Entity)this, 10.0);
            float f1 = this.field_70127_C + (this.field_70125_A - this.field_70127_C);
            float f2 = this.field_70126_B + (this.field_70177_z - this.field_70126_B);
            Vec3 vec3 = new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
            float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
            float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
            float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
            float f7 = f4 * f5;
            float f8 = f3 * f5;
            double box = 5.0;
            for (double d = 0.0; d <= 11.0; d += 0.5) {
                Vec3 vec31 = vec3.func_72441_c((double)f7 * d, (double)f6 * d, (double)f8 * d);
                if (d > 0.0 && (mop = WorldHelper.getMOPFromEntity((Entity)this, d)) != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) break;
                AxisAlignedBB bb = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_72314_b(box, box, box).func_72317_d(vec31.field_72450_a, vec31.field_72448_b + (double)this.func_70047_e(), vec31.field_72449_c);
                List list = this.field_70170_p.func_72839_b((Entity)this, bb);
                if (list.isEmpty()) continue;
                boolean flag = false;
                for (Entity e : list) {
                    if (e == this || e == this.field_70154_o) continue;
                    flag = true;
                    float f = this.func_70032_d(e) / 12.0f;
                    if (f <= 0.2f) {
                        f = 0.2f;
                    }
                    MovingObjectPosition mop2 = WorldHelper.getMOPFromEntity((Entity)this, 1.0f / f);
                    double x = mop2.field_72307_f.field_72450_a - this.field_70165_t;
                    double y = mop2.field_72307_f.field_72448_b - this.field_70163_u - (double)this.func_70047_e();
                    double z = mop2.field_72307_f.field_72449_c - this.field_70161_v;
                    e.func_70024_g(x, y, z);
                    if (e instanceof EntityNeko || e instanceof EntityMechaExo) continue;
                    e.func_70097_a(DamageSource.field_76379_h, 1.0f);
                }
                if (flag) break;
            }
            this.setBlasterTicks(this.field_70154_o != null ? 220 : 140);
            this.field_70170_p.func_72956_a((Entity)this, "tragicmc:random.windblast", 1.7f, 1.0f);
        }
        if (this.field_70173_aa % 40 == 0 && this.func_70638_az() != null && !this.field_70128_L) {
            double d = 16.0 + (double)(this.func_110143_aJ() / this.func_110138_aP()) * 48.0;
            List list = this.field_70170_p.func_72872_a(EntityNeko.class, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72314_b(d, d, d));
            for (EntityNeko e : list) {
                if (e.isReleased() || e.func_70638_az() != null) continue;
                e.func_70624_b(this.func_70638_az());
            }
            if (list.size() < 6 && (this.func_110143_aJ() < this.func_110138_aP() / 2.0f || this.hasLostMecha()) && this.field_70173_aa % 240 == 0 && TragicConfig.getBoolean("professorNekoidReinforcements")) {
                EntityNeko neko = new EntityTragicNeko(this.field_70170_p);
                if (this.field_70146_Z.nextInt(4) == 0) {
                    neko = this.field_70146_Z.nextInt(4) == 0 ? new EntityJetNeko(this.field_70170_p) : (this.field_70146_Z.nextBoolean() ? new EntityScienceNeko(this.field_70170_p) : new EntityAssaultNeko(this.field_70170_p));
                }
                neko.func_82149_j((Entity)this);
                this.spawnEntityNearby((EntityLiving)neko, 4, 5, true);
            }
        }
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (entity == this.field_70154_o) {
            return false;
        }
        return super.func_70652_k(entity);
    }

    @Override
    public boolean func_70097_a(DamageSource src, float dmg) {
        if (src.func_76346_g() != null && src.func_76346_g() == this.field_70154_o || src.func_94541_c() || src.func_76346_g() instanceof EntityNeko && !((EntityNeko)src.func_76346_g()).isReleased()) {
            return false;
        }
        boolean flag = super.func_70097_a(src, dmg);
        if (flag && this.field_70154_o instanceof EntityMechaExo && src.func_76346_g() instanceof EntityLivingBase) {
            if (src.func_76346_g() instanceof EntityLiving) {
                ((EntityLiving)src.func_76346_g()).func_70624_b((EntityLivingBase)((EntityMechaExo)this.field_70154_o));
            }
            ((EntityMechaExo)this.field_70154_o).func_70624_b((EntityLivingBase)src.func_76346_g());
        }
        return flag;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance ins, IEntityLivingData data) {
        if (!this.field_70170_p.field_72995_K && this.field_70154_o == null && TragicConfig.getBoolean("allowMechaExo") && TragicConfig.getBoolean("professorNekoidMechaSpawn")) {
            EntityMechaExo exo = new EntityMechaExo(this.field_70170_p);
            exo.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70170_p.func_72838_d((Entity)exo);
            this.func_70078_a((Entity)exo);
            exo.setVariant(true);
        }
        return super.func_180482_a(ins, data);
    }

    @Override
    public void func_70645_a(DamageSource src) {
        super.func_70645_a(src);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = (EntityPlayer)(src.func_76346_g() instanceof EntityPlayer ? src.func_76346_g() : null);
        if (TragicConfig.getBoolean("professorNekoidDeathRelease")) {
            double d = 48.0;
            List list = this.field_70170_p.func_72872_a(EntityNeko.class, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72314_b(d, d, d));
            for (EntityNeko e : list) {
                if (e.isReleased()) continue;
                e.releaseNeko(player);
            }
        }
        if (player instanceof EntityPlayerMP && !this.lostStartingMech) {
            player.func_71029_a((StatBase)TragicAchievements.professorNekoid);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("blasterTicks")) {
            this.setBlasterTicks(tag.func_74762_e("blasterTicks"));
        }
        if (tag.func_74764_b("hasLostMecha")) {
            this.setLostMecha(tag.func_74767_n("hasLostMecha"));
        }
        if (tag.func_74764_b("commandTicks")) {
            this.setCommandTicks(tag.func_74762_e("commandTicks"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("blasterTicks", this.getBlasterTicks());
        tag.func_74757_a("hasLostMecha", this.hasLostMecha());
        tag.func_74768_a("commandTicks", this.getCommandTicks());
    }

    public String func_70639_aQ() {
        return TragicConfig.getBoolean("allowMobSounds") ? (this.func_70638_az() == null ? "tragicmc:boss.professornekoid.idle" : "tragicmc:boss.professornekoid.battle") : null;
    }

    public String func_70621_aR() {
        return super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:boss.professornekoid.death" : null;
    }

    public float func_70647_i() {
        return 1.0f;
    }

    public float func_70599_aP() {
        return 0.6f;
    }

    public int func_70627_aG() {
        return 260;
    }

    public boolean canAreaSeeSky(BlockPos pos, int area) {
        if (!this.field_70170_p.func_175710_j(pos)) {
            return false;
        }
        for (int x1 = -area; x1 < area + 1; ++x1) {
            for (int z1 = -area; z1 < area + 1; ++z1) {
                if (this.field_70170_p.func_175710_j(pos.func_177982_a(x1, 0, z1))) continue;
                return false;
            }
        }
        return true;
    }
}

