/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.boss;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicEntities;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.entity.EntityAIWatchTarget;
import tragicneko.tragicmc.entity.boss.TragicBoss;

public class EntityPolaris
extends TragicBoss {
    public static final int DW_ATTACK_TIME = 20;
    public static final int DW_DAYTIME = 21;
    public static final int DW_CLONE = 22;
    public static final Predicate golemTarget = new Predicate(){

        public boolean apply(Object input) {
            return this.canApply((Entity)input);
        }

        public boolean canApply(Entity entity) {
            return entity instanceof EntityGolem;
        }
    };
    private EntityAIBase fearGolems = new EntityAIAvoidEntity((EntityCreature)this, EntityGolem.class, golemTarget, 6.0f, 1.0, 1.2);

    public EntityPolaris(World par1World) {
        super(par1World);
        this.func_70105_a(0.5f, 2.075f);
        this.field_70138_W = 2.0f;
        this.field_70728_aV = 600;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchTarget((EntityLiving)this, 48.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.75, 32.0f));
        if (TragicConfig.getBoolean("polarisFearGolems")) {
            this.field_70714_bg.func_75776_a(1, this.fearGolems);
        }
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
    }

    public EnumCreatureAttribute func_70668_bt() {
        return TragicEntities.Natural;
    }

    public boolean func_90999_ad() {
        return super.func_90999_ad() && !this.func_82150_aj();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        return !this.getDaytime() ? 0xF000F0 : super.func_70070_b(par1);
    }

    public float func_70013_c(float par1) {
        return !this.getDaytime() ? 1.0f : super.func_70013_c(par1);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] polarisStats = TragicConfig.getMobStat("polarisStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(polarisStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(polarisStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(polarisStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(polarisStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(polarisStats[4]);
    }

    @Override
    public void func_70645_a(DamageSource src) {
        super.func_70645_a(src);
        if (src.func_76346_g() instanceof EntityPlayerMP && TragicConfig.getBoolean("allowAchievements")) {
            ((EntityPlayerMP)src.func_76346_g()).func_71029_a((StatBase)TragicAchievements.polaris);
        }
    }

    @Override
    protected void func_70628_a(boolean flag, int l) {
        super.func_70628_a(flag, l);
        if (!this.field_70170_p.field_72995_K && TragicConfig.getBoolean("allowMobStatueDrops") && this.field_70146_Z.nextInt(100) <= TragicConfig.getInt("mobStatueDropChance") && this.getAllowLoot()) {
            this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(TragicItems.MobStatue, 1, 5)));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
    }

    public int getAttackTime() {
        return this.field_70180_af.func_75679_c(20);
    }

    private void setAttackTime(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    private void decrementAttackTime() {
        int pow = this.getAttackTime();
        this.setAttackTime(--pow);
    }

    public boolean getDaytime() {
        return this.field_70180_af.func_75679_c(21) == 0;
    }

    private void setDaytime(boolean flag) {
        this.field_70180_af.func_75692_b(21, (Object)(flag ? 0 : 1));
    }

    public boolean isClone() {
        return this.field_70180_af.func_75679_c(22) == 1;
    }

    public void setClone() {
        this.field_70180_af.func_75692_b(22, (Object)1);
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_72935_r() && !this.getDaytime()) {
                this.setDaytime(true);
            } else if (!this.field_70170_p.func_72935_r() && this.getDaytime()) {
                this.setDaytime(false);
            }
        }
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.getAttackTime() > 0) {
            this.decrementAttackTime();
        }
        if (this.isClone() && this.field_70714_bg.field_75782_a.contains(this.fearGolems)) {
            this.field_70714_bg.field_75782_a.remove(this.fearGolems);
        }
        if (this.func_70090_H()) {
            this.teleportRandomly();
        }
        if (this.field_70173_aa % 240 == 0 && TragicConfig.getBoolean("polarisRegeneration")) {
            this.func_70691_i(3.0f);
        }
        if (this.func_70638_az() != null && !this.isClone()) {
            if (TragicConfig.getBoolean("polarisNighttimeSet")) {
                this.field_70170_p.func_72912_H().func_76068_b(18000L);
            }
            if (this.isEntityInRange((Entity)this.func_70638_az(), 3.0f, 16.0f) && TragicConfig.getBoolean("polarisInvisibility")) {
                this.func_82142_c(true);
            } else {
                this.func_82142_c(false);
            }
            if (this.func_70032_d((Entity)this.func_70638_az()) > 16.0f && this.field_70146_Z.nextInt(48) == 0 && TragicConfig.getBoolean("polarisTeleport")) {
                this.teleportToEntity((Entity)this.func_70638_az());
            }
            if (this.field_70173_aa % 10 == 0 && this.field_70146_Z.nextInt(4) == 0 && this.func_70032_d((Entity)this.func_70638_az()) <= 12.0f && TragicConfig.getBoolean("polarisTeleport")) {
                this.teleportRandomly();
            }
        } else {
            this.func_82142_c(false);
        }
        if (this.isClone() && this.field_70173_aa >= 100) {
            this.func_70106_y();
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.isClone()) {
            this.func_70018_K();
            this.func_70106_y();
            return true;
        }
        if (par1DamageSource.func_76355_l().equals("arrow") || this.func_82150_aj()) {
            par2 = (float)((double)par2 * 1.15);
        }
        if (par1DamageSource.func_76346_g() != null && par1DamageSource.func_76346_g() instanceof EntityLivingBase) {
            if (this.func_110143_aJ() - par2 > 0.0f && TragicConfig.getBoolean("polarisTeleport")) {
                this.teleportRandomly();
            }
            if (par1DamageSource.func_76346_g() instanceof EntityPlayer && !par1DamageSource.func_76352_a()) {
                EntityPlayer player = (EntityPlayer)par1DamageSource.func_76346_g();
                player.field_71067_cb = player.field_71067_cb > 20 ? (player.field_71067_cb -= 20) : 0;
            }
        }
        if (this.getAttackTime() == 0) {
            this.setAttackTime(5);
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        boolean flag = super.func_70652_k(par1Entity);
        if (flag) {
            if (this.field_70146_Z.nextBoolean() && par1Entity instanceof EntityLivingBase) {
                ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 30));
            }
            if (TragicConfig.getBoolean("polarisTeleport")) {
                this.teleportRandomly();
            }
            ArrayList list = (ArrayList)this.field_70170_p.func_72872_a(EntityPolaris.class, this.func_174813_aQ().func_72314_b(32.0, 32.0, 32.0));
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) == this || this.isClone() || !((EntityPolaris)((Object)list.get(i))).isClone()) continue;
                ((EntityPolaris)((Object)list.get(i))).func_70106_y();
            }
            if (this.isClone()) {
                this.func_70106_y();
            }
        }
        return flag;
    }

    public int func_70658_aO() {
        return this.field_70170_p.func_72935_r() ? 0 : TragicConfig.getMobStat("polarisStats").getArmorValue();
    }

    public void func_180430_e(float dist, float multi) {
    }

    @Override
    protected void onTeleport(double d3, double d4, double d5) {
        if (this.field_70146_Z.nextBoolean() && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f && TragicConfig.getBoolean("polarisAfterImage")) {
            List list = this.field_70170_p.func_72872_a(EntityPolaris.class, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72314_b(32.0, 32.0, 32.0));
            for (int mow = 0; mow < list.size(); ++mow) {
                if (list.get(mow) != this) continue;
                list.remove(mow);
            }
            if (list.size() <= 3) {
                EntityPolaris polar = new EntityPolaris(this.field_70170_p);
                polar.func_82149_j((Entity)this);
                polar.func_70107_b(d3, d4, d5);
                polar.setClone();
                this.field_70170_p.func_72838_d((Entity)polar);
                if (this.func_70638_az() != null) {
                    polar.func_70624_b(this.func_70638_az());
                }
                polar.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos(d3, d4, d5)), null);
            }
        }
    }

    public void func_70110_aj() {
    }

    public IEntityLivingData func_180482_a(DifficultyInstance ins, IEntityLivingData data) {
        if (!this.field_70170_p.field_72995_K && !this.field_70170_p.func_72935_r() && this.getDaytime()) {
            this.setDaytime(false);
        }
        return super.func_180482_a(ins, data);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("attackTime")) {
            this.setAttackTime(tag.func_74762_e("attackTime"));
        }
        if (tag.func_74764_b("isClone") && tag.func_74767_n("isClone")) {
            this.setClone();
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("attackTime", this.getAttackTime());
        tag.func_74757_a("isClone", this.isClone());
    }

    public String func_70639_aQ() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:boss.polaris.sonar" : null;
    }

    public String func_70621_aR() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:boss.polaris.ding" : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:boss.polaris.death" : null;
    }

    public float func_70647_i() {
        return 0.8f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    public float func_70599_aP() {
        return 1.0f;
    }

    public int func_70627_aG() {
        return super.func_70627_aG();
    }

    @Override
    protected String getTeleportSound() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:boss.polaris.clone" : super.getTeleportSound();
    }

    @Override
    protected int getTeleportLight() {
        return 15;
    }
}

