/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.boss;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicEntities;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.entity.EntityAIWatchTarget;
import tragicneko.tragicmc.entity.EntityKurayami;
import tragicneko.tragicmc.entity.boss.TragicBoss;

public class EntityKitsune
extends TragicBoss {
    public static final int DW_FIRING_TICKS = 20;
    public static final int DW_TAUNT_TICKS = 21;
    public static final int DW_HURT_TIME = 22;
    public static final int DW_ATTACK_TIME = 23;
    private AttributeModifier mod = new AttributeModifier(UUID.fromString("c6334c3a-6cf4-4755-8fe5-d1b713c1f375"), "kitsuneSpeedDebuff", TragicConfig.modifier[1], 0);

    public EntityKitsune(World par1World) {
        super(par1World);
        this.func_70105_a(0.745f, 1.745f);
        this.field_70728_aV = 800;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.75));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchTarget((EntityLiving)this, 32.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 64.0f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
        this.field_70178_ae = true;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return TragicEntities.Beast;
    }

    public boolean func_90999_ad() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] kitsunakumaStats = TragicConfig.getMobStat("kitsunakumaStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(kitsunakumaStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(kitsunakumaStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(kitsunakumaStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(kitsunakumaStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(kitsunakumaStats[4]);
    }

    public int func_70658_aO() {
        return TragicConfig.getMobStat("kitsunakumaStats").getArmorValue();
    }

    @Override
    public void func_70645_a(DamageSource src) {
        super.func_70645_a(src);
        if (src.func_76346_g() instanceof EntityPlayerMP && TragicConfig.getBoolean("allowAchievements")) {
            ((EntityPlayerMP)src.func_76346_g()).func_71029_a((StatBase)TragicAchievements.kitsunakuma);
        }
    }

    @Override
    protected void func_70628_a(boolean flag, int l) {
        super.func_70628_a(flag, l);
        if (!this.field_70170_p.field_72995_K && TragicConfig.getBoolean("allowMobStatueDrops") && this.field_70146_Z.nextInt(100) <= TragicConfig.getInt("mobStatueDropChance") && this.getAllowLoot()) {
            this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(TragicItems.MobStatue, 1, 1)));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    public int getFiringTicks() {
        return this.field_70180_af.func_75679_c(20);
    }

    private void setFiringTicks(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    private void decrementFiringTicks() {
        int pow = this.getFiringTicks();
        this.setFiringTicks(--pow);
    }

    public boolean isFiring() {
        return this.getFiringTicks() > 0;
    }

    public int getTauntTicks() {
        return this.field_70180_af.func_75679_c(21);
    }

    private void setTauntTicks(int i) {
        this.field_70180_af.func_75692_b(21, (Object)i);
    }

    private void decrementTauntTicks() {
        int pow = this.getTauntTicks();
        this.setTauntTicks(--pow);
    }

    public int getHurtTime() {
        return this.field_70180_af.func_75679_c(22);
    }

    private void setHurtTime(int i) {
        this.field_70180_af.func_75692_b(22, (Object)i);
    }

    private void decrementHurtTime() {
        int pow = this.getHurtTime();
        this.setHurtTime(--pow);
    }

    public int getAttackTime() {
        return this.field_70180_af.func_75679_c(23);
    }

    private void setAttackTime(int i) {
        this.field_70180_af.func_75692_b(23, (Object)i);
    }

    private void decrementAttackTime() {
        int pow = this.getAttackTime();
        this.setAttackTime(--pow);
    }

    @Override
    public void func_70636_d() {
        if (this.getTauntTicks() > 0 || this.isFiring()) {
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
        }
        if (this.getTauntTicks() > 0 || this.isFiring()) {
            this.field_70181_x = -0.1;
        }
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextBoolean() || this.isFiring() || this.getHurtTime() > 0) {
                int wow = this.isFiring() ? 4 : (this.getHurtTime() > 0 ? 4 : 1);
                EnumParticleTypes s = this.getHurtTime() > 0 ? EnumParticleTypes.SMOKE_NORMAL : EnumParticleTypes.FLAME;
                for (int i = 0; i < wow; ++i) {
                    this.field_70170_p.func_175688_a(s, this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.355, this.field_70163_u + 0.115 + this.field_70146_Z.nextDouble(), this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.355, 0.0, (double)(0.155f * this.field_70146_Z.nextFloat()), 0.0, new int[0]);
                }
            }
            if (this.getHurtTime() == 100) {
                for (int i = 0; i < 36; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.355, this.field_70163_u + 0.115 + this.field_70146_Z.nextDouble(), this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.355, (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), (double)(0.155f * this.field_70146_Z.nextFloat()), (double)this.field_70146_Z.nextFloat(), new int[0]);
                }
            }
            return;
        }
        if (this.getAttackTime() > 0) {
            this.decrementAttackTime();
        }
        if (this.isFiring()) {
            this.decrementFiringTicks();
        }
        if (this.getHurtTime() > 0) {
            this.decrementHurtTime();
        }
        if (this.getTauntTicks() > 0 && this.getHurtTime() > 0) {
            this.setTauntTicks(0);
        }
        if (this.getTauntTicks() > 0) {
            this.decrementTauntTicks();
        }
        if ((this.getTauntTicks() == 1 && TragicConfig.getBoolean("kitsunakumaTaunt") || this.getAttackTime() == 1) && TragicConfig.getBoolean("kitsunakumaTeleport")) {
            this.teleportRandomly();
        }
        if (this.getAttackTime() == 5 && this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) <= 5.0f) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(this.mod);
        if (this.isFiring() || this.getTauntTicks() > 0) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(this.mod);
        }
        if (this.func_70090_H() && TragicConfig.getBoolean("kitsunakumaTeleport")) {
            this.teleportRandomly();
        }
        if (this.func_70638_az() != null) {
            boolean flag;
            double d2;
            double d1;
            if (this.isFiring() && (this.func_70032_d((Entity)this.func_70638_az()) < 4.0f || this.func_70032_d((Entity)this.func_70638_az()) >= 14.0f)) {
                this.setFiringTicks(0);
            } else if (this.field_70122_E && this.func_70032_d((Entity)this.func_70638_az()) < 4.0f && this.field_70146_Z.nextInt(32) == 0) {
                double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
                d2 = this.func_70638_az().field_70163_u - this.field_70163_u;
                float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                this.field_70159_w = d0 / (double)f2 * 1.05 * 0.500000011920929 + this.field_70159_w * 0.40000000298023225;
                this.field_70179_y = d1 / (double)f2 * 1.05 * 0.500000011920929 + this.field_70179_y * 0.40000000298023225;
                this.field_70181_x = d1 / (double)f2 * 1.1 * 0.200000011920929 + this.field_70181_x * (double)0.2f;
            }
            if (this.func_70685_l((Entity)this.func_70638_az())) {
                if (this.field_70146_Z.nextInt(48) == 0) {
                    EntityLivingBase entity = this.func_70638_az();
                    if (this.field_70146_Z.nextInt(72) == 0) {
                        entity.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 300 + this.field_70146_Z.nextInt(320), 0));
                    }
                    if (this.field_70146_Z.nextInt(72) == 0 && TragicConfig.getBoolean("allowDisorientation")) {
                        entity.func_70690_d(new PotionEffect(TragicPotion.Disorientation.field_76415_H, 300 + this.field_70146_Z.nextInt(320), this.field_70146_Z.nextInt(3)));
                    }
                    if (this.field_70146_Z.nextInt(72) == 0) {
                        entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 300 + this.field_70146_Z.nextInt(320), 0));
                    }
                    if (this.field_70173_aa % 120 == 0 && this.field_70146_Z.nextInt(16) == 0 && TragicConfig.getBoolean("kitsunakumaTeleport")) {
                        this.teleportRandomly();
                    }
                }
                if (this.getHurtTime() % 20 == 0 && this.getHurtTime() > 0 && this.func_70032_d((Entity)this.func_70638_az()) > 4.0f && TragicConfig.getBoolean("kitsunakumaFireballs")) {
                    double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                    d1 = this.func_70638_az().func_174813_aQ().field_72338_b + (double)(this.func_70638_az().field_70131_O / 3.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
                    d2 = this.func_70638_az().field_70161_v - this.field_70161_v;
                    float f1 = MathHelper.func_76129_c((float)this.func_70032_d((Entity)this.func_70638_az())) * 0.175f;
                    for (int i = 0; i < 3; ++i) {
                        EntitySmallFireball fireball = new EntitySmallFireball(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
                        fireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O * 2.0f / 3.0f);
                        this.field_70170_p.func_72838_d((Entity)fireball);
                    }
                }
            } else if ((this.field_70146_Z.nextInt(56) == 0 || this.getHurtTime() > 0 && this.getHurtTime() % 20 == 0 && this.func_70032_d((Entity)this.func_70638_az()) > 4.0f || this.func_70032_d((Entity)this.func_70638_az()) >= 14.0f && this.field_70146_Z.nextInt(4) == 0) && TragicConfig.getBoolean("kitsunakumaTeleport")) {
                this.teleportToEntity((Entity)this.func_70638_az());
            }
            if (this.isEntityInRange((Entity)this.func_70638_az(), 6.0f, 16.0f) && this.field_70146_Z.nextInt(4) == 0 && !this.isFiring() && this.func_70685_l((Entity)this.func_70638_az()) && this.getTauntTicks() == 0 && this.field_70173_aa % 5 == 0 && TragicConfig.getBoolean("kitsunakumaFireballs")) {
                this.setFiringTicks(40);
            }
            if (this.isEntityInRange((Entity)this.func_70638_az(), 4.0f, 16.0f) && this.func_70685_l((Entity)this.func_70638_az()) && this.getTauntTicks() == 0 && this.isFiring() && this.getFiringTicks() % 25 == 0 && TragicConfig.getBoolean("kitsunakumaFireballs")) {
                double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                d1 = this.func_70638_az().func_174813_aQ().field_72338_b + (double)(this.func_70638_az().field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
                d2 = this.func_70638_az().field_70161_v - this.field_70161_v;
                EntityLargeFireball fireball = new EntityLargeFireball(this.field_70170_p, (EntityLivingBase)this, d0, d1, d2);
                fireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O * 2.0f / 3.0f);
                this.field_70170_p.func_72838_d((Entity)fireball);
            }
            if (this.func_70032_d((Entity)this.func_70638_az()) >= 12.0f && this.field_70146_Z.nextInt(36) == 0 && !this.isFiring() && this.getTauntTicks() == 0 && TragicConfig.getBoolean("kitsunakumaTeleport") && !(flag = this.teleportToEntity((Entity)this.func_70638_az()))) {
                this.teleportRandomly();
            }
            if (!this.isFiring() && this.func_70032_d((Entity)this.func_70638_az()) > 8.0f && this.func_70032_d((Entity)this.func_70638_az()) < 16.0f && this.field_70146_Z.nextInt(56) == 0 && this.getTauntTicks() == 0 && TragicConfig.getBoolean("kitsunakumaTaunt")) {
                this.setTauntTicks(40);
            }
            if (this.getTauntTicks() == 40 && TragicConfig.getBoolean("allowMobSounds")) {
                this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.kitsune.taunt", 1.0f, 1.0f);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70170_p.field_72995_K || this.getHurtTime() > 0) {
            return false;
        }
        boolean flag = false;
        if (par1DamageSource.func_76346_g() != null && par1DamageSource.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)par1DamageSource.func_76346_g();
            boolean bl = flag = player.func_71045_bC() != null && (player.func_71045_bC().func_77973_b() == TragicItems.SwordOfJustice || player.func_71045_bC().func_77973_b() == TragicItems.BowOfJustice);
        }
        if (par1DamageSource.func_76346_g() instanceof EntityKurayami) {
            return super.func_70097_a(par1DamageSource, par2 * 0.145f);
        }
        if (!TragicConfig.getBoolean("kitsunakumaFireballExempt")) {
            return super.func_70097_a(par1DamageSource, par2);
        }
        if (!par1DamageSource.func_76355_l().equals("fireball") && !flag) {
            return super.func_70097_a(par1DamageSource, 0.0f);
        }
        if (this.getHurtTime() == 0 && !flag) {
            this.setHurtTime(100);
        }
        float f = flag ? Float.MAX_VALUE : (par2 = (float)(this.isFiring() && this.getFiringTicks() % 20 >= 15 ? 20 : 10));
        if (!flag && par1DamageSource.func_76346_g() != null && TragicConfig.getBoolean("kitsunakumaTeleport")) {
            this.teleportToEntity(par1DamageSource.func_76346_g());
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        boolean flag = super.func_70652_k(par1Entity);
        if (flag) {
            if (this.getTauntTicks() > 0) {
                this.setTauntTicks(0);
            }
            if (this.getFiringTicks() > 0) {
                this.setFiringTicks(0);
            }
            if (this.getAttackTime() == 0) {
                this.setAttackTime(10);
            }
            if (par1Entity instanceof EntityLivingBase && this.field_70146_Z.nextBoolean()) {
                switch (this.field_70146_Z.nextInt(8)) {
                    default: {
                        ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                        break;
                    }
                    case 1: {
                        ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                        break;
                    }
                    case 2: {
                        if (!TragicConfig.getBoolean("allowDisorientation")) break;
                        ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Disorientation.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                    }
                }
            }
            if (this.field_70146_Z.nextInt(4) == 0) {
                par1Entity.func_70015_d(4 + this.field_70146_Z.nextInt(8));
            }
        }
        return flag;
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("firingTicks")) {
            this.setFiringTicks(tag.func_74762_e("firingTicks"));
        }
        if (tag.func_74764_b("tauntTicks")) {
            this.setTauntTicks(tag.func_74762_e("tauntTicks"));
        }
        if (tag.func_74764_b("hurtTime")) {
            this.setHurtTime(tag.func_74762_e("hurtTime"));
        }
        if (tag.func_74764_b("attackTime")) {
            this.setAttackTime(tag.func_74762_e("attackTime"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("firingTicks", this.getFiringTicks());
        tag.func_74768_a("tauntTicks", this.getTauntTicks());
        tag.func_74768_a("hurtTime", this.getHurtTime());
        tag.func_74768_a("attackTime", this.getAttackTime());
    }

    public String func_70639_aQ() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:boss.kitsune.living" : null;
    }

    public String func_70621_aR() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:boss.kitsune.hurt" : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:boss.kitsune.hurt" : null;
    }

    public float func_70647_i() {
        return 0.8f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    public float func_70599_aP() {
        return 0.6f;
    }

    public int func_70627_aG() {
        return super.func_70627_aG() / 2;
    }

    @Override
    protected EnumParticleTypes getTeleportParticle() {
        return EnumParticleTypes.FLAME;
    }

    @Override
    protected int getTeleportLight() {
        return 15;
    }
}

