/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.boss;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.entity.EntityAIWatchTarget;
import tragicneko.tragicmc.entity.alpha.EntityOverlordCore;
import tragicneko.tragicmc.entity.boss.TragicBoss;
import tragicneko.tragicmc.entity.projectile.EntityLargePumpkinbomb;
import tragicneko.tragicmc.util.WorldHelper;

public class EntityDeathReaper
extends TragicBoss {
    public static final int DW_DEMEANOR = 20;
    public static final int DW_ATTACK_TIME = 21;
    public static final int DW_HIT_TIME = 22;
    public static final int DW_CLONE_TIME = 23;
    public static final int DW_REAPER_TYPE = 24;
    private boolean isBomb;

    public EntityDeathReaper(World par1World) {
        super(par1World);
        this.func_70105_a(0.7f, 2.1f);
        this.field_70138_W = 2.0f;
        this.field_70728_aV = 1200;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.75));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchTarget((EntityLiving)this, 32.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 32.0f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityGolem.class, 0, true, false, null));
        this.field_70178_ae = true;
        this.isBomb = false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
    }

    public int getDemeanor() {
        return this.field_70180_af.func_75679_c(20);
    }

    private void setDemeanor(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    private void decrementDemeanor() {
        int pow = this.getDemeanor();
        if (pow > -20) {
            this.setDemeanor(--pow);
        }
    }

    private void incrementDemeanor() {
        int pow = this.getDemeanor();
        if (pow < 20) {
            this.setDemeanor(++pow);
        }
    }

    public boolean isBeingAggressive() {
        return this.getDemeanor() > 0;
    }

    public int getAttackTime() {
        return this.field_70180_af.func_75679_c(21);
    }

    private void setAttackTime(int i) {
        this.field_70180_af.func_75692_b(21, (Object)i);
    }

    private void decrementAttackTime() {
        int pow = this.getAttackTime();
        this.setAttackTime(--pow);
    }

    public int getHitTime() {
        return this.field_70180_af.func_75679_c(22);
    }

    private void setHitTime(int i) {
        this.field_70180_af.func_75692_b(22, (Object)i);
    }

    private void incrementHitTime() {
        int pow = this.getHitTime();
        this.setHitTime(++pow);
    }

    private int getCloneTime() {
        return this.field_70180_af.func_75679_c(23);
    }

    private void setCloneTime(int i) {
        this.field_70180_af.func_75692_b(23, (Object)i);
    }

    private void incrementCloneTime() {
        int pow = this.getCloneTime();
        this.setCloneTime(++pow);
    }

    public int getReaperType() {
        return this.field_70180_af.func_75679_c(24);
    }

    private void setReaperType(int i) {
        this.field_70180_af.func_75692_b(24, (Object)i);
        if (i == 0) {
            this.isBomb = false;
        }
    }

    public void setClone() {
        this.setReaperType(1);
        this.isBomb = this.field_70146_Z.nextBoolean();
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean func_90999_ad() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        boolean flag = this.getReaperType() == 0;
        double[] skultarStats = TragicConfig.getMobStat("skultarStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(skultarStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(flag ? skultarStats[1] : skultarStats[1] * 0.875);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(flag ? skultarStats[2] : skultarStats[2] / 2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(skultarStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(flag ? skultarStats[4] : skultarStats[4] * 0.4);
    }

    @Override
    public void func_70645_a(DamageSource src) {
        if (this.getReaperType() == 1) {
            return;
        }
        super.func_70645_a(src);
        if (src.func_76346_g() instanceof EntityPlayerMP && TragicConfig.getBoolean("allowAchievements")) {
            ((EntityPlayerMP)src.func_76346_g()).func_71029_a((StatBase)TragicAchievements.skultar);
        }
        List list = this.field_70170_p.func_72872_a(EntityDeathReaper.class, this.func_174813_aQ().func_72314_b(32.0, 32.0, 32.0));
        for (EntityDeathReaper reaper : list) {
            if (reaper.getReaperType() != 1) continue;
            reaper.func_70106_y();
        }
    }

    @Override
    protected void func_70628_a(boolean flag, int l) {
        super.func_70628_a(flag, l);
        if (!this.field_70170_p.field_72995_K && TragicConfig.getBoolean("allowMobStatueDrops") && this.field_70146_Z.nextInt(100) <= TragicConfig.getInt("mobStatueDropChance") && this.getAllowLoot()) {
            this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(TragicItems.MobStatue, 1, 2)));
        }
    }

    @Override
    public void func_70636_d() {
        if (this.func_82165_m(Potion.field_82731_v.field_76415_H)) {
            this.func_82170_o(Potion.field_82731_v.field_76415_H);
        }
        if (this.func_82165_m(Potion.field_76437_t.field_76415_H)) {
            this.func_82170_o(Potion.field_76437_t.field_76415_H);
        }
        if (this.func_82165_m(Potion.field_76440_q.field_76415_H)) {
            this.func_82170_o(Potion.field_76440_q.field_76415_H);
        }
        if (this.getAttackTime() > 0) {
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
        }
        if (this.getAttackTime() > 0) {
            this.field_70181_x = -0.1;
        }
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            int i;
            EnumParticleTypes s = this.isBeingAggressive() ? EnumParticleTypes.REDSTONE : EnumParticleTypes.SPELL_MOB_AMBIENT;
            int pow = this.isBeingAggressive() ? 4 : 8;
            for (i = 0; i < pow; ++i) {
                this.field_70170_p.func_175688_a(s, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 1.3, this.field_70163_u + this.field_70146_Z.nextDouble() * 0.115 + 0.545, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 1.3, 0.0, this.field_70146_Z.nextDouble() * 0.5556, 0.0, new int[0]);
            }
            if (this.getAttackTime() == 2) {
                for (i = 0; i < 14; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 1.3, this.field_70163_u + this.field_70146_Z.nextDouble() * 0.115 + 0.375, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 1.3, 0.0, this.field_70146_Z.nextDouble() * 0.5556, 0.0, new int[0]);
                }
            }
        } else {
            int i;
            this.incrementCloneTime();
            this.incrementHitTime();
            if (this.field_70146_Z.nextInt(524) == 0 && this.getDemeanor() <= 0 && this.func_70638_az() != null || this.getHitTime() >= 100 && this.func_70638_az() != null) {
                this.setDemeanor(5);
            }
            if (this.getAttackTime() > 0) {
                this.decrementAttackTime();
            }
            if (this.isBomb) {
                this.setCloneTime(0);
                if (this.getReaperType() == 0) {
                    this.isBomb = false;
                }
            }
            if (this.field_70173_aa % 60 == 0 && this.func_110143_aJ() < this.func_110138_aP() && this.getReaperType() == 0 && TragicConfig.getBoolean("skultarRegeneration")) {
                this.func_70691_i(6.0f);
            }
            if (this.field_70173_aa >= 600 && this.getReaperType() == 1) {
                this.func_70106_y();
            }
            if (this.func_70638_az() == null) {
                this.setDemeanor(0);
                this.setCloneTime(0);
                if (this.getReaperType() == 1) {
                    this.func_70106_y();
                }
            } else {
                int x;
                float f2;
                double d2;
                double d1;
                int z;
                if (this.func_70638_az() instanceof EntityPlayerMP && TragicConfig.getBoolean("allowAchievements") && TragicConfig.getBoolean("allowImmunity") && TragicConfig.getBoolean("allowClarity") && this.func_70638_az().func_70644_a(TragicPotion.Immunity) && this.func_70638_az().func_70644_a(TragicPotion.Clarity)) {
                    ((EntityPlayerMP)this.func_70638_az()).func_71029_a((StatBase)TragicAchievements.skultarImmune);
                }
                if (this.func_70638_az().func_110143_aJ() <= this.func_70638_az().func_110138_aP() / 4.0f) {
                    this.setDemeanor(5);
                }
                int n = z = this.func_110143_aJ() <= this.func_110138_aP() / 2.0f ? 2 : 1;
                if (this.func_70685_l((Entity)this.func_70638_az()) && this.field_70146_Z.nextInt(96 / z) == 0 && this.getReaperType() == 0) {
                    EntityLivingBase entity = this.func_70638_az();
                    if (this.field_70146_Z.nextInt(72) == 0) {
                        entity.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 300 + this.field_70146_Z.nextInt(320), 0));
                    }
                    if (this.field_70146_Z.nextInt(256) == 0) {
                        entity.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 300 + this.field_70146_Z.nextInt(320), 0));
                    }
                    if (this.field_70146_Z.nextInt(128) == 0 && TragicConfig.getBoolean("allowInhibit")) {
                        entity.func_70690_d(new PotionEffect(TragicPotion.Inhibit.field_76415_H, 300 + this.field_70146_Z.nextInt(320), 0));
                    }
                    if (this.field_70146_Z.nextInt(72) == 0 && TragicConfig.getBoolean("allowCripple")) {
                        entity.func_70690_d(new PotionEffect(TragicPotion.Cripple.field_76415_H, 300 + this.field_70146_Z.nextInt(320), this.field_70146_Z.nextInt(3)));
                    }
                    if (this.field_70146_Z.nextInt(72) == 0 && TragicConfig.getBoolean("allowDisorientation")) {
                        entity.func_70690_d(new PotionEffect(TragicPotion.Disorientation.field_76415_H, 300 + this.field_70146_Z.nextInt(320), this.field_70146_Z.nextInt(3)));
                    }
                    if (this.field_70146_Z.nextInt(72) == 0 && TragicConfig.getBoolean("allowMalnourish")) {
                        entity.func_70690_d(new PotionEffect(TragicPotion.Malnourish.field_76415_H, 300 + this.field_70146_Z.nextInt(320), this.field_70146_Z.nextInt(3)));
                    }
                }
                if (this.isEntityInRange((Entity)this.func_70638_az(), 2.0f, 6.0f) && this.field_70122_E && this.field_70146_Z.nextInt(16) == 0 && this.getAttackTime() == 0) {
                    double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                    d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
                    d2 = this.func_70638_az().field_70163_u - this.field_70163_u;
                    f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    if (this.isBeingAggressive()) {
                        this.field_70159_w = d0 / (double)f2 * 2.45 * (double)0.8f + this.field_70159_w * 0.8000000029802322;
                        this.field_70179_y = d1 / (double)f2 * 2.45 * (double)0.8f + this.field_70179_y * 0.8000000029802322;
                        this.field_70181_x = d2 / (double)f2 * 2.45 * (double)0.8f + this.field_70181_x * 0.8000000029802322;
                    } else {
                        this.field_70159_w = -d0 / (double)f2 * 2.45 * (double)0.8f + this.field_70159_w * 0.8000000029802322;
                        this.field_70179_y = -d1 / (double)f2 * 2.45 * (double)0.8f + this.field_70179_y * 0.8000000029802322;
                        this.field_70181_x = d2 / (double)f2 * 2.45 * (double)0.8f + this.field_70181_x * 0.8000000029802322;
                    }
                } else if (this.func_70638_az() != null && this.isEntityInRange((Entity)this.func_70638_az(), 1.0f, 12.0f) && this.getAttackTime() == 0) {
                    double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                    d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
                    d2 = this.func_70638_az().field_70163_u - this.field_70163_u;
                    f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    if (!this.isBeingAggressive()) {
                        this.field_70159_w = -d0 / (double)f2 * 1.25 * 0.200000011920929 + this.field_70159_w * 0.10000000298023223;
                        this.field_70179_y = -d1 / (double)f2 * 1.25 * 0.200000011920929 + this.field_70179_y * 0.10000000298023223;
                        this.field_70181_x = d2 / (double)f2 * 1.25 * 0.200000011920929 + this.field_70181_x * 0.10000000298023223;
                    }
                }
                int n2 = x = this.func_110143_aJ() <= this.func_110138_aP() / 2.0f ? 4 : 2;
                if (this.func_70032_d((Entity)this.func_70638_az()) > 4.0f && this.field_70146_Z.nextInt(64 / x) == 0 && this.func_70685_l((Entity)this.func_70638_az()) && this.getAttackTime() == 0 && TragicConfig.getBoolean("skultarProjectiles")) {
                    double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                    double d12 = this.func_70638_az().func_174813_aQ().field_72338_b + (double)(this.func_70638_az().field_70131_O / 3.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
                    double d22 = this.func_70638_az().field_70161_v - this.field_70161_v;
                    if (this.isBeingAggressive()) {
                        EntityLargePumpkinbomb bomb = new EntityLargePumpkinbomb(this.field_70170_p, (EntityLivingBase)this);
                        bomb.field_70163_u = this.field_70163_u + (double)this.field_70131_O * 2.0 / 3.0;
                        this.field_70170_p.func_72838_d((Entity)bomb);
                    } else {
                        EntityWitherSkull skull = new EntityWitherSkull(this.field_70170_p, (EntityLivingBase)this, d0, d12, d22);
                        skull.field_70163_u = this.field_70163_u + (double)this.field_70131_O * 2.0 / 3.0;
                        this.field_70170_p.func_72838_d((Entity)skull);
                    }
                    if (this.field_70146_Z.nextInt(4) == 0 && TragicConfig.getBoolean("skultarDemeanor")) {
                        this.incrementDemeanor();
                    }
                }
                if (this.func_70032_d((Entity)this.func_70638_az()) <= 3.0f && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f && this.getAttackTime() == 0 && this.isBeingAggressive() && this.field_70146_Z.nextInt(32) == 0) {
                    this.setAttackTime(20);
                }
                if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f && this.getAttackTime() == 1 && TragicConfig.getBoolean("skultarWitheringGas")) {
                    ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(this.field_70170_p, 3.5, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    for (BlockPos coords : list) {
                        Block block = this.field_70170_p.func_180495_p(coords).func_177230_c();
                        if (!EntityOverlordCore.replaceableBlocks.contains(block) && block != TragicBlocks.WitheringGas || !World.func_175683_a((IBlockAccess)this.field_70170_p, (BlockPos)coords.func_177977_b())) continue;
                        this.field_70170_p.func_175656_a(coords, TragicBlocks.WitheringGas.func_176223_P());
                    }
                }
            }
            int n = i = this.getDemeanor() > 0 ? 8 : 16;
            if (this.field_70173_aa % i == 0 && !this.field_70128_L && TragicConfig.getBoolean("allowMobSounds")) {
                this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.skultar.heartbeat", 0.8f, 1.0f);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70170_p.field_72995_K || par1DamageSource == DamageSource.field_82727_n) {
            return false;
        }
        if (this.isBomb && this.getReaperType() == 1 && !par1DamageSource.func_94541_c()) {
            par2 = Float.MAX_VALUE;
            if (this.isBomb && this.getReaperType() == 1) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, this.getMobGriefing());
            }
        }
        this.trackHitType(par1DamageSource.func_76355_l());
        boolean result = super.func_70097_a(par1DamageSource, par2);
        if (result) {
            this.setHitTime(0);
            if (this.getCloneTime() > 100 && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f && this.field_70146_Z.nextInt(4) == 0 && par1DamageSource.func_76346_g() != null && TragicConfig.getBoolean("skultarClone")) {
                int potato = this.func_110143_aJ() <= this.func_110138_aP() / 4.0f ? 2 : 1;
                for (int x = 0; x < potato && this.attemptToSummonClones(); ++x) {
                }
                this.setCloneTime(0);
            }
        }
        return result;
    }

    private boolean attemptToSummonClones() {
        List list = this.field_70170_p.func_72872_a(EntityDeathReaper.class, this.func_174813_aQ().func_72314_b(32.0, 32.0, 32.0));
        if (list.size() >= 4 || this.func_70638_az() == null || this.getCloneTime() <= 100) {
            return false;
        }
        EntityDeathReaper clone = new EntityDeathReaper(this.field_70170_p);
        clone.func_82149_j((Entity)this);
        clone.setClone();
        return this.spawnEntityNearby((EntityLiving)clone, 4, 5, true);
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        if (this.field_70170_p.field_72995_K || this.getAttackTime() > 0) {
            return false;
        }
        boolean result = super.func_70652_k(par1Entity);
        if (result) {
            if (par1Entity instanceof EntityLivingBase && this.field_70146_Z.nextInt(8) == 0) {
                switch (this.field_70146_Z.nextInt(8)) {
                    case 0: {
                        ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                        break;
                    }
                    case 1: {
                        ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                        break;
                    }
                    case 2: {
                        ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                        break;
                    }
                    case 3: {
                        ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                        break;
                    }
                    case 4: {
                        if (!TragicConfig.getBoolean("allowDisorientation")) break;
                        ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Disorientation.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                        break;
                    }
                    case 5: {
                        if (!TragicConfig.getBoolean("allowFear")) break;
                        ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Fear.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                        break;
                    }
                    default: {
                        if (!TragicConfig.getBoolean("allowSubmission")) break;
                        ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Submission.field_76415_H, this.field_70146_Z.nextInt(200) + 320, this.field_70146_Z.nextInt(2) + 1));
                    }
                }
            }
            if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
                par1Entity.func_70015_d(4 + this.field_70146_Z.nextInt(12));
            }
            par1Entity.field_70159_w *= 1.4;
            par1Entity.field_70179_y *= 1.4;
            par1Entity.field_70181_x += 0.3;
            if (this.getAttackTime() == 0) {
                this.setAttackTime(10);
            }
            if (TragicConfig.getBoolean("allowMobSounds")) {
                this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.skultar.slice", 0.8f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
            }
        }
        return result;
    }

    public int func_70658_aO() {
        int i = TragicConfig.getMobStat("skultarStats").getArmorValue();
        return this.getReaperType() == 1 ? MathHelper.func_76128_c((double)(i / 4)) : (this.isBeingAggressive() ? i : MathHelper.func_76128_c((double)(i / 3)));
    }

    public void func_180430_e(float dist, float multi) {
    }

    private void trackHitType(String damageType) {
        String hitType = null;
        boolean flag = false;
        if (damageType.equals("arrow")) {
            hitType = "projectile";
        } else if (damageType.equals("fireball")) {
            hitType = "projectile";
        } else if (damageType.equals("indirectMagic")) {
            hitType = "normal";
        } else if (damageType.equals("player")) {
            hitType = "normal";
            flag = true;
        } else if (damageType.equals("generic")) {
            hitType = "normal";
        } else if (damageType.equals("mob")) {
            hitType = "normal";
        }
        if (hitType == null || !TragicConfig.getBoolean("skultarDemeanor")) {
            return;
        }
        if (hitType == "projectile") {
            this.incrementDemeanor();
            if (flag) {
                this.incrementDemeanor();
            }
        } else {
            this.decrementDemeanor();
            if (flag) {
                this.decrementDemeanor();
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance ins, IEntityLivingData data) {
        if (!this.field_70170_p.field_72995_K) {
            this.isBomb = this.field_70146_Z.nextBoolean();
        }
        return super.func_180482_a(ins, data);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("demeanor")) {
            this.setDemeanor(tag.func_74762_e("demeanor"));
        }
        if (tag.func_74764_b("hitTime")) {
            this.setHitTime(tag.func_74762_e("hitTime"));
        }
        if (tag.func_74764_b("cloneTime")) {
            this.setCloneTime(tag.func_74762_e("cloneTime"));
        }
        if (tag.func_74764_b("attackTime")) {
            this.setAttackTime(tag.func_74762_e("attackTime"));
        }
        if (tag.func_74764_b("reaperType")) {
            this.setReaperType(tag.func_74762_e("reaperType"));
        }
        if (tag.func_74764_b("isBomb")) {
            this.isBomb = tag.func_74767_n("isBomb");
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("demeanor", this.getDemeanor());
        tag.func_74768_a("hitTime", this.getHitTime());
        tag.func_74768_a("cloneTime", this.getCloneTime());
        tag.func_74768_a("attackTime", this.getAttackTime());
        tag.func_74768_a("reaperType", this.getReaperType());
        tag.func_74757_a("isBomb", this.isBomb);
    }

    public String func_70639_aQ() {
        return "mob.skeleton.say";
    }

    public String func_70621_aR() {
        return TragicConfig.getBoolean("allowMobSounds") && this.field_70146_Z.nextBoolean() ? "tragicmc:boss.skultar.laugh" : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:boss.skultar.laugh" : null;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
    }

    public float func_70647_i() {
        return 1.0f;
    }

    public float func_70599_aP() {
        return 0.4f;
    }

    public int func_70627_aG() {
        return 170;
    }
}

