/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.boss;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicEntities;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.entity.EntityAIWatchTarget;
import tragicneko.tragicmc.entity.boss.TragicBoss;
import tragicneko.tragicmc.entity.projectile.EntitySolarBomb;
import tragicneko.tragicmc.util.WorldHelper;

public class EntityApis
extends TragicBoss {
    public static final int DW_CHARGE_TICKS = 20;
    public static final int DW_REFLECTION_TICKS = 21;
    public static final int DW_STOMP_TICKS = 22;
    public static final int DW_ATTACK_TIME = 23;
    public static final int DW_HURT_TIME = 24;
    public int reflectionBuffer;
    private AttributeModifier mod = new AttributeModifier(UUID.fromString("08bd1ef5-8f24-4ee4-9ffa-10cdef76b7ae"), "apisStompDebuff", TragicConfig.modifier[13], 0);

    public EntityApis(World par1World) {
        super(par1World);
        this.func_70105_a(1.385f, 3.325f);
        this.field_70138_W = 2.0f;
        this.field_70728_aV = 1000;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.75));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchTarget((EntityLiving)this, 48.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 48.0f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
        this.field_70178_ae = true;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return TragicEntities.Beast;
    }

    public boolean func_90999_ad() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] apisStats = TragicConfig.getMobStat("apisStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(apisStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(apisStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(apisStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(apisStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(apisStats[4]);
    }

    @Override
    public void func_70645_a(DamageSource src) {
        super.func_70645_a(src);
        if (src.func_76346_g() instanceof EntityPlayerMP && TragicConfig.getBoolean("allowAchievements")) {
            ((EntityPlayerMP)src.func_76346_g()).func_71029_a((StatBase)TragicAchievements.apis);
        }
    }

    @Override
    protected void func_70628_a(boolean flag, int l) {
        super.func_70628_a(flag, l);
        if (!this.field_70170_p.field_72995_K && TragicConfig.getBoolean("allowMobStatueDrops") && this.field_70146_Z.nextInt(100) <= TragicConfig.getInt("mobStatueDropChance") && this.getAllowLoot()) {
            this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(TragicItems.MobStatue, 1, 0)));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
    }

    public int getChargeTicks() {
        return this.field_70180_af.func_75679_c(20);
    }

    private void setChargeTicks(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    private void decrementChargeTicks() {
        int pow = this.getChargeTicks();
        this.setChargeTicks(--pow);
    }

    public boolean isCharging() {
        return this.getChargeTicks() > 0;
    }

    public int getReflectionTicks() {
        return this.field_70180_af.func_75679_c(21);
    }

    private void setReflectionTicks(int i) {
        this.field_70180_af.func_75692_b(21, (Object)i);
    }

    private void decrementReflectionTicks() {
        int pow = this.getReflectionTicks();
        this.setReflectionTicks(--pow);
    }

    public boolean isReflecting() {
        return this.getReflectionTicks() > 0;
    }

    public int getStompTicks() {
        return this.field_70180_af.func_75679_c(22);
    }

    private void setStompTicks(int i) {
        this.field_70180_af.func_75692_b(22, (Object)i);
    }

    private void decrementStompTicks() {
        int pow = this.getStompTicks();
        this.setStompTicks(--pow);
    }

    public boolean isStomping() {
        return this.getStompTicks() > 0;
    }

    public int getAttackTime() {
        return this.field_70180_af.func_75679_c(23);
    }

    private void setAttackTime(int i) {
        this.field_70180_af.func_75692_b(23, (Object)i);
    }

    private void decrementAttackTime() {
        int pow = this.getAttackTime();
        this.setAttackTime(--pow);
    }

    private void setHurtTime(int i) {
        this.field_70180_af.func_75692_b(24, (Object)i);
    }

    public int getHurtTime() {
        return this.field_70180_af.func_75679_c(24);
    }

    @Override
    public void func_70636_d() {
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(this.mod);
        if (this.isStomping()) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(this.mod);
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
            this.field_70181_x = -0.2;
            this.field_70143_R = 0.0f;
            this.field_70133_I = false;
        }
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.isStomping()) {
                int i;
                for (i = 0; i < 2; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0, this.field_70163_u + this.field_70146_Z.nextDouble() * 0.15, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0, 0.0, this.field_70146_Z.nextDouble() * 1.2556, 0.0, new int[0]);
                }
                if (this.getStompTicks() <= 2) {
                    for (i = 0; i < 36; ++i) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0, this.field_70163_u + this.field_70146_Z.nextDouble() * 0.15, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0, this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), this.field_70146_Z.nextDouble() * 0.2556, this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), new int[0]);
                    }
                }
            } else if (this.isCharging()) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0, this.field_70163_u + this.field_70146_Z.nextDouble() * 0.75 + 0.45, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            float f2;
            double d2;
            if (this.isStomping()) {
                this.decrementStompTicks();
                if (this.isCharging()) {
                    this.setChargeTicks(0);
                }
                if (this.getAttackTime() > 0) {
                    this.setAttackTime(0);
                }
                this.func_70031_b(false);
            }
            if (this.isCharging()) {
                this.decrementChargeTicks();
            }
            if (this.isReflecting()) {
                this.reflectionBuffer = 160;
                this.decrementReflectionTicks();
                if (this.field_70146_Z.nextInt(4) == 0 && this.field_70122_E && this.field_70173_aa % 2 == 0 && this.field_70170_p.func_72935_r() && this.func_110143_aJ() <= this.func_110138_aP() / 4.0f) {
                    ArrayList<BlockPos> list = WorldHelper.getBlocksInCircularRange(this.field_70170_p, 0.75, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    for (int i = 0; i < list.size(); ++i) {
                        BlockPos coords = list.get(i);
                        Block block = this.field_70170_p.func_180495_p(coords).func_177230_c();
                        if (block != Blocks.field_150350_a || !World.func_175683_a((IBlockAccess)this.field_70170_p, (BlockPos)coords.func_177977_b())) continue;
                        this.field_70170_p.func_175656_a(coords, Blocks.field_150480_ab.func_176223_P());
                    }
                }
            } else if (this.reflectionBuffer > 0) {
                --this.reflectionBuffer;
            }
            if (this.getAttackTime() > 0) {
                this.decrementAttackTime();
            }
            if (this.getHurtTime() > 0) {
                this.setHurtTime(this.getHurtTime() - 1);
            }
            if (this.func_70638_az() != null && this.isEntityInRange((Entity)this.func_70638_az(), 2.0f, 8.0f) && this.field_70122_E && this.field_70146_Z.nextInt(32) == 0 && this.field_70122_E && !this.isCharging() && !this.isStomping() && this.func_70685_l((Entity)this.func_70638_az()) && TragicConfig.getBoolean("apisChargeAttack")) {
                if (this.field_70146_Z.nextInt(3) == 0 && TragicConfig.getBoolean("apisExplosiveCharge")) {
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextFloat() * 0.5f, false);
                }
                double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
                d2 = this.func_70638_az().field_70163_u - this.field_70163_u;
                f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                this.field_70159_w = d0 / (double)f2 * 2.5 * 0.600000011920929 + this.field_70159_w * 0.40000000298023225;
                this.field_70179_y = d1 / (double)f2 * 2.5 * 0.600000011920929 + this.field_70179_y * 0.40000000298023225;
                this.field_70181_x = d1 / (double)f2 * 1.1 * 0.200000011920929 + this.field_70181_x * (double)0.2f;
                this.setChargeTicks(10);
                this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
            }
            if (this.func_70638_az() != null && this.isEntityInRange((Entity)this.func_70638_az(), 6.0f, 12.0f) && this.field_70122_E && this.field_70146_Z.nextInt(48) == 0 && !this.isCharging() && !this.isStomping() && TragicConfig.getBoolean("apisChargeAttack")) {
                if (this.field_70146_Z.nextInt(3) == 0 && TragicConfig.getBoolean("apisExplosiveCharge")) {
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextFloat(), false);
                }
                double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
                d2 = this.func_70638_az().field_70163_u - this.field_70163_u;
                f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                this.field_70159_w = d0 / (double)f2 * 2.5 * 0.600000011920929 + this.field_70159_w * 0.40000000298023225;
                this.field_70179_y = d1 / (double)f2 * 2.5 * 0.600000011920929 + this.field_70179_y * 0.40000000298023225;
                this.field_70181_x = d1 / (double)f2 * 1.1 * 0.200000011920929 + this.field_70181_x * (double)0.2f;
                this.setChargeTicks(10);
                this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
            }
            if (this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) >= 12.0f && this.field_70122_E && this.field_70146_Z.nextInt(48) == 0 && !this.isCharging() && !this.isStomping() && TragicConfig.getBoolean("apisChargeAttack")) {
                if (this.field_70146_Z.nextInt(3) == 0 && TragicConfig.getBoolean("apisExplosiveCharge")) {
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextFloat() + 0.5f, false);
                }
                double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
                float f22 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                this.field_70159_w = d0 / (double)f22 * 3.5 * (double)0.8f + this.field_70159_w * 0.6000000029802323;
                this.field_70179_y = d1 / (double)f22 * 3.5 * (double)0.8f + this.field_70179_y * 0.6000000029802323;
                this.field_70181_x = 0.45;
                this.setChargeTicks(10);
                this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
            }
            if (this.func_70638_az() != null && this.field_70173_aa % 3 == 0 && this.field_70122_E && this.field_70146_Z.nextInt(48) == 0 && !this.isCharging() && !this.isStomping() && this.func_70032_d((Entity)this.func_70638_az()) <= 6.0f && TragicConfig.getBoolean("apisSuperStomp")) {
                if (TragicConfig.getBoolean("allowMobSounds")) {
                    this.func_85030_a("tragicmc:boss.apis.roar", 1.8f, 1.0f);
                }
                this.setStompTicks(40);
            }
            if (this.getStompTicks() == 1) {
                List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(6.0, 6.0, 6.0));
                for (int i = 0; i < list.size(); ++i) {
                    Entity entity = (Entity)list.get(i);
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 8.0f - this.func_70032_d(entity));
                }
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextFloat() * 1.225f + 4.0f, this.getMobGriefing());
            }
            if (this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) >= 10.0f && this.field_70146_Z.nextInt(8) == 0 && !this.isCharging() && !this.isStomping() && TragicConfig.getBoolean("apisSolarbombs")) {
                double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                double d1 = this.func_70638_az().func_174813_aQ().field_72338_b + (double)(this.func_70638_az().field_70131_O / 3.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
                double d22 = this.func_70638_az().field_70161_v - this.field_70161_v;
                float f1 = MathHelper.func_76129_c((float)this.func_70032_d((Entity)this.func_70638_az())) * 0.95f;
                switch (this.field_70146_Z.nextInt(6)) {
                    case 0: {
                        EntityLargeFireball fireball = new EntityLargeFireball(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d22 + this.field_70146_Z.nextGaussian() * (double)f1);
                        fireball.field_70163_u = this.field_70163_u + (double)this.field_70131_O;
                        this.field_70170_p.func_72838_d((Entity)fireball);
                        break;
                    }
                    case 1: {
                        EntitySolarBomb solarBomb = new EntitySolarBomb(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d22 + this.field_70146_Z.nextGaussian() * (double)f1);
                        solarBomb.field_70163_u = this.field_70163_u + (double)this.field_70131_O;
                        this.field_70170_p.func_72838_d((Entity)solarBomb);
                        break;
                    }
                    case 2: {
                        EntitySolarBomb solarBomb2 = new EntitySolarBomb(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d22 + this.field_70146_Z.nextGaussian() * (double)f1);
                        solarBomb2.field_70163_u = this.field_70163_u + (double)this.field_70131_O;
                        this.field_70170_p.func_72838_d((Entity)solarBomb2);
                        break;
                    }
                    default: {
                        for (int i = 0; i < 3; ++i) {
                            EntitySmallFireball fireball2 = new EntitySmallFireball(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d22 + this.field_70146_Z.nextGaussian() * (double)f1);
                            fireball2.field_70163_u = this.field_70163_u + (double)this.field_70131_O;
                            this.field_70170_p.func_72838_d((Entity)fireball2);
                        }
                    }
                }
            }
            if (this.func_70638_az() != null && this.reflectionBuffer == 0 && this.field_70173_aa % 20 == 0 && !this.isReflecting() && TragicConfig.getBoolean("apisReflection")) {
                this.setReflectionTicks(160);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70170_p.field_72995_K || par1DamageSource.func_94541_c()) {
            return false;
        }
        if (this.isReflecting() && par1DamageSource.func_76346_g() != null && !(par1DamageSource.func_76346_g() instanceof EntityApis)) {
            if (par2 > 3.0f) {
                par1DamageSource.func_76346_g().func_70097_a(par1DamageSource, par2 / 2.0f + 1.0f);
            }
            if (TragicConfig.getBoolean("allowMobSounds")) {
                this.func_85030_a("tragicmc:boss.apis.reflect", 1.0f, 1.0f);
            }
            return true;
        }
        if (par1DamageSource.func_76346_g() != null && par1DamageSource.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)par1DamageSource.func_76346_g();
            if (player.func_71045_bC() != null) {
                if (!(player.func_71045_bC().func_77973_b() instanceof ItemBow)) {
                    player.func_71045_bC().func_77972_a(this.field_70146_Z.nextInt(2) + 1, (EntityLivingBase)player);
                }
            } else if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
                player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 5.0f);
                player.func_70015_d(this.field_70146_Z.nextInt(8) + 4);
            } else {
                player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 3.0f);
            }
        }
        if (!par1DamageSource.func_76352_a()) {
            par2 *= 0.425f;
        }
        if (this.getHurtTime() == 0 && !this.isCharging() && !this.isStomping()) {
            this.setHurtTime(10);
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        if (this.field_70170_p.field_72995_K || this.isStomping()) {
            return false;
        }
        boolean flag = super.func_70652_k(par1Entity);
        if (flag) {
            if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
                par1Entity.func_70015_d(8 + this.field_70146_Z.nextInt(12));
            }
            if (this.isCharging()) {
                par1Entity.field_70159_w *= 2.2000000059604643;
                par1Entity.field_70179_y *= 2.2;
                par1Entity.field_70181_x += 0.56;
            } else if (this.getAttackTime() == 0) {
                this.setAttackTime(10);
            }
        }
        return flag;
    }

    public void func_82167_n(Entity entity) {
        super.func_82167_n(entity);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70173_aa % 10 == 0 && entity instanceof EntityLivingBase && this.isReflecting()) {
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f);
        }
    }

    public int func_70658_aO() {
        int i = TragicConfig.getMobStat("apisStats").getArmorValue();
        return this.field_70170_p.func_72935_r() ? i : MathHelper.func_76128_c((double)(i / 2));
    }

    public void func_180430_e(float dist, float multi) {
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("chargeTicks")) {
            this.setChargeTicks(tag.func_74762_e("chargeTicks"));
        }
        if (tag.func_74764_b("reflectionTicks")) {
            this.setReflectionTicks(tag.func_74762_e("reflectionTicks"));
        }
        if (tag.func_74764_b("stompTicks")) {
            this.setStompTicks(tag.func_74762_e("stompTicks"));
        }
        if (tag.func_74764_b("attackTime")) {
            this.setAttackTime(tag.func_74762_e("attackTime"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("chargeTicks", this.getChargeTicks());
        tag.func_74768_a("reflectionTicks", this.getReflectionTicks());
        tag.func_74768_a("stompTicks", this.getStompTicks());
        tag.func_74768_a("attackTime", this.getAttackTime());
    }

    @Override
    public boolean getIllumination() {
        return true;
    }

    public String func_70639_aQ() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:boss.apis.living" : null;
    }

    public String func_70621_aR() {
        return !this.isReflecting() ? super.func_70621_aR() : null;
    }

    public String func_70673_aS() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:boss.apis.death" : null;
    }

    public float func_70647_i() {
        return 1.0f;
    }

    public float func_70599_aP() {
        return 1.0f;
    }

    public int func_70627_aG() {
        return 120;
    }
}

