/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.alpha;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicEntities;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.entity.EntityAIWatchTarget;
import tragicneko.tragicmc.entity.EntityDimensionalAnomaly;
import tragicneko.tragicmc.entity.alpha.EntityOverlordCore;
import tragicneko.tragicmc.entity.boss.TragicBoss;
import tragicneko.tragicmc.entity.mob.EntityHunter;
import tragicneko.tragicmc.entity.mob.EntityNanoSwarm;
import tragicneko.tragicmc.util.DamageHelper;
import tragicneko.tragicmc.util.WorldHelper;

public class EntityOverlordCombat
extends TragicBoss {
    public static final int DW_UNSTABLE_TICKS = 20;
    public static final int DW_HURT_TIME = 21;
    public static final int DW_ATTACK_TIME = 22;
    public static final int DW_LEAP_TICKS = 23;
    public static final int DW_CHARGE_TICKS = 24;
    public static final int DW_GRAPPLE_TICKS = 25;
    public static final int DW_REFLECTION_TICKS = 26;
    public static final int DW_TRANSFORMATION_TICKS = 27;
    private boolean hasLeaped;
    private int aggregate = 1;
    private int unstableBuffer;
    private int reflectionBuffer;
    public static final Predicate nonSynapseTarget = new Predicate(){

        public boolean apply(Object o) {
            return this.canApply((Entity)o);
        }

        public boolean canApply(Entity entity) {
            return entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70668_bt() != TragicEntities.Synapse;
        }
    };

    public EntityOverlordCombat(World par1World) {
        super(par1World);
        this.func_70105_a(4.385f, 5.325f);
        this.field_70138_W = 2.0f;
        this.field_70728_aV = 75;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchTarget((EntityLiving)this, 64.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 48.0f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, false, nonSynapseTarget));
        this.field_70178_ae = true;
    }

    public void func_70050_g(int i) {
    }

    protected void func_70623_bb() {
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_180430_e(float dist, float multi) {
        if (!this.field_70170_p.field_72995_K && this.hasLeaped) {
            this.hasLeaped = false;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
            for (Entity e : list) {
                if (!(e instanceof EntityLivingBase)) continue;
                double d1 = e.field_70165_t - this.field_70165_t;
                double d2 = e.field_70161_v - this.field_70161_v;
                double d3 = e.field_70163_u - this.field_70163_u;
                float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d2 * d2 + d3 * d3));
                double d4 = 0.25;
                e.field_70159_w = d1 / (double)f2 * d4 * 26.80000001192093 + e.field_70159_w * 20.700000002980232;
                e.field_70179_y = d2 / (double)f2 * d4 * 26.80000001192093 + e.field_70179_y * 20.700000002980232;
                e.field_70181_x = this.field_70146_Z.nextDouble() + this.field_70146_Z.nextDouble() * 2.700000011920929 + e.field_70179_y * 1.7000000029802322;
                e.field_70133_I = true;
                if (!TragicConfig.getBoolean("allowHacked") || ((EntityLivingBase)e).func_70668_bt() == TragicEntities.Synapse) continue;
                ((EntityLivingBase)e).func_70690_d(new PotionEffect(TragicPotion.Hacked.field_76415_H, 40 + this.field_70146_Z.nextInt(20), 0));
            }
            if (TragicConfig.getBoolean("allowMobSounds")) {
                this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.overlordcombat.wam", 1.8f, 1.0f);
            }
        }
        if (this.field_70170_p.field_72995_K && dist > 16.0f) {
            float f0 = 0.0f;
            float f1 = 0.0f;
            float f2 = 0.0f;
            for (int i = 0; i < 22; ++i) {
                double dr = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                double dr2 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                double dr3 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                double x = dr * 3.25 + this.field_70165_t;
                double y = dr2 * 1.25 + this.field_70163_u + (double)this.field_70131_O / 2.0;
                double z = dr3 * 3.25 + this.field_70161_v;
                this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, x, y, z, (double)f0, (double)f1, (double)f2, new int[0]);
            }
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return TragicEntities.Synapse;
    }

    @Override
    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (!this.field_70170_p.field_72995_K) {
            List list2;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0));
            for (Entity e : list) {
                if (!(e instanceof EntityLivingBase) || ((EntityLivingBase)e).func_70668_bt() != TragicEntities.Synapse) continue;
                e.func_70106_y();
            }
            if (TragicConfig.getBoolean("overlordTransformation")) {
                EntityOverlordCore core = new EntityOverlordCore(this.field_70170_p);
                core.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                core.setStartTransform();
                this.field_70170_p.func_72838_d((Entity)core);
            }
            if (par1DamageSource.func_76346_g() instanceof EntityPlayerMP) {
                ((EntityPlayerMP)par1DamageSource.func_76346_g()).func_71029_a((StatBase)TragicAchievements.overlord3);
            }
            if (!(list2 = this.field_70170_p.func_72872_a(EntityPlayerMP.class, this.func_174813_aQ().func_72314_b(24.0, 24.0, 24.0))).isEmpty()) {
                for (EntityPlayerMP mp : list2) {
                    mp.func_71029_a((StatBase)TragicAchievements.overlord3);
                }
            }
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] overlordCombatStats = TragicConfig.getMobStat("overlordCombatStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(overlordCombatStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(overlordCombatStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(overlordCombatStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(overlordCombatStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(overlordCombatStats[4]);
    }

    public int func_70658_aO() {
        return TragicConfig.getMobStat("overlordCombatStats").getArmorValue();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)0);
        this.field_70180_af.func_75682_a(27, (Object)0);
    }

    private void setUnstableTicks(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    public int getUnstableTicks() {
        return this.field_70180_af.func_75679_c(20);
    }

    private void setHurtTime(int i) {
        this.field_70180_af.func_75692_b(21, (Object)i);
    }

    public int getHurtTime() {
        return this.field_70180_af.func_75679_c(21);
    }

    private void setAttackTime(int i) {
        this.field_70180_af.func_75692_b(22, (Object)i);
    }

    public int getAttackTime() {
        return this.field_70180_af.func_75679_c(22);
    }

    private void setLeapTicks(int i) {
        this.field_70180_af.func_75692_b(23, (Object)i);
    }

    public int getLeapTicks() {
        return this.field_70180_af.func_75679_c(23);
    }

    private void setChargeTicks(int i) {
        this.field_70180_af.func_75692_b(24, (Object)i);
    }

    public int getChargeTicks() {
        return this.field_70180_af.func_75679_c(24);
    }

    private void setGrappleTicks(int i) {
        this.field_70180_af.func_75692_b(25, (Object)i);
    }

    public int getGrappleTicks() {
        return this.field_70180_af.func_75679_c(25);
    }

    private void setReflectionTicks(int i) {
        this.field_70180_af.func_75692_b(26, (Object)i);
    }

    public int getReflectionTicks() {
        return this.field_70180_af.func_75679_c(26);
    }

    private void setTransformationTicks(int i) {
        this.field_70180_af.func_75692_b(27, (Object)i);
    }

    public int getTransformationTicks() {
        return this.field_70180_af.func_75679_c(27);
    }

    public EntityOverlordCombat setTransforming() {
        if (TragicConfig.getBoolean("overlordTransformationAesthetics")) {
            this.setTransformationTicks(120);
        }
        return this;
    }

    private boolean canUseAbility() {
        return this.getUnstableTicks() == 0 && !this.hasLeaped && this.getLeapTicks() == 0 && this.getChargeTicks() == 0 && this.getGrappleTicks() == 0 && this.getReflectionTicks() == 0 && this.getTransformationTicks() == 0 && this.unstableBuffer == 0 && this.reflectionBuffer == 0;
    }

    @Override
    public void func_70636_d() {
        List list;
        if (this.getGrappleTicks() > 0 || this.getLeapTicks() > 20) {
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
            this.field_70181_x = -1.0;
        }
        if (this.getReflectionTicks() > 0 || this.getTransformationTicks() > 0) {
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
        }
        if (this.getUnstableTicks() > 0) {
            this.field_70181_x = -1.0;
            this.field_70159_w *= 0.25;
            this.field_70179_y *= 0.25;
        }
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            double z;
            double y;
            double x;
            double dr3;
            double dr2;
            double dr;
            int i;
            float f = 0.0f;
            float f1 = 0.0f;
            float f2 = 0.0f;
            if (this.getTransformationTicks() > 0) {
                return;
            }
            if (this.getGrappleTicks() > 0) {
                for (i = 0; i < 22; ++i) {
                    dr = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    dr2 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    dr3 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    x = dr * 2.25 + this.field_70165_t;
                    y = dr2 * 2.25 + this.field_70163_u + (double)this.field_70131_O / 2.0;
                    z = dr3 * 2.25 + this.field_70161_v;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, (double)f, (double)f1, (double)f2, new int[0]);
                }
            }
            if (this.getLeapTicks() >= 10 && !this.field_70122_E) {
                for (i = 0; i < 22; ++i) {
                    dr = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    dr2 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    dr3 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    x = dr * 2.25 + this.field_70165_t;
                    y = dr2 * 2.25 + this.field_70163_u + (double)this.field_70131_O / 2.0;
                    z = dr3 * 2.25 + this.field_70161_v;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, x, y, z, (double)f, (double)f1, (double)f2, new int[0]);
                }
            }
            if (this.getChargeTicks() > 0) {
                for (i = 0; i < 32; ++i) {
                    dr = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    dr2 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    dr3 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    x = dr * 3.25 + this.field_70165_t;
                    y = dr2 * 1.25 + this.field_70163_u + (double)this.field_70131_O / 2.0;
                    z = dr3 * 3.25 + this.field_70161_v;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, x, y, z, (double)f, (double)f1, (double)f2, new int[0]);
                }
            }
            if (this.getUnstableTicks() > 0) {
                for (i = 0; i < 44; ++i) {
                    dr = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    dr2 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    dr3 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    x = dr * 3.25 + this.field_70165_t;
                    y = dr2 * 3.25 + this.field_70163_u + (double)this.field_70131_O / 2.0;
                    z = dr3 * 3.25 + this.field_70161_v;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, (double)f, (double)f1, (double)f2, new int[0]);
                }
            }
            if (this.getReflectionTicks() > 0) {
                for (i = 0; i < 22; ++i) {
                    dr = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    dr2 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    dr3 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    x = dr * 3.25 + this.field_70165_t;
                    y = dr2 * 3.25 + this.field_70163_u + (double)this.field_70131_O / 2.0;
                    z = dr3 * 3.25 + this.field_70161_v;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, x, y, z, (double)f, (double)f1, (double)f2, new int[0]);
                }
                f = 0.33f;
                f1 = 0.88f;
                f2 = 0.94f;
                for (i = 0; i < 22; ++i) {
                    dr = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    dr2 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    dr3 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    x = dr * 3.25 + this.field_70165_t;
                    y = dr2 * 3.25 + this.field_70163_u + (double)this.field_70131_O / 2.0;
                    z = dr3 * 3.25 + this.field_70161_v;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, (double)f, (double)f1, (double)f2, new int[0]);
                }
            }
            return;
        }
        if (this.getTransformationTicks() > 0) {
            if (this.getTransformationTicks() == 120 && TragicConfig.getBoolean("allowMobSounds")) {
                this.func_85030_a("tragicmc:boss.overlordcombat.wam", 1.6f, 0.6f);
            }
            this.setTransformationTicks(this.getTransformationTicks() - 1);
            this.reflectionBuffer = 0;
            this.unstableBuffer = 0;
            this.setHurtTime(0);
            this.setLeapTicks(0);
            this.setReflectionTicks(0);
            this.setUnstableTicks(0);
            this.setAttackTime(0);
            this.setGrappleTicks(0);
            this.hasLeaped = false;
            return;
        }
        if (this.unstableBuffer > 0) {
            --this.unstableBuffer;
        }
        if (this.reflectionBuffer > 0) {
            --this.reflectionBuffer;
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getLeapTicks() > 0) {
            this.setLeapTicks(this.getLeapTicks() - 1);
        }
        if (this.hasLeaped && !this.field_70122_E) {
            this.field_70181_x = -1.0;
        }
        if (this.getAttackTime() > 0) {
            this.setAttackTime(this.getAttackTime() - 1);
        }
        if (this.getLeapTicks() > 0 && this.getLeapTicks() <= 20) {
            if (this.getLeapTicks() == 1) {
                this.hasLeaped = true;
            }
            this.field_70181_x = 1.4;
        }
        if (this.getUnstableTicks() > 0) {
            this.setUnstableTicks(this.getUnstableTicks() - 1);
            if (this.getUnstableTicks() % 20 == 0 && this.field_70146_Z.nextBoolean()) {
                EntityDimensionalAnomaly ana = new EntityDimensionalAnomaly(this.field_70170_p);
                ana.func_70107_b(this.field_70165_t + (double)this.field_70146_Z.nextInt(4) - (double)this.field_70146_Z.nextInt(4), this.field_70163_u + (double)this.field_70146_Z.nextInt(6), this.field_70161_v + (double)this.field_70146_Z.nextInt(4) - (double)this.field_70146_Z.nextInt(4));
                this.field_70170_p.func_72838_d((Entity)ana);
            }
            if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f && this.field_70173_aa % 10 == 0 && this.field_70146_Z.nextBoolean() && TragicConfig.getBoolean("allowNanoSwarm") && TragicConfig.getBoolean("overlordNanoSwarms")) {
                EntityNanoSwarm swarm = new EntityNanoSwarm(this.field_70170_p);
                swarm.func_82149_j((Entity)this);
                this.field_70170_p.func_72838_d((Entity)swarm);
            }
            if (this.func_110143_aJ() <= this.func_110138_aP() / 4.0f && this.field_70173_aa % 10 == 0 && this.field_70146_Z.nextBoolean() && TragicConfig.getBoolean("overlordHunters")) {
                EntityHunter hunter = new EntityHunter(this.field_70170_p);
                hunter.func_70107_b(this.field_70165_t + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), this.field_70163_u + this.field_70146_Z.nextDouble(), this.field_70161_v + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble());
                this.field_70170_p.func_72838_d((Entity)hunter);
            }
            if (this.field_70146_Z.nextBoolean() && this.field_70173_aa % 10 == 0) {
                list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
                for (Entity e : list) {
                    if (!(e instanceof EntityLivingBase) || ((EntityLivingBase)e).func_70668_bt() == TragicEntities.Synapse) continue;
                    if (this.field_70146_Z.nextBoolean()) {
                        e.func_70097_a(DamageHelper.causeArmorPiercingDamageToEntity((EntityLivingBase)this), 1.0f);
                    }
                    if (!this.field_70146_Z.nextBoolean()) continue;
                    e.field_70159_w += (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 2.45;
                    e.field_70181_x += (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 2.45;
                    e.field_70179_y += (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 1.45;
                }
            }
            if (this.getUnstableTicks() % 10 == 0) {
                this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.overlordcocoon.wah", 1.4f, 0.5f);
            }
            this.unstableBuffer = 300;
            this.aggregate = 1;
        }
        if (this.canUseAbility() && this.field_70173_aa % 20 == 0 && this.field_70122_E && this.field_70146_Z.nextInt(64) == 0 && TragicConfig.getBoolean("overlordMegaLeap")) {
            this.setLeapTicks(40);
        }
        if (this.canUseAbility() && this.unstableBuffer == 0 && this.field_70173_aa % (1000 / this.aggregate) == 0 && this.field_70146_Z.nextInt(32) == 0 && TragicConfig.getBoolean("overlordUnstableAnomalies")) {
            this.setUnstableTicks(200 + this.field_70146_Z.nextInt(100));
            this.aggregate = 1;
            list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
            for (Entity e : list) {
                if (!(e instanceof EntityLivingBase) || !TragicConfig.getBoolean("allowHacked") || ((EntityLivingBase)e).func_70668_bt() == TragicEntities.Synapse) continue;
                ((EntityLivingBase)e).func_70690_d(new PotionEffect(TragicPotion.Hacked.field_76415_H, 40 + this.field_70146_Z.nextInt(20), 0));
            }
        }
        if (this.func_70638_az() != null && this.canUseAbility() && this.field_70173_aa % 20 == 0 && this.field_70146_Z.nextInt(32) == 0 && this.field_70122_E && !this.func_70090_H() && TragicConfig.getBoolean("overlordChargeAttack")) {
            this.setChargeTicks(200);
        }
        this.func_70031_b(false);
        if (this.getChargeTicks() > 0) {
            this.setChargeTicks(this.getChargeTicks() - 1);
            this.func_70031_b(true);
            this.field_70181_x = -0.2;
            if (this.func_70638_az() != null) {
                if (this.getChargeTicks() <= 170) {
                    float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 30.0f;
                    if (this.field_70123_F && f >= 2.0f) {
                        if (f > 10.0f) {
                            f = 10.0f;
                        }
                        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, f / 2.0f * this.field_70146_Z.nextFloat() + f / 2.0f, this.getMobGriefing());
                        this.setChargeTicks(0);
                    } else {
                        double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                        double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
                        float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                        double d2 = d0 / (double)f2 * 0.23 * 0.310000011929209 + this.field_70159_w * 1.44;
                        this.field_70159_w = Math.min(Math.abs(d2), 1.6) == Math.abs(d2) ? d2 : 1.6 * (double)(d2 < 0.0 ? -1 : 1);
                        double d3 = d1 / (double)f2 * 0.23 * 0.310000011929209 + this.field_70179_y * 1.44;
                        double d = Math.min(Math.abs(d3), 1.6) == Math.abs(d3) ? d3 : (this.field_70179_y = 1.6 * (double)(d3 < 0.0 ? -1 : 1));
                    }
                }
                if (this.getChargeTicks() % 10 == 0 && TragicConfig.getBoolean("allowMobSounds")) {
                    this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.overlordcombat.march", 1.8f, 1.0f);
                }
            } else {
                this.setChargeTicks(0);
            }
        }
        if (this.canUseAbility() && this.func_70638_az() != null && this.field_70173_aa % 10 == 0 && this.func_70032_d((Entity)this.func_70638_az()) >= 8.0f && this.field_70146_Z.nextInt(16) == 0 && this.field_70122_E && TragicConfig.getBoolean("overlordGrappleAttack")) {
            this.setGrappleTicks(80 + this.field_70146_Z.nextInt(40));
        }
        if (this.getGrappleTicks() > 0) {
            this.setGrappleTicks(this.getGrappleTicks() - 1);
            this.field_70159_w *= 0.2;
            this.field_70179_y *= 0.2;
            this.field_70181_x = -0.4;
            if (this.func_70638_az() != null) {
                EntityLivingBase e = this.func_70638_az();
                e.func_70097_a(DamageHelper.causeArmorPiercingDamageToEntity((EntityLivingBase)this), 1.0f);
                double d1 = e.field_70165_t - this.field_70165_t;
                double d2 = e.field_70161_v - this.field_70161_v;
                double d3 = e.field_70163_u - this.field_70163_u;
                float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d2 * d2 + d3 * d3));
                double d4 = 0.5;
                e.field_70159_w = -d1 / (double)f2 * d4 * 0.600000011920929 + e.field_70159_w * (double)0.2f;
                e.field_70179_y = -d2 / (double)f2 * d4 * 0.600000011920929 + e.field_70179_y * (double)0.2f;
                e.field_70181_x = -d3 / (double)f2 * d4 * 0.300000011920929 + e.field_70179_y * 0.10000000298023223;
                if (this.getGrappleTicks() % 20 == 0 && TragicConfig.getBoolean("allowMobSounds")) {
                    this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.overlordcombat.phaser", 1.8f, 1.0f);
                }
            } else {
                this.setGrappleTicks(0);
            }
        }
        if (this.canUseAbility() && this.field_70146_Z.nextInt(16) == 0 && this.field_70173_aa % 5 == 0 && !this.field_70122_E && this.field_70181_x <= 0.0 && this.reflectionBuffer == 0 && !this.func_70090_H() && TragicConfig.getBoolean("overlordReflection")) {
            this.setReflectionTicks(200 + this.field_70146_Z.nextInt(100));
        }
        if (this.getReflectionTicks() > 0) {
            this.setReflectionTicks(this.getReflectionTicks() - 1);
            this.reflectionBuffer = 200;
            if (this.field_70181_x < 0.0 && !this.field_70122_E && TragicConfig.getBoolean("overlordBarriers")) {
                ArrayList<BlockPos> list2 = WorldHelper.getBlocksInCircularRange(this.field_70170_p, 2.5, this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v);
                for (BlockPos coords : list2) {
                    if (!EntityOverlordCore.replaceableBlocks.contains(this.field_70170_p.func_180495_p(coords).func_177230_c())) continue;
                    this.field_70170_p.func_180501_a(coords, TragicBlocks.OverlordBarrier.func_176223_P(), 2);
                }
            }
            this.field_70181_x = 0.0;
            if (this.field_70173_aa % 10 == 0 && TragicConfig.getBoolean("overlordHunters") && TragicConfig.getBoolean("allowHunter")) {
                EntityHunter hunter = new EntityHunter(this.field_70170_p);
                hunter.func_70107_b(this.field_70165_t + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), this.field_70163_u + this.field_70146_Z.nextDouble(), this.field_70161_v + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble());
                this.field_70170_p.func_72838_d((Entity)hunter);
            }
            if (this.getReflectionTicks() % 20 == 0 && TragicConfig.getBoolean("allowMobSounds")) {
                this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.overlordcombat.wow", 1.8f, 1.0f);
            }
        }
        if (this.field_70122_E && this.hasLeaped) {
            this.hasLeaped = false;
        }
        if (this.field_70163_u <= 1.0 && this.field_70181_x < 0.0 && !this.field_70122_E && this.getReflectionTicks() == 0 && TragicConfig.getBoolean("overlordBarriers")) {
            ArrayList<BlockPos> list3 = WorldHelper.getBlocksInCircularRange(this.field_70170_p, 2.5, this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v);
            for (BlockPos coords : list3) {
                if (!EntityOverlordCore.replaceableBlocks.contains(this.field_70170_p.func_180495_p(coords).func_177230_c())) continue;
                this.field_70170_p.func_180501_a(coords, TragicBlocks.OverlordBarrier.func_176223_P(), 2);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource src, float dmg) {
        if (this.getTransformationTicks() > 0) {
            return false;
        }
        if (src.func_76346_g() instanceof EntityLivingBase && !this.field_70170_p.field_72995_K) {
            boolean flag;
            EntityLivingBase entity = (EntityLivingBase)src.func_76346_g();
            boolean bl = flag = TragicConfig.getBoolean("allowDivinity") && entity.func_70644_a(TragicPotion.Divinity);
            if (this.getReflectionTicks() > 0 && entity.func_70668_bt() != TragicEntities.Synapse && dmg > 1.0f) {
                entity.func_70097_a(DamageHelper.causeArmorPiercingDamageToEntity((EntityLivingBase)this), dmg * 0.825f);
                return false;
            }
            if (flag || !TragicConfig.getBoolean("allowDivinity") && entity.func_70668_bt() != TragicEntities.Synapse || entity.func_70694_bm() != null && entity.func_70694_bm().func_77973_b() == TragicItems.SwordOfJustice || src.func_76357_e() || !TragicConfig.getBoolean("overlordDivineWeakness") || !TragicConfig.getBoolean("overlordUnstableAnomalies")) {
                if (this.field_70146_Z.nextBoolean() && TragicConfig.getBoolean("allowNanoSwarm") && this.field_70170_p.func_72872_a(EntityNanoSwarm.class, this.func_174813_aQ().func_72314_b(64.0, 64.0, 64.0)).size() < 16 && TragicConfig.getBoolean("allowNanoSwarm") && TragicConfig.getBoolean("overlordNanoSwarms")) {
                    EntityNanoSwarm swarm = new EntityNanoSwarm(this.field_70170_p);
                    swarm.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)swarm);
                }
                if (this.getHurtTime() == 0 && this.getChargeTicks() == 0) {
                    this.setHurtTime(40);
                }
                if (this.getChargeTicks() > 0) {
                    dmg *= 0.825f;
                }
                return super.func_70097_a(src, dmg);
            }
            if (this.field_70146_Z.nextInt(4) == 0 && this.func_70638_az() != entity && entity.func_70668_bt() != TragicEntities.Synapse) {
                this.func_70624_b(entity);
            }
            if (this.aggregate < 100) {
                ++this.aggregate;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72956_a((Entity)this, super.func_70621_aR(), 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (this.field_70170_p.field_72995_K || this.getTransformationTicks() > 0) {
            return false;
        }
        if (this.getChargeTicks() == 0 && this.getAttackTime() == 0) {
            this.setAttackTime(20);
        }
        if (this.getGrappleTicks() > 0) {
            this.setGrappleTicks(0);
        }
        if (this.getChargeTicks() > 0 || this.canUseAbility()) {
            boolean flag = super.func_70652_k(entity);
            if (flag && !this.field_70170_p.field_72995_K && TragicConfig.getBoolean("overlordSlashAttack")) {
                entity.field_70159_w *= 2.24;
                entity.field_70179_y *= 2.24;
                entity.field_70181_x += 0.4;
                List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(4.0, 4.0, 4.0));
                for (Entity e : list) {
                    if (!(e instanceof EntityLivingBase) || e == entity) continue;
                    e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                }
                if (this.getChargeTicks() == 0 && this.getAttackTime() == 20 && TragicConfig.getBoolean("allowMobSounds")) {
                    this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.overlordcombat.shink", 1.9f, 1.0f);
                }
            }
            return flag;
        }
        return false;
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("unstableTicks")) {
            this.setUnstableTicks(tag.func_74762_e("unstableTicks"));
        }
        if (tag.func_74764_b("unstableBuffer")) {
            this.unstableBuffer = tag.func_74762_e("unstableBuffer");
        }
        if (tag.func_74764_b("aggregate")) {
            this.aggregate = tag.func_74762_e("aggregate");
        }
        if (tag.func_74764_b("hurtTicks")) {
            this.setHurtTime(tag.func_74762_e("hurtTicks"));
        }
        if (tag.func_74764_b("leapTicks")) {
            this.setLeapTicks(tag.func_74762_e("leapTicks"));
        }
        if (tag.func_74764_b("hasLeaped")) {
            this.hasLeaped = tag.func_74767_n("hasLeaped");
        }
        if (tag.func_74764_b("chargeTicks")) {
            this.setChargeTicks(tag.func_74762_e("chargeTicks"));
        }
        if (tag.func_74764_b("grappleTicks")) {
            this.setGrappleTicks(tag.func_74762_e("grappleTicks"));
        }
        if (tag.func_74764_b("reflectionTicks")) {
            this.setReflectionTicks(tag.func_74762_e("reflectionTicks"));
        }
        if (tag.func_74764_b("reflectionBuffer")) {
            this.reflectionBuffer = tag.func_74762_e("reflectionBuffer");
        }
        if (tag.func_74764_b("transformationTicks")) {
            this.setTransformationTicks(tag.func_74762_e("transformationTicks"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("unstableTicks", this.getUnstableTicks());
        tag.func_74768_a("unstableBuffer", this.unstableBuffer);
        tag.func_74768_a("aggregate", this.aggregate);
        tag.func_74768_a("hurtTicks", this.getHurtTime());
        tag.func_74768_a("leapTicks", this.getLeapTicks());
        tag.func_74757_a("hasLeaped", this.hasLeaped);
        tag.func_74768_a("chargeTicks", this.getChargeTicks());
        tag.func_74768_a("grappleTicks", this.getGrappleTicks());
        tag.func_74768_a("reflectionTicks", this.getReflectionTicks());
        tag.func_74768_a("reflectionBuffer", this.reflectionBuffer);
        tag.func_74768_a("transformationTicks", this.getTransformationTicks());
    }

    public void func_70690_d(PotionEffect pe) {
    }

    public IEntityLivingData func_180482_a(DifficultyInstance ins, IEntityLivingData data) {
        this.setTransforming();
        this.func_70642_aH();
        return super.func_180482_a(ins, data);
    }

    public String func_70639_aQ() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:boss.overlordcombat.living" : null;
    }

    public String func_70621_aR() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:boss.overlordcombat.hurt" : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:boss.overlordcombat.death" : null;
    }

    public float func_70647_i() {
        return 1.0f;
    }

    public float func_70599_aP() {
        return 0.6f;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_85030_a("mob.irongolem.walk", 1.2f, 1.8f);
    }

    public int func_70627_aG() {
        return super.func_70627_aG();
    }
}

