/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.alpha;

import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicEntities;
import tragicneko.tragicmc.entity.alpha.EntityGhostAdmin;
import tragicneko.tragicmc.entity.boss.TragicBoss;
import tragicneko.tragicmc.entity.mob.EntityArchangel;
import tragicneko.tragicmc.util.WorldHelper;

public class EntityAdmin
extends TragicBoss {
    private ControlTower[] towers;
    private boolean phaseChange = false;
    public static final int TOWER_LIMIT = 8;
    public int phaseTime = 1000;
    public EntityGhostAdmin ghost = null;
    public static final int DW_PHASE = 20;

    public EntityAdmin(World par1World) {
        super(par1World);
        this.func_70105_a(3.5f, 6.0f);
        this.towers = new ControlTower[8];
        this.field_70765_h = new EntityArchangel.FlyingMoveHelper((EntityLiving)this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
    }

    private void setIntState(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    public int getIntState() {
        return this.field_70180_af.func_75679_c(20);
    }

    private void setState(EnumAdminState state) {
        this.setIntState(state.getIntValue());
    }

    public EnumAdminState getState() {
        return EnumAdminState.values()[this.getIntState()];
    }

    @Override
    public void func_70636_d() {
        if (this.getState() == EnumAdminState.OVERLOADED) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        }
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.phaseTime > 0) {
            --this.phaseTime;
        } else if (this.phaseChange) {
            this.setState(EnumAdminState.getNextPhase(this.getState()));
            this.initPhase();
        } else {
            this.resetPhase();
        }
        this.updatePhase();
    }

    public void initPhase() {
        switch (this.getState()) {
            case INITIAL: {
                break;
            }
            case INVINCIBLE: {
                break;
            }
            case OVERLOADED: {
                break;
            }
            case REGENERATING: {
                break;
            }
            case NPC: {
                break;
            }
        }
    }

    public void resetPhase() {
        switch (this.getState()) {
            case INITIAL: {
                break;
            }
            case INVINCIBLE: {
                break;
            }
            case OVERLOADED: {
                break;
            }
            case REGENERATING: {
                break;
            }
            case NPC: {
                break;
            }
        }
    }

    public void updatePhase() {
        switch (this.getState()) {
            case INITIAL: {
                break;
            }
            case INVINCIBLE: {
                break;
            }
            case OVERLOADED: {
                break;
            }
            case REGENERATING: {
                break;
            }
            case NPC: {
                break;
            }
        }
    }

    private void updateTowers() {
        for (int i = 0; i < this.towers.length; ++i) {
            ControlTower ct = this.towers[i];
            if (ct == null) continue;
            ct.update();
        }
    }

    private void generateTowers() {
        int t = 0;
        ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(this.field_70170_p, 25.5, this.func_180425_c());
        block0: for (int i = 0; i < 128 && t < 8; ++i) {
            BlockPos pos = list.get(this.field_70146_Z.nextInt(list.size()));
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            if (Math.abs((double)pos.func_177956_o() - this.field_70163_u) > 10.0 || !(state.func_177230_c().func_176195_g(this.field_70170_p, pos) > 0.0f) || !World.func_175683_a((IBlockAccess)this.field_70170_p, (BlockPos)pos) || !this.field_70170_p.func_175710_j(pos)) continue;
            for (int j = 0; j < this.towers.length; ++j) {
                double z;
                double x;
                double d0;
                ControlTower ct = this.towers[j];
                if (ct != null && (ct.origin.func_177957_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) < 8.0 || (d0 = (double)MathHelper.func_76133_a((double)((x = (double)(ct.origin.func_177958_n() - pos.func_177958_n())) * x + (z = (double)(ct.origin.func_177952_p() - pos.func_177952_p())) * z))) < 8.0)) continue block0;
            }
            int n = t;
            t = (byte)(t + 1);
            this.towers[n] = new ControlTower(this, pos);
        }
    }

    private void regenerateTowers() {
    }

    private void deleteTowers() {
        for (int i = 0; i < this.towers.length; ++i) {
            ControlTower ct = this.towers[i];
            if (ct == null) continue;
            ct.kill();
        }
        this.towers = new ControlTower[8];
    }

    public void func_70050_g(int i) {
    }

    protected void func_70623_bb() {
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_180430_e(float dist, float multi) {
    }

    public EnumCreatureAttribute func_70668_bt() {
        return TragicEntities.Synapse;
    }

    public static class ControlTower {
        private final World worldObj;
        private final EntityAdmin admin;
        private final byte sizeH = (byte)16;
        private final byte sizeW = (byte)4;
        private final byte sizeL = (byte)4;
        private EnumTowerState state = EnumTowerState.INACTIVE;
        private final BlockPos origin;
        private float activePer;
        private static final float LOAD_LIMIT = 56.735f;

        protected ControlTower(EntityAdmin admin, BlockPos ori) {
            this.admin = admin;
            this.worldObj = admin.field_70170_p;
            this.origin = ori;
            this.activePer = 100.0f;
        }

        public boolean isOverloaded() {
            return this.state == EnumTowerState.OVERLOADED;
        }

        public boolean isActive() {
            return this.state != EnumTowerState.INACTIVE && this.state != EnumTowerState.REGENERATING;
        }

        public void update() {
            if (this.state == EnumTowerState.INACTIVE && this.shouldActivate()) {
                this.state = EnumTowerState.ACTIVE;
            } else if (this.state == EnumTowerState.ACTIVE) {
                this.updateComposition();
                this.updateState();
                this.damageEntities();
            }
        }

        private boolean shouldActivate() {
            return this.activePer == 100.0f && this.admin.field_70173_aa > 0;
        }

        public void updateComposition() {
            this.activePer = 100.0f;
        }

        private void updateState() {
            this.state = this.activePer > 56.735f ? EnumTowerState.ACTIVE : EnumTowerState.OVERLOADED;
        }

        private void kill() {
        }

        private void damageEntities() {
        }

        public static enum EnumTowerState {
            ACTIVE,
            INACTIVE,
            OVERLOADED,
            REGENERATING;

        }
    }

    public static enum EnumAdminState {
        INVINCIBLE(0),
        INITIAL(1),
        OVERLOADED(2),
        REGENERATING(3),
        NPC(4);

        private final int id;

        public static EnumAdminState getNextPhase(EnumAdminState state) {
            return state == INVINCIBLE ? INITIAL : (state == INITIAL ? OVERLOADED : NPC);
        }

        private EnumAdminState(int i) {
            this.id = i;
        }

        public int getIntValue() {
            return this.id;
        }
    }
}

