/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.doomsday;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.doomsday.Doomsday;
import tragicneko.tragicmc.doomsday.DoomsdayEffect;
import tragicneko.tragicmc.properties.PropertyDoom;
import tragicneko.tragicmc.util.WorldHelper;

public class DoomsdaySeptics
extends Doomsday
implements Doomsday.IExtendedDoomsday {
    public DoomsdaySeptics(int id) {
        super(id, Doomsday.EnumDoomType.WORLDSHAPER);
    }

    @Override
    public void doInitialEffects(DoomsdayEffect effect, PropertyDoom doom, EntityPlayer player, boolean crucMoment) {
        super.doInitialEffects(effect, doom, player, crucMoment);
        if (TragicConfig.getBoolean("allowImmunity")) {
            player.func_70690_d(new PotionEffect(TragicPotion.Immunity.field_76415_H, 600, 0));
        }
    }

    @Override
    public void useDoomsday(DoomsdayEffect effect, PropertyDoom doom, EntityPlayer player, boolean crucMoment) {
        double radius = crucMoment ? 6.0 : 4.0;
        ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(player.field_70170_p, radius, player.field_70165_t, player.field_70163_u, player.field_70161_v);
        if (crucMoment) {
            List list2 = player.field_70170_p.func_72839_b((Entity)player, player.func_174813_aQ().func_72314_b(radius, radius, radius));
            for (int i = 0; i < list2.size(); ++i) {
                if (!(list2.get(i) instanceof EntityMob)) continue;
                ((EntityLivingBase)list2.get(i)).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 120, 2));
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            BlockPos coords = (BlockPos)list.get(i);
            Block block = player.field_70170_p.func_180495_p(coords).func_177230_c();
            if (!block.isAir((IBlockAccess)player.field_70170_p, coords) || !World.func_175683_a((IBlockAccess)player.field_70170_p, (BlockPos)coords.func_177977_b())) continue;
            player.field_70170_p.func_175656_a(coords, TragicBlocks.SepticGas.func_176223_P());
        }
        if (crucMoment) {
            DoomsdaySeptics.addCrucialMessage(player);
        }
    }

    @Override
    public void doBacklashEffect(PropertyDoom doom, EntityPlayer player) {
        player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 120, 1));
    }

    @Override
    public int getWaitTime() {
        return 5;
    }

    @Override
    public int getMaxIterations() {
        return 60;
    }
}

