/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.doomsday;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.doomsday.Doomsday;
import tragicneko.tragicmc.doomsday.DoomsdayEffect;

public class DoomsdayManager {
    public static final Logger logger = LogManager.getLogger((String)"TragicMC/Doomsday Manager");
    private static Map<UUID, ArrayList<DoomsdayEffect>> playerMap = new HashMap<UUID, ArrayList<DoomsdayEffect>>();

    public static synchronized void registerDoomsdayEffect(UUID playerID, DoomsdayEffect effect) {
        if (playerMap.containsKey(playerID)) {
            try {
                ArrayList<DoomsdayEffect> list = playerMap.get(playerID);
                for (int i = 0; i < list.size(); ++i) {
                    DoomsdayEffect effect2 = list.get(i);
                    if (effect2.dday != effect.dday) continue;
                    logger.warn("" + DoomsdayManager.getUsernameFromUUID(playerID) + " attempted to register a new Doomsday effect for a Doomsday they already have active, ignoring registration.");
                    return;
                }
                list.add(effect);
            }
            catch (ConcurrentModificationException e) {
                logger.error("Error caught while attempting to register a new Doomsday effect.", (Throwable)e);
                return;
            }
        }
        try {
            ArrayList<DoomsdayEffect> list = new ArrayList<DoomsdayEffect>();
            list.add(effect);
            playerMap.put(playerID, list);
        }
        catch (ConcurrentModificationException e) {
            logger.error("Error caught while attempting to register a new Doomsday effect.", (Throwable)e);
            return;
        }
    }

    public static synchronized void clearRegistry() {
        try {
            playerMap.clear();
            logger.info("Doomsday map was cleared.");
        }
        catch (Exception e) {
            logger.error("Error caught while clearing the playerMap", (Throwable)e);
        }
    }

    public static synchronized void clearPlayerFromRegistry(UUID playerID, String reason) {
        try {
            if (playerMap.containsKey(playerID)) {
                playerMap.remove(playerID);
                if (reason != null) {
                    logger.info("Registry removed registration for " + DoomsdayManager.getUsernameFromUUID(playerID) + ", reason: " + reason);
                }
            } else {
                logger.error("Attempted to remove a player that was not registered in the map, there is a problem somewhere.");
            }
        }
        catch (Exception e) {
            logger.error("Error caught while attempting to remove a player from the playerMap", (Throwable)e);
        }
    }

    public static String getUsernameFromUUID(UUID uuid) {
        try {
            for (int i = 0; i < MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.size(); ++i) {
                EntityPlayer player = (EntityPlayer)MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.get(i);
                if (player.func_110124_au() != uuid) continue;
                return player.func_70005_c_();
            }
        }
        catch (Exception e) {
            logger.error("There was an error while retrieving a username from a UUID", (Throwable)e);
        }
        return uuid.toString();
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (playerMap.isEmpty()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            Set<UUID> set = playerMap.keySet();
            Iterator<UUID> ite = set.iterator();
            String reason = null;
            while (ite.hasNext()) {
                ArrayList<DoomsdayEffect> list = playerMap.get(ite.next());
                DoomsdayEffect effect = null;
                DoomsdayEffect temp = null;
                reason = null;
                boolean flag = false;
                if (list.size() == 0) {
                    reason = "No Doomsday effects registered.";
                }
                for (int i = 0; i < list.size(); ++i) {
                    effect = list.get(i);
                    if (effect == null) {
                        logger.error("Player had a null registration somehow! To prevent any problems, the player's registrations were cleared!");
                        reason = "Null Doomsday registration.";
                        list.clear();
                        break;
                    }
                    if (TragicConfig.getBoolean("allowCombinationDoomsdays")) {
                        if (flag && temp != null && temp.dday.getCombination() == effect.dday) {
                            if (temp.isActive && !temp.isInstant && !effect.player.field_71075_bZ.field_75098_d && !effect.isCommandActivated) {
                                temp.dday.applyDoomCost(temp.doom);
                            }
                            list.clear();
                            try {
                                list.add(new DoomsdayEffect(effect.dday.getCombination().getDoomId(), effect.doom, effect.isCommandActivated).inheritCooldown(temp, effect));
                            }
                            catch (NullPointerException e) {
                                e.printStackTrace();
                                logger.error("Combination doomsdays had a null Combination, report this!");
                                break;
                            }
                            if (!TragicConfig.getBoolean("allowAchievements")) break;
                            effect.player.func_71029_a((StatBase)TragicAchievements.doomsdayCombo);
                            break;
                        }
                        if (effect.dday instanceof Doomsday.IExtendedDoomsday && effect.dday.getCombination() != null) {
                            flag = true;
                            temp = effect;
                        }
                        if (!(effect.dday instanceof Doomsday.IExtendedDoomsday) && TragicConfig.getBoolean("allowPartnerDoomsdays")) {
                            block4: for (UUID uuid : playerMap.keySet()) {
                                ArrayList<DoomsdayEffect> effs = playerMap.get(uuid);
                                for (int j = 0; j < effs.size(); ++j) {
                                    DoomsdayEffect eff = effs.get(j);
                                    if (!(eff.dday instanceof Doomsday.IExtendedDoomsday) || eff.dday.getCombination() != effect.dday || !(effect.doom.getPlayer().func_70032_d((Entity)eff.doom.getPlayer()) <= (float)TragicConfig.getInt("partnerDoomsdayDistance"))) continue;
                                    list.clear();
                                    reason = "Partner activated a Combination.";
                                    DoomsdayManager.clearPlayerFromRegistry(uuid, "Partner Combination activated.");
                                    DoomsdayManager.registerDoomsdayEffect(uuid, new DoomsdayEffect(effect.dday.getCombination().getDoomId(), effect.doom, effect.isCommandActivated).inheritCooldown(eff, effect));
                                    continue block4;
                                }
                            }
                        }
                    }
                    effect.onDoomsdayUpdate();
                    if ((!effect.isActive && effect.isInstant || effect.dday instanceof Doomsday.IExtendedDoomsday && effect.timeBetweenUpdates == ((Doomsday.IExtendedDoomsday)((Object)effect.dday)).getWaitTime()) && !effect.player.field_71075_bZ.field_75098_d && !effect.isCommandActivated && effect.sneakTicks == 0) {
                        effect.dday.applyDoomCost(effect.doom);
                    }
                    if (effect.isActive) continue;
                    if (!(effect.player.field_71075_bZ.field_75098_d || effect.isCommandActivated || effect.player.func_70644_a(TragicPotion.Convergence))) {
                        if (effect.dday.doomsdayType == Doomsday.EnumDoomType.COMBINATION) {
                            effect.dday.applyCooldown(effect.doom, effect.iterations, effect.inheritedCooldown);
                        } else {
                            effect.dday.applyCooldown(effect.doom, effect.iterations);
                        }
                    }
                    list.remove(effect);
                    if (!(effect.dday instanceof Doomsday.IExtendedDoomsday)) continue;
                    effect.player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"doomsday.finish") + " " + effect.dday.getLocalizedName() + "!"));
                }
                if (effect.player.func_110143_aJ() <= 0.0f) {
                    reason = "Player is dead.";
                }
                if (!list.isEmpty() && !(effect.player.func_110143_aJ() <= 0.0f)) continue;
                DoomsdayManager.clearPlayerFromRegistry(effect.player.func_110124_au(), reason);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDisconnect(FMLNetworkEvent.ServerDisconnectionFromClientEvent event) {
        if (event.handler instanceof NetHandlerPlayServer && !playerMap.isEmpty()) {
            NetHandlerPlayServer net = (NetHandlerPlayServer)event.handler;
            if (net.field_147369_b == null) {
                return;
            }
            if (playerMap.containsKey(net.field_147369_b.func_110124_au())) {
                DoomsdayManager.clearPlayerFromRegistry(net.field_147369_b.func_110124_au(), "Disconnected from server.");
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.entityLiving instanceof EntityPlayer && playerMap.containsKey(event.entityLiving.func_110124_au())) {
            DoomsdayManager.clearPlayerFromRegistry(event.entityLiving.func_110124_au(), "Player died during use.");
        }
    }
}

