/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.doomsday;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RegistryNamespacedDefaultedByKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.doomsday.DoomsdayAdrenaline;
import tragicneko.tragicmc.doomsday.DoomsdayAmbience;
import tragicneko.tragicmc.doomsday.DoomsdayAsphyxiate;
import tragicneko.tragicmc.doomsday.DoomsdayBeastlyImpulses;
import tragicneko.tragicmc.doomsday.DoomsdayBerserker;
import tragicneko.tragicmc.doomsday.DoomsdayBlink;
import tragicneko.tragicmc.doomsday.DoomsdayBlizzard;
import tragicneko.tragicmc.doomsday.DoomsdayBloodlust;
import tragicneko.tragicmc.doomsday.DoomsdayDangerZone;
import tragicneko.tragicmc.doomsday.DoomsdayDeathMark;
import tragicneko.tragicmc.doomsday.DoomsdayDecay;
import tragicneko.tragicmc.doomsday.DoomsdayDelete;
import tragicneko.tragicmc.doomsday.DoomsdayDimentia;
import tragicneko.tragicmc.doomsday.DoomsdayDragonsRoar;
import tragicneko.tragicmc.doomsday.DoomsdayEffect;
import tragicneko.tragicmc.doomsday.DoomsdayEscape;
import tragicneko.tragicmc.doomsday.DoomsdayEvacuation;
import tragicneko.tragicmc.doomsday.DoomsdayFear;
import tragicneko.tragicmc.doomsday.DoomsdayFireRain;
import tragicneko.tragicmc.doomsday.DoomsdayFirestorm;
import tragicneko.tragicmc.doomsday.DoomsdayFlash;
import tragicneko.tragicmc.doomsday.DoomsdayFlightOfTheValkyries;
import tragicneko.tragicmc.doomsday.DoomsdayFreeze;
import tragicneko.tragicmc.doomsday.DoomsdayGambler;
import tragicneko.tragicmc.doomsday.DoomsdayGiftOfTheGods;
import tragicneko.tragicmc.doomsday.DoomsdayGrowthSpurt;
import tragicneko.tragicmc.doomsday.DoomsdayGuardian;
import tragicneko.tragicmc.doomsday.DoomsdayHarden;
import tragicneko.tragicmc.doomsday.DoomsdayHarmonizer;
import tragicneko.tragicmc.doomsday.DoomsdayHuntersInstinct;
import tragicneko.tragicmc.doomsday.DoomsdayKurayami;
import tragicneko.tragicmc.doomsday.DoomsdayLaserCutter;
import tragicneko.tragicmc.doomsday.DoomsdayLifeShare;
import tragicneko.tragicmc.doomsday.DoomsdayLightShove;
import tragicneko.tragicmc.doomsday.DoomsdayLightningRush;
import tragicneko.tragicmc.doomsday.DoomsdayMagnetizer;
import tragicneko.tragicmc.doomsday.DoomsdayManager;
import tragicneko.tragicmc.doomsday.DoomsdayMarionette;
import tragicneko.tragicmc.doomsday.DoomsdayMedic;
import tragicneko.tragicmc.doomsday.DoomsdayMindcrack;
import tragicneko.tragicmc.doomsday.DoomsdayMinerSkills;
import tragicneko.tragicmc.doomsday.DoomsdayMoonlightSonata;
import tragicneko.tragicmc.doomsday.DoomsdayNatureDrain;
import tragicneko.tragicmc.doomsday.DoomsdayParadigmShift;
import tragicneko.tragicmc.doomsday.DoomsdayParasite;
import tragicneko.tragicmc.doomsday.DoomsdayPermafrost;
import tragicneko.tragicmc.doomsday.DoomsdayPiercingLight;
import tragicneko.tragicmc.doomsday.DoomsdayPoisonBreak;
import tragicneko.tragicmc.doomsday.DoomsdayPulse;
import tragicneko.tragicmc.doomsday.DoomsdayPurge;
import tragicneko.tragicmc.doomsday.DoomsdayPurify;
import tragicneko.tragicmc.doomsday.DoomsdayRadiantLight;
import tragicneko.tragicmc.doomsday.DoomsdayRapidFire;
import tragicneko.tragicmc.doomsday.DoomsdayRavage;
import tragicneko.tragicmc.doomsday.DoomsdayRealityAlter;
import tragicneko.tragicmc.doomsday.DoomsdayReaperLaugh;
import tragicneko.tragicmc.doomsday.DoomsdayRecall;
import tragicneko.tragicmc.doomsday.DoomsdayResurge;
import tragicneko.tragicmc.doomsday.DoomsdaySeptics;
import tragicneko.tragicmc.doomsday.DoomsdaySharpen;
import tragicneko.tragicmc.doomsday.DoomsdayShotgun;
import tragicneko.tragicmc.doomsday.DoomsdayShuffle;
import tragicneko.tragicmc.doomsday.DoomsdaySkullCrusher;
import tragicneko.tragicmc.doomsday.DoomsdaySnipe;
import tragicneko.tragicmc.doomsday.DoomsdaySoulstealer;
import tragicneko.tragicmc.doomsday.DoomsdaySuicidalTendencies;
import tragicneko.tragicmc.doomsday.DoomsdaySupport;
import tragicneko.tragicmc.doomsday.DoomsdaySymbiosis;
import tragicneko.tragicmc.doomsday.DoomsdayTimeCollapse;
import tragicneko.tragicmc.doomsday.DoomsdayTitanfall;
import tragicneko.tragicmc.doomsday.DoomsdayTorment;
import tragicneko.tragicmc.doomsday.DoomsdayToxicity;
import tragicneko.tragicmc.properties.PropertyAmulets;
import tragicneko.tragicmc.properties.PropertyDoom;

public abstract class Doomsday {
    protected static final Random rand = new Random();
    public static final String[] doomsdayNames = new String[]{"null", "decay", "huntersInstinct", "toxicity", "berserker", "piercingLight", "natureDrain", "poisonBreak", "snipe", "rapidFire", "pulse", "lightShove", "fear", "harmonizer", "ravage", "torment", "beastlyImpulses", "suicidalTendencies", "reaperLaugh", "realityAlter", "skullCrusher", "minerSkills", "freeze", "moonlightSonata", "flightOfTheValkyries", "titanfall", "bloodlust", "permafrost", "purge", "lightningCrush", "marionette", "mindcrack", "growthSpurt", "blizzard", "asphyxiate", "fireRain", "dragonsRoar", "firestorm", "shotgun", "guardiansCall", "harden", "sharpen", "flash", "septics", "kurayami", "lifeShare", "deathMark", "paradigmShift", "adrenaline", "escape", "giftOfTheGods", "gambler", "soulstealer", "parasite", "symbiosis", "timeCollapse", "magnetizer", "ambience", "dimentia", "delete", "laserCutter", "radiantLight", "dangerZone", "support", "purify", "recall", "shuffle", "blink", "evacuation", "medic", "resurge"};
    public static final RegistryNamespacedDefaultedByKey<ResourceLocation, Doomsday> doomsdayRegistry = new RegistryNamespacedDefaultedByKey((Object)new ResourceLocation("null"));
    public static final Doomsday Decay = new DoomsdayDecay(1);
    public static final Doomsday HuntersInstinct = new DoomsdayHuntersInstinct(2);
    public static final Doomsday Toxicity = new DoomsdayToxicity(3);
    public static final Doomsday Berserker = new DoomsdayBerserker(4);
    public static final Doomsday PiercingLight = new DoomsdayPiercingLight(5);
    public static final Doomsday NatureDrain = new DoomsdayNatureDrain(6);
    public static final Doomsday PoisonBreak = new DoomsdayPoisonBreak(7);
    public static final Doomsday Snipe = new DoomsdaySnipe(8);
    public static final Doomsday RapidFire = new DoomsdayRapidFire(9);
    public static final Doomsday Pulse = new DoomsdayPulse(10);
    public static final Doomsday LightShove = new DoomsdayLightShove(11);
    public static final Doomsday Fear = new DoomsdayFear(12);
    public static final Doomsday Harmonizer = new DoomsdayHarmonizer(13);
    public static final Doomsday Ravage = new DoomsdayRavage(14);
    public static final Doomsday Torment = new DoomsdayTorment(15);
    public static final Doomsday BeastlyImpulses = new DoomsdayBeastlyImpulses(16);
    public static final Doomsday SuicidalTendencies = new DoomsdaySuicidalTendencies(17);
    public static final Doomsday ReaperLaugh = new DoomsdayReaperLaugh(18);
    public static final Doomsday RealityAlter = new DoomsdayRealityAlter(19);
    public static final Doomsday SkullCrusher = new DoomsdaySkullCrusher(20);
    public static final Doomsday MinerSkills = new DoomsdayMinerSkills(21);
    public static final Doomsday Freeze = new DoomsdayFreeze(22);
    public static final Doomsday MoonlightSonata = new DoomsdayMoonlightSonata(23);
    public static final Doomsday FlightOfTheValkyries = new DoomsdayFlightOfTheValkyries(24);
    public static final Doomsday Titanfall = new DoomsdayTitanfall(25);
    public static final Doomsday Bloodlust = new DoomsdayBloodlust(26);
    public static final Doomsday Permafrost = new DoomsdayPermafrost(27);
    public static final Doomsday Purge = new DoomsdayPurge(28);
    public static final Doomsday LightningRush = new DoomsdayLightningRush(29);
    public static final Doomsday Marionette = new DoomsdayMarionette(30);
    public static final Doomsday Mindcrack = new DoomsdayMindcrack(31);
    public static final Doomsday GrowthSpurt = new DoomsdayGrowthSpurt(32);
    public static final Doomsday Blizzard = new DoomsdayBlizzard(33);
    public static final Doomsday Asphyxiate = new DoomsdayAsphyxiate(34);
    public static final Doomsday FireRain = new DoomsdayFireRain(35);
    public static final Doomsday DragonsRoar = new DoomsdayDragonsRoar(36);
    public static final Doomsday Firestorm = new DoomsdayFirestorm(37);
    public static final Doomsday Shotgun = new DoomsdayShotgun(38);
    public static final Doomsday GuardiansCall = new DoomsdayGuardian(39);
    public static final Doomsday Harden = new DoomsdayHarden(40);
    public static final Doomsday Sharpen = new DoomsdaySharpen(41);
    public static final Doomsday Flash = new DoomsdayFlash(42);
    public static final Doomsday Septics = new DoomsdaySeptics(43);
    public static final Doomsday Kurayami = new DoomsdayKurayami(44);
    public static final Doomsday LifeShare = new DoomsdayLifeShare(45);
    public static final Doomsday DeathMark = new DoomsdayDeathMark(46);
    public static final Doomsday ParadigmShift = new DoomsdayParadigmShift(47);
    public static final Doomsday Adrenaline = new DoomsdayAdrenaline(48);
    public static final Doomsday Escape = new DoomsdayEscape(49);
    public static final Doomsday GiftOfTheGods = new DoomsdayGiftOfTheGods(50);
    public static final Doomsday Gambler = new DoomsdayGambler(51);
    public static final Doomsday Soulstealer = new DoomsdaySoulstealer(52);
    public static final Doomsday Parasite = new DoomsdayParasite(53);
    public static final Doomsday Symbiosis = new DoomsdaySymbiosis(54);
    public static final Doomsday TimeCollapse = new DoomsdayTimeCollapse(55);
    public static final Doomsday Magnetizer = new DoomsdayMagnetizer(56);
    public static final Doomsday Ambience = new DoomsdayAmbience(57);
    public static final Doomsday Dimentia = new DoomsdayDimentia(58);
    public static final Doomsday Delete = new DoomsdayDelete(59);
    public static final Doomsday LaserCutter = new DoomsdayLaserCutter(60);
    public static final Doomsday RadiantLight = new DoomsdayRadiantLight(61);
    public static final Doomsday DangerZone = new DoomsdayDangerZone(62);
    public static final Doomsday Support = new DoomsdaySupport(63);
    public static final Doomsday Purify = new DoomsdayPurify(64);
    public static final Doomsday Recall = new DoomsdayRecall(65);
    public static final Doomsday Shuffle = new DoomsdayShuffle(66);
    public static final Doomsday Blink = new DoomsdayBlink(67);
    public static final Doomsday Evacuation = new DoomsdayEvacuation(68);
    public static final Doomsday Medic = new DoomsdayMedic(69);
    public static final Doomsday Resurge = new DoomsdayResurge(70);
    public final EnumDoomType doomsdayType;
    public final int requiredDoom;
    public final int cooldown;

    public Doomsday(int id) {
        this(id, EnumDoomType.INFLUENCE);
    }

    public Doomsday(int id, EnumDoomType doomType) {
        ResourceLocation rl = new ResourceLocation("tragicmc:" + doomsdayNames[id]);
        this.doomsdayType = doomType;
        this.cooldown = TragicConfig.doomsdayCooldown[id];
        this.requiredDoom = TragicConfig.doomsdayCost[id];
        if (doomsdayRegistry.func_148741_d((Object)rl)) {
            throw new IllegalArgumentException("There is already a Doomsday registered with that name! (" + rl + ")");
        }
        doomsdayRegistry.func_177775_a(id, (Object)rl, (Object)this);
    }

    public static void load() {
    }

    public EnumDoomType getDoomsdayType() {
        return this.doomsdayType;
    }

    public int getScaledDoomRequirement(EnumDifficulty dif) {
        int reqDoom = this.requiredDoom;
        if (dif == EnumDifficulty.PEACEFUL) {
            return 1;
        }
        if (dif == EnumDifficulty.EASY) {
            return MathHelper.func_76143_f((double)((double)reqDoom / 2.0));
        }
        if (dif == EnumDifficulty.HARD) {
            return reqDoom;
        }
        return MathHelper.func_76143_f((double)((double)reqDoom * 2.0 / 3.0));
    }

    public int getScaledDoomRequirement(World world) {
        return this.getScaledDoomRequirement(world.func_175659_aa());
    }

    public int getScaledDoomRequirement(PropertyDoom doom) {
        return this.getScaledDoomRequirement(doom.getPlayer().field_70170_p);
    }

    public boolean activateDoomsday(PropertyDoom doom) {
        if (doom == null) {
            TragicMC.logError("A doomsday was activated with null doom? This error shouldn't be possible and should be reported.");
            return false;
        }
        if (!TragicConfig.getBoolean("allowDoom")) {
            TragicMC.logError("You have Doom disabled... this shouldn't have been called, report this");
            return false;
        }
        if (!TragicConfig.doomsdayAllow[this.getDoomId()]) {
            doom.getPlayer().func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"doomsday.fail5")));
            return false;
        }
        if (doom.getCurrentCooldown() != 0) {
            doom.getPlayer().func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"doomsday.fail")));
            return false;
        }
        if (!this.doesCurrentDoomMeetRequirement(doom)) {
            doom.getPlayer().func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"doomsday.fail2")));
            return false;
        }
        if (doom.getPlayer().field_70128_L) {
            doom.getPlayer().func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"doomsday.fail3")));
            return false;
        }
        if (TragicConfig.getBoolean("allowStun") && doom.getPlayer().func_70644_a(TragicPotion.Stun) || TragicConfig.getBoolean("allowHarmony") && doom.getPlayer().func_70644_a(TragicPotion.Harmony) || TragicConfig.getBoolean("allowFear") && doom.getPlayer().func_70644_a(TragicPotion.Fear)) {
            doom.getPlayer().func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"doomsday.fail4")));
            return false;
        }
        return this.doDoomsday(doom, doom.getPlayer());
    }

    public boolean doDoomsday(PropertyDoom doom, EntityPlayer player) {
        int backlash = this.getScaledBacklash(TragicConfig.getInt("backlashChance"), player, this.doomsdayType);
        if (rand.nextInt(100) <= backlash && TragicConfig.getBoolean("allowBacklash")) {
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"doomsday.backlash")));
            if (!player.field_71075_bZ.field_75098_d) {
                doom.increaseCooldown(this.getScaledCooldown(player.field_70170_p.func_175659_aa()) / 3);
                int cost = this.getScaledDoomRequirement(doom) / 3;
                if (TragicConfig.getBoolean("amuConsumption")) {
                    EntityPlayer mp = doom.getPlayer();
                    PropertyAmulets amu = PropertyAmulets.get(mp);
                    for (int i = 0; i < 3; ++i) {
                        if (amu.getActiveAmulet(i) == null || amu.getActiveAmulet(i) != TragicItems.ConsumptionAmulet) continue;
                        cost = doom.getMaxDoom();
                        break;
                    }
                }
                doom.increaseDoom(-cost);
                this.doBacklashEffect(doom, player);
            }
            return false;
        }
        DoomsdayEffect effect = new DoomsdayEffect(this.getDoomId(), doom);
        DoomsdayManager.registerDoomsdayEffect(player.func_110124_au(), effect);
        if (TragicConfig.getBoolean("allowAchievements")) {
            player.func_71029_a((StatBase)TragicAchievements.doomsday);
        }
        return true;
    }

    public void doInitialEffects(DoomsdayEffect effect, PropertyDoom doom, EntityPlayer player, boolean crucMoment) {
        player.func_145747_a((IChatComponent)new ChatComponentText(this.doomsdayType.format + StatCollector.func_74838_a((String)"doomsday.confirmation") + " " + this.getLocalizedName() + "!"));
        if (crucMoment) {
            Doomsday.addCrucialMessage(player);
        }
    }

    public abstract void useDoomsday(DoomsdayEffect var1, PropertyDoom var2, EntityPlayer var3, boolean var4);

    public abstract void doBacklashEffect(PropertyDoom var1, EntityPlayer var2);

    public void applyDoomAndCooldown(PropertyDoom doom) {
        doom.decreaseDoomAmountAndApplyCooldown(this.getScaledDoomRequirement(doom), this.getScaledCooldown(doom.getPlayer().field_70170_p.func_175659_aa()));
    }

    public void applyDoomCost(PropertyDoom doom) {
        int cost = -this.getScaledDoomRequirement(doom);
        if (TragicConfig.getBoolean("amuConsumption")) {
            EntityPlayer mp = doom.getPlayer();
            PropertyAmulets amu = PropertyAmulets.get(mp);
            for (int i = 0; i < 3; ++i) {
                if (amu.getActiveAmulet(i) == null || amu.getActiveAmulet(i) != TragicItems.ConsumptionAmulet || mp.field_70170_p.field_73012_v.nextInt(16) != 0) continue;
                cost = (int)((double)cost * 0.5);
                break;
            }
        }
        doom.increaseDoom(cost);
    }

    public void applyCooldown(PropertyDoom doom, int iterations) {
        doom.increaseCooldown(this.getScaledCooldown(doom.getPlayer().field_70170_p.func_175659_aa()) * iterations);
    }

    public void applyCooldown(PropertyDoom doom, int iterations, int inheritence) {
        this.applyCooldown(doom, iterations);
        doom.increaseCooldown(inheritence);
    }

    protected int getScaledBacklash(int backlashChance, EntityPlayer player, EnumDoomType doomType) {
        EnumDifficulty dif = player.field_70170_p.func_175659_aa();
        int x = 1;
        switch (doomType) {
            case INFLUENCE: {
                x = 1;
                break;
            }
            case OVERFLOW: 
            case WORLDSHAPER: {
                x = 2;
                break;
            }
            case CRISIS: {
                x = 3;
                break;
            }
            case COMBINATION: {
                x = -1;
            }
        }
        if (dif == EnumDifficulty.PEACEFUL) {
            return backlashChance * 4 * x;
        }
        if (dif == EnumDifficulty.EASY) {
            return backlashChance * 2 * x;
        }
        if (dif == EnumDifficulty.HARD) {
            return backlashChance / 2 * x;
        }
        return backlashChance * x;
    }

    public String getUnlocalizedName() {
        int a = this.getDoomId();
        String s = null;
        if (a < doomsdayNames.length && a > 0) {
            s = doomsdayNames[a];
        }
        return "doomsday." + s + ".name";
    }

    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)this.getUnlocalizedName());
    }

    public String getLocalizedType() {
        return StatCollector.func_74838_a((String)this.getUnlocalizedType());
    }

    public String getUnlocalizedType() {
        EnumDoomType type = this.doomsdayType;
        return "doomsday." + type.func_176610_l() + ".type";
    }

    public static EnumDoomType getDoomsdayTypeFromId(int id) {
        return ((Doomsday)Doomsday.doomsdayRegistry.func_148754_a((int)id)).doomsdayType;
    }

    public int getScaledCooldown(EnumDifficulty dif) {
        if (dif == EnumDifficulty.HARD) {
            return this.cooldown;
        }
        if (dif == EnumDifficulty.NORMAL) {
            return this.cooldown * 2 / 3;
        }
        if (dif == EnumDifficulty.EASY) {
            return this.cooldown / 2;
        }
        return 0;
    }

    public boolean doesCurrentDoomMeetRequirement(PropertyDoom doom) {
        return doom.getCurrentDoom() >= this.getScaledDoomRequirement(doom);
    }

    public boolean doesCurrentDoomMeetRequirement(PropertyDoom doom, int iterations) {
        return doom.getCurrentDoom() >= this.getScaledDoomRequirement(doom) * iterations;
    }

    public int getDoomId() {
        return doomsdayRegistry.func_148757_b((Object)this);
    }

    public static Doomsday getDoomsdayFromId(int id) {
        return (Doomsday)doomsdayRegistry.func_148754_a(id);
    }

    public static Doomsday getDoomsdayFromString(String s) {
        s.trim();
        return (Doomsday)doomsdayRegistry.func_82594_a((Object)new ResourceLocation("tragicmc:" + s));
    }

    public static int getRegistrySize() {
        return doomsdayRegistry.func_148742_b().size();
    }

    public static Doomsday getRandomDoomsday() {
        int i = Doomsday.getRegistrySize();
        return (Doomsday)doomsdayRegistry.func_148754_a(rand.nextInt(i));
    }

    public int getOverflow(PropertyDoom doom) {
        return doom.getMaxDoom() - doom.getCurrentDoom();
    }

    public float getCrisis(EntityPlayer player) {
        return player.func_110143_aJ() / player.func_110138_aP();
    }

    public Doomsday getCombination() {
        return null;
    }

    public static void addCrucialMessage(EntityPlayer player) {
        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"doomsday.crucial")));
    }

    public static void addNoEntityMessage(EntityPlayer player) {
        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"doomsday.noEntities")));
    }

    public static interface IExtendedDoomsday {
        public int getWaitTime();

        public int getMaxIterations();
    }

    public static enum EnumDoomType implements IStringSerializable
    {
        INFLUENCE("influence"),
        OVERFLOW("overflow", EnumChatFormatting.GREEN),
        CRISIS("crisis", EnumChatFormatting.RED),
        WORLDSHAPER("worldshaper", EnumChatFormatting.DARK_PURPLE),
        COMBINATION("combination", EnumChatFormatting.YELLOW);

        private final EnumChatFormatting format;
        private final String name;

        private EnumDoomType(String name) {
            this(name, EnumChatFormatting.AQUA);
        }

        private EnumDoomType(String name, EnumChatFormatting format) {
            this.name = name;
            this.format = format;
        }

        public EnumChatFormatting getFormat() {
            return this.format;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

