/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ReportedException;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerAddIsland;
import net.minecraft.world.gen.layer.GenLayerAddMushroomIsland;
import net.minecraft.world.gen.layer.GenLayerAddSnow;
import net.minecraft.world.gen.layer.GenLayerDeepOcean;
import net.minecraft.world.gen.layer.GenLayerEdge;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerIsland;
import net.minecraft.world.gen.layer.GenLayerRemoveTooMuchOcean;
import net.minecraft.world.gen.layer.GenLayerRiver;
import net.minecraft.world.gen.layer.GenLayerRiverInit;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraft.world.gen.layer.IntCache;
import tragicneko.tragicmc.TragicBiome;
import tragicneko.tragicmc.dimension.SubBiomeCache;
import tragicneko.tragicmc.dimension.WildsBiomeBaseVariantGenLayer;
import tragicneko.tragicmc.dimension.WildsBiomeEdgeGenLayer;
import tragicneko.tragicmc.dimension.WildsBiomeGenLayer;
import tragicneko.tragicmc.dimension.WildsRareBiomeGenLayer;
import tragicneko.tragicmc.dimension.WildsRiverMixGenLayer;
import tragicneko.tragicmc.dimension.WildsSubBiomeGenLayer;
import tragicneko.tragicmc.worldgen.subbiome.TragicSubBiome;

public class WildsChunkManager
extends WorldChunkManager {
    private GenLayer genLayerBiomes;
    private GenLayer genLayerBiomeIndex;
    private GenLayer genLayerSubBiomes;
    private GenLayer genLayerSubBiomeIndex;
    private BiomeCache biomeCache = new BiomeCache((WorldChunkManager)this);
    private SubBiomeCache subBiomeCache = new SubBiomeCache(this);
    private List<BiomeGenBase> spawnBiomes = new ArrayList<BiomeGenBase>();

    public WildsChunkManager(long seed, WorldType worldType) {
        this.addBiomes(this.spawnBiomes);
        GenLayer[] genLayers = WildsChunkManager.getGenLayers(seed, worldType);
        this.genLayerBiomes = genLayers[0];
        this.genLayerBiomeIndex = genLayers[1];
        this.genLayerSubBiomes = genLayers[2];
        this.genLayerSubBiomeIndex = genLayers[3];
    }

    public WildsChunkManager(World world) {
        this(world.func_72905_C(), world.func_72912_H().func_76067_t());
    }

    public void addBiomes(List<BiomeGenBase> list) {
        list.add(TragicBiome.WildPlains);
        list.add(TragicBiome.WildForest);
        list.add(TragicBiome.WildDenseForest);
        list.add(TragicBiome.WildValley);
        list.add(TragicBiome.WildHills);
        list.add(TragicBiome.WildExtremeHills);
        list.add(TragicBiome.WildSteppes);
        list.add(TragicBiome.WildSavanna);
        list.add(TragicBiome.WildDesert);
        list.add(TragicBiome.WildMountains);
        list.add(TragicBiome.WildIsland);
    }

    public static GenLayer[] getGenLayers(long seed, WorldType worldType) {
        GenLayerIsland genlayerisland = new GenLayerIsland(1L);
        GenLayerFuzzyZoom genlayerfuzzyzoom = new GenLayerFuzzyZoom(2000L, (GenLayer)genlayerisland);
        GenLayerAddIsland genlayeraddisland = new GenLayerAddIsland(1L, (GenLayer)genlayerfuzzyzoom);
        GenLayerZoom genlayerzoom = new GenLayerZoom(2001L, (GenLayer)genlayeraddisland);
        genlayeraddisland = new GenLayerAddIsland(2L, (GenLayer)genlayerzoom);
        genlayeraddisland = new GenLayerAddIsland(50L, (GenLayer)genlayeraddisland);
        genlayeraddisland = new GenLayerAddIsland(70L, (GenLayer)genlayeraddisland);
        GenLayerRemoveTooMuchOcean genlayerremovetoomuchocean = new GenLayerRemoveTooMuchOcean(2L, (GenLayer)genlayeraddisland);
        GenLayerAddSnow genlayeraddsnow = new GenLayerAddSnow(2L, (GenLayer)genlayerremovetoomuchocean);
        genlayeraddisland = new GenLayerAddIsland(3L, (GenLayer)genlayeraddsnow);
        GenLayerEdge genlayeredge = new GenLayerEdge(2L, (GenLayer)genlayeraddisland, GenLayerEdge.Mode.COOL_WARM);
        genlayeredge = new GenLayerEdge(2L, (GenLayer)genlayeredge, GenLayerEdge.Mode.HEAT_ICE);
        genlayeredge = new GenLayerEdge(3L, (GenLayer)genlayeredge, GenLayerEdge.Mode.SPECIAL);
        genlayerzoom = new GenLayerZoom(2002L, (GenLayer)genlayeredge);
        genlayerzoom = new GenLayerZoom(2003L, (GenLayer)genlayerzoom);
        genlayeraddisland = new GenLayerAddIsland(4L, (GenLayer)genlayerzoom);
        GenLayerAddMushroomIsland genlayeraddmushroomisland = new GenLayerAddMushroomIsland(5L, (GenLayer)genlayeraddisland);
        GenLayerDeepOcean genlayerdeepocean = new GenLayerDeepOcean(4L, (GenLayer)genlayeraddmushroomisland);
        GenLayer genlayer2 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerdeepocean, (int)0);
        GenLayer genlayer = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayer2, (int)0);
        GenLayerRiverInit genlayerriverinit = new GenLayerRiverInit(100L, genlayer);
        GenLayer biomes = new WildsBiomeGenLayer(seed, genlayer2);
        biomes = GenLayerZoom.func_75915_a((long)100L, (GenLayer)biomes, (int)5);
        biomes = new WildsBiomeEdgeGenLayer(seed, biomes);
        GenLayer genlayer1 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerriverinit, (int)2);
        WildsBiomeBaseVariantGenLayer genlayerhills = new WildsBiomeBaseVariantGenLayer(1000L, biomes, genlayer1);
        genlayer = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerriverinit, (int)2);
        genlayer = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayer, (int)5);
        GenLayerRiver genlayerriver = new GenLayerRiver(1L, genlayer);
        GenLayerSmooth genlayersmooth = new GenLayerSmooth(1000L, (GenLayer)genlayerriver);
        WildsRareBiomeGenLayer object = new WildsRareBiomeGenLayer(1001L, genlayerhills);
        for (int l = 0; l < 5; l = (int)((byte)(l + 1))) {
            object = new GenLayerZoom((long)(1000 + l), (GenLayer)object);
        }
        GenLayerSmooth genlayersmooth1 = new GenLayerSmooth(1000L, (GenLayer)object);
        WildsRiverMixGenLayer genlayerrivermix = new WildsRiverMixGenLayer(100L, (GenLayer)genlayersmooth1, (GenLayer)genlayersmooth);
        GenLayerVoronoiZoom genlayervoronoizoom = new GenLayerVoronoiZoom(10L, (GenLayer)genlayerrivermix);
        genlayerrivermix.func_75905_a(seed);
        genlayervoronoizoom.func_75905_a(seed);
        WildsSubBiomeGenLayer subBiomes = new WildsSubBiomeGenLayer(seed);
        subBiomes = GenLayerZoom.func_75915_a((long)110L, (GenLayer)subBiomes, (int)9);
        GenLayerVoronoiZoom zoom2 = new GenLayerVoronoiZoom(10L, (GenLayer)subBiomes);
        subBiomes.func_75905_a(seed);
        zoom2.func_75905_a(seed);
        return new GenLayer[]{genlayerrivermix, genlayervoronoizoom, subBiomes, zoom2};
    }

    public final List func_76932_a() {
        return this.spawnBiomes;
    }

    public BiomeGenBase func_180631_a(BlockPos pos) {
        return this.func_180300_a(pos, null);
    }

    public BiomeGenBase func_180300_a(BlockPos pos, BiomeGenBase biome) {
        return this.biomeCache.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), biome);
    }

    public float[] func_76936_a(float[] store, int x, int z, int width, int height) {
        IntCache.func_76446_a();
        int len = width * height;
        if (store == null || store.length < len) {
            store = new float[len];
        }
        int[] ints = this.genLayerBiomeIndex.func_75904_a(x, z, width, height);
        for (int i = 0; i < len; ++i) {
            try {
                float f = (float)BiomeGenBase.func_150568_d((int)ints[i]).func_76744_g() / 65536.0f;
                if (f > 1.0f) {
                    f = 1.0f;
                }
                store[i] = f;
                continue;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("DownfallBlock");
                crashreportcategory.func_71507_a("biome id", (Object)i);
                crashreportcategory.func_71507_a("downfalls[] size", (Object)store.length);
                crashreportcategory.func_71507_a("x", (Object)x);
                crashreportcategory.func_71507_a("z", (Object)z);
                crashreportcategory.func_71507_a("w", (Object)width);
                crashreportcategory.func_71507_a("h", (Object)height);
                throw new ReportedException(crashreport);
            }
        }
        return store;
    }

    public float func_76939_a(float temperature, int y) {
        return temperature;
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] store, int x, int z, int width, int height) {
        IntCache.func_76446_a();
        int len = width * height;
        if (store == null || store.length < len) {
            store = new BiomeGenBase[len];
        }
        int[] ints = this.genLayerBiomes.func_75904_a(x, z, width, height);
        for (int i = 0; i < len; ++i) {
            try {
                store[i] = BiomeGenBase.func_150568_d((int)ints[i]);
                continue;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("RawBiomeBlock");
                crashreportcategory.func_71507_a("biomes[] size", (Object)store.length);
                crashreportcategory.func_71507_a("x", (Object)x);
                crashreportcategory.func_71507_a("z", (Object)z);
                crashreportcategory.func_71507_a("w", (Object)width);
                crashreportcategory.func_71507_a("h", (Object)height);
                throw new ReportedException(crashreport);
            }
        }
        return store;
    }

    public BiomeGenBase[] func_76933_b(BiomeGenBase[] store, int x, int z, int width, int height) {
        return this.func_76931_a(store, x, z, width, height, true);
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] store, int x, int z, int width, int height, boolean cache) {
        IntCache.func_76446_a();
        int len = width * height;
        if (store == null || store.length < len) {
            store = new BiomeGenBase[len];
        }
        if (cache && width == 16 && height == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            BiomeGenBase[] biomes = this.biomeCache.func_76839_e(x, z);
            System.arraycopy(biomes, 0, store, 0, len);
            return store;
        }
        int[] ints = this.genLayerBiomeIndex.func_75904_a(x, z, width, height);
        for (int i = 0; i < len; ++i) {
            store[i] = BiomeGenBase.func_150568_d((int)ints[i]);
        }
        return store;
    }

    public TragicSubBiome[] getBiomeGenAt(TragicSubBiome[] store, int x, int z, int width, int height, boolean cache) {
        IntCache.func_76446_a();
        int len = width * height;
        if (store == null || store.length < len) {
            store = new TragicSubBiome[len];
        }
        if (cache && width == 16 && height == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            TragicSubBiome[] biomes = this.subBiomeCache.getCachedBiomes(x, z);
            System.arraycopy(biomes, 0, store, 0, len);
            return store;
        }
        int[] ints = this.genLayerSubBiomeIndex.func_75904_a(x, z, width, height);
        for (int i = 0; i < len; ++i) {
            store[i] = TragicSubBiome.subBiomes[ints[i]];
        }
        return store;
    }

    public boolean func_76940_a(int x, int z, int range, List biomes) {
        IntCache.func_76446_a();
        int x1 = x - range >> 2;
        int z1 = z - range >> 2;
        int x2 = x + range >> 2;
        int z2 = z + range >> 2;
        int x3 = x2 - x1 + 1;
        int z3 = z2 - z1 + 1;
        int len = x3 * z3;
        int[] ints = this.genLayerBiomes.func_75904_a(x1, z1, x3, z3);
        try {
            for (int i = 0; i < len; ++i) {
                BiomeGenBase biomegenbase = BiomeGenBase.func_150568_d((int)ints[i]);
                if (biomes.contains(biomegenbase) && biomegenbase instanceof TragicBiome) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Layer");
            crashreportcategory.func_71507_a("Layer", (Object)this.genLayerBiomes.toString());
            crashreportcategory.func_71507_a("x", (Object)x);
            crashreportcategory.func_71507_a("z", (Object)z);
            crashreportcategory.func_71507_a("radius", (Object)range);
            crashreportcategory.func_71507_a("allowed", (Object)biomes);
            throw new ReportedException(crashreport);
        }
    }

    public BlockPos func_180630_a(int x, int z, int range, List biomes, Random random) {
        IntCache.func_76446_a();
        int l = x - range >> 2;
        int i1 = z - range >> 2;
        int j1 = x + range >> 2;
        int k1 = z + range >> 2;
        int l1 = j1 - l + 1;
        int i2 = k1 - i1 + 1;
        int[] aint = this.genLayerBiomes.func_75904_a(l, i1, l1, i2);
        BlockPos blockpos = null;
        int j2 = 0;
        for (int k2 = 0; k2 < l1 * i2; ++k2) {
            int l2 = l + k2 % l1 << 2;
            int i3 = i1 + k2 / l1 << 2;
            BiomeGenBase biomegenbase = BiomeGenBase.func_150568_d((int)aint[k2]);
            if (!biomes.contains(biomegenbase) || blockpos != null && random.nextInt(j2 + 1) != 0) continue;
            blockpos = new BlockPos(l2, 0, i3);
            ++j2;
        }
        return blockpos;
    }

    public final void func_76938_b() {
        this.biomeCache.func_76838_a();
        this.subBiomeCache.cleanupCache();
    }

    public TragicSubBiome getSubBiomeGenAt(BlockPos pos) {
        return this.subBiomeCache.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), null);
    }
}

