/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.compatibility;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.util.Tuple;

public class CompatibilityThaumcraft {
    public static void init() {
        try {
            CompatibilityThaumcraft.registerThaumcraftAspects();
        }
        catch (NoSuchMethodError e) {
            TragicMC.logError("Error while attempting to do Thaumcraft registrations, if Thaumcraft is not installed then this can safely be ignored.");
            return;
        }
    }

    @Optional.Method(modid="Thaumcraft")
    public static void registerThaumcraftAspects() {
        if (TragicConfig.getBoolean("allowMobs")) {
            if (TragicConfig.getBoolean("allowTox")) {
                CompatibilityThaumcraft.registerEntityAspects("TragicMC.Tox", CompatibilityThaumcraft.getList(new Tuple<Aspect, Integer>(Aspect.PLANT, 3)));
            }
            if (TragicConfig.getBoolean("allowInkling")) {
                CompatibilityThaumcraft.registerEntityAspects("TragicMC.Inkling", CompatibilityThaumcraft.getList(new Tuple<Aspect, Integer>(Aspect.DARKNESS, 2), new Tuple<Aspect, Integer>(Aspect.AVERSION, 1), new Tuple<Aspect, Integer>(Aspect.MAN, 1)));
            }
            if (TragicConfig.getBoolean("allowAbomination")) {
                CompatibilityThaumcraft.registerEntityAspects("TragicMC.Abomination", CompatibilityThaumcraft.getList(new Tuple<Aspect, Integer>(Aspect.BEAST, 2), new Tuple<Aspect, Integer>(Aspect.COLD, 1)));
            }
            if (TragicConfig.getBoolean("allowCryse")) {
                CompatibilityThaumcraft.registerEntityAspects("TragicMC.Cryse", CompatibilityThaumcraft.getList(new Tuple<Aspect, Integer>(Aspect.COLD, 3)));
            }
            if (TragicConfig.getBoolean("allowJabba")) {
                CompatibilityThaumcraft.registerEntityAspects("TragicMC.Jabba", CompatibilityThaumcraft.getList(new Tuple<Aspect, Integer>(Aspect.FIRE, 3)));
            }
            if (TragicConfig.getBoolean("allowRagr")) {
                CompatibilityThaumcraft.registerEntityAspects("TragicMC.Ragr", CompatibilityThaumcraft.getList(new Tuple<Aspect, Integer>(Aspect.COLD, 1), new Tuple<Aspect, Integer>(Aspect.MAN, 1), new Tuple<Aspect, Integer>(Aspect.FIRE, 1)));
            }
            if (TragicConfig.getBoolean("allowTragicNeko")) {
                CompatibilityThaumcraft.registerEntityAspects("TragicMC.TragicNeko", CompatibilityThaumcraft.getList(new Tuple<Aspect, Integer>(Aspect.MAN, 3), new Tuple<Aspect, Integer>(Aspect.FIRE, 1)));
            }
        }
        if (TragicConfig.getBoolean("allowNonMobItems") && TragicConfig.getBoolean("allowNonMobBlocks")) {
            CompatibilityThaumcraft.registerObjectAspects(new ItemStack(TragicItems.Ash), CompatibilityThaumcraft.getList(new Tuple<Aspect, Integer>(Aspect.DEATH, 1), new Tuple<Aspect, Integer>(Aspect.FIRE, 1)));
            CompatibilityThaumcraft.registerObjectAspects(new ItemStack(TragicItems.EnchantedTears), CompatibilityThaumcraft.getList(new Tuple<Aspect, Integer>(Aspect.LIFE, 2), new Tuple<Aspect, Integer>(Aspect.WATER, 1), new Tuple<Aspect, Integer>(Aspect.CRAFT, 1)));
        }
    }

    @Optional.Method(modid="Thaumcraft")
    public static void registerEntityAspects(String entityListName, AspectList list) {
        ThaumcraftApi.registerEntityTag((String)entityListName, (AspectList)list, (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
    }

    @Optional.Method(modid="Thaumcraft")
    public static void registerObjectAspects(ItemStack stack, AspectList list) {
        ThaumcraftApi.registerObjectTag((ItemStack)stack, (AspectList)list);
    }

    @Optional.Method(modid="Thaumcraft")
    public static AspectList getList(Tuple<Aspect, Integer> ... aspects) {
        AspectList list = new AspectList();
        for (Tuple<Aspect, Integer> t : aspects) {
            list = list.add(t.getLeft(), t.getRight().intValue());
        }
        return list;
    }
}

