/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.teleporter;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import gnu.trove.map.TObjectByteMap;
import gnu.trove.map.hash.TObjectByteHashMap;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.WorldEvent;
import thebetweenlands.utils.confighandler.ConfigHandler;
import thebetweenlands.world.teleporter.TeleporterBetweenlands;

public final class TeleporterHandler {
    private static TeleporterHandler INSTANCE = new TeleporterHandler();
    private final TObjectByteMap<UUID> waitingPlayers = new TObjectByteHashMap();
    private boolean checkWaitingPlayers = false;
    private TeleporterBetweenlands teleportToOverworld;
    private TeleporterBetweenlands teleportToBetweenlands;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)INSTANCE);
    }

    public static void transferToOverworld(Entity entity) {
        INSTANCE.transferEntity(entity, 0);
    }

    public static void transferToBL(Entity entity) {
        INSTANCE.transferEntity(entity, ConfigHandler.DIMENSION_ID);
    }

    private TeleporterHandler() {
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        if (!(e.world instanceof WorldServer)) {
            return;
        }
        WorldServer world = (WorldServer)e.world;
        if (world.field_73011_w.field_76574_g == 0) {
            this.teleportToOverworld = new TeleporterBetweenlands(world);
            world.customTeleporters.add(this.teleportToOverworld);
        } else if (world.field_73011_w.field_76574_g == ConfigHandler.DIMENSION_ID) {
            this.teleportToBetweenlands = new TeleporterBetweenlands(world);
            world.customTeleporters.add(this.teleportToBetweenlands);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        UUID[] ids;
        if (e.phase != TickEvent.Phase.END || !this.checkWaitingPlayers) {
            return;
        }
        for (UUID uuid : ids = (UUID[])this.waitingPlayers.keys((Object[])new UUID[this.waitingPlayers.size()])) {
            if (this.waitingPlayers.adjustOrPutValue((Object)uuid, (byte)-1, (byte)0) > 0) continue;
            this.waitingPlayers.remove((Object)uuid);
            if (!this.waitingPlayers.isEmpty()) continue;
            this.checkWaitingPlayers = false;
        }
    }

    private void transferEntity(Entity entity, int dimensionId) {
        if (dimensionId != 0) {
            if (dimensionId != ConfigHandler.DIMENSION_ID) {
                throw new IllegalArgumentException("Supplied invalid dimension ID into BL teleporter: " + dimensionId);
            }
        }
        World world = entity.field_70170_p;
        if (!world.field_72995_K && !entity.field_70128_L) {
            if (entity instanceof EntityPlayerMP) {
                if (entity instanceof FakePlayer) {
                    return;
                }
                EntityPlayerMP player = (EntityPlayerMP)entity;
                if (this.waitingPlayers.containsKey((Object)player.func_146103_bH().getId())) {
                    this.waitingPlayers.put((Object)player.func_146103_bH().getId(), (byte)20);
                    return;
                }
                this.waitingPlayers.put((Object)player.func_146103_bH().getId(), (byte)40);
                this.checkWaitingPlayers = true;
                player.field_71133_b.func_71203_ab().transferPlayerToDimension(player, dimensionId, (Teleporter)(dimensionId == 0 ? this.teleportToOverworld : this.teleportToBetweenlands));
                player.field_71088_bW = 0;
            } else if (!(entity instanceof EntityMinecartContainer)) {
                world.field_72984_F.func_76320_a("changeDimension");
                MinecraftServer mcServer = MinecraftServer.func_71276_C();
                WorldServer worldCurrent = mcServer.func_71218_a(entity.field_71093_bK);
                WorldServer worldTarget = mcServer.func_71218_a(dimensionId);
                entity.field_71093_bK = dimensionId;
                world.func_72900_e(entity);
                entity.field_70128_L = false;
                world.field_72984_F.func_76320_a("reposition");
                mcServer.func_71203_ab().transferEntityToWorld(entity, dimensionId, worldCurrent, worldTarget, (Teleporter)(dimensionId == 0 ? this.teleportToOverworld : this.teleportToBetweenlands));
                world.field_72984_F.func_76318_c("reloading");
                Entity newEntity = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)entity), (World)worldTarget);
                if (newEntity != null) {
                    newEntity.func_82141_a(entity, true);
                    worldTarget.func_72838_d(newEntity);
                }
                entity.field_70128_L = true;
                world.field_72984_F.func_76319_b();
                worldCurrent.func_82742_i();
                worldTarget.func_82742_i();
                world.field_72984_F.func_76319_b();
                newEntity.field_71088_bW = entity.func_82147_ab();
            }
        }
    }
}

