/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.teleporter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.LongHashMap;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.utils.confighandler.ConfigHandler;
import thebetweenlands.world.feature.trees.WorldGenWeedWoodPortalTree;

public final class TeleporterBetweenlands
extends Teleporter {
    private final WorldServer worldServerInstance;
    private final LongHashMap destinationCoordinateCache = new LongHashMap();
    private final List<Long> destinationCoordinateKeys = new ArrayList<Long>();

    public TeleporterBetweenlands(WorldServer worldServer) {
        super(worldServer);
        this.worldServerInstance = worldServer;
    }

    public void func_77185_a(Entity entity, double x, double y, double z, float rotationYaw) {
        if (!this.func_77184_b(entity, x, y, z, rotationYaw)) {
            this.func_85188_a(entity);
            this.func_77184_b(entity, x, y, z, rotationYaw);
        }
    }

    public boolean func_77184_b(Entity entity, double x, double y, double z, float rotationYaw) {
        int checkRadius = 128;
        double distToPortal = -1.0;
        int posX = 0;
        int posY = 0;
        int posZ = 0;
        int roundX = MathHelper.func_76128_c((double)x);
        int roundZ = MathHelper.func_76128_c((double)z);
        long coordPair = ChunkCoordIntPair.func_77272_a((int)roundX, (int)roundZ);
        boolean portalNotSaved = true;
        if (this.destinationCoordinateCache.func_76161_b(coordPair)) {
            Teleporter.PortalPosition pos = (Teleporter.PortalPosition)this.destinationCoordinateCache.func_76164_a(coordPair);
            distToPortal = 0.0;
            posX = pos.field_71574_a;
            posY = pos.field_71572_b;
            posZ = pos.field_71573_c;
            pos.field_85087_d = this.worldServerInstance.func_82737_E();
            portalNotSaved = false;
        } else {
            for (int i = roundX - checkRadius; i <= roundX + checkRadius; ++i) {
                for (int j = roundZ - checkRadius; j <= roundZ + checkRadius; ++j) {
                    for (int h = this.worldServerInstance.func_72976_f(i, j); h >= 0; --h) {
                        Block block = this.worldServerInstance.func_147439_a(i, h, j);
                        if (block != BLBlockRegistry.treePortalBlock) continue;
                        while (this.worldServerInstance.func_147439_a(i, --h, j) == BLBlockRegistry.treePortalBlock) {
                        }
                        double X = (double)i + 0.5 - x;
                        double Z = (double)j + 0.5 - z;
                        double Y = (double)(h + 2) + 0.5 - y;
                        double dist = X * X + Y * Y + Z * Z;
                        if (!(distToPortal < 0.0) && !(dist < distToPortal)) continue;
                        distToPortal = dist;
                        posX = i;
                        posY = h + 2;
                        posZ = j;
                    }
                }
            }
        }
        if (distToPortal >= 0.0) {
            if (portalNotSaved) {
                this.destinationCoordinateCache.func_76163_a(coordPair, (Object)new Teleporter.PortalPosition((Teleporter)this, posX, posY, posZ, this.worldServerInstance.func_82737_E()));
                this.destinationCoordinateKeys.add(coordPair);
            }
            entity.field_70179_y = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70159_w = 0.0;
            entity.func_70012_b((double)posX + 0.5, (double)posY, (double)posZ + 0.5, entity.field_70177_z, entity.field_70125_A);
            if (entity.field_70170_p.field_73011_w.field_76574_g != ConfigHandler.DIMENSION_ID) {
                this.setDefaultPlayerSpawnLocation(entity);
            }
            return true;
        }
        return false;
    }

    public boolean func_85188_a(Entity entity) {
        int minSpawnHeight;
        int maxPortalSpawnHeight;
        int posX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int posZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        if (entity.field_71093_bK == 0) {
            maxPortalSpawnHeight = 100;
            minSpawnHeight = 64;
        } else {
            maxPortalSpawnHeight = 85;
            minSpawnHeight = 80;
        }
        for (int x = posX - 127; x < posX + 127; ++x) {
            for (int z = posZ - 127; z < posZ + 127; ++z) {
                for (int y = maxPortalSpawnHeight; y >= minSpawnHeight; --y) {
                    Block block = this.worldServerInstance.func_147439_a(x, y, z);
                    if (block == Blocks.field_150350_a) continue;
                    if (this.canGenerate((World)this.worldServerInstance, x, y, z)) {
                        new WorldGenWeedWoodPortalTree().func_76484_a((World)this.worldServerInstance, this.worldServerInstance.field_73012_v, x, y, z);
                        entity.func_70012_b((double)x, (double)(y + 2), (double)z, entity.field_70177_z, entity.field_70125_A);
                        return true;
                    }
                    for (int yy = y; yy <= maxPortalSpawnHeight; ++yy) {
                        if (!this.canGenerate((World)this.worldServerInstance, x, yy, z)) continue;
                        new WorldGenWeedWoodPortalTree().func_76484_a((World)this.worldServerInstance, this.worldServerInstance.field_73012_v, x, yy, z);
                        entity.func_70012_b((double)x, (double)(yy + 2), (double)z, entity.field_70177_z, entity.field_70125_A);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean canGenerate(World world, int posX, int posY, int posZ) {
        int height = 16;
        int maxRadius = 9;
        for (int xx = posX - maxRadius; xx <= posX + maxRadius; ++xx) {
            for (int zz = posZ - maxRadius; zz <= posZ + maxRadius; ++zz) {
                for (int yy = posY + 2; yy < posY + height; ++yy) {
                    Block block = world.func_147439_a(xx, yy, zz);
                    if ((world.func_147437_c(xx, yy, zz) || !block.func_149721_r()) && !(block instanceof BlockLeaves)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void func_85189_a(long timer) {
        if (timer % 100L == 0L) {
            Iterator<Long> iterator = this.destinationCoordinateKeys.iterator();
            while (iterator.hasNext()) {
                Long hashedPortalPos = iterator.next();
                Teleporter.PortalPosition position = (Teleporter.PortalPosition)this.destinationCoordinateCache.func_76164_a(hashedPortalPos.longValue());
                if (position != null && position.field_85087_d >= timer - 600L) continue;
                iterator.remove();
                this.destinationCoordinateCache.func_76159_d(hashedPortalPos.longValue());
            }
        }
    }

    public void setDefaultPlayerSpawnLocation(Entity entity) {
        if (!(entity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entity;
        ChunkCoordinates coords = player.getBedLocation(ConfigHandler.DIMENSION_ID);
        if (coords == null) {
            coords = player.func_82114_b();
            int spawnFuzz = 64;
            int spawnFuzzHalf = spawnFuzz / 2;
            coords.field_71574_a += this.worldServerInstance.field_73012_v.nextInt(spawnFuzz) - spawnFuzzHalf;
            coords.field_71573_c += this.worldServerInstance.field_73012_v.nextInt(spawnFuzz) - spawnFuzzHalf;
            coords.field_71572_b = this.worldServerInstance.func_72825_h(coords.field_71574_a, coords.field_71573_c) + 1;
            player.setSpawnChunk(coords, true, ConfigHandler.DIMENSION_ID);
        }
    }
}

