/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.storage.world;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.event.world.WorldEvent;

public abstract class WorldDataBase
extends WorldSavedData {
    private World world;
    private NBTTagCompound data = new NBTTagCompound();
    private static final Map<WorldDataTypePair, WorldDataBase> CACHE = new HashMap<WorldDataTypePair, WorldDataBase>();
    public static final WorldUnloadHandler WORLD_UNLOAD_HANDLER = new WorldUnloadHandler();

    public WorldDataBase(String name) {
        super(name);
    }

    public World getWorld() {
        return this.world;
    }

    public final void func_76184_a(NBTTagCompound compound) {
        this.data = compound.func_74775_l("worldData");
    }

    public final void func_76187_b(NBTTagCompound compound) {
        this.save();
        compound.func_74782_a("worldData", (NBTBase)this.data);
    }

    protected abstract void load();

    protected abstract void save();

    protected abstract void init();

    protected abstract void setDefaults();

    public NBTTagCompound getData() {
        return this.data;
    }

    private static WorldDataBase getMatchingData(World world, Class<? extends WorldDataBase> clazz) {
        for (Map.Entry<WorldDataTypePair, WorldDataBase> cacheEntry : CACHE.entrySet()) {
            WorldDataTypePair pair = cacheEntry.getKey();
            if (pair.world != world || !pair.data.equals(clazz)) continue;
            return cacheEntry.getValue();
        }
        return null;
    }

    public static <T extends WorldDataBase> T forWorld(World world, Class<T> clazz) {
        WorldDataBase cached = WorldDataBase.getMatchingData(world, clazz);
        if (cached != null) {
            cached.world = world;
            return (T)((Object)cached);
        }
        MapStorage storage = world.perWorldStorage;
        WorldDataBase newInstance = null;
        try {
            newInstance = (WorldDataBase)((Object)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        WorldDataBase result = (WorldDataBase)storage.func_75742_a(clazz, newInstance.field_76190_i);
        if (result == null) {
            result = newInstance;
            result.world = world;
            result.init();
            result.setDefaults();
            result.save();
            storage.func_75745_a(result.field_76190_i, (WorldSavedData)result);
        } else {
            result.world = world;
            result.init();
            result.load();
        }
        CACHE.put(new WorldDataTypePair(world, clazz), result);
        return (T)((Object)result);
    }

    public static class WorldUnloadHandler {
        private WorldUnloadHandler() {
        }

        @SubscribeEvent
        public void onWorldUnload(WorldEvent.Unload event) {
            Iterator cacheIT = CACHE.entrySet().iterator();
            while (cacheIT.hasNext()) {
                World world = ((WorldDataTypePair)cacheIT.next().getKey()).world;
                if (!world.equals(event.world)) continue;
                cacheIT.remove();
            }
        }
    }

    private static class WorldDataTypePair {
        private World world;
        private Class<? extends WorldDataBase> data;

        private WorldDataTypePair(World world, Class<? extends WorldDataBase> data) {
            this.world = world;
            this.data = data;
        }
    }
}

