/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.storage.world;

import net.minecraft.world.World;
import thebetweenlands.herblore.aspects.AspectManager;
import thebetweenlands.world.events.EnvironmentEvent;
import thebetweenlands.world.events.EnvironmentEventRegistry;
import thebetweenlands.world.storage.world.WorldDataBase;

public class BetweenlandsWorldData
extends WorldDataBase {
    private EnvironmentEventRegistry environmentEventRegistry = new EnvironmentEventRegistry();
    private AspectManager aspectManager = new AspectManager();

    public BetweenlandsWorldData() {
        super("thebetweenlands:worldData");
    }

    public BetweenlandsWorldData(String name) {
        super(name);
    }

    public EnvironmentEventRegistry getEnvironmentEventRegistry() {
        return this.environmentEventRegistry;
    }

    public AspectManager getAspectManager() {
        return this.aspectManager;
    }

    @Override
    protected void init() {
        this.environmentEventRegistry.init();
    }

    @Override
    protected void setDefaults() {
        if (!this.getWorld().field_72995_K) {
            for (EnvironmentEvent event : this.environmentEventRegistry.getEvents().values()) {
                event.setDefaults();
                event.setLoaded();
            }
            this.aspectManager.loadAndPopulateStaticAspects(null, AspectManager.getAspectsSeed(this.getWorld().func_72912_H().func_76063_b()));
        }
    }

    @Override
    protected void load() {
        if (!this.getWorld().field_72995_K) {
            for (EnvironmentEvent event : this.environmentEventRegistry.getEvents().values()) {
                event.readFromNBT(this.getData());
            }
            this.environmentEventRegistry.setDisabled(this.getData().func_74767_n("eventsDisabled"));
            this.aspectManager.loadAndPopulateStaticAspects(this.getData(), AspectManager.getAspectsSeed(this.getWorld().func_72912_H().func_76063_b()));
        }
    }

    @Override
    protected void save() {
        if (!this.getWorld().field_72995_K) {
            for (EnvironmentEvent event : this.environmentEventRegistry.getEvents().values()) {
                event.writeToNBT(this.getData());
            }
            this.getData().func_74757_a("eventsDisabled", this.environmentEventRegistry.isDisabled());
            this.aspectManager.saveStaticAspects(this.getData());
        }
    }

    public static BetweenlandsWorldData forWorld(World world) {
        return WorldDataBase.forWorld(world, BetweenlandsWorldData.class);
    }
}

