/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.storage.chunk.storage.location;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.chunk.Chunk;
import thebetweenlands.world.storage.chunk.BetweenlandsChunkData;
import thebetweenlands.world.storage.chunk.storage.ChunkStorage;
import thebetweenlands.world.storage.chunk.storage.location.EnumLocationType;
import thebetweenlands.world.storage.chunk.storage.location.GuardedLocationStorage;
import thebetweenlands.world.storage.chunk.storage.location.LocationAmbience;

public class LocationStorage
extends ChunkStorage {
    private String name;
    private AxisAlignedBB area;
    private EnumLocationType type;
    private int layer;
    private LocationAmbience ambience = null;
    private boolean visible = true;
    private boolean inheritAmbience = true;
    private long locationSeed = 0L;
    private static final Comparator<LocationStorage> LAYER_SORTER = new Comparator<LocationStorage>(){

        @Override
        public int compare(LocationStorage s1, LocationStorage s2) {
            return Integer.compare(s1.getLayer(), s2.getLayer());
        }
    };

    public LocationStorage(Chunk chunk, BetweenlandsChunkData data) {
        super(chunk, data);
    }

    public LocationStorage(Chunk chunk, BetweenlandsChunkData data, String name, AxisAlignedBB area, EnumLocationType type) {
        super(chunk, data);
        this.name = name;
        this.area = area;
        if (type == null) {
            type = EnumLocationType.NONE;
        }
        this.type = type;
    }

    public LocationStorage setSeed(long seed) {
        this.locationSeed = seed;
        return this;
    }

    public long getSeed() {
        return this.locationSeed;
    }

    public LocationStorage setInheritAmbience(boolean inherit) {
        this.inheritAmbience = inherit;
        this.ambience = null;
        return this;
    }

    public LocationStorage setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public LocationStorage setLayer(int layer) {
        this.layer = layer;
        return this;
    }

    public int getLayer() {
        return this.layer;
    }

    public LocationStorage setAmbience(LocationAmbience ambience) {
        this.inheritAmbience = false;
        this.ambience = ambience;
        ambience.setLocation(this);
        return this;
    }

    public boolean hasAmbience() {
        return this.ambience != null;
    }

    public String getLocalizedName() {
        String locationName = this.name;
        boolean translate = locationName.startsWith("translate:");
        if (translate) {
            locationName = StatCollector.func_74838_a((String)("location." + locationName.replaceFirst("translate:", "") + ".name"));
        }
        return locationName;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.name = nbt.func_74779_i("name");
        double minX = nbt.func_74769_h("minX");
        double minY = nbt.func_74769_h("minY");
        double minZ = nbt.func_74769_h("minZ");
        double maxX = nbt.func_74769_h("maxX");
        double maxY = nbt.func_74769_h("maxY");
        double maxZ = nbt.func_74769_h("maxZ");
        this.area = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        this.type = EnumLocationType.fromName(nbt.func_74779_i("type"));
        this.layer = nbt.func_74762_e("layer");
        if (nbt.func_74764_b("ambience")) {
            NBTTagCompound ambienceTag = nbt.func_74775_l("ambience");
            this.ambience = LocationAmbience.readFromNBT(this, ambienceTag);
        }
        this.visible = nbt.func_74767_n("visible");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("name", this.name);
        nbt.func_74780_a("minX", this.area.field_72340_a);
        nbt.func_74780_a("minY", this.area.field_72338_b);
        nbt.func_74780_a("minZ", this.area.field_72339_c);
        nbt.func_74780_a("maxX", this.area.field_72336_d);
        nbt.func_74780_a("maxY", this.area.field_72337_e);
        nbt.func_74780_a("maxZ", this.area.field_72334_f);
        nbt.func_74778_a("type", this.type.name);
        nbt.func_74768_a("layer", this.layer);
        if (this.hasAmbience()) {
            NBTTagCompound ambienceTag = new NBTTagCompound();
            this.ambience.writeToNBT(ambienceTag);
            nbt.func_74782_a("ambience", (NBTBase)ambienceTag);
        }
        nbt.func_74757_a("visible", this.visible);
    }

    public boolean isAreaEqual(AxisAlignedBB other) {
        return this.area.field_72340_a == other.field_72340_a && this.area.field_72338_b == other.field_72338_b && this.area.field_72339_c == other.field_72339_c && this.area.field_72336_d == other.field_72336_d && this.area.field_72337_e == other.field_72337_e && this.area.field_72334_f == other.field_72334_f;
    }

    public boolean isInside(Entity entity) {
        return this.area.func_72318_a(Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v));
    }

    public boolean isInside(double x, double y, double z) {
        return this.area.func_72318_a(Vec3.func_72443_a((double)x, (double)y, (double)z));
    }

    public AxisAlignedBB getArea() {
        return this.area;
    }

    public String getName() {
        return this.name;
    }

    public EnumLocationType getType() {
        return this.type;
    }

    public boolean isVisible(Entity entity) {
        return this.visible;
    }

    public static List<LocationStorage> getLocations(Entity entity) {
        ArrayList<LocationStorage> locations = new ArrayList<LocationStorage>();
        Chunk chunk = entity.field_70170_p.func_72938_d(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70161_v));
        if (chunk != null) {
            BetweenlandsChunkData chunkData = BetweenlandsChunkData.forChunk(entity.field_70170_p, chunk);
            for (ChunkStorage storage : chunkData.getStorage()) {
                if (!(storage instanceof LocationStorage) || !((LocationStorage)storage).isInside(entity)) continue;
                locations.add((LocationStorage)storage);
            }
        }
        return locations;
    }

    public static LocationAmbience getAmbience(Entity entity) {
        LocationStorage storage;
        int i;
        List<LocationStorage> locations = LocationStorage.getLocations(entity);
        Collections.sort(locations, LAYER_SORTER);
        LocationStorage highestLocation = null;
        for (i = 0; i < locations.size(); ++i) {
            storage = locations.get(i);
            if (!storage.hasAmbience() && !storage.inheritAmbience) continue;
            highestLocation = storage;
        }
        if (highestLocation != null) {
            if (highestLocation.ambience == null && highestLocation.inheritAmbience) {
                for (i = 0; i < locations.size(); ++i) {
                    storage = locations.get(i);
                    if (!storage.hasAmbience()) continue;
                    return storage.ambience;
                }
            }
            return highestLocation.ambience;
        }
        return null;
    }

    public static boolean isInLocationType(Entity entity, EnumLocationType type) {
        List<LocationStorage> locations = LocationStorage.getLocations(entity);
        for (LocationStorage location : locations) {
            if (location.getType() != type) continue;
            return true;
        }
        return false;
    }

    public static boolean isLocationGuarded(Entity entity) {
        List<LocationStorage> locations = LocationStorage.getLocations(entity);
        for (LocationStorage location : locations) {
            if (!(location instanceof GuardedLocationStorage) || !((GuardedLocationStorage)location).isGuarded()) continue;
            return true;
        }
        return false;
    }
}

