/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.storage.chunk.storage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import thebetweenlands.world.storage.chunk.BetweenlandsChunkData;
import thebetweenlands.world.storage.chunk.storage.ChunkStorage;
import thebetweenlands.world.storage.chunk.storage.location.EnumLocationType;
import thebetweenlands.world.storage.chunk.storage.location.GuardedLocationStorage;
import thebetweenlands.world.storage.chunk.storage.location.LocationStorage;

public class StorageHelper {
    public static List<LocationStorage> addArea(World world, String name, AxisAlignedBB area, EnumLocationType type, int layer) {
        return StorageHelper.addArea(world, name, area, type, layer, false);
    }

    public static List<LocationStorage> addArea(World world, String name, AxisAlignedBB area, EnumLocationType type, int layer, boolean guarded) {
        ArrayList<LocationStorage> addedLocations = new ArrayList<LocationStorage>();
        int sx = MathHelper.func_76128_c((double)(area.field_72340_a / 16.0));
        int sz = MathHelper.func_76128_c((double)(area.field_72339_c / 16.0));
        int ex = MathHelper.func_76128_c((double)(area.field_72336_d / 16.0));
        int ez = MathHelper.func_76128_c((double)(area.field_72334_f / 16.0));
        for (int cx = sx; cx <= ex; ++cx) {
            for (int cz = sz; cz <= ez; ++cz) {
                Chunk chunk = world.func_72964_e(cx, cz);
                double csx = Math.max(area.field_72340_a, (double)(cx * 16));
                double csz = Math.max(area.field_72339_c, (double)(cz * 16));
                double cex = Math.min(area.field_72336_d, (double)((cx + 1) * 16));
                double cez = Math.min(area.field_72334_f, (double)((cz + 1) * 16));
                AxisAlignedBB clampedArea = AxisAlignedBB.func_72330_a((double)csx, (double)area.field_72338_b, (double)csz, (double)cex, (double)area.field_72337_e, (double)cez);
                BetweenlandsChunkData chunkData = BetweenlandsChunkData.forChunk(world, chunk);
                LocationStorage location = guarded ? new GuardedLocationStorage(chunk, chunkData, name, clampedArea, type).setLayer(layer) : new LocationStorage(chunk, chunkData, name, clampedArea, type).setLayer(layer);
                addedLocations.add(location);
                chunkData.getStorage().add(location);
                chunkData.markDirty();
            }
        }
        return addedLocations;
    }

    public static void removeArea(World world, String name, AxisAlignedBB area) {
        int sx = MathHelper.func_76128_c((double)(area.field_72340_a / 16.0));
        int sz = MathHelper.func_76128_c((double)(area.field_72339_c / 16.0));
        int ex = MathHelper.func_76128_c((double)(area.field_72336_d / 16.0));
        int ez = MathHelper.func_76128_c((double)(area.field_72334_f / 16.0));
        for (int cx = sx; cx <= ex; ++cx) {
            for (int cz = sz; cz <= ez; ++cz) {
                Chunk chunk = world.func_72964_e(cx, cz);
                BetweenlandsChunkData chunkData = BetweenlandsChunkData.forChunk(world, chunk);
                boolean changed = false;
                Iterator<ChunkStorage> storageIT = chunkData.getStorage().iterator();
                while (storageIT.hasNext()) {
                    LocationStorage areaStorage;
                    ChunkStorage storage = storageIT.next();
                    if (!(storage instanceof LocationStorage) || !name.equals((areaStorage = (LocationStorage)storage).getName())) continue;
                    storageIT.remove();
                    changed = true;
                }
                if (!changed) continue;
                chunkData.markDirty();
            }
        }
    }

    public static List<LocationStorage> getAreas(World world, AxisAlignedBB area) {
        ArrayList<LocationStorage> foundLocations = new ArrayList<LocationStorage>();
        int sx = MathHelper.func_76128_c((double)(area.field_72340_a / 16.0));
        int sz = MathHelper.func_76128_c((double)(area.field_72339_c / 16.0));
        int ex = MathHelper.func_76128_c((double)(area.field_72336_d / 16.0));
        int ez = MathHelper.func_76128_c((double)(area.field_72334_f / 16.0));
        for (int cx = sx; cx <= ex; ++cx) {
            for (int cz = sz; cz <= ez; ++cz) {
                Chunk chunk = world.func_72964_e(cx, cz);
                BetweenlandsChunkData chunkData = BetweenlandsChunkData.forChunk(world, chunk);
                for (ChunkStorage storage : chunkData.getStorage()) {
                    LocationStorage location;
                    if (!(storage instanceof LocationStorage) || !(location = (LocationStorage)storage).getArea().func_72326_a(area)) continue;
                    foundLocations.add(location);
                }
            }
        }
        return foundLocations;
    }
}

