/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.storage.chunk;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;

public abstract class ChunkDataBase {
    public final String name;
    private NBTTagCompound data = new NBTTagCompound();
    private Chunk chunk;
    private World world;
    private static final Map<ChunkDataTypePair, ChunkDataBase> CACHE = new HashMap<ChunkDataTypePair, ChunkDataBase>();
    private static final Map<ChunkPosWorldPair, NBTTagCompound> CHUNK_NBT_CACHE = new HashMap<ChunkPosWorldPair, NBTTagCompound>();
    private static final List<Chunk> CHUNK_UNLOAD_QUEUE = new ArrayList<Chunk>();
    public static final ChunkDataHandler CHUNK_DATA_HANDLER = new ChunkDataHandler();

    public ChunkDataBase(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final NBTTagCompound readData() {
        ChunkDataBase chunkDataBase = this;
        synchronized (chunkDataBase) {
            return (NBTTagCompound)this.data.func_74737_b();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeData(NBTTagCompound compound) {
        ChunkDataBase chunkDataBase = this;
        synchronized (chunkDataBase) {
            this.data = (NBTTagCompound)compound.func_74737_b();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeToNBTInternal(NBTTagCompound compound) {
        ChunkDataBase chunkDataBase = this;
        synchronized (chunkDataBase) {
            compound.func_74782_a(this.name, (NBTBase)this.data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readFromNBTInternal(NBTTagCompound compound) {
        ChunkDataBase chunkDataBase = this;
        synchronized (chunkDataBase) {
            this.data = compound.func_74775_l(this.name);
        }
    }

    public Chunk getChunk() {
        return this.chunk;
    }

    public World getWorld() {
        return this.world;
    }

    protected abstract void load();

    protected abstract void save();

    protected abstract void init();

    public void markDirty() {
        this.save();
        this.chunk.func_76630_e();
    }

    protected void postInit() {
    }

    protected abstract void setDefaults();

    protected void onUnload() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addDataCache(ChunkCoordIntPair pos, World world, Class<? extends ChunkDataBase> clazz, ChunkDataBase data) {
        ChunkDataHandler chunkDataHandler = CHUNK_DATA_HANDLER;
        synchronized (chunkDataHandler) {
            CACHE.put(new ChunkDataTypePair(pos, world, clazz), data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ChunkDataBase getDataCache(ChunkCoordIntPair pos, World world, Class<? extends ChunkDataBase> clazz) {
        ChunkDataHandler chunkDataHandler = CHUNK_DATA_HANDLER;
        synchronized (chunkDataHandler) {
            for (Map.Entry<ChunkDataTypePair, ChunkDataBase> cacheEntry : CACHE.entrySet()) {
                ChunkDataTypePair pair = cacheEntry.getKey();
                if (!pair.pos.equals((Object)pos) || !pair.type.equals(clazz) || !pair.world.equals(world)) continue;
                return cacheEntry.getValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeDataCache(ChunkCoordIntPair pos, World world, Class<? extends ChunkDataBase> clazz) {
        ChunkDataHandler chunkDataHandler = CHUNK_DATA_HANDLER;
        synchronized (chunkDataHandler) {
            Iterator<Map.Entry<ChunkDataTypePair, ChunkDataBase>> dataCacheIT = CACHE.entrySet().iterator();
            while (dataCacheIT.hasNext()) {
                ChunkDataTypePair pair = dataCacheIT.next().getKey();
                if (!pair.pos.equals((Object)pos) || !pair.world.equals(world) || !pair.type.equals(clazz)) continue;
                dataCacheIT.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addNBTCache(ChunkCoordIntPair pos, World world, NBTTagCompound nbt) {
        ChunkDataHandler chunkDataHandler = CHUNK_DATA_HANDLER;
        synchronized (chunkDataHandler) {
            CHUNK_NBT_CACHE.put(new ChunkPosWorldPair(pos, world), nbt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static NBTTagCompound getNBTCache(ChunkCoordIntPair pos, World world) {
        ChunkDataHandler chunkDataHandler = CHUNK_DATA_HANDLER;
        synchronized (chunkDataHandler) {
            for (Map.Entry<ChunkPosWorldPair, NBTTagCompound> cacheEntry : CHUNK_NBT_CACHE.entrySet()) {
                ChunkPosWorldPair pair = cacheEntry.getKey();
                if (!pair.pos.equals((Object)pos) || !pair.world.equals(world)) continue;
                return cacheEntry.getValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeNBTCache(ChunkCoordIntPair pos, World world) {
        ChunkDataHandler chunkDataHandler = CHUNK_DATA_HANDLER;
        synchronized (chunkDataHandler) {
            Iterator<Map.Entry<ChunkPosWorldPair, NBTTagCompound>> nbtCacheIT = CHUNK_NBT_CACHE.entrySet().iterator();
            while (nbtCacheIT.hasNext()) {
                ChunkPosWorldPair chunkPosWorldPair = nbtCacheIT.next().getKey();
                if (!chunkPosWorldPair.pos.equals((Object)pos) || !chunkPosWorldPair.world.equals(world)) continue;
                nbtCacheIT.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ChunkDataBase> T forChunk(World world, Chunk chunk, Class<T> clazz) {
        ChunkDataHandler chunkDataHandler = CHUNK_DATA_HANDLER;
        synchronized (chunkDataHandler) {
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(chunk.field_76635_g, chunk.field_76647_h);
            ChunkDataBase cached = ChunkDataBase.getDataCache(chunkPos, world, clazz);
            if (cached != null) {
                cached.chunk = chunk;
                cached.world = world;
                return (T)cached;
            }
            ChunkDataBase newInstance = null;
            try {
                newInstance = (ChunkDataBase)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            NBTTagCompound nbt = ChunkDataBase.getNBTCache(chunkPos, world);
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            newInstance.chunk = chunk;
            newInstance.world = world;
            if (!nbt.func_74764_b(newInstance.name)) {
                newInstance.init();
                newInstance.setDefaults();
                chunk.func_76630_e();
                newInstance.postInit();
            } else {
                newInstance.init();
                newInstance.readFromNBTInternal(nbt);
                newInstance.load();
                newInstance.postInit();
            }
            CACHE.put(new ChunkDataTypePair(chunkPos, world, clazz), newInstance);
            return (T)newInstance;
        }
    }

    public static class ChunkDataHandler {
        private ChunkDataHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public void onChunkDataEvent(ChunkDataEvent event) {
            ChunkDataHandler chunkDataHandler = CHUNK_DATA_HANDLER;
            synchronized (chunkDataHandler) {
                ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(event.getChunk().field_76635_g, event.getChunk().field_76647_h);
                NBTTagCompound chunkNBT = event.getData();
                if (event instanceof ChunkDataEvent.Save) {
                    NBTTagCompound prevNBT = ChunkDataBase.getNBTCache(chunkPos, event.world);
                    if (prevNBT != null) {
                        chunkNBT.func_74782_a("extendedChunkData", (NBTBase)prevNBT);
                    }
                    for (ChunkDataTypePair pair : CACHE.keySet()) {
                        if (!pair.pos.equals((Object)chunkPos) || !pair.world.equals(event.world)) continue;
                        NBTTagCompound chunkData = new NBTTagCompound();
                        ChunkDataBase data = (ChunkDataBase)CACHE.get(pair);
                        data.writeToNBTInternal(chunkData);
                        chunkNBT.func_74782_a("extendedChunkData", (NBTBase)chunkData);
                    }
                    boolean removeNBTCache = false;
                    Iterator unloadIT = CHUNK_UNLOAD_QUEUE.iterator();
                    while (unloadIT.hasNext()) {
                        Chunk unloadedChunk = (Chunk)unloadIT.next();
                        if (unloadedChunk != event.getChunk()) continue;
                        for (ChunkDataTypePair cpair : this.getDataCacheKeys(chunkPos, event.world)) {
                            ChunkDataBase data;
                            if (cpair == null || (data = (ChunkDataBase)CACHE.get(cpair)) == null) continue;
                            data.onUnload();
                            CACHE.remove(cpair);
                            removeNBTCache = true;
                        }
                        unloadIT.remove();
                    }
                    if (!event.getChunk().field_76636_d || event.world.field_72995_K) {
                        for (ChunkDataTypePair cpair : this.getDataCacheKeys(chunkPos, event.world)) {
                            ChunkDataBase data = (ChunkDataBase)CACHE.get(cpair);
                            if (data == null) continue;
                            data.onUnload();
                            CACHE.remove(cpair);
                            removeNBTCache = true;
                        }
                    }
                    if (!event.getChunk().field_76636_d || removeNBTCache || event.world.field_72995_K) {
                        ChunkDataBase.removeNBTCache(chunkPos, event.world);
                    }
                } else if (event instanceof ChunkDataEvent.Load && chunkNBT.func_74764_b("extendedChunkData") && chunkNBT.func_74781_a("extendedChunkData") instanceof NBTTagCompound) {
                    CHUNK_NBT_CACHE.put(new ChunkPosWorldPair(chunkPos, event.world), chunkNBT.func_74775_l("extendedChunkData"));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public void onChunkUnload(ChunkEvent.Unload event) {
            ChunkDataHandler chunkDataHandler = CHUNK_DATA_HANDLER;
            synchronized (chunkDataHandler) {
                ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(event.getChunk().field_76635_g, event.getChunk().field_76647_h);
                for (ChunkDataTypePair pair : this.getDataCacheKeys(chunkPos, event.world)) {
                    if (pair == null || !CACHE.containsKey(pair) && ChunkDataBase.getNBTCache(chunkPos, event.world) == null) continue;
                    if (event.world.field_72995_K) {
                        for (ChunkDataTypePair cpair : this.getDataCacheKeys(chunkPos, event.world)) {
                            CACHE.remove(cpair);
                        }
                        continue;
                    }
                    CHUNK_UNLOAD_QUEUE.add(event.getChunk());
                }
                if (event.world.field_72995_K) {
                    ChunkDataBase.removeNBTCache(chunkPos, event.world);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<ChunkDataTypePair> getDataCacheKeys(ChunkCoordIntPair chunkPos, World world) {
            ChunkDataHandler chunkDataHandler = CHUNK_DATA_HANDLER;
            synchronized (chunkDataHandler) {
                ArrayList<ChunkDataTypePair> caches = new ArrayList<ChunkDataTypePair>();
                for (Map.Entry entry : CACHE.entrySet()) {
                    if (!((ChunkDataTypePair)entry.getKey()).pos.equals((Object)chunkPos) || !((ChunkDataTypePair)entry.getKey()).world.equals(world)) continue;
                    caches.add((ChunkDataTypePair)entry.getKey());
                }
                return caches;
            }
        }
    }

    private static class ChunkPosWorldPair {
        protected final ChunkCoordIntPair pos;
        protected final World world;

        private ChunkPosWorldPair(ChunkCoordIntPair pos, World world) {
            this.pos = pos;
            this.world = world;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.pos == null ? 0 : this.pos.hashCode());
            result = 31 * result + (this.world == null ? 0 : this.world.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChunkPosWorldPair other = (ChunkPosWorldPair)obj;
            if (this.pos == null ? other.pos != null : !this.pos.equals((Object)other.pos)) {
                return false;
            }
            return !(this.world == null ? other.world != null : !this.world.equals(other.world));
        }
    }

    private static class ChunkDataTypePair {
        protected final ChunkCoordIntPair pos;
        protected final World world;
        protected final Class<? extends ChunkDataBase> type;

        private ChunkDataTypePair(ChunkCoordIntPair pos, World world, Class<? extends ChunkDataBase> data) {
            this.pos = pos;
            this.world = world;
            this.type = data;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.pos == null ? 0 : this.pos.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.world == null ? 0 : this.world.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChunkDataTypePair other = (ChunkDataTypePair)obj;
            if (this.pos == null ? other.pos != null : !this.pos.equals((Object)other.pos)) {
                return false;
            }
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            return !(this.world == null ? other.world != null : !this.world.equals(other.world));
        }
    }
}

