/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.storage.chunk;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.network.message.base.AbstractMessage;
import thebetweenlands.world.storage.chunk.ChunkDataBase;
import thebetweenlands.world.storage.chunk.storage.ChunkStorage;

public class BetweenlandsChunkData
extends ChunkDataBase {
    public static final ChunkSyncHandler CHUNK_SYNC_HANDLER = new ChunkSyncHandler();
    private List<ChunkStorage> storage = new ArrayList<ChunkStorage>();

    public BetweenlandsChunkData() {
        super("thebetweenlands:chunkData");
    }

    @Override
    protected void init() {
    }

    @Override
    protected void setDefaults() {
    }

    public static BetweenlandsChunkData forChunk(World world, Chunk chunk) {
        return ChunkDataBase.forChunk(world, chunk, BetweenlandsChunkData.class);
    }

    @Override
    public void markDirty() {
        super.markDirty();
    }

    @Override
    protected void postInit() {
        this.save();
        this.syncData();
    }

    public void syncData() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            ChunkCoordIntPair pos = new ChunkCoordIntPair(this.getChunk().field_76635_g, this.getChunk().field_76647_h);
            List watchers = (List)CHUNK_SYNC_HANDLER.chunkWatchers.get(pos);
            if (watchers != null && !watchers.isEmpty()) {
                for (EntityPlayerMP watcher : watchers) {
                    TheBetweenlands.networkWrapper.sendTo((IMessage)new ChunkSyncHandler.MessageSyncChunkData(this), watcher);
                }
            }
        }
    }

    @Override
    protected void load() {
        try {
            NBTTagCompound nbt = this.readData();
            if (nbt.func_74764_b("storage")) {
                this.storage.clear();
                NBTTagList storageList = nbt.func_150295_c("storage", 10);
                for (int i = 0; i < storageList.func_74745_c(); ++i) {
                    NBTTagCompound storageCompound = storageList.func_150305_b(i);
                    String type = storageCompound.func_74779_i("type");
                    Class<? extends ChunkStorage> storageClass = ChunkStorage.getStorageClass(type);
                    if (storageClass == null) {
                        throw new Exception("Chunk storage type not mapped!");
                    }
                    Constructor<? extends ChunkStorage> ctor = storageClass.getConstructor(Chunk.class, BetweenlandsChunkData.class);
                    ChunkStorage storage = ctor.newInstance(this.getChunk(), this);
                    storage.readFromNBT(storageCompound.func_74775_l("storage"));
                    this.storage.add(storage);
                }
            }
        }
        catch (Exception ex) {
            this.markDirty();
            ex.printStackTrace();
        }
    }

    @Override
    protected void save() {
        try {
            NBTTagCompound nbt = new NBTTagCompound();
            if (!this.storage.isEmpty()) {
                NBTTagList storageList = new NBTTagList();
                for (ChunkStorage storage : this.storage) {
                    NBTTagCompound storageCompound = new NBTTagCompound();
                    storage.writeToNBT(storageCompound);
                    String type = ChunkStorage.getStorageType(storage.getClass());
                    if (type == null) {
                        throw new Exception("Chunk storage type not mapped!");
                    }
                    NBTTagCompound fullNBT = new NBTTagCompound();
                    fullNBT.func_74778_a("type", type);
                    fullNBT.func_74782_a("storage", (NBTBase)storageCompound);
                    storageList.func_74742_a((NBTBase)fullNBT);
                }
                nbt.func_74782_a("storage", (NBTBase)storageList);
            }
            this.writeData(nbt);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.syncData();
    }

    public List<ChunkStorage> getStorage() {
        return this.storage;
    }

    public static class ChunkSyncHandler {
        private final Map<ChunkCoordIntPair, List<EntityPlayerMP>> chunkWatchers = new HashMap<ChunkCoordIntPair, List<EntityPlayerMP>>();

        public void registerPacket(SimpleNetworkWrapper networkWrapper, int packetID) {
            networkWrapper.registerMessage(MessageSyncChunkData.class, MessageSyncChunkData.class, packetID, Side.CLIENT);
        }

        private boolean addWatcher(ChunkCoordIntPair chunk, EntityPlayerMP player) {
            List<EntityPlayerMP> watchers = this.chunkWatchers.get(chunk);
            if (watchers == null) {
                watchers = new ArrayList<EntityPlayerMP>();
                this.chunkWatchers.put(chunk, watchers);
            }
            if (!watchers.contains(player)) {
                watchers.add(player);
                return true;
            }
            return false;
        }

        private void removeWatcher(ChunkCoordIntPair chunk, EntityPlayerMP player) {
            List<EntityPlayerMP> watchers = this.chunkWatchers.get(chunk);
            if (watchers != null) {
                watchers.remove(player);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public void onWatch(ChunkWatchEvent event) {
            if (event instanceof ChunkWatchEvent.Watch) {
                if (this.addWatcher(event.chunk, event.player)) {
                    ChunkDataBase.ChunkDataHandler chunkDataHandler = ChunkDataBase.CHUNK_DATA_HANDLER;
                    synchronized (chunkDataHandler) {
                        Chunk chunk = event.player.field_70170_p.func_72964_e(event.chunk.field_77276_a, event.chunk.field_77275_b);
                        BetweenlandsChunkData data = BetweenlandsChunkData.forChunk(event.player.field_70170_p, chunk);
                        TheBetweenlands.networkWrapper.sendTo((IMessage)new MessageSyncChunkData(data), event.player);
                    }
                }
            } else if (event instanceof ChunkWatchEvent.UnWatch) {
                this.removeWatcher(event.chunk, event.player);
            }
        }

        @SubscribeEvent
        public void onChunkUnload(ChunkEvent.Unload event) {
            this.chunkWatchers.remove(event.getChunk());
        }

        public static class MessageSyncChunkData
        extends AbstractMessage<MessageSyncChunkData> {
            private int chunkX;
            private int chunkZ;
            private String name;
            private NBTTagCompound nbt;

            public MessageSyncChunkData() {
            }

            public MessageSyncChunkData(BetweenlandsChunkData data) {
                this.chunkX = data.getChunk().field_76635_g;
                this.chunkZ = data.getChunk().field_76647_h;
                this.name = data.name;
                NBTTagCompound nbtData = data.readData();
                this.nbt = nbtData != null ? nbtData : new NBTTagCompound();
            }

            public void fromBytes(ByteBuf buf) {
                this.chunkX = buf.readInt();
                this.chunkZ = buf.readInt();
                PacketBuffer packetBuffer = new PacketBuffer(buf);
                try {
                    this.name = packetBuffer.func_150789_c(128);
                    this.nbt = packetBuffer.func_150793_b();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void toBytes(ByteBuf buf) {
                buf.writeInt(this.chunkX);
                buf.writeInt(this.chunkZ);
                PacketBuffer packetBuffer = new PacketBuffer(buf);
                try {
                    packetBuffer.func_150785_a(this.name);
                    packetBuffer.func_150786_a(this.nbt);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMessageClientSide(MessageSyncChunkData message, EntityPlayer player) {
                ChunkDataBase.ChunkDataHandler chunkDataHandler = ChunkDataBase.CHUNK_DATA_HANDLER;
                synchronized (chunkDataHandler) {
                    ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(message.chunkX, message.chunkZ);
                    NBTTagCompound currentNBT = ChunkDataBase.getNBTCache(chunkPos, player.field_70170_p);
                    if (currentNBT == null) {
                        currentNBT = new NBTTagCompound();
                    }
                    currentNBT.func_74782_a(message.name, (NBTBase)message.nbt);
                    ChunkDataBase.addNBTCache(chunkPos, player.field_70170_p, currentNBT);
                    ChunkDataBase data = ChunkDataBase.getDataCache(chunkPos, player.field_70170_p, BetweenlandsChunkData.class);
                    if (data != null) {
                        data.writeData(message.nbt);
                        data.load();
                    }
                }
            }

            @Override
            public void onMessageServerSide(MessageSyncChunkData message, EntityPlayer player) {
            }
        }
    }
}

