/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.gen;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.utils.MathUtils;
import thebetweenlands.world.biomes.base.BLBiomeRegistry;
import thebetweenlands.world.biomes.base.BiomeGenBaseBetweenlands;
import thebetweenlands.world.gen.FractalOpenSimplexNoise;
import thebetweenlands.world.gen.OpenSimplexNoise;

public class MapGenCavesBetweenlands
extends MapGenBase {
    private static final int CHUNK_SIZE = 16;
    private static final int Y_STRIDE = 256;
    private static final double XZ_CAVE_SCALE = 0.08;
    private static final double Y_CAVE_SCALE = 0.15;
    private static final double XZ_FORM_SCALE = 0.5;
    private static final double Y_FORM_SCALE = 0.3;
    private static final double FORM_SCALE = 0.4;
    private static final double XZ_BREAK_SCALE = 0.05;
    private static final double BREAK_SCALE = 0.85;
    private static final double BASE_LIMIT = -0.3;
    private static final int LOWER_BOUND = 10;
    private static final int UPPER_BOUND = 20;
    private static final double SHOULDNT_BREAK = 2.5;
    private static final double RIDGE_EXTENTS = 0.5;
    private OpenSimplexNoise cave;
    private OpenSimplexNoise seaLevelBreak;
    private FractalOpenSimplexNoise form;
    private List<BiomeGenBaseBetweenlands> noBreakBiomes;

    public MapGenCavesBetweenlands(long seed) {
        this.cave = new OpenSimplexNoise(seed);
        this.seaLevelBreak = new OpenSimplexNoise(seed + 1L);
        this.form = new FractalOpenSimplexNoise(seed + 2L, 4, 0.1);
        this.noBreakBiomes = Lists.newArrayList((Object[])new BiomeGenBaseBetweenlands[]{BLBiomeRegistry.deepWater, BLBiomeRegistry.coarseIslands, BLBiomeRegistry.marsh1, BLBiomeRegistry.marsh2, BLBiomeRegistry.patchyIslands, BLBiomeRegistry.sludgePlains});
    }

    public void func_151539_a(IChunkProvider chunkProvider, World world, int chunkX, int chunkZ, Block[] blocks) {
        int cx = chunkX * 16;
        int cz = chunkZ * 16;
        for (int bx = 0; bx < 16; ++bx) {
            for (int bz = 0; bz < 16; ++bz) {
                int newlevel;
                int x = cx + bx;
                int z = cz + bz;
                BiomeGenBase biome = world.func_72807_a(x, z);
                boolean shouldntBreak = this.noBreakBiomes.contains(biome);
                int xzIndex = (bx * 16 + bz) * 256;
                int level = 0;
                while (!(blocks[xzIndex + level] != null && blocks[xzIndex + level++].func_149688_o().func_76224_d() || level > 80)) {
                }
                boolean brokeSurface = false;
                for (int y = 0; y <= level; ++y) {
                    int surfaceDist;
                    double noise = this.cave.eval((double)x * 0.08, (double)y * 0.15, (double)z * 0.08) + this.form.eval((double)x * 0.5, (double)y * 0.3, (double)z * 0.5) * 0.4;
                    double limit = -0.3;
                    if (y <= 10) {
                        limit = (limit + 1.0) / 10.0 * (double)y - 1.0;
                    }
                    if ((surfaceDist = level - y) <= 20) {
                        noise += (shouldntBreak ? 2.5 : MathUtils.linearTransformd(this.seaLevelBreak.eval((double)x * 0.05, (double)z * 0.05), -1.0, 1.0, 0.0, 1.0)) * 0.85 * (double)(1.0f - (float)surfaceDist / 20.0f);
                    }
                    if (noise < limit) {
                        int index;
                        if (y == level) {
                            brokeSurface = true;
                        }
                        if (blocks[index = xzIndex + y] == null || blocks[index].func_149688_o().func_76224_d()) continue;
                        blocks[index] = y > 20 ? Blocks.field_150350_a : BLBlockRegistry.swampWater;
                        continue;
                    }
                    if (y != level || !(noise < limit + 0.5)) continue;
                    double h = MathUtils.linearTransformd(noise, limit, limit + 0.5, 0.0, 1.0);
                    if (h < 0.5) {
                        brokeSurface = true;
                    }
                    double f1 = MathUtils.linearTransformd(Math.sin(Math.PI * 2 * (Math.pow(1.0 - h, 2.0) - 0.25)), -1.0, 1.0, 0.0, 1.0);
                    double f2 = Math.sqrt(Math.pow(0.5, 2.0) - Math.pow(h - 0.5, 2.0));
                    int height = (int)((f1 + f2) / 1.4576 * 3.0);
                    for (int dy = -1; dy < height; ++dy) {
                        blocks[xzIndex + y + dy] = dy < height - 1 ? BLBlockRegistry.swampDirt : BLBlockRegistry.swampGrass;
                    }
                }
                if (!brokeSurface) continue;
                for (newlevel = 80; newlevel > 0; --newlevel) {
                    if (blocks[xzIndex + newlevel] == null) continue;
                    Material material = blocks[xzIndex + newlevel].func_149688_o();
                    if (blocks[xzIndex + newlevel] != BLBlockRegistry.algae && material != Material.field_151579_a && !material.func_76224_d()) break;
                }
                if (newlevel <= 0) continue;
                for (int y = newlevel; y < 82; ++y) {
                    blocks[xzIndex + y] = Blocks.field_150350_a;
                }
            }
        }
    }
}

