/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.feature.trees;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.BlockTreePortal;
import thebetweenlands.blocks.plants.BlockPoisonIvy;
import thebetweenlands.blocks.tree.BlockBLLeaves;
import thebetweenlands.blocks.tree.BlockBLLog;

public class WorldGenWeedWoodPortalTree
extends WorldGenerator {
    private BlockBLLog bark;
    private BlockBLLog wood;
    private BlockBLLeaves leaves;
    private BlockPoisonIvy ivy;
    private BlockTreePortal portal;

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int radius = 4;
        int height = 16;
        int maxRadius = 9;
        this.bark = (BlockBLLog)BLBlockRegistry.portalBark;
        this.wood = (BlockBLLog)BLBlockRegistry.weedwood;
        this.leaves = (BlockBLLeaves)BLBlockRegistry.weedwoodLeaves;
        this.ivy = BLBlockRegistry.poisonIvy;
        this.portal = BLBlockRegistry.treePortalBlock;
        for (int xx = x - maxRadius; xx <= x + maxRadius; ++xx) {
            for (int zz = z - maxRadius; zz <= z + maxRadius; ++zz) {
                for (int yy = y + 2; yy < y + height; ++yy) {
                    if (world.func_147437_c(xx, yy, zz) || !world.func_147439_a(xx, yy, zz).func_149721_r()) continue;
                    return false;
                }
            }
        }
        this.createMainCanopy(world, rand, x, y + height / 2 + 4, z, maxRadius);
        for (int yy = y; yy < y + height; ++yy) {
            if ((yy - y) % 5 == 0 && radius > 1 && yy > 7) {
                --radius;
            }
            for (int i = radius * -1; i <= radius; ++i) {
                for (int j = radius * -1; j <= radius; ++j) {
                    double dSq = i * i + j * j;
                    if (Math.round(Math.sqrt(dSq)) < (long)radius && yy <= y + 1) {
                        world.func_147465_d(x + i, yy, z + j, (Block)this.wood, 0, 2);
                    }
                    if ((Math.round(Math.sqrt(dSq)) != (long)radius || yy != y) && (Math.round(Math.sqrt(dSq)) != (long)radius || yy > y + height - 1)) continue;
                    world.func_147465_d(x + i, yy, z + j, (Block)this.bark, 0, 2);
                }
            }
            if (yy == y + 4) {
                BlockTreePortal.makePortalX(world, x + radius, yy - 2, z);
                BlockTreePortal.makePortalX(world, x - radius, yy - 2, z);
                BlockTreePortal.makePortalZ(world, x, yy - 2, z + radius);
                BlockTreePortal.makePortalZ(world, x, yy - 2, z - radius);
            }
            if (yy == y + height / 2 + 2) {
                this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(2), z, 1, false, rand.nextInt(2) + 4);
                this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(2), z, 2, false, rand.nextInt(2) + 4);
                this.createBranch(world, rand, x, yy - rand.nextInt(2), z + radius + 1, 3, false, rand.nextInt(2) + 4);
                this.createBranch(world, rand, x, yy - rand.nextInt(2), z - radius - 1, 4, false, rand.nextInt(2) + 4);
                this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(2), z + radius + 1, 5, false, rand.nextInt(2) + 3);
                this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(2), z - radius - 1, 6, false, rand.nextInt(2) + 3);
                this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(2), z + radius + 1, 7, false, rand.nextInt(2) + 3);
                this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(2), z - radius - 1, 8, false, rand.nextInt(2) + 3);
            }
            if (yy == y + height / 2 + 4) {
                this.createSmallBranch(world, rand, x + radius + 1, yy - rand.nextInt(2), z, 1, 4);
                this.createSmallBranch(world, rand, x - radius - 1, yy - rand.nextInt(2), z, 2, 4);
                this.createSmallBranch(world, rand, x, yy - rand.nextInt(2), z + radius + 1, 3, 4);
                this.createSmallBranch(world, rand, x, yy - rand.nextInt(2), z - radius - 1, 4, 4);
                this.createSmallBranch(world, rand, x + radius + 1, yy - rand.nextInt(2), z + radius + 1, 5, 3);
                this.createSmallBranch(world, rand, x - radius - 1, yy - rand.nextInt(2), z - radius - 1, 6, 3);
                this.createSmallBranch(world, rand, x - radius - 1, yy - rand.nextInt(2), z + radius + 1, 7, 3);
                this.createSmallBranch(world, rand, x + radius + 1, yy - rand.nextInt(2), z - radius - 1, 8, 3);
            }
            if (yy == y + height / 2 + 7) {
                this.createSmallBranch(world, rand, x + radius + 1, yy - rand.nextInt(2), z, 1, 2);
                this.createSmallBranch(world, rand, x - radius - 1, yy - rand.nextInt(2), z, 2, 2);
                this.createSmallBranch(world, rand, x, yy - rand.nextInt(3), z + radius + 1, 3, 2);
                this.createSmallBranch(world, rand, x, yy - rand.nextInt(3), z - radius - 1, 4, 2);
                this.createSmallBranch(world, rand, x + radius + 1, yy - rand.nextInt(2), z + radius + 1, 5, 2);
                this.createSmallBranch(world, rand, x - radius - 1, yy - rand.nextInt(2), z - radius - 1, 6, 2);
                this.createSmallBranch(world, rand, x - radius - 1, yy - rand.nextInt(2), z + radius + 1, 7, 2);
                this.createSmallBranch(world, rand, x + radius + 1, yy - rand.nextInt(2), z - radius - 1, 8, 2);
            }
            if (yy != y + 1) continue;
            this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(2), z, 1, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(2), z, 2, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x, yy - rand.nextInt(2), z + radius + 1, 3, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x, yy - rand.nextInt(2), z - radius - 1, 4, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(2), z + radius + 1, 5, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(2), z - radius - 1, 6, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(2), z + radius + 1, 7, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(2), z - radius - 1, 8, true, rand.nextInt(2) + 3);
        }
        return true;
    }

    private void createSmallBranch(World world, Random rand, int x, int y, int z, int dir, int branchLength) {
        int meta = dir;
        for (int i = 0; i <= branchLength; ++i) {
            if (i >= 2) {
                ++y;
            }
            if (dir == 1) {
                world.func_147449_b(x + i, y, z, (Block)this.bark);
            }
            if (dir == 2) {
                world.func_147449_b(x - i, y, z, (Block)this.bark);
            }
            if (dir == 3) {
                world.func_147449_b(x, y, z + i, (Block)this.bark);
            }
            if (dir == 4) {
                world.func_147449_b(x, y, z - i, (Block)this.bark);
            }
            if (dir == 5) {
                world.func_147449_b(x + i - 1, y, z + i - 1, (Block)this.bark);
            }
            if (dir == 6) {
                world.func_147449_b(x - i + 1, y, z - i + 1, (Block)this.bark);
            }
            if (dir == 7) {
                world.func_147449_b(x - i + 1, y, z + i - 1, (Block)this.bark);
            }
            if (dir != 8) continue;
            world.func_147449_b(x + i - 1, y, z - i + 1, (Block)this.bark);
        }
    }

    private void createMainCanopy(World world, Random rand, int x, int y, int z, int maxRadius) {
        for (int x1 = x - maxRadius; x1 <= x + maxRadius; ++x1) {
            for (int z1 = z - maxRadius; z1 <= z + maxRadius; ++z1) {
                for (int y1 = y; y1 < y + maxRadius; ++y1) {
                    double dSq = Math.pow(x1 - x, 2.0) + Math.pow(z1 - z, 2.0) + Math.pow(y1 - y, 2.5);
                    if (Math.round(Math.sqrt(dSq)) <= (long)maxRadius && world.func_147439_a(x1, y1, z1) != this.bark && rand.nextInt(5) != 0) {
                        world.func_147449_b(x1, y1, z1, (Block)this.leaves);
                    }
                    if (Math.round(Math.sqrt(dSq)) < (long)(maxRadius - 1) && rand.nextInt(5) == 0 && y1 > y && world.func_147439_a(x1, y1, z1) != this.bark) {
                        world.func_147449_b(x1, y1, z1, (Block)this.bark);
                    }
                    if (Math.round(Math.sqrt(dSq)) > (long)maxRadius || rand.nextInt(3) != 0 || y1 != y || world.func_147439_a(x1, y1, z1) == this.bark) continue;
                    for (int i = 1; i < 1 + rand.nextInt(3); ++i) {
                        world.func_147449_b(x1, y1 - i, z1, (Block)this.leaves);
                    }
                }
            }
        }
    }

    private void createBranch(World world, Random rand, int x, int y, int z, int dir, boolean root, int branchLength) {
        int meta = dir;
        for (int i = 0; i <= branchLength; ++i) {
            if (i >= 3) {
                y = !root ? ++y : --y;
                meta = 0;
            }
            if (dir == 1) {
                if (!root) {
                    world.func_147449_b(x + i, y, z, (Block)this.bark);
                    if (i < branchLength + 1) {
                        this.addVines(world, rand, x + i, y - 1, z, 2);
                    }
                } else {
                    world.func_147449_b(x + i, y, z, (Block)this.bark);
                    world.func_147449_b(x + i, y - 1, z, (Block)this.bark);
                }
            }
            if (dir == 2) {
                if (!root) {
                    world.func_147449_b(x - i, y, z, (Block)this.bark);
                    if (i < branchLength + 1) {
                        this.addVines(world, rand, x - i, y - 1, z, 8);
                    }
                } else {
                    world.func_147449_b(x - i, y, z, (Block)this.bark);
                    world.func_147449_b(x - i, y - 1, z, (Block)this.bark);
                }
            }
            if (dir == 3) {
                if (!root) {
                    world.func_147449_b(x, y, z + i, (Block)this.bark);
                    if (i < branchLength + 1) {
                        this.addVines(world, rand, x, y - 1, z + i, 4);
                    }
                } else {
                    world.func_147449_b(x, y, z + i, (Block)this.bark);
                    world.func_147449_b(x, y - 1, z + i, (Block)this.bark);
                }
            }
            if (dir == 4) {
                if (!root) {
                    world.func_147449_b(x, y, z - i, (Block)this.bark);
                    if (i < branchLength + 1) {
                        this.addVines(world, rand, x, y - 1, z - i, 1);
                    }
                } else {
                    world.func_147449_b(x, y, z - i, (Block)this.bark);
                    world.func_147449_b(x, y - 1, z - i, (Block)this.bark);
                }
            }
            if (dir == 5) {
                if (!root) {
                    world.func_147449_b(x + i - 1, y, z + i - 1, (Block)this.bark);
                    if (i < branchLength + 1) {
                        this.addVines(world, rand, x + i - 1, y - 1, z + i - 1, 2);
                    }
                } else {
                    world.func_147449_b(x + i - 1, y, z + i - 1, (Block)this.bark);
                    world.func_147449_b(x + i - 1, y - 1, z + i - 1, (Block)this.bark);
                }
            }
            if (dir == 6) {
                if (!root) {
                    world.func_147449_b(x - i + 1, y, z - i + 1, (Block)this.bark);
                    if (i < branchLength + 1) {
                        this.addVines(world, rand, x - i + 1, y - 1, z - i + 1, 8);
                    }
                } else {
                    world.func_147449_b(x - i + 1, y, z - i + 1, (Block)this.bark);
                    world.func_147449_b(x - i + 1, y - 1, z - i + 1, (Block)this.bark);
                }
            }
            if (dir == 7) {
                if (!root) {
                    world.func_147449_b(x - i + 1, y, z + i - 1, (Block)this.bark);
                    if (i < branchLength + 1) {
                        this.addVines(world, rand, x - i + 1, y - 1, z + i - 1, 4);
                    }
                } else {
                    world.func_147449_b(x - i + 1, y, z + i - 1, (Block)this.bark);
                    world.func_147449_b(x - i + 1, y - 1, z + i - 1, (Block)this.bark);
                }
            }
            if (dir != 8) continue;
            if (!root) {
                world.func_147449_b(x + i - 1, y, z - i + 1, (Block)this.bark);
                if (i >= branchLength + 1) continue;
                this.addVines(world, rand, x + i - 1, y - 1, z - i + 1, 1);
                continue;
            }
            world.func_147449_b(x + i - 1, y, z - i + 1, (Block)this.bark);
            world.func_147449_b(x + i - 1, y - 1, z - i + 1, (Block)this.bark);
        }
    }

    public void addVines(World world, Random rand, int x, int y, int z, int meta) {
    }
}

