/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.feature.trees;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.plants.BlockPoisonIvy;
import thebetweenlands.blocks.tree.BlockBLLog;

public class WorldGenSmallWeedWoodTree
extends WorldGenerator {
    private BlockBLLog log;
    private BlockBLLog bark;
    private BlockBLLog wood;
    private BlockPoisonIvy ivy;

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int radius = rand.nextInt(2) + 3;
        int height = rand.nextInt(2) + 15;
        int maxRadius = 9;
        this.log = (BlockBLLog)BLBlockRegistry.rottenWeedwoodBark;
        this.bark = (BlockBLLog)BLBlockRegistry.rottenWeedwoodBark;
        this.wood = (BlockBLLog)BLBlockRegistry.weedwood;
        this.ivy = BLBlockRegistry.poisonIvy;
        for (int xx = x - maxRadius; xx <= x + maxRadius; ++xx) {
            for (int zz = z - maxRadius; zz <= z + maxRadius; ++zz) {
                for (int yy = y + 2; yy < y + height; ++yy) {
                    if (world.func_147437_c(xx, yy, zz) || world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) continue;
                    return false;
                }
            }
        }
        for (int yy = y; yy < y + height; ++yy) {
            if (yy % 5 == 0 && radius > 1) {
                --radius;
            }
            for (int i = radius * -1; i <= radius; ++i) {
                for (int j = radius * -1; j <= radius; ++j) {
                    double dSq = i * i + j * j;
                    if (Math.round(Math.sqrt(dSq)) < (long)radius && yy <= y + height - 2) {
                        world.func_147465_d(x + i, yy, z + j, (Block)this.wood, 0, 2);
                    }
                    if ((Math.round(Math.sqrt(dSq)) != (long)radius || yy != y) && (Math.round(Math.sqrt(dSq)) != (long)radius || yy > y + height - 1)) continue;
                    world.func_147465_d(x + i, yy, z + j, (Block)this.bark, 0, 2);
                }
            }
            if (yy == y + height / 2 + 2) {
                this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(1), z, 1, false, rand.nextInt(2) + 4);
                this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(1), z, 2, false, rand.nextInt(2) + 4);
                this.createBranch(world, rand, x, yy - rand.nextInt(1), z + radius + 1, 3, false, rand.nextInt(2) + 4);
                this.createBranch(world, rand, x, yy - rand.nextInt(1), z - radius - 1, 4, false, rand.nextInt(2) + 4);
                this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(1), z + radius + 1, 5, false, rand.nextInt(2) + 3);
                this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(1), z - radius - 1, 6, false, rand.nextInt(2) + 3);
                this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(1), z + radius + 1, 7, false, rand.nextInt(2) + 3);
                this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(1), z - radius - 1, 8, false, rand.nextInt(2) + 3);
            }
            if (yy == y + height / 2 + 4) {
                this.createSmallBranch(world, rand, x + radius + 1, yy - rand.nextInt(1), z, 1, 4);
                this.createSmallBranch(world, rand, x - radius - 1, yy - rand.nextInt(1), z, 2, 4);
                this.createSmallBranch(world, rand, x, yy - rand.nextInt(1), z + radius + 1, 3, 4);
                this.createSmallBranch(world, rand, x, yy - rand.nextInt(1), z - radius - 1, 4, 4);
                this.createSmallBranch(world, rand, x + radius + 1, yy - rand.nextInt(1), z + radius + 1, 5, 3);
                this.createSmallBranch(world, rand, x - radius - 1, yy - rand.nextInt(1), z - radius - 1, 6, 3);
                this.createSmallBranch(world, rand, x - radius - 1, yy - rand.nextInt(1), z + radius + 1, 7, 3);
                this.createSmallBranch(world, rand, x + radius + 1, yy - rand.nextInt(1), z - radius - 1, 8, 3);
            }
            if (yy == y + height / 2 + 7) {
                this.createSmallBranch(world, rand, x + radius + 1, yy - rand.nextInt(2), z, 1, 2);
                this.createSmallBranch(world, rand, x - radius - 1, yy - rand.nextInt(2), z, 2, 2);
                this.createSmallBranch(world, rand, x, yy - rand.nextInt(3), z + radius + 1, 3, 2);
                this.createSmallBranch(world, rand, x, yy - rand.nextInt(3), z - radius - 1, 4, 2);
                this.createSmallBranch(world, rand, x + radius + 1, yy - rand.nextInt(1), z + radius + 1, 5, 2);
                this.createSmallBranch(world, rand, x - radius - 1, yy - rand.nextInt(1), z - radius - 1, 6, 2);
                this.createSmallBranch(world, rand, x - radius - 1, yy - rand.nextInt(1), z + radius + 1, 7, 2);
                this.createSmallBranch(world, rand, x + radius + 1, yy - rand.nextInt(1), z - radius - 1, 8, 2);
            }
            if (yy != y + 1) continue;
            this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(3), z, 1, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(3), z, 2, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x, yy - rand.nextInt(3), z + radius + 1, 3, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x, yy - rand.nextInt(3), z - radius - 1, 4, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(2), z + radius + 1, 5, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(2), z - radius - 1, 6, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(2), z + radius + 1, 7, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(2), z - radius - 1, 8, true, rand.nextInt(2) + 3);
        }
        return true;
    }

    private void createSmallBranch(World world, Random rand, int x, int y, int z, int dir, int branchLength) {
        int meta = dir;
        for (int i = 0; i <= branchLength; ++i) {
            if (i >= 2) {
                ++y;
                meta = 0;
            }
            if (dir == 1) {
                world.func_147465_d(x + i, y, z, (Block)this.log, meta == 0 ? 0 : 4, 2);
            }
            if (dir == 2) {
                world.func_147465_d(x - i, y, z, (Block)this.log, meta == 0 ? 0 : 4, 2);
            }
            if (dir == 3) {
                world.func_147465_d(x, y, z + i, (Block)this.log, meta == 0 ? 0 : 8, 2);
            }
            if (dir == 4) {
                world.func_147465_d(x, y, z - i, (Block)this.log, meta == 0 ? 0 : 8, 2);
            }
            if (dir == 5) {
                world.func_147465_d(x + i - 1, y, z + i - 1, (Block)this.log, meta == 0 ? 0 : 4, 2);
            }
            if (dir == 6) {
                world.func_147465_d(x - i + 1, y, z - i + 1, (Block)this.log, meta == 0 ? 0 : 4, 2);
            }
            if (dir == 7) {
                world.func_147465_d(x - i + 1, y, z + i - 1, (Block)this.log, meta == 0 ? 0 : 8, 2);
            }
            if (dir != 8) continue;
            world.func_147465_d(x + i - 1, y, z - i + 1, (Block)this.log, meta == 0 ? 0 : 8, 2);
        }
    }

    private void createBranch(World world, Random rand, int x, int y, int z, int dir, boolean root, int branchLength) {
        int meta = dir;
        for (int i = 0; i <= branchLength; ++i) {
            if (i >= 3) {
                y = !root ? ++y : --y;
                meta = 0;
            }
            if (dir == 1) {
                if (!root) {
                    world.func_147465_d(x + i, y, z, (Block)this.log, meta == 0 ? 0 : 4, 2);
                    if (i <= branchLength) {
                        this.addVines(world, rand, x + i, y - 1, z, 2);
                    }
                } else {
                    world.func_147465_d(x + i, y, z, (Block)this.log, 15, 2);
                    world.func_147465_d(x + i, y - 1, z, (Block)this.log, 15, 2);
                }
            }
            if (dir == 2) {
                if (!root) {
                    world.func_147465_d(x - i, y, z, (Block)this.log, meta == 0 ? 0 : 4, 2);
                    if (i <= branchLength) {
                        this.addVines(world, rand, x - i, y - 1, z, 8);
                    }
                } else {
                    world.func_147465_d(x - i, y, z, (Block)this.log, 15, 2);
                    world.func_147465_d(x - i, y - 1, z, (Block)this.log, 15, 2);
                }
            }
            if (dir == 3) {
                if (!root) {
                    world.func_147465_d(x, y, z + i, (Block)this.log, meta == 0 ? 0 : 8, 2);
                    if (i <= branchLength) {
                        this.addVines(world, rand, x, y - 1, z + i, 4);
                    }
                } else {
                    world.func_147465_d(x, y, z + i, (Block)this.log, 15, 2);
                    world.func_147465_d(x, y - 1, z + i, (Block)this.log, 15, 2);
                }
            }
            if (dir == 4) {
                if (!root) {
                    world.func_147465_d(x, y, z - i, (Block)this.log, meta == 0 ? 0 : 8, 2);
                    if (i <= branchLength) {
                        this.addVines(world, rand, x, y - 1, z - i, 1);
                    }
                } else {
                    world.func_147465_d(x, y, z - i, (Block)this.log, 15, 2);
                    world.func_147465_d(x, y - 1, z - i, (Block)this.log, 15, 2);
                }
            }
            if (dir == 5) {
                if (!root) {
                    world.func_147465_d(x + i - 1, y, z + i - 1, (Block)this.log, meta == 0 ? 0 : 4, 2);
                    if (i <= branchLength) {
                        this.addVines(world, rand, x + i - 1, y - 1, z + i - 1, 2);
                    }
                } else {
                    world.func_147465_d(x + i - 1, y, z + i - 1, (Block)this.log, 15, 2);
                    world.func_147465_d(x + i - 1, y - 1, z + i - 1, (Block)this.log, 15, 2);
                }
            }
            if (dir == 6) {
                if (!root) {
                    world.func_147465_d(x - i + 1, y, z - i + 1, (Block)this.log, meta == 0 ? 0 : 4, 2);
                    if (i <= branchLength) {
                        this.addVines(world, rand, x - i + 1, y - 1, z - i + 1, 8);
                    }
                } else {
                    world.func_147465_d(x - i + 1, y, z - i + 1, (Block)this.log, 15, 2);
                    world.func_147465_d(x - i + 1, y - 1, z - i + 1, (Block)this.log, 15, 2);
                }
            }
            if (dir == 7) {
                if (!root) {
                    world.func_147465_d(x - i + 1, y, z + i - 1, (Block)this.log, meta == 0 ? 0 : 8, 2);
                    if (i <= branchLength) {
                        this.addVines(world, rand, x - i + 1, y - 1, z + i - 1, 4);
                    }
                } else {
                    world.func_147465_d(x - i + 1, y, z + i - 1, (Block)this.log, 15, 2);
                    world.func_147465_d(x - i + 1, y - 1, z + i - 1, (Block)this.log, 15, 2);
                }
            }
            if (dir != 8) continue;
            if (!root) {
                world.func_147465_d(x + i - 1, y, z - i + 1, (Block)this.log, meta == 0 ? 0 : 8, 2);
                if (i > branchLength) continue;
                this.addVines(world, rand, x + i - 1, y - 1, z - i + 1, 1);
                continue;
            }
            world.func_147465_d(x + i - 1, y, z - i + 1, (Block)this.log, 15, 2);
            world.func_147465_d(x + i - 1, y - 1, z - i + 1, (Block)this.log, 15, 2);
        }
    }

    private void addVines(World world, Random rand, int x, int y, int z, int meta) {
        if (rand.nextInt(4) != 0) {
            int length = rand.nextInt(4) + 4;
            for (int yy = y; yy > y - length && world.func_147439_a(x, yy, z) == Blocks.field_150350_a; --yy) {
                world.func_147465_d(x, yy, z, (Block)this.ivy, meta, 2);
            }
        }
    }
}

