/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.feature.trees;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.tree.BlockBLLeaves;
import thebetweenlands.blocks.tree.BlockBLLog;

public class WorldGenSapTree
extends WorldGenerator {
    private BlockBLLog log;
    private BlockBLLeaves leaves;

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int height = rand.nextInt(3) + 16;
        int maxRadius = 6;
        this.log = BLBlockRegistry.sapTreeLog;
        this.leaves = BLBlockRegistry.sapTreeLeaves;
        for (int xx = x - maxRadius; xx <= x + maxRadius; ++xx) {
            for (int zz = z - maxRadius; zz <= z + maxRadius; ++zz) {
                for (int yy = y + 2; yy < y + height; ++yy) {
                    if (world.func_147437_c(xx, yy, zz)) continue;
                    return false;
                }
            }
        }
        for (int yy = y; yy < y + height; ++yy) {
            world.func_147465_d(x, yy, z, (Block)this.log, 0, 2);
            if (yy == y) {
                this.createRoots(world, x, yy, z);
            }
            if (yy == y + height - 1) {
                this.createLeaves(world, x, yy, z, true);
            }
            if (yy == y + height - 8 || yy == y + height - 12) {
                if (rand.nextBoolean()) {
                    this.createlBranch(world, rand, x + 1, yy - rand.nextInt(2), z, 1, 2);
                    this.createlBranch(world, rand, x - 1, yy - rand.nextInt(2), z, 2, 2);
                    this.createlBranch(world, rand, x, yy - rand.nextInt(2), z + 1, 3, 2);
                    this.createlBranch(world, rand, x, yy - rand.nextInt(2), z - 1, 4, 2);
                } else {
                    this.createlBranch(world, rand, x + 2, yy - rand.nextInt(2), z + 2, 5, 2);
                    this.createlBranch(world, rand, x - 2, yy - rand.nextInt(2), z - 2, 6, 2);
                    this.createlBranch(world, rand, x - 2, yy - rand.nextInt(2), z + 2, 7, 2);
                    this.createlBranch(world, rand, x + 2, yy - rand.nextInt(2), z - 2, 8, 2);
                }
            }
            if (yy != y + height - 4) continue;
            if (rand.nextBoolean()) {
                this.createlBranch(world, rand, x + 1, yy - rand.nextInt(2), z, 1, 1);
                this.createlBranch(world, rand, x - 1, yy - rand.nextInt(2), z, 2, 1);
                this.createlBranch(world, rand, x, yy - rand.nextInt(2), z + 1, 3, 1);
                this.createlBranch(world, rand, x, yy - rand.nextInt(2), z - 1, 4, 1);
                continue;
            }
            this.createlBranch(world, rand, x + 2, yy - rand.nextInt(2), z + 2, 5, 1);
            this.createlBranch(world, rand, x - 2, yy - rand.nextInt(2), z - 2, 6, 1);
            this.createlBranch(world, rand, x - 2, yy - rand.nextInt(2), z + 2, 7, 1);
            this.createlBranch(world, rand, x + 2, yy - rand.nextInt(2), z - 2, 8, 1);
        }
        return true;
    }

    private void createlBranch(World world, Random rand, int x, int y, int z, int dir, int branchLength) {
        int meta = dir;
        for (int i = 0; i <= branchLength; ++i) {
            if (i >= 1) {
                ++y;
                meta = 0;
            }
            if (dir == 1) {
                world.func_147465_d(x + i, y, z, (Block)this.log, meta == 0 ? 0 : 4, 2);
                if (i == branchLength) {
                    this.createLeaves(world, x + i, y, z, false);
                }
            }
            if (dir == 2) {
                world.func_147465_d(x - i, y, z, (Block)this.log, meta == 0 ? 0 : 4, 2);
                if (i == branchLength) {
                    this.createLeaves(world, x - i, y, z, false);
                }
            }
            if (dir == 3) {
                world.func_147465_d(x, y, z + i, (Block)this.log, meta == 0 ? 0 : 8, 2);
                if (i == branchLength) {
                    this.createLeaves(world, x, y, z + i, false);
                }
            }
            if (dir == 4) {
                world.func_147465_d(x, y, z - i, (Block)this.log, meta == 0 ? 0 : 8, 2);
                if (i == branchLength) {
                    this.createLeaves(world, x, y, z - i, false);
                }
            }
            if (dir == 5) {
                world.func_147465_d(x + i - 1, y, z + i - 1, (Block)this.log, meta == 0 ? 0 : 4, 2);
                if (i == branchLength) {
                    this.createLeaves(world, x + i - 1, y, z + i - 1, false);
                }
            }
            if (dir == 6) {
                world.func_147465_d(x - i + 1, y, z - i + 1, (Block)this.log, meta == 0 ? 0 : 4, 2);
                if (i == branchLength) {
                    this.createLeaves(world, x - i + 1, y, z - i + 1, false);
                }
            }
            if (dir == 7) {
                world.func_147465_d(x - i + 1, y, z + i - 1, (Block)this.log, meta == 0 ? 0 : 8, 2);
                if (i == branchLength) {
                    this.createLeaves(world, x - i + 1, y, z + i - 1, false);
                }
            }
            if (dir != 8) continue;
            world.func_147465_d(x + i - 1, y, z - i + 1, (Block)this.log, meta == 0 ? 0 : 8, 2);
            if (i != branchLength) continue;
            this.createLeaves(world, x + i - 1, y, z - i + 1, false);
        }
    }

    private void createLeaves(World world, int x, int y, int z, boolean top) {
        world.func_147449_b(x, y, z + 1, (Block)this.leaves);
        world.func_147449_b(x, y, z - 1, (Block)this.leaves);
        world.func_147449_b(x + 1, y, z, (Block)this.leaves);
        world.func_147449_b(x - 1, y, z, (Block)this.leaves);
        if (top) {
            world.func_147449_b(x, y + 1, z, (Block)this.leaves);
        } else {
            world.func_147449_b(x, y - 1, z, (Block)this.leaves);
        }
    }

    private void createRoots(World world, int x, int y, int z) {
        world.func_147465_d(x, y, z + 1, (Block)this.log, 15, 2);
        world.func_147465_d(x, y, z - 1, (Block)this.log, 15, 2);
        world.func_147465_d(x + 1, y, z, (Block)this.log, 15, 2);
        world.func_147465_d(x - 1, y, z, (Block)this.log, 15, 2);
    }
}

