/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.feature.trees;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.tree.BlockBLLeaves;
import thebetweenlands.blocks.tree.BlockBLLog;

public class WorldGenRubberTree
extends WorldGenerator {
    private BlockBLLog log;
    private BlockBLLeaves leaves;

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int height = rand.nextInt(8) + 8;
        int maxRadius = 4;
        this.log = (BlockBLLog)BLBlockRegistry.rubberTreeLog;
        this.leaves = (BlockBLLeaves)BLBlockRegistry.rubberTreeLeaves;
        for (int xx = x - maxRadius; xx <= x + maxRadius; ++xx) {
            for (int zz = z - maxRadius; zz <= z + maxRadius; ++zz) {
                for (int yy = y + 2; yy < y + height; ++yy) {
                    if (world.func_147437_c(xx, yy, zz)) continue;
                    return false;
                }
            }
        }
        for (int yy = y; yy < y + height; ++yy) {
            world.func_147465_d(x, yy, z, (Block)this.log, 1, 2);
            if (yy == y + height - 1) {
                this.createMainCanopy(world, rand, x, yy, z, maxRadius);
            }
            if (yy != y + height - 2) continue;
            this.createBranch(world, rand, x + 1, yy, z, 1, 1);
            this.createBranch(world, rand, x - 1, yy, z, 2, 1);
            this.createBranch(world, rand, x, yy, z + 1, 3, 1);
            this.createBranch(world, rand, x, yy, z - 1, 4, 1);
        }
        return true;
    }

    private void createBranch(World world, Random rand, int x, int y, int z, int dir, int branchLength) {
        int meta = dir;
        for (int i = 0; i <= branchLength; ++i) {
            if (i >= 1) {
                ++y;
                meta = 0;
            }
            if (dir == 1) {
                world.func_147465_d(x + i, y, z, (Block)this.log, 1, 2);
            }
            if (dir == 2) {
                world.func_147465_d(x - i, y, z, (Block)this.log, 1, 2);
            }
            if (dir == 3) {
                world.func_147465_d(x, y, z + i, (Block)this.log, 1, 2);
            }
            if (dir != 4) continue;
            world.func_147465_d(x, y, z - i, (Block)this.log, 1, 2);
        }
    }

    private void createMainCanopy(World world, Random rand, int x, int y, int z, int maxRadius) {
        for (int x1 = x - maxRadius; x1 <= x + maxRadius; ++x1) {
            for (int z1 = z - maxRadius; z1 <= z + maxRadius; ++z1) {
                for (int y1 = y; y1 < y + maxRadius; ++y1) {
                    double dSq = Math.pow(x1 - x, 2.0) + Math.pow(z1 - z, 2.0) + Math.pow(y1 - y, 2.0);
                    if (Math.round(Math.sqrt(dSq)) > (long)maxRadius || world.func_147439_a(x1, y1, z1) == this.log || rand.nextInt(5) == 0) continue;
                    world.func_147449_b(x1, y1, z1, (Block)this.leaves);
                }
            }
        }
    }
}

