/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.feature.trees;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.world.feature.trees.WorldGenGiantTree;

public class WorldGenGiantTreeDead
extends WorldGenGiantTree {
    private static final float TILT_SCALE = 0.2f;
    private float tiltOffsetX;
    private float tiltOffsetZ;

    @Override
    protected boolean canFungusGenerateAtY(int dy, int height) {
        return super.canFungusGenerateAtY(dy, height) && dy > 5 && dy <= height - 4;
    }

    @Override
    protected void initAttributes(Random rand) {
        this.tiltOffsetX = rand.nextFloat() * 2.0f * (float)Math.PI / 0.2f;
        this.tiltOffsetZ = rand.nextFloat() * 2.0f * (float)Math.PI / 0.2f;
    }

    @Override
    protected void placeWood(World world, Random rand, int radius, int height, int blockX, int blockY, int blockZ, int dx, int dy, int dz) {
        float distanceToTop = this.calculateDistanceToTop(height, dx, dy, dz);
        int tilt = this.calculateTilt(dx, dz);
        if (distanceToTop > (float)radius * (rand.nextFloat() * 0.1f + 0.8f) && height - tilt > dy) {
            super.placeWood(world, rand, radius, height, blockX, blockY, blockZ, dx, dy, dz);
        }
    }

    @Override
    protected void placeBark(World world, Random rand, int radius, int height, int blockX, int blockY, int blockZ, int dx, int dy, int dz) {
        float distanceToTop = this.calculateDistanceToTop(height, dx, dy, dz);
        int tilt = this.calculateTilt(dx, dz);
        if (distanceToTop > (float)radius * 0.75f && height - tilt > dy) {
            super.placeBark(world, rand, radius, height, blockX, blockY, blockZ, dx, dy, dz);
            this.addVineToRandomBlockSide(world, rand, blockX + dx, blockY + dy, blockZ + dz);
        }
    }

    public void addVineToRandomBlockSide(World world, Random rand, int x, int y, int z) {
        ForgeDirection direction = ForgeDirection.values()[2 + rand.nextInt(3)];
        if (world.func_147439_a(x + direction.offsetX, y, z + direction.offsetZ).func_149688_o().func_76222_j()) {
            world.func_147465_d(x + direction.offsetX, y, z + direction.offsetZ, (Block)BLBlockRegistry.poisonIvy, BLBlockRegistry.poisonIvy.getMetaForDirection(direction), 2);
        }
    }

    private float calculateDistanceToTop(int height, int dx, int dy, int dz) {
        return MathHelper.func_76129_c((float)(dx * dx + dz * dz + (height - dy) * (height - dy)));
    }

    private int calculateTilt(int dx, int dz) {
        int tiltHeight = 3;
        return (int)((MathHelper.func_76126_a((float)((float)dx * 0.2f + this.tiltOffsetX)) * 0.5f + MathHelper.func_76126_a((float)((float)dz * 0.2f + this.tiltOffsetZ)) * 0.5f + 1.0f) * 0.5f * 3.0f);
    }
}

