/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.feature.trees;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.world.feature.trees.WorldGenGiantTree;
import thebetweenlands.world.storage.chunk.storage.StorageHelper;
import thebetweenlands.world.storage.chunk.storage.location.EnumLocationType;
import thebetweenlands.world.storage.chunk.storage.location.LocationStorage;

public class WorldGenGiantTreeAlive
extends WorldGenGiantTree {
    private static final ForgeDirection[] SHUFFLED_DIRECTIONS = (ForgeDirection[])DIRECTIONS.clone();

    @Override
    public boolean generateTree(World world, Random rand, int blockX, int blockY, int blockZ) {
        boolean gen = super.generateTree(world, rand, blockX, blockY, blockZ);
        if (gen) {
            List<LocationStorage> addedLocations = StorageHelper.addArea(world, "giantTree", AxisAlignedBB.func_72330_a((double)(blockX - 32), (double)(blockY - 10), (double)(blockZ - 32), (double)(blockX + 32), (double)(blockY + 80), (double)(blockZ + 32)), EnumLocationType.GIANT_TREE, 0);
            for (LocationStorage location : addedLocations) {
                location.setVisible(false).getChunkData().markDirty();
            }
        }
        return gen;
    }

    @Override
    protected int getRadiusHeightRatio() {
        return 3;
    }

    @Override
    protected boolean canFungusGenerateAtY(int dy, int height) {
        return super.canFungusGenerateAtY(dy, height) && dy >= height / 4 && dy <= height / 4 * 3 - 3;
    }

    @Override
    protected void generateShoots(World world, Random rand, int baseRadius, int height, int blockX, int blockY, int blockZ) {
        super.generateShoots(world, rand, baseRadius, height, blockX, blockY, blockZ);
        int endRadius = this.getRadius(baseRadius, height);
        this.generateBranches(world, rand, baseRadius, height, endRadius, blockY, blockX, blockY + height / 3 * 2, blockZ, true);
        this.generateBranches(world, rand, baseRadius, height, endRadius, blockY, blockX, blockY + height / 3, blockZ, false);
        this.generateBranch(world, rand, blockX, blockY + height, blockZ, rand.nextFloat() * 2.0f * (float)Math.PI, 1.5707964f, 6, endRadius, -2.0f);
    }

    private void generateBranches(World world, Random rand, int baseRadius, int height, int endRadius, int baseY, int blockX, int blockY, int blockZ, boolean top) {
        int branchCount = rand.nextInt(3) + (top ? 2 : 1);
        float angle = (float)Math.PI * 2 / (float)branchCount;
        float angleOffset = rand.nextFloat() * 2.0f * (float)Math.PI;
        for (int branch = 0; branch < branchCount; ++branch) {
            float yaw = angle * (float)branch + angleOffset;
            float pitch = 0.7853982f + rand.nextFloat() * (float)Math.PI / 6.0f;
            int length = rand.nextInt(8) + 25;
            this.generateBranch(world, rand, blockX, Math.min(blockY + rand.nextInt(10), baseY + height - rand.nextInt(10)), blockZ, yaw, pitch, length, (int)((float)endRadius * 0.85f), (int)((float)endRadius * 0.4f));
        }
    }

    private void generateBranch(World world, Random rand, float posX, float posY, float posZ, float yaw, float pitch, int length, float startSize, float endSize) {
        int branchPoint;
        float yawDelta = 0.0f;
        boolean largeCanopy = endSize == -2.0f;
        int n = branchPoint = largeCanopy ? -1 : length / 4 + rand.nextInt(length / 4);
        if (endSize == -1.0f) {
            endSize = 1.0f;
        } else if (largeCanopy) {
            endSize = startSize * 0.75f;
        }
        int minX = 30000000;
        int minY = 255;
        int minZ = 30000000;
        int maxX = -30000000;
        int maxY = 0;
        int maxZ = -30000000;
        for (int step = 0; step < length; ++step) {
            float along = (float)step / (float)length;
            float cosPitch = MathHelper.func_76134_b((float)pitch);
            posX += MathHelper.func_76134_b((float)yaw) * cosPitch;
            posY += MathHelper.func_76126_a((float)pitch);
            posZ += MathHelper.func_76126_a((float)yaw) * cosPitch;
            if (!largeCanopy) {
                pitch *= 1.0f - along + along * 0.1f;
                if (along > 0.5f && pitch < 1.5707964f) {
                    pitch += along - 0.45f;
                }
            }
            yaw += yawDelta * 0.1f;
            yawDelta *= 0.8f;
            yawDelta += (rand.nextFloat() - rand.nextFloat()) * rand.nextFloat() * 4.0f * (along + 0.1f);
            float size = along * endSize + (1.0f - along) * startSize;
            int sizeRange = (int)Math.ceil(size);
            if (step == branchPoint && startSize > 1.0f && length > 5) {
                float branchYaw = rand.nextFloat() * (float)Math.PI / 16.0f;
                float branchAngle = rand.nextFloat() * (float)Math.PI / 4.0f + 0.7853982f;
                this.generateBranch(world, rand, posX, posY, posZ, yaw + branchYaw + branchAngle, pitch + 0.5235988f, length - step, size * 0.8f, -1.0f);
                this.generateBranch(world, rand, posX, posY, posZ, yaw + branchYaw - branchAngle, pitch + 0.5235988f, length - step, size * 0.8f, -1.0f);
            }
            for (int x = -sizeRange; x <= sizeRange; ++x) {
                for (int z = -sizeRange; z <= sizeRange; ++z) {
                    for (int y = -sizeRange; y <= sizeRange; ++y) {
                        float dist = MathHelper.func_76129_c((float)(x * x + y * y + z * z));
                        if (!(dist <= size)) continue;
                        Block block = world.func_147439_a((int)posX + x, (int)posY + y, (int)posZ + z);
                        Block above = world.func_147439_a((int)posX + x, (int)posY + y + 1, (int)posZ + z);
                        if (block == BLBlockRegistry.weedwood && above.func_149688_o().func_76222_j()) continue;
                        int bx = (int)posX + x;
                        int by = (int)posY + y;
                        int bz = (int)posZ + z;
                        world.func_147449_b(bx, by, bz, BLBlockRegistry.weedwoodBark);
                        if (bx < minX) {
                            minX = bx;
                        }
                        if (by < minY) {
                            minY = by;
                        }
                        if (bz < minZ) {
                            minZ = bz;
                        }
                        if (bx > maxX) {
                            maxX = bx;
                        }
                        if (by > maxY) {
                            maxY = by;
                        }
                        if (bz <= maxZ) continue;
                        maxZ = bz;
                    }
                }
            }
        }
        this.makeBarkInsideNotBark(world, minX, minY, minZ, maxX, maxY, maxZ);
        int maxRadius = largeCanopy ? 16 : (length < 2 ? 1 : length * 3 / 8 + rand.nextInt(length / 4));
        this.generateCanopy(world, rand, (int)posX, (int)posY, (int)posZ, maxRadius);
    }

    private void generateCanopy(World world, Random rand, int blockX, int blockY, int blockZ, int maxRadius) {
        if (maxRadius > 4) {
            int branchCount = rand.nextInt(3) + 3;
            float angleOffset = rand.nextFloat() * 2.0f * (float)Math.PI;
            float angle = (float)Math.PI * 2 / (float)branchCount;
            float pitch = 0.3926991f;
            float deltaY = MathHelper.func_76126_a((float)pitch);
            float cosPitch = MathHelper.func_76134_b((float)pitch);
            int size = 1;
            for (int branch = 0; branch < branchCount; ++branch) {
                double posX = blockX;
                double posY = blockY - 2;
                double posZ = blockZ;
                float yaw = angle * (float)branch + angleOffset;
                float deltaX = MathHelper.func_76134_b((float)yaw) * cosPitch;
                float deltaZ = MathHelper.func_76126_a((float)yaw) * cosPitch;
                int length = (int)((float)maxRadius * (rand.nextFloat() * 0.39999998f + 0.5f));
                for (int step = 0; step < length; ++step) {
                    posX += (double)deltaX;
                    posY += (double)deltaY;
                    posZ += (double)deltaZ;
                    for (int x = -size; x <= size; ++x) {
                        for (int z = -size; z <= size; ++z) {
                            for (int y = -size; y <= size; ++y) {
                                if (!(MathHelper.func_76129_c((float)(x * x + y * y + z * z)) <= (float)size)) continue;
                                world.func_147449_b((int)posX + x, (int)posY + y, (int)posZ + z, BLBlockRegistry.weedwoodBark);
                            }
                        }
                    }
                }
            }
        }
        for (int x = blockX - maxRadius; x <= blockX + maxRadius; ++x) {
            for (int z = blockZ - maxRadius; z <= blockZ + maxRadius; ++z) {
                for (int y = blockY; y < blockY + maxRadius; ++y) {
                    int dist = (int)Math.round(Math.sqrt(Math.pow(x - blockX, 2.0) + Math.pow(z - blockZ, 2.0) + Math.pow(y - blockY, 2.5)));
                    if (dist < maxRadius - 1 && rand.nextInt(4) == 0 && y > blockY && world.func_147439_a(x, y, z) != BLBlockRegistry.weedwoodLog) {
                        world.func_147449_b(x, y, z, BLBlockRegistry.weedwoodLog);
                    }
                    if (dist <= maxRadius && world.func_147439_a(x, y, z) != BLBlockRegistry.weedwoodLog && world.func_147439_a(x, y, z) != BLBlockRegistry.weedwoodBark) {
                        world.func_147465_d(x, y, z, BLBlockRegistry.weedwoodLeaves, 0, 15);
                    }
                    if (dist > maxRadius || rand.nextInt(2) != 0 || y != blockY || world.func_147439_a(x, y, z) != BLBlockRegistry.weedwoodLeaves) continue;
                    int length = rand.nextInt(3) + 1;
                    for (int i = 1; i < length; ++i) {
                        world.func_147465_d(x, y - i, z, BLBlockRegistry.weedwoodLeaves, 0, 15);
                        if (i != 2) continue;
                        this.addHangers(world, rand, x, y - i - 1, z);
                    }
                }
            }
        }
    }

    private void addHangers(World world, Random rand, int x, int startY, int z) {
        if (rand.nextInt(4) == 0) {
            int length = rand.nextInt(10) + 10;
            for (int y = startY; y > startY - length && world.func_147439_a(x, y, z).func_149688_o().func_76222_j(); --y) {
                world.func_147449_b(x, y, z, BLBlockRegistry.hanger);
            }
        }
    }
}

