/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.feature.trees;

import java.util.Random;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.world.feature.trees.WorldGenGiantTree;

public class Fungus {
    private int posX;
    private int posY;
    private int posZ;
    private int radius;

    public Fungus(int posX, int posY, int posZ, int radius) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.radius = radius;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getPosZ() {
        return this.posZ;
    }

    public int getRadius() {
        return this.radius;
    }

    public void generate(World world, Random rand) {
        for (int y = this.posY; y > this.posY - this.radius; y -= 2) {
            if (this.radius > 1) {
                --this.radius;
            }
            ChunkCoordinates center = new ChunkCoordinates(this.posX, y, this.posZ);
            Stack<ChunkCoordinates> pendingCoords = new Stack<ChunkCoordinates>();
            pendingCoords.add(center);
            while (!pendingCoords.isEmpty()) {
                ChunkCoordinates coord = (ChunkCoordinates)pendingCoords.pop();
                if (world.func_147439_a(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c).func_149688_o().func_76222_j() || world.func_147439_a(coord.field_71574_a, coord.field_71572_b + 1, coord.field_71573_c).func_149688_o().func_76222_j()) {
                    world.func_147449_b(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c, BLBlockRegistry.treeFungus);
                }
                for (ForgeDirection direction : WorldGenGiantTree.DIRECTIONS) {
                    ChunkCoordinates neighborCoord = new ChunkCoordinates(coord.field_71574_a + direction.offsetX, coord.field_71572_b, coord.field_71573_c + direction.offsetZ);
                    Block block = world.func_147439_a(neighborCoord.field_71574_a, neighborCoord.field_71572_b, neighborCoord.field_71573_c);
                    Block above = world.func_147439_a(neighborCoord.field_71574_a, neighborCoord.field_71572_b + 1, neighborCoord.field_71573_c);
                    if (pendingCoords.contains(neighborCoord) || this.getDistanceBetweenChunkCoordinates(center, neighborCoord) > this.radius || !block.func_149688_o().func_76222_j() && (!above.func_149688_o().func_76222_j() || block == BLBlockRegistry.treeFungus)) continue;
                    pendingCoords.add(neighborCoord);
                }
            }
        }
    }

    private int getDistanceBetweenChunkCoordinates(ChunkCoordinates a, ChunkCoordinates b) {
        return (int)Math.round(Math.sqrt(a.func_82371_e(b)));
    }
}

