/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.feature.structure;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.BlockBLSpawner;
import thebetweenlands.entities.EntitySwordEnergy;
import thebetweenlands.entities.mobs.boss.fortress.EntityFortressBossTeleporter;
import thebetweenlands.tileentities.TileEntityBLSign;
import thebetweenlands.tileentities.TileEntityItemCage;
import thebetweenlands.tileentities.TileEntityLootPot1;
import thebetweenlands.tileentities.TileEntityWeedWoodChest;
import thebetweenlands.world.loot.LootTables;
import thebetweenlands.world.loot.LootUtil;
import thebetweenlands.world.storage.chunk.storage.StorageHelper;
import thebetweenlands.world.storage.chunk.storage.location.EnumLocationType;
import thebetweenlands.world.storage.chunk.storage.location.LocationAmbience;
import thebetweenlands.world.storage.chunk.storage.location.LocationStorage;

public class WorldGenWightFortress
extends WorldGenerator {
    private int length = 13;
    private int width = 13;
    private int height = 19;
    private int direction = -1;
    private int originX;
    private int originY;
    private int originZ = -1;
    private Block limestonePolished = BLBlockRegistry.polishedLimestone;
    private Block limestoneChiselled = BLBlockRegistry.chiseledLimestone;
    private Block limestoneBrickSlab = BLBlockRegistry.limestoneBrickSlab;
    private Block limestonePolishedCollapsing = BLBlockRegistry.polishedLimestoneCollapsing;
    private Block betweenstone = BLBlockRegistry.betweenstone;
    private Block betweenstoneSmooth = BLBlockRegistry.smoothBetweenstone;
    private Block betweenstoneSmoothMossy = BLBlockRegistry.betweenstoneSmoothMossy;
    private Block betweenstoneTiles = BLBlockRegistry.betweenstoneTiles;
    private Block betweenstoneTilesMossy = BLBlockRegistry.betweenstoneTilesMossy;
    private Block betweenstoneTilesCracked = BLBlockRegistry.betweenstoneTilesCracked;
    private Block betweenstoneTilesCollapsing = BLBlockRegistry.betweenstoneTilesCollapsing;
    private Block betweenstoneTilesMossyCollapsing = BLBlockRegistry.betweenstoneTilesMossyCollapsing;
    private Block betweenstoneBrickStairs = BLBlockRegistry.betweenstoneBrickStairs;
    private Block betweenstoneBrickStairsMossy = BLBlockRegistry.betweenstoneBrickStairsMossy;
    private Block betweenstoneBrickStairsCracked = BLBlockRegistry.betweenstoneBrickStairsCracked;
    private Block betweenstoneBrickSlab = BLBlockRegistry.betweenstoneBrickSlab;
    private Block betweenstoneBrickWall = BLBlockRegistry.betweenstoneBrickWall;
    private Block betweenstoneBrickWallMossy = BLBlockRegistry.betweenstoneBrickWallMossy;
    private Block betweenstoneBrickWallCracked = BLBlockRegistry.betweenstoneBrickWallCracked;
    private Block betweenstoneBricks = BLBlockRegistry.betweenstoneBricks;
    private Block betweenstoneBricksMirage = BLBlockRegistry.betweenstoneBricksMirage;
    private Block betweenstoneBricksMossy = BLBlockRegistry.betweenstoneBricksMossy;
    private Block betweenstoneBricksCracked = BLBlockRegistry.betweenstoneBricksCracked;
    private Block betweenstonePillar = BLBlockRegistry.betweenstonePillar;
    private Block betweenstoneStairsSmooth = BLBlockRegistry.smoothBetweenstoneStairs;
    private Block betweenstoneStairsSmoothMossy = BLBlockRegistry.betweenstoneSmoothStairsMossy;
    private Block betweenstoneTilesFortress = BLBlockRegistry.betweenstoneTilesFortress;
    private Block stagnantWater = BLBlockRegistry.stagnantWaterFluid;
    private Block spikeTrap = BLBlockRegistry.spikeTrap;
    private Block swordStone = BLBlockRegistry.itemCage;
    private Block root = BLBlockRegistry.root;
    private Block possessedBlock = BLBlockRegistry.possessedBlock;
    private Block chest = BLBlockRegistry.weedwoodChest;
    private Block lootPot1 = BLBlockRegistry.lootPot1;
    private Block lootPot2 = BLBlockRegistry.lootPot2;
    private Block lootPot3 = BLBlockRegistry.lootPot3;
    private BlockBLSpawner spawner = BLBlockRegistry.blSpawner;
    private Block obviousSign = BLBlockRegistry.weedwoodWallSign;
    private Block energyBarrier = BLBlockRegistry.energyBarrier;
    private Block valoniteBlock = BLBlockRegistry.valoniteBlock;
    private Block syrmoriteBlock = BLBlockRegistry.syrmoriteBlock;
    private Block octineBlock = BLBlockRegistry.octineBlock;
    private Block mushroomBlackHat = BLBlockRegistry.blackHatMushroom;
    private Block mushroomBulbCapped = BLBlockRegistry.bulbCappedMushroom;
    private Block mushroomflatHead = BLBlockRegistry.flatHeadMushroom;

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        for (int xa = x; xa <= x + 32; ++xa) {
            for (int za = z; za <= z + 32; ++za) {
                for (int ya = y; ya < y + 42; ++ya) {
                    if (world.func_147439_a(xa, ya, za).isAir((IBlockAccess)world, xa, ya, za)) continue;
                    return false;
                }
            }
        }
        List<LocationStorage> addedLocations = StorageHelper.addArea(world, "translate:wightTower", AxisAlignedBB.func_72330_a((double)(x - 10), (double)(y - 10), (double)(z - 10), (double)(x + 42), (double)(y + 80), (double)(z + 42)), EnumLocationType.WIGHT_TOWER, 0, true);
        for (LocationStorage location : addedLocations) {
            location.setAmbience(new LocationAmbience(LocationAmbience.EnumLocationAmbience.WIGHT_TOWER).setFogRangeMultiplier(0.2f).setFogBrightness(80)).getChunkData().markDirty();
        }
        StorageHelper.addArea(world, "translate:wightTowerPuzzle", AxisAlignedBB.func_72330_a((double)(x - 10 + 20), (double)(y + 17), (double)(z - 10 + 20), (double)(x + 42 - 20), (double)(y + 17 + 6), (double)(z + 42 - 20)), EnumLocationType.WIGHT_TOWER, 1, true);
        StorageHelper.addArea(world, "translate:wightTowerTeleporter", AxisAlignedBB.func_72330_a((double)(x - 10 + 23), (double)(y + 17 + 12), (double)(z - 10 + 23), (double)(x + 42 - 23), (double)(y + 17 + 6 + 11), (double)(z + 42 - 23)), EnumLocationType.WIGHT_TOWER, 2, true);
        addedLocations = StorageHelper.addArea(world, "translate:wightTowerBoss", AxisAlignedBB.func_72330_a((double)(x - 10 + 17), (double)(y + 17 + 19), (double)(z - 10 + 17), (double)(x + 42 - 17), (double)(y + 17 + 12 + 32), (double)(z + 42 - 17)), EnumLocationType.WIGHT_TOWER, 3, true);
        for (LocationStorage location : addedLocations) {
            location.setAmbience(new LocationAmbience(LocationAmbience.EnumLocationAmbience.WIGHT_TOWER).setFogRange(12.0f, 20.0f).setFogColorMultiplier(0.1f)).getChunkData().markDirty();
        }
        this.originX = x;
        this.originY = y;
        this.originZ = z;
        return this.generateStructure(world, rand, x, y, z);
    }

    public Block getRandomWall(Random rand) {
        int type = rand.nextInt(3);
        switch (type) {
            case 0: {
                return this.betweenstoneBrickWall;
            }
            case 1: {
                return this.betweenstoneBrickWallMossy;
            }
            case 2: {
                return this.betweenstoneBrickWallCracked;
            }
        }
        return this.betweenstoneBrickWall;
    }

    public Block getRandomBricks(Random rand) {
        int type = rand.nextInt(3);
        switch (type) {
            case 0: {
                return this.betweenstoneBricks;
            }
            case 1: {
                return this.betweenstoneBricksMossy;
            }
            case 2: {
                return this.betweenstoneBricksCracked;
            }
        }
        return this.betweenstoneBricks;
    }

    public Block getRandomTiles(Random rand) {
        int type = rand.nextInt(3);
        switch (type) {
            case 0: {
                return this.betweenstoneTiles;
            }
            case 1: {
                return this.betweenstoneTilesMossy;
            }
            case 2: {
                return this.betweenstoneTilesCracked;
            }
        }
        return this.betweenstoneTiles;
    }

    public Block getRandomMetalBlock(Random rand) {
        int type = rand.nextInt(3);
        switch (type) {
            case 0: {
                return this.syrmoriteBlock;
            }
            case 1: {
                return this.octineBlock;
            }
            case 2: {
                return this.valoniteBlock;
            }
        }
        return this.syrmoriteBlock;
    }

    public Block getRandomMushroom(Random rand) {
        int type = rand.nextInt(3);
        switch (type) {
            case 0: {
                return this.mushroomflatHead;
            }
            case 1: {
                return this.mushroomBlackHat;
            }
            case 2: {
                return this.mushroomBulbCapped;
            }
        }
        return this.mushroomBlackHat;
    }

    public Block getRandomCollapsingTiles(Random rand) {
        return rand.nextBoolean() ? this.betweenstoneTilesCollapsing : this.betweenstoneTilesMossyCollapsing;
    }

    public Block getRandomSmoothBetweenstone(Random rand) {
        return rand.nextBoolean() ? this.betweenstoneSmooth : this.betweenstoneSmoothMossy;
    }

    public Block getRandomSmoothBetweenstoneStairs(Random rand) {
        return rand.nextBoolean() ? this.betweenstoneStairsSmooth : this.betweenstoneStairsSmoothMossy;
    }

    public Block getRandomBetweenstoneBrickStairs(Random rand) {
        int type = rand.nextInt(3);
        switch (type) {
            case 0: {
                return this.betweenstoneBrickStairs;
            }
            case 1: {
                return this.betweenstoneBrickStairsMossy;
            }
            case 2: {
                return this.betweenstoneBrickStairsCracked;
            }
        }
        return this.betweenstoneBrickStairs;
    }

    public boolean generateStructure(World world, Random rand, int xx, int yy, int zz) {
        int count;
        int z;
        int y;
        int x;
        int tower;
        int ya;
        int za;
        int xa;
        for (xa = xx; xa <= xx + 32; ++xa) {
            for (za = zz; za <= zz + 32; ++za) {
                for (ya = yy - 12; ya < yy; ++ya) {
                    if (world.func_147439_a(xa, ya, za).func_149721_r()) continue;
                    world.func_147449_b(xa, ya, za, this.betweenstone);
                }
            }
        }
        for (xa = xx + 8; xa <= xx + 24; ++xa) {
            for (za = zz + 8; za <= zz + 24; ++za) {
                for (ya = yy - 8; ya < yy; ++ya) {
                    world.func_147468_f(xa, ya, za);
                }
            }
        }
        this.length = 32;
        this.width = 32;
        this.direction = 0;
        while (this.direction < 4) {
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 8, -7, 8, this.betweenstoneBricks, 0, 8, 6, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 8, -7, 9, this.betweenstoneBricks, 0, 1, 6, 7, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 8, -8, 8, this.betweenstoneSmooth, 0, 8, 1, 2, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 8, -8, 9, this.betweenstoneSmooth, 0, 2, 1, 7, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, -8, 10, this.betweenstoneTilesFortress, 0, 1, 1, 1, this.direction);
            if (rand.nextBoolean()) {
                this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, -6, 10, (Block)this.spawner, 0, 1, 1, 1, this.direction);
            }
            BlockBLSpawner.setMob(world, xx + 10, yy - 6, zz + 10, rand.nextBoolean() ? "thebetweenlands.swampHag" : (rand.nextBoolean() ? "thebetweenlands.chiromaw" : "thebetweenlands.termite"));
            BlockBLSpawner.setMob(world, xx + 21, yy - 6, zz + 21, rand.nextBoolean() ? "thebetweenlands.swampHag" : (rand.nextBoolean() ? "thebetweenlands.chiromaw" : "thebetweenlands.termite"));
            BlockBLSpawner.setMob(world, xx + 10, yy - 6, zz + 21, rand.nextBoolean() ? "thebetweenlands.swampHag" : (rand.nextBoolean() ? "thebetweenlands.chiromaw" : "thebetweenlands.termite"));
            BlockBLSpawner.setMob(world, xx + 21, yy - 6, zz + 10, rand.nextBoolean() ? "thebetweenlands.swampHag" : (rand.nextBoolean() ? "thebetweenlands.chiromaw" : "thebetweenlands.termite"));
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 11, -8, 10, this.betweenstoneTiles, 0, 5, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, -8, 11, this.betweenstoneTiles, 0, 1, 1, 5, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 11, -8, 11, this.betweenstoneSmooth, 0, 5, 1, 5, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 12, -7, 12, this.betweenstoneStairsSmooth, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 4, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 12, -7, 13, this.betweenstoneStairsSmooth, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 3, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, -7, 13, this.stagnantWater, 0, 3, 1, 3, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, -7, 9, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, -6, 9, this.betweenstonePillar, 0, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, -4, 9, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, -3, 9, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, -3, 10, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 12, -3, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 4 : (this.direction == 1 ? 7 : (this.direction == 2 ? 5 : 6)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, -3, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 5 : (this.direction == 1 ? 6 : (this.direction == 2 ? 4 : 7)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 9, -7, 13, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 9, -6, 13, this.betweenstonePillar, 0, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 9, -4, 13, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 9, -3, 13, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, -3, 13, this.betweenstoneBrickStairs, this.direction == 0 ? 5 : (this.direction == 1 ? 6 : (this.direction == 2 ? 4 : 7)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 9, -3, 14, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 9, -3, 12, this.betweenstoneBrickStairs, this.direction == 0 ? 6 : (this.direction == 1 ? 4 : (this.direction == 2 ? 7 : 5)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 9, -2, 9, this.betweenstoneBricks, 0, 7, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 9, -2, 10, this.betweenstoneBricks, 0, 1, 1, 6, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, -2, 10, this.limestoneBrickSlab, 8, 3, 1, 3, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, -2, 10, this.limestoneBrickSlab, 8, 2, 1, 3, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, -2, 14, this.limestoneBrickSlab, 8, 3, 1, 2, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, -2, 10, this.betweenstoneBricks, 0, 1, 1, 6, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, -2, 13, this.betweenstoneBricks, 0, 6, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 9, -7, 9, this.getRandomMetalBlock(rand), 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 9, -6, 9, this.getRandomMetalBlock(rand), 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 9, -5, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 11, -7, 9, this.getRandomMetalBlock(rand), 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 11, -6, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 9, -7, 11, this.getRandomMetalBlock(rand), 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 9, -6, 11, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 0, -1, 0, this.betweenstoneSmooth, 0, 13, 1, 13, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 5, -1, 4, this.betweenstoneTiles, 0, 3, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 4, -1, 5, this.betweenstoneTiles, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 6, -1, 5, this.limestonePolished, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 7, -1, 5, this.betweenstoneTiles, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 4, -1, 6, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 5, -1, 6, this.limestonePolished, 0, 3, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 8, -1, 6, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 4, -1, 7, this.betweenstoneTiles, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 6, -1, 7, this.limestonePolished, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 7, -1, 7, this.betweenstoneTiles, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 5, -1, 8, this.betweenstoneTiles, 0, 3, 1, 1, this.direction);
            if (rand.nextBoolean()) {
                this.rotatedCubeVolume(world, rand, xx, yy, zz, 6, 2, 6, (Block)this.spawner, 0, 1, 1, 1, this.direction);
            }
            BlockBLSpawner.setMob(world, xx + 6, yy + 2, zz + 6, rand.nextBoolean() ? "thebetweenlands.swampHag" : "thebetweenlands.chiromaw");
            BlockBLSpawner.setMob(world, xx + 25, yy + 2, zz + 6, rand.nextBoolean() ? "thebetweenlands.swampHag" : "thebetweenlands.chiromaw");
            BlockBLSpawner.setMob(world, xx + 25, yy + 2, zz + 25, rand.nextBoolean() ? "thebetweenlands.swampHag" : "thebetweenlands.chiromaw");
            BlockBLSpawner.setMob(world, xx + 6, yy + 2, zz + 25, rand.nextBoolean() ? "thebetweenlands.swampHag" : "thebetweenlands.chiromaw");
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 3, 5, 3, this.limestonePolished, 0, 7, 1, 7, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 6, 5, 5, this.limestoneChiselled, 0, 1, 1, 3, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 5, 5, 6, this.limestoneChiselled, 0, 3, 1, 1, this.direction);
            if (rand.nextBoolean()) {
                this.rotatedCubeVolume(world, rand, xx, yy, zz, 6, 8, 6, (Block)this.spawner, 0, 1, 1, 1, this.direction);
            }
            BlockBLSpawner.setMob(world, xx + 6, yy + 8, zz + 6, "thebetweenlands.pyrad");
            BlockBLSpawner.setMob(world, xx + 25, yy + 8, zz + 6, "thebetweenlands.pyrad");
            BlockBLSpawner.setMob(world, xx + 25, yy + 8, zz + 25, "thebetweenlands.pyrad");
            BlockBLSpawner.setMob(world, xx + 6, yy + 8, zz + 25, "thebetweenlands.pyrad");
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 4, 11, 4, this.limestonePolished, 0, 5, 1, 5, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 6, 11, 6, this.limestoneChiselled, 0, 1, 1, 1, this.direction);
            if (rand.nextBoolean()) {
                this.rotatedCubeVolume(world, rand, xx, yy, zz, 6, 14, 6, (Block)this.spawner, 0, 1, 1, 1, this.direction);
            }
            BlockBLSpawner.setMob(world, xx + 6, yy + 14, zz + 6, "thebetweenlands.termite");
            BlockBLSpawner.setMob(world, xx + 25, yy + 14, zz + 6, "thebetweenlands.termite");
            BlockBLSpawner.setMob(world, xx + 25, yy + 14, zz + 25, "thebetweenlands.termite");
            BlockBLSpawner.setMob(world, xx + 6, yy + 14, zz + 25, "thebetweenlands.termite");
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 4, 16, 4, this.limestoneChiselled, 0, 5, 1, 5, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 5, 16, 4, this.betweenstoneTiles, 0, 3, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 4, 16, 5, this.betweenstoneTiles, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 6, 16, 5, this.limestonePolished, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 7, 16, 5, this.betweenstoneTiles, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 4, 16, 6, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 5, 16, 6, this.limestonePolished, 0, 3, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 8, 16, 6, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 4, 16, 7, this.betweenstoneTiles, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 6, 16, 7, this.limestonePolished, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 7, 16, 7, this.betweenstoneTiles, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 5, 16, 8, this.betweenstoneTiles, 0, 3, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 6, 19, 6, (Block)this.spawner, 0, 1, 1, 1, this.direction);
            BlockBLSpawner.setMob(world, xx + 6, yy + 19, zz + 6, "thebetweenlands.wight");
            if (BlockBLSpawner.getLogic(world, xx + 6, yy + 19, zz + 6) != null) {
                BlockBLSpawner.getLogic(world, xx + 6, yy + 19, zz + 6).setCheckRange(16.0).setDelay(3000, 5000).setMaxEntities(1);
            }
            BlockBLSpawner.setMob(world, xx + 25, yy + 19, zz + 6, "thebetweenlands.wight");
            if (BlockBLSpawner.getLogic(world, xx + 25, yy + 19, zz + 6) != null) {
                BlockBLSpawner.getLogic(world, xx + 25, yy + 19, zz + 6).setCheckRange(16.0).setDelay(3000, 5000).setMaxEntities(1);
            }
            BlockBLSpawner.setMob(world, xx + 25, yy + 19, zz + 25, "thebetweenlands.wight");
            if (BlockBLSpawner.getLogic(world, xx + 25, yy + 19, zz + 25) != null) {
                BlockBLSpawner.getLogic(world, xx + 25, yy + 19, zz + 25).setCheckRange(16.0).setDelay(3000, 5000).setMaxEntities(1);
            }
            BlockBLSpawner.setMob(world, xx + 6, yy + 19, zz + 25, "thebetweenlands.wight");
            if (BlockBLSpawner.getLogic(world, xx + 6, yy + 19, zz + 25) != null) {
                BlockBLSpawner.getLogic(world, xx + 6, yy + 19, zz + 25).setCheckRange(16.0).setDelay(3000, 5000).setMaxEntities(1);
            }
            if (rand.nextBoolean()) {
                this.rotatedCubeVolume(world, rand, xx, yy, zz, 16, 26, 16, (Block)this.spawner, 0, 1, 1, 1, this.direction);
            }
            BlockBLSpawner.setMob(world, xx + 16, yy + 26, zz + 16, "thebetweenlands.chiromaw");
            BlockBLSpawner.setMob(world, xx + 16, yy + 26, zz + 15, "thebetweenlands.chiromaw");
            BlockBLSpawner.setMob(world, xx + 15, yy + 26, zz + 16, "thebetweenlands.chiromaw");
            BlockBLSpawner.setMob(world, xx + 15, yy + 26, zz + 15, "thebetweenlands.chiromaw");
            ++this.direction;
        }
        this.length = 13;
        this.width = 13;
        for (tower = 0; tower < 5; ++tower) {
            x = xx;
            y = yy;
            z = zz;
            if (tower == 1) {
                x = xx + 19;
            }
            if (tower == 2) {
                x = xx + 19;
                z = zz + 19;
            }
            if (tower == 3) {
                z = zz + 19;
            }
            this.direction = 0;
            while (this.direction < 4) {
                if (tower < 4) {
                    this.rotatedCubeVolume(world, rand, x, y, z, 3, 2, 1, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 7, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 2, 4, 2, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 8, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 0, 0, 1, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 0, 0, 3, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 1, 0, 0, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 3, 0, 0, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 5, 0, 0, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 7, 0, 0, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 1, 0, 1, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 1, 3, 1, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 2, 0, 1, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 4, 0, 1, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 8, 0, 1, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 2, 0, 0, this.betweenstoneBrickWall, 0, 1, 4, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 4, 0, 0, this.betweenstoneBrickWall, 0, 1, 4, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 8, 0, 0, this.betweenstoneBrickWall, 0, 1, 4, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 0, 0, 0, this.betweenstoneBrickWall, 0, 1, 4, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 0, 0, 2, this.betweenstoneBrickWall, 0, 1, 4, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 4, 4, 2, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 8, 4, 2, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 6, 10, 3, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 0, 4, 0, this.betweenstoneBrickWall, 0, 9, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 0, 4, 1, this.betweenstoneBrickWall, 0, 1, 1, 3, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 1, 4, 1, this.betweenstoneBrickWall, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 3, 4, 1, this.betweenstoneBrickWall, 0, 1, 6, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 1, 4, 3, this.betweenstoneBrickWall, 0, 1, 6, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 2, 6, 1, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 1, 6, 2, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 2, 7, 2, this.betweenstoneBrickWall, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 3, 9, 2, this.betweenstoneBrickWall, 0, 1, 6, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 2, 9, 3, this.betweenstoneBrickWall, 0, 1, 6, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 3, 14, 3, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 3, 16, 2, this.betweenstoneBrickWall, 0, 1, 4, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 2, 16, 3, this.betweenstoneBrickWall, 0, 1, 4, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 2, 17, 2, this.betweenstoneBrickWall, 0, 1, 4, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 3, 17, 1, this.betweenstoneBrickWall, 0, 4, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 1, 17, 3, this.betweenstoneBrickWall, 0, 1, 1, 3, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 4, 16, 1, this.betweenstoneBrickWall, 0, 5, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 5, 16, 0, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 5, 15, 1, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 5, 18, 1, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 5, 18, 2, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 7, 16, 0, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 7, 15, 1, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 7, 18, 1, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 7, 18, 2, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 5, 10, 2, this.betweenstoneBrickWall, 0, 1, 7, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 6, 14, 2, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 7, 10, 2, this.betweenstoneBrickWall, 0, 1, 7, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 5, 10, 1, this.betweenstoneBrickWall, 0, 3, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 5, 5, 1, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 6, 8, 1, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 7, 5, 1, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 5, 5, 0, this.betweenstoneBrickWall, 0, 3, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 4, 9, 1, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 8, 9, 1, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 4, 3, 2, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 4, 4, 3, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 8, 3, 2, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 8, 4, 3, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 4, 4, 4, this.betweenstoneBrickSlab, 8, 5, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 1, 3, 2, this.betweenstoneBricks, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 2, 3, 1, this.betweenstoneBricks, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 1, 0, 2, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 4, 4, 1, this.betweenstoneBricks, 0, 1, 4, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 8, 4, 1, this.betweenstoneBricks, 0, 1, 4, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 2, 5, 2, this.betweenstoneBricks, 0, 1, 2, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 2, 5, 3, this.betweenstoneBricks, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 3, 5, 2, this.betweenstoneBricks, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 2, 3, 1, this.betweenstoneBricks, 0, 7, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 1, 3, 3, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 3, 8, 3, this.betweenstoneBricks, 0, 1, 6, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 4, 8, 2, this.betweenstoneBricks, 0, 1, 11, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 8, 8, 2, this.betweenstoneBricks, 0, 1, 11, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 6, 16, 2, this.betweenstoneBricks, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 5, 17, 2, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 7, 17, 2, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 6, 16, 3, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 4, 10, 3, this.betweenstoneBricks, 0, 1, 8, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 8, 10, 3, this.betweenstoneBricks, 0, 1, 8, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 5, 10, 3, this.betweenstoneBricks, 0, 1, 7, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 7, 10, 3, this.betweenstoneBricks, 0, 1, 7, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 4, 5, 2, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 7, 5, 2, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 5, 6, 2, this.betweenstoneBricks, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 7, 6, 2, this.betweenstoneBricks, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 6, 15, 3, this.betweenstoneTilesFortress, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 6, 14, 3, this.betweenstoneBrickSlab, 8, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 6, 9, 2, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 6, 8, 2, this.betweenstoneBrickSlab, 8, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 6, 3, 0, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 6, 2, 0, this.betweenstoneBrickSlab, 8, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 1, 3, 0, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 3, 3, 0, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 5, 3, 0, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 7, 3, 0, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 5, 9, 2, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 7, 9, 2, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 6, 5, 2, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 0, 3, 1, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 0, 3, 3, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 2, 8, 3, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 3, 8, 2, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 4, 8, 1, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 8, 8, 1, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 6, 11, 4, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 3, 0, 1, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 9, 0, 1, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 4, 6, 2, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, x, y, z, 8, 6, 2, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
                    if (tower == 0 && this.direction == 0 || tower == 0 && this.direction == 1 || tower == 1 && this.direction == 0 || tower == 1 && this.direction == 3 || tower == 2 && this.direction == 2 || tower == 2 && this.direction == 3 || tower == 3 && this.direction == 1 || tower == 3 && this.direction == 2) {
                        this.rotatedCubeVolume(world, rand, x, y, z, 6, 10, 2, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
                    }
                    this.rotatedCubeVolume(world, rand, x, y, z, 4, 12, 4, this.chest, this.direction == 0 ? 3 : (this.direction == 1 ? 5 : (this.direction == 2 ? 2 : 4)), 1, 1, 1, this.direction);
                    if (tower == 0 && this.direction == 0 || tower == 0 && this.direction == 1 || tower == 1 && this.direction == 0 || tower == 1 && this.direction == 3 || tower == 2 && this.direction == 2 || tower == 2 && this.direction == 3 || tower == 3 && this.direction == 1 || tower == 3 && this.direction == 2) {
                        this.rotatedCubeVolume(world, rand, x, y, z, 5, 17, 3, this.chest, this.direction == 0 ? 3 : (this.direction == 1 ? 5 : (this.direction == 2 ? 2 : 4)), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 6, 17, 3, this.chest, this.direction == 0 ? 3 : (this.direction == 1 ? 5 : (this.direction == 2 ? 2 : 4)), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 7, 17, 3, this.chest, this.direction == 0 ? 3 : (this.direction == 1 ? 5 : (this.direction == 2 ? 2 : 4)), 1, 1, 1, this.direction);
                    }
                }
                ++this.direction;
            }
        }
        for (tower = 0; tower < 5; ++tower) {
            x = xx;
            y = yy;
            z = zz;
            if (tower == 1) {
                x = xx + 19;
            }
            if (tower == 2) {
                x = xx + 19;
                z = zz + 19;
            }
            if (tower == 3) {
                z = zz + 19;
            }
            this.direction = 0;
            while (this.direction < 4) {
                if (tower < 4) {
                    if (tower == 0 && this.direction == 0 || tower == 0 && this.direction == 1 || tower == 1 && this.direction == 0 || tower == 1 && this.direction == 3 || tower == 2 && this.direction == 2 || tower == 2 && this.direction == 3 || tower == 3 && this.direction == 1 || tower == 3 && this.direction == 2) {
                        this.rotatedCubeVolume(world, rand, x, y, z, 5, 4, 11, this.betweenstoneTiles, 0, 3, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 4, 5, 12, this.betweenstoneBricks, 0, 1, 1, 4, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 8, 5, 12, this.betweenstoneBricks, 0, 1, 1, 4, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 5, 4, 1, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 3, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 6, 10, 3, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 5, 5, 11, Blocks.field_150350_a, 0, 3, 5, 2, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 4, 6, 12, this.betweenstoneBrickWall, 0, 1, 1, 4, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 8, 6, 12, this.betweenstoneBrickWall, 0, 1, 1, 4, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 4, 7, 14, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 8, 7, 14, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 4, 9, 11, this.betweenstoneBricks, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 8, 9, 11, this.betweenstoneBricks, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 4, 10, 11, this.betweenstoneBrickWall, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 8, 10, 11, this.betweenstoneBrickWall, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 5, 10, 10, this.betweenstoneTilesCollapsing, 0, 3, 1, 6, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 4, 11, 11, this.betweenstoneBricks, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 8, 11, 11, this.betweenstoneBricks, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 4, 12, 11, this.betweenstoneBrickWall, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 8, 12, 11, this.betweenstoneBrickWall, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 4, 13, 14, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 8, 13, 14, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 4, 15, 11, this.betweenstoneBricks, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 8, 15, 11, this.betweenstoneBricks, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 5, 16, 10, this.betweenstoneTiles, 0, 3, 1, 6, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 5, 11, 10, Blocks.field_150350_a, 0, 3, 5, 2, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 5, 17, 10, Blocks.field_150350_a, 0, 3, 4, 3, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 4, 5, 12, this.possessedBlock, tower == 0 && this.direction == 0 ? 5 : (tower == 0 && this.direction == 1 ? 2 : (tower == 1 && this.direction == 0 ? 5 : (tower == 1 && this.direction == 3 ? 3 : (tower == 2 && this.direction == 2 ? 4 : (tower == 2 && this.direction == 3 ? 3 : (tower == 3 && this.direction == 1 ? 2 : 4)))))), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 7, 5, 11, this.lootPot1, this.direction == 0 ? 5 : (this.direction == 1 ? 3 : (this.direction == 2 ? 4 : 2)), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 7, 5, 12, this.lootPot1, this.direction == 0 ? 5 : (this.direction == 1 ? 3 : (this.direction == 2 ? 4 : 2)), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 7, 5, 13, this.lootPot1, this.direction == 0 ? 5 : (this.direction == 1 ? 3 : (this.direction == 2 ? 4 : 2)), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 7, 11, 10, this.lootPot1, this.direction == 0 ? 5 : (this.direction == 1 ? 3 : (this.direction == 2 ? 4 : 2)), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 7, 11, 11, this.lootPot1, this.direction == 0 ? 5 : (this.direction == 1 ? 3 : (this.direction == 2 ? 4 : 2)), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 7, 11, 12, this.lootPot1, this.direction == 0 ? 5 : (this.direction == 1 ? 3 : (this.direction == 2 ? 4 : 2)), 1, 1, 1, this.direction);
                    }
                    if (tower == 0 && this.direction == 0 || tower == 1 && this.direction == 3 || tower == 2 && this.direction == 2 || tower == 3 && this.direction == 1) {
                        this.rotatedCubeVolume(world, rand, x, y, z, 8, 16, 11, this.betweenstoneBricks, 0, 1, 3, 4, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 7, 17, 15, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 8, 17, 15, this.spikeTrap, 0, 3, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 9, 17, 14, this.betweenstoneBricks, 0, 2, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 8, 19, 10, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 8, 19, 12, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 8, 19, 14, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 8, 21, 10, this.betweenstoneBrickSlab, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 4, 16, 12, this.betweenstoneBrickWall, 0, 1, 2, 4, this.direction);
                    }
                    if (tower == 0 && this.direction == 1 || tower == 1 && this.direction == 0 || tower == 2 && this.direction == 3 || tower == 3 && this.direction == 2) {
                        this.rotatedCubeVolume(world, rand, x, y, z, 4, 16, 11, this.betweenstoneBricks, 0, 1, 3, 4, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 5, 17, 15, this.betweenstoneBrickStairs, this.direction == 0 ? 1 : (this.direction == 1 ? 2 : (this.direction == 2 ? 0 : 3)), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 2, 17, 15, this.spikeTrap, 0, 3, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 2, 17, 14, this.betweenstoneBricks, 0, 2, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 4, 19, 10, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 4, 19, 12, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 4, 19, 14, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 4, 21, 10, this.betweenstoneBrickSlab, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, x, y, z, 8, 16, 12, this.betweenstoneBrickWall, 0, 1, 2, 4, this.direction);
                    }
                }
                if (tower == 4) {
                    this.length = 14;
                    this.width = 14;
                    x = xx + 9;
                    z = zz + 9;
                    y = yy + 18;
                    this.generateTopTowerRight(world, rand, x, y, z, this.direction);
                    this.generateTopTowerLeft(world, rand, x, y, z, this.direction);
                }
                ++this.direction;
            }
        }
        this.length = 32;
        this.width = 32;
        this.direction = 0;
        while (this.direction < 4) {
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, 22, 10, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 11, 23, 10, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, 23, 11, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 11, 24, 11, this.betweenstoneBrickWall, 0, 1, 3, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 12, 26, 11, this.betweenstoneBrickWall, 0, 1, 12, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 11, 26, 12, this.betweenstoneBrickWall, 0, 1, 12, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 12, 32, 12, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 11, 34, 11, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 12, 35, 10, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, 35, 12, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 32, 11, this.betweenstoneBrickWall, 0, 1, 3, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 11, 32, 14, this.betweenstoneBrickWall, 0, 1, 3, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 15, 32, 11, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 11, 32, 15, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 33, 10, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, 33, 14, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 34, 9, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 9, 34, 14, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 15, 34, 10, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, 34, 15, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 36, 11, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 11, 36, 14, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 26, 10, this.betweenstoneBrickWall, 0, 1, 11, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, 26, 13, this.betweenstoneBrickWall, 0, 1, 11, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 12, 22, 10, this.betweenstoneBrickWall, 0, 1, 4, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, 22, 12, this.betweenstoneBrickWall, 0, 1, 4, 1, this.direction);
            ++this.direction;
        }
        this.direction = 0;
        while (this.direction < 4) {
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 0, 9, this.betweenstonePillar, 0, 1, 3, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 3, 9, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 4, 9, this.betweenstonePillar, 0, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 9, 9, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 10, 9, this.betweenstonePillar, 0, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 15, 9, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 16, 9, this.betweenstonePillar, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 0, 9, this.betweenstonePillar, 0, 1, 3, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 3, 9, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 4, 9, this.betweenstonePillar, 0, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 9, 9, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 10, 9, this.betweenstonePillar, 0, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 15, 9, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 16, 9, this.betweenstonePillar, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 3, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 5 : (this.direction == 1 ? 6 : (this.direction == 2 ? 4 : 7)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 17, 3, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 4 : (this.direction == 1 ? 7 : (this.direction == 2 ? 5 : 6)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 4, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 17, 4, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 1 : (this.direction == 1 ? 2 : (this.direction == 2 ? 0 : 3)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 15, 4, 9, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 12, 3, 9, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 11, 4, 9, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 12, 4, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 1 : (this.direction == 1 ? 2 : (this.direction == 2 ? 0 : 3)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 19, 3, 9, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 20, 4, 9, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 19, 4, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 9, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 5 : (this.direction == 1 ? 6 : (this.direction == 2 ? 4 : 7)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 17, 9, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 4 : (this.direction == 1 ? 7 : (this.direction == 2 ? 5 : 6)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 10, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 17, 10, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 1 : (this.direction == 1 ? 2 : (this.direction == 2 ? 0 : 3)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 15, 10, 9, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 12, 9, 9, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, 10, 9, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 12, 10, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 1 : (this.direction == 1 ? 2 : (this.direction == 2 ? 0 : 3)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 19, 9, 9, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 20, 10, 9, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 19, 10, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 15, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 5 : (this.direction == 1 ? 6 : (this.direction == 2 ? 4 : 7)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 17, 15, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 4 : (this.direction == 1 ? 7 : (this.direction == 2 ? 5 : 6)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 16, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 17, 16, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 1 : (this.direction == 1 ? 2 : (this.direction == 2 ? 0 : 3)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 15, 16, 9, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 12, 15, 9, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, 16, 9, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 12, 16, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 1 : (this.direction == 1 ? 2 : (this.direction == 2 ? 0 : 3)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 19, 15, 9, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 20, 16, 9, this.betweenstoneBricks, 0, 3, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 22, 15, 9, this.betweenstoneBrickSlab, 8, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 19, 16, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 15, 10, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 16, 10, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 16, 11, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 16, 12, this.betweenstoneBrickSlab, 8, 1, 1, 2, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 16, 12, this.betweenstoneBrickSlab, 8, 4, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 15, 10, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 16, 10, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 16, 11, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 16, 12, this.betweenstoneBrickSlab, 8, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, -1, 5, this.betweenstoneTiles, 0, 6, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, -1, 13, this.betweenstoneStairsSmooth, this.direction == 0 ? 3 : (this.direction == 1 ? 1 : (this.direction == 2 ? 2 : 0)), 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 17, -1, 13, this.betweenstoneStairsSmooth, this.direction == 0 ? 3 : (this.direction == 1 ? 1 : (this.direction == 2 ? 2 : 0)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, -1, 13, this.betweenstoneStairsSmooth, this.direction == 0 ? 3 : (this.direction == 1 ? 1 : (this.direction == 2 ? 2 : 0)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, -1, 6, this.betweenstoneStairsSmooth, this.direction == 0 ? 3 : (this.direction == 1 ? 1 : (this.direction == 2 ? 2 : 0)), 4, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, -1, 7, this.betweenstoneStairsSmooth, this.direction == 0 ? 1 : (this.direction == 1 ? 2 : (this.direction == 2 ? 0 : 3)), 1, 1, 6, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 15, -1, 7, this.betweenstoneSmooth, 0, 2, 1, 2, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 17, -1, 7, this.betweenstoneStairsSmooth, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 6, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 15, -1, 9, this.betweenstoneStairsSmooth, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 15, -1, 10, this.betweenstoneSmooth, 0, 2, 1, 3, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 15, -1, 13, this.betweenstoneStairsSmooth, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, -1, 6, this.betweenstoneTiles, 0, 1, 1, 7, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, -1, 6, this.betweenstoneTiles, 0, 1, 1, 7, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 12, -1, 12, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, -1, 14, this.betweenstoneSmooth, 0, 3, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 15, -1, 15, this.stagnantWater, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 15, -2, 15, this.stagnantWater, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 3, 5, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 6, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 0, 5, this.root, 0, 1, rand.nextBoolean() ? rand.nextInt(3) + 1 : 0, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 0, 5, this.root, 0, 1, rand.nextBoolean() ? rand.nextInt(3) + 1 : 0, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 5, 0, 13, this.root, 0, 1, rand.nextBoolean() ? rand.nextInt(3) + 1 : 0, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 5, 0, 18, this.root, 0, 1, rand.nextBoolean() ? rand.nextInt(3) + 1 : 0, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 0, 11, this.root, 0, 1, rand.nextBoolean() ? rand.nextInt(3) + 2 : 0, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 0, 11, this.root, 0, 1, rand.nextBoolean() ? rand.nextInt(3) + 2 : 0, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 11, 0, 13, this.root, 0, 1, rand.nextBoolean() ? rand.nextInt(3) + 2 : 0, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 11, 0, 18, this.root, 0, 1, rand.nextBoolean() ? rand.nextInt(3) + 2 : 0, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 11, 4, 11, this.root, 0, 1, rand.nextInt(3) + 3, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 0, 14, this.root, 0, 1, rand.nextBoolean() ? rand.nextInt(4) + 4 : 0, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 16, 0, 14, this.root, 0, 1, rand.nextBoolean() ? rand.nextInt(3) + 2 : 0, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 0, 10, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 0, 10, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 15, 5, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 16, 5, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 11, 11, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 15, 11, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 16, 11, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 20, 11, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            ++this.direction;
        }
        this.direction = rand.nextInt(4);
        for (xa = xx + 1; xa <= xx + 31; ++xa) {
            for (za = zz + 1; za <= zz + 31; ++za) {
                if (!world.func_147439_a(xa, yy - 1, za).func_149721_r() || !world.func_147439_a(xa, yy, za).isAir((IBlockAccess)world, xa, yy, za) || rand.nextInt(8) != 0) continue;
                world.func_147449_b(xa, yy, za, this.getRandomMushroom(rand));
            }
        }
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 0, 3, this.betweenstoneBricks, 0, 1, 5, 2, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 0, 2, this.betweenstoneBricks, 0, 1, 4, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 0, 1, this.betweenstoneBricks, 0, 1, 3, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 0, 0, this.betweenstoneBricks, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 0, 3, this.betweenstoneBricks, 0, 1, 5, 2, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 0, 2, this.betweenstoneBricks, 0, 1, 4, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 0, 1, this.betweenstoneBricks, 0, 1, 3, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 0, 0, this.betweenstoneBricks, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 0, 1, this.betweenstoneBricks, 0, 4, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 2, 4, this.betweenstoneBricks, 0, 4, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 2, 3, this.betweenstoneBricks, 0, 4, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 15, 0, 4, this.betweenstoneBricks, 0, 2, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 0, 4, this.betweenstoneBricksMirage, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 17, 0, 4, this.betweenstoneBricksMirage, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, -1, 0, this.betweenstoneTiles, 0, 4, 1, 4, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 15, 0, 3, this.chest, this.direction == 0 ? 4 : (this.direction == 1 ? 3 : (this.direction == 2 ? 5 : 2)), 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 16, 0, 3, this.chest, this.direction == 0 ? 4 : (this.direction == 1 ? 3 : (this.direction == 2 ? 5 : 2)), 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 5, 3, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 4, 2, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 3, 1, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 2, 0, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 5, 3, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 4, 2, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 3, 1, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 2, 0, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 7, 4, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 7, 4, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 0, 0, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 4, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 1, 1, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 4, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 2, 2, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 4, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 3, 3, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 4, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 4, 4, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 4, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 5, 3, Blocks.field_150350_a, 0, 4, 4, 2, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 4, 0, 13, this.betweenstone, 0, 1, 4, 6, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 4, 4, 14, this.betweenstone, 0, 1, 1, 4, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 3, 0, 14, this.betweenstone, 0, 1, 3, 4, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 3, 3, 15, this.betweenstone, 0, 1, 1, 2, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 27, 0, 13, this.betweenstone, 0, 1, 4, 6, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 27, 4, 14, this.betweenstone, 0, 1, 1, 4, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 28, 0, 14, this.betweenstone, 0, 1, 3, 4, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 28, 3, 15, this.betweenstone, 0, 1, 1, 2, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 0, 27, this.betweenstone, 0, 6, 4, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 4, 27, this.betweenstone, 0, 4, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 0, 28, this.betweenstone, 0, 4, 3, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 15, 3, 28, this.betweenstone, 0, 2, 1, 1, this.direction);
        for (count = 0; count < 6; ++count) {
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 16 + count, 5 + count, 24, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
        }
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 17, 5, 24, this.betweenstoneBricks, 0, 4, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 6, 24, this.betweenstoneBricks, 0, 3, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 19, 7, 24, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 20, 8, 24, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 19, 5, 23, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 10, 24, Blocks.field_150350_a, 0, 3, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 22, 12, 24, this.possessedBlock, this.direction == 0 ? 4 : (this.direction == 1 ? 3 : (this.direction == 2 ? 5 : 2)), 1, 1, 1, this.direction);
        for (count = 0; count < 6; ++count) {
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 16 - count, 11 + count, 7, this.betweenstoneBrickStairs, this.direction == 0 ? 1 : (this.direction == 1 ? 2 : (this.direction == 2 ? 0 : 3)), 1, 1, 1, this.direction);
        }
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, 11, 7, this.betweenstoneBricks, 0, 6, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, 12, 7, this.betweenstoneBricks, 0, 5, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, 13, 7, this.betweenstoneBricks, 0, 4, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, 14, 7, this.betweenstoneBricks, 0, 3, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, 15, 7, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 10, 16, 7, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 12, 16, 7, Blocks.field_150350_a, 0, 3, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 17, 19, 23, Blocks.field_150350_a, 0, 3, 3, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 23, 17, 22, this.betweenstoneBricks, 0, 1, 4, 2, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 22, 21, 10, this.betweenstoneBrickSlab, 0, 2, 1, 14, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 22, 21, 14, this.betweenstoneBricks, 0, 1, 1, 4, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 22, 21, 10, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 22, 18, 22, this.betweenstoneBricks, 0, 1, 3, 2, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 19, 19, 23, this.betweenstoneBricks, 0, 3, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 20, 20, 23, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
        for (count = 0; count < 3; ++count) {
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 17 + count, 18 + count, 23, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
        }
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 19, 22, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 20, 21, 22, this.betweenstoneBrickSlab, 0, 1, 1, 1, this.direction);
        for (count = 0; count < 6; ++count) {
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 22 - count, 22 + count, 10, this.betweenstoneBrickStairs, this.direction == 0 ? 1 : (this.direction == 1 ? 2 : (this.direction == 2 ? 0 : 3)), 1, 1, 1, this.direction);
        }
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 27, 10, Blocks.field_150350_a, 0, 1, 5, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 21, 22, 10, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 19, 22, 10, this.betweenstoneBricks, 0, 1, 3, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 15, 27, 10, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 27, 10, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 26, 10, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 17, 26, 10, this.betweenstoneBrickStairs, this.direction == 0 ? 4 : (this.direction == 1 ? 7 : (this.direction == 2 ? 5 : 6)), 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 26, 10, this.betweenstoneBrickStairs, this.direction == 0 ? 5 : (this.direction == 1 ? 6 : (this.direction == 2 ? 4 : 7)), 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 17, 29, 11, this.obviousSign, this.direction == 0 ? 2 : (this.direction == 1 ? 4 : (this.direction == 2 ? 3 : 5)), 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 9, 17, 9, this.limestonePolished, 0, 5, 1, 2, 0);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 9, 17, 11, this.limestonePolished, 0, 2, 1, 3, 0);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 9, 17, 18, this.limestonePolished, 0, 2, 1, 3, 0);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 9, 17, 21, this.limestonePolished, 0, 5, 1, 2, 0);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 17, 21, this.limestonePolished, 0, 5, 1, 2, 0);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 17, 9, this.limestonePolished, 0, 5, 1, 2, 0);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 21, 17, 11, this.limestonePolished, 0, 2, 1, 3, 0);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 21, 17, 18, this.limestonePolished, 0, 2, 1, 3, 0);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 11, 17, 11, this.spikeTrap, 0, 10, 1, 10, 0);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 9, 17, 9, this.betweenstoneBricks, 0, 1, 1, 1, 0);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 22, 17, 22, this.betweenstoneBricks, 0, 1, 1, 1, 0);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 9, 17, 22, this.betweenstoneBricks, 0, 1, 1, 1, 0);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 22, 17, 9, this.betweenstoneBricks, 0, 1, 1, 1, 0);
        this.setSwordStone(world, rand, xx + 12, yy + 22, zz + 12, this.swordStone, 0, (byte)0);
        this.setSwordStone(world, rand, xx + 19, yy + 22, zz + 12, this.swordStone, 0, (byte)1);
        this.setSwordStone(world, rand, xx + 19, yy + 22, zz + 19, this.swordStone, 0, (byte)2);
        this.setSwordStone(world, rand, xx + 12, yy + 22, zz + 19, this.swordStone, 0, (byte)3);
        EntitySwordEnergy swordEnergy = new EntitySwordEnergy(world);
        swordEnergy.func_70107_b((double)xx + 16.0, (double)yy + 21.5, (double)zz + 16.0);
        world.func_72838_d((Entity)swordEnergy);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 12, 23, 12, this.limestonePolishedCollapsing, 0, 8, 1, 8, 0);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 16, 24, 16, this.chest, this.direction == 0 ? 5 : (this.direction == 1 ? 2 : (this.direction == 2 ? 4 : 3)), 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 16, 24, 15, this.chest, this.direction == 0 ? 5 : (this.direction == 1 ? 2 : (this.direction == 2 ? 4 : 3)), 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 28, 13, this.limestonePolished, 0, 6, 1, 6, 0);
        EntityFortressBossTeleporter tp = new EntityFortressBossTeleporter(world);
        tp.func_70012_b(xx + 16, yy + 30, zz + 16, 0.0f, 0.0f);
        tp.setTeleportDestination(Vec3.func_72443_a((double)(xx + 16), (double)((double)(yy + 17) + 19.2), (double)(zz + 16)));
        tp.setBossSpawnPosition(Vec3.func_72443_a((double)(xx + 16), (double)((double)(yy + 17 + 19) + 5.2), (double)(zz + 16)));
        world.func_72838_d((Entity)tp);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 35, 13, this.betweenstoneTiles, 0, 6, 1, 6, 0);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 35, 12, this.betweenstoneTiles, 0, 4, 1, 1, 0);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 35, 19, this.betweenstoneTiles, 0, 4, 1, 1, 0);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 12, 35, 14, this.betweenstoneTiles, 0, 1, 1, 4, 0);
        this.rotatedCubeVolume(world, rand, xx, yy, zz, 19, 35, 14, this.betweenstoneTiles, 0, 1, 1, 4, 0);
        this.direction = 0;
        while (this.direction < 4) {
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 12, 17, 7, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 17, 7, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 17, 7, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 11, 18, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 13, 18, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 17, 17, 7, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 17, 7, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 19, 17, 7, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 18, 18, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 20, 18, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 15, 22, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 16, 22, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 15, 28, 11, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 16, 28, 11, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 12, 18, 10, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 14, 19, 10, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 17, 19, 10, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 19, 18, 10, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, xx, yy, zz, 15, 29, 13, this.energyBarrier, 0, 2, 4, 1, this.direction);
            ++this.direction;
        }
        return true;
    }

    private void placeChest(World world, Random rand, int x, int y, int z, Block blockType, int blockMeta) {
        world.func_147465_d(x, y, z, this.chest, blockMeta, 2);
        TileEntityWeedWoodChest lootChest = (TileEntityWeedWoodChest)world.func_147438_o(x, y, z);
        if (lootChest != null) {
            world.func_72921_c(x, y, z, blockMeta, 3);
            LootUtil.generateLoot((IInventory)lootChest, rand, LootTables.DUNGEON_CHEST_LOOT, 4, 8);
        }
    }

    private void placeRandomisedLootPot(World world, Random rand, int x, int y, int z, Block blockType, int blockMeta) {
        if (rand.nextInt(5) != 0 || world.func_147437_c(x, y - 1, z)) {
            return;
        }
        world.func_147465_d(x, y, z, blockType, blockMeta, 2);
        TileEntityLootPot1 lootPot = (TileEntityLootPot1)world.func_147438_o(x, y, z);
        if (lootPot != null) {
            LootUtil.generateLoot((IInventory)lootPot, rand, LootTables.DUNGEON_POT_LOOT, 1, 3);
            lootPot.setModelRotationOffset(world.field_73012_v.nextInt(41) - 20);
            world.func_147471_g(x, y, z);
        }
    }

    public void setSwordStone(World world, Random rand, int x, int y, int z, Block blockType, int blockMeta, byte type) {
        world.func_147465_d(x, y, z, blockType, blockMeta, 2);
        TileEntityItemCage swordStone = (TileEntityItemCage)world.func_147438_o(x, y, z);
        if (swordStone != null) {
            swordStone.setType(type);
        }
    }

    private void placeSign(World world, Random rand, int x, int y, int z, Block blockType, int blockMeta) {
        world.func_147465_d(x, y, z, this.obviousSign, blockMeta, 2);
        TileEntityBLSign sign = (TileEntityBLSign)world.func_147438_o(x, y, z);
        if (sign != null) {
            sign.field_145915_a = new String[]{StatCollector.func_74838_a((String)"fortress.line1"), StatCollector.func_74838_a((String)"fortress.line2"), StatCollector.func_74838_a((String)"fortress.line3"), StatCollector.func_74838_a((String)"fortress.line4")};
            world.func_147471_g(x, y, z);
        }
    }

    public void rotatedCubeVolume(World world, Random rand, int x, int y, int z, int offsetA, int offsetB, int offsetC, Block blockType, int blockMeta, int sizeWidth, int sizeHeight, int sizeDepth, int direction) {
        switch (direction) {
            case 0: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + offsetA; xx < x + offsetA + sizeWidth; ++xx) {
                        for (int zz = z + offsetC; zz < z + offsetC + sizeDepth; ++zz) {
                            if (blockType == this.betweenstoneTiles) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneTiles : this.getRandomTiles(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneBricks) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneBricks : this.getRandomBricks(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneBrickWall) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneBrickWall : this.getRandomWall(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneBrickStairs) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneBrickStairs : this.getRandomBetweenstoneBrickStairs(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneStairsSmooth) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneStairsSmooth : this.getRandomSmoothBetweenstoneStairs(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneSmooth) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneSmooth : this.getRandomSmoothBetweenstone(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneTilesCollapsing) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneTilesCollapsing : this.getRandomCollapsingTiles(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.lootPot1) {
                                this.placeRandomisedLootPot(world, rand, xx, yy, zz, rand.nextBoolean() ? this.lootPot1 : (rand.nextBoolean() ? this.lootPot2 : this.lootPot3), blockMeta);
                                continue;
                            }
                            if (blockType == this.chest) {
                                if (yy <= this.originY + 17 && yy != this.originY) {
                                    if (rand.nextInt(4) != 0) continue;
                                    this.placeChest(world, rand, xx, yy, zz, this.chest, blockMeta);
                                    continue;
                                }
                                if (yy <= this.originY + 17 && yy != this.originY) continue;
                                this.placeChest(world, rand, xx, yy, zz, this.chest, blockMeta);
                                continue;
                            }
                            if (blockType == this.obviousSign) {
                                this.placeSign(world, rand, xx, yy, zz, this.obviousSign, blockMeta);
                                continue;
                            }
                            world.func_147465_d(xx, yy, zz, blockType, blockMeta, 2);
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + this.length - offsetA - 1; zz > z + this.length - offsetA - sizeWidth - 1; --zz) {
                        for (int xx = x + offsetC; xx < x + offsetC + sizeDepth; ++xx) {
                            if (blockType == this.betweenstoneTiles) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneTiles : this.getRandomTiles(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneBricks) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneBricks : this.getRandomBricks(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneBrickWall) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneBrickWall : this.getRandomWall(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneBrickStairs) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneBrickStairs : this.getRandomBetweenstoneBrickStairs(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneStairsSmooth) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneStairsSmooth : this.getRandomSmoothBetweenstoneStairs(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneSmooth) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneSmooth : this.getRandomSmoothBetweenstone(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneTilesCollapsing) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneTilesCollapsing : this.getRandomCollapsingTiles(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.lootPot1) {
                                this.placeRandomisedLootPot(world, rand, xx, yy, zz, rand.nextBoolean() ? this.lootPot1 : (rand.nextBoolean() ? this.lootPot2 : this.lootPot3), blockMeta);
                                continue;
                            }
                            if (blockType == this.chest) {
                                if (yy <= this.originY + 17 && yy != this.originY) {
                                    if (rand.nextInt(4) != 0) continue;
                                    this.placeChest(world, rand, xx, yy, zz, this.chest, blockMeta);
                                    continue;
                                }
                                if (yy <= this.originY + 17 && yy != this.originY) continue;
                                this.placeChest(world, rand, xx, yy, zz, this.chest, blockMeta);
                                continue;
                            }
                            if (blockType == this.obviousSign) {
                                this.placeSign(world, rand, xx, yy, zz, this.obviousSign, blockMeta);
                                continue;
                            }
                            world.func_147465_d(xx, yy, zz, blockType, blockMeta, 2);
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + this.length - offsetA - 1; xx > x + this.length - offsetA - sizeWidth - 1; --xx) {
                        for (int zz = z + this.length - offsetC - 1; zz > z + this.length - offsetC - sizeDepth - 1; --zz) {
                            if (blockType == this.betweenstoneTiles) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneTiles : this.getRandomTiles(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneBricks) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneBricks : this.getRandomBricks(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneBrickWall) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneBrickWall : this.getRandomWall(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneBrickStairs) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneBrickStairs : this.getRandomBetweenstoneBrickStairs(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneStairsSmooth) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneStairsSmooth : this.getRandomSmoothBetweenstoneStairs(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneSmooth) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneSmooth : this.getRandomSmoothBetweenstone(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneTilesCollapsing) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneTilesCollapsing : this.getRandomCollapsingTiles(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.lootPot1) {
                                this.placeRandomisedLootPot(world, rand, xx, yy, zz, rand.nextBoolean() ? this.lootPot1 : (rand.nextBoolean() ? this.lootPot2 : this.lootPot3), blockMeta);
                                continue;
                            }
                            if (blockType == this.chest) {
                                if (yy <= this.originY + 17 && yy != this.originY) {
                                    if (rand.nextInt(4) != 0) continue;
                                    this.placeChest(world, rand, xx, yy, zz, this.chest, blockMeta);
                                    continue;
                                }
                                if (yy <= this.originY + 17 && yy != this.originY) continue;
                                this.placeChest(world, rand, xx, yy, zz, this.chest, blockMeta);
                                continue;
                            }
                            if (blockType == this.obviousSign) {
                                this.placeSign(world, rand, xx, yy, zz, this.obviousSign, blockMeta);
                                continue;
                            }
                            world.func_147465_d(xx, yy, zz, blockType, blockMeta, 2);
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + offsetA; zz < z + offsetA + sizeWidth; ++zz) {
                        for (int xx = x + this.length - offsetC - 1; xx > x + this.length - offsetC - sizeDepth - 1; --xx) {
                            if (blockType == this.betweenstoneTiles) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneTiles : this.getRandomTiles(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneBricks) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneBricks : this.getRandomBricks(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneBrickWall) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneBrickWall : this.getRandomWall(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneBrickStairs) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneBrickStairs : this.getRandomBetweenstoneBrickStairs(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneStairsSmooth) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneStairsSmooth : this.getRandomSmoothBetweenstoneStairs(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneSmooth) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneSmooth : this.getRandomSmoothBetweenstone(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.betweenstoneTilesCollapsing) {
                                world.func_147465_d(xx, yy, zz, rand.nextBoolean() ? this.betweenstoneTilesCollapsing : this.getRandomCollapsingTiles(rand), blockMeta, 2);
                                continue;
                            }
                            if (blockType == this.lootPot1) {
                                this.placeRandomisedLootPot(world, rand, xx, yy, zz, rand.nextBoolean() ? this.lootPot1 : (rand.nextBoolean() ? this.lootPot2 : this.lootPot3), blockMeta);
                                continue;
                            }
                            if (blockType == this.chest) {
                                if (yy <= this.originY + 17 && yy != this.originY) {
                                    if (rand.nextInt(4) != 0) continue;
                                    this.placeChest(world, rand, xx, yy, zz, this.chest, blockMeta);
                                    continue;
                                }
                                if (yy <= this.originY + 17 && yy != this.originY) continue;
                                this.placeChest(world, rand, xx, yy, zz, this.chest, blockMeta);
                                continue;
                            }
                            if (blockType == this.obviousSign) {
                                this.placeSign(world, rand, xx, yy, zz, this.obviousSign, blockMeta);
                                continue;
                            }
                            world.func_147465_d(xx, yy, zz, blockType, blockMeta, 2);
                        }
                    }
                }
                break;
            }
        }
    }

    public void generateTopTowerRight(World world, Random rand, int x, int y, int z, int direction) {
        this.rotatedCubeVolume(world, rand, x, y, z, 0, 0, 1, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 0, 0, 3, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 1, 0, 1, this.betweenstoneBricks, 0, 1, 4, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 1, 0, 2, this.betweenstoneBricks, 0, 1, 6, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 2, 0, 1, this.betweenstoneBricks, 0, 1, 6, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 4, 0, 1, this.betweenstoneBricks, 0, 1, 8, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 2, 4, 2, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 2, 4, 3, this.betweenstoneBricks, 0, 1, 4, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 3, 4, 2, this.betweenstoneBricks, 0, 1, 4, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 3, 3, 1, this.betweenstoneBricks, 0, 4, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 1, 3, 3, this.betweenstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 3, 8, 3, this.betweenstoneBricks, 0, 1, 6, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 4, 8, 2, this.betweenstoneBricks, 0, 1, 11, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 6, 16, 2, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 5, 17, 2, this.betweenstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 6, 16, 3, this.betweenstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 4, 10, 3, this.betweenstoneBricks, 0, 1, 8, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 5, 10, 3, this.betweenstoneBricks, 0, 1, 7, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 1, 0, 0, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 3, 0, 0, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 5, 0, 0, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 4, 5, 2, this.betweenstoneBricks, 0, 2, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 5, 6, 2, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 6, 15, 3, this.betweenstoneTiles, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 6, 14, 3, this.betweenstoneBrickSlab, 8, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 6, 9, 2, this.betweenstoneTiles, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 6, 8, 2, this.betweenstoneBrickSlab, 8, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 6, 3, 0, this.betweenstoneTiles, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 6, 2, 0, this.betweenstoneBrickSlab, 8, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 1, 3, 0, this.betweenstoneBrickStairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 3, 3, 0, this.betweenstoneBrickStairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 5, 3, 0, this.betweenstoneBrickStairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 5, 9, 2, this.betweenstoneBrickStairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 6, 5, 2, this.betweenstoneBrickStairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 0, 3, 1, this.betweenstoneBrickStairs, direction == 0 ? 0 : (direction == 1 ? 3 : (direction == 2 ? 1 : 2)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 0, 3, 3, this.betweenstoneBrickStairs, direction == 0 ? 0 : (direction == 1 ? 3 : (direction == 2 ? 1 : 2)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 5, 4, 1, this.betweenstoneBrickStairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1)), 4, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 6, 10, 3, this.betweenstoneBrickStairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1)), 2, 1, 1, direction);
    }

    public void generateTopTowerLeft(World world, Random rand, int x, int y, int z, int direction) {
        if (direction == 2) {
            z -= 13;
        }
        if (direction == 0) {
            z += 13;
        }
        if (direction == 3) {
            x -= 13;
        }
        if (direction == 1) {
            x += 13;
        }
        this.rotatedCubeVolume(world, rand, x, y, z, 0, 0, -1, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 0, 0, -3, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 1, 0, -1, this.betweenstoneBricks, 0, 1, 4, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 1, 0, -2, this.betweenstoneBricks, 0, 1, 6, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 2, 0, -1, this.betweenstoneBricks, 0, 1, 6, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 4, 0, -1, this.betweenstoneBricks, 0, 1, 8, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 2, 4, -2, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 2, 4, -3, this.betweenstoneBricks, 0, 1, 4, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 3, 4, -2, this.betweenstoneBricks, 0, 1, 4, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 3, 3, -1, this.betweenstoneBricks, 0, 4, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 1, 3, -3, this.betweenstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 3, 8, -3, this.betweenstoneBricks, 0, 1, 6, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 4, 8, -2, this.betweenstoneBricks, 0, 1, 11, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 6, 16, -2, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 5, 17, -2, this.betweenstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 6, 16, -3, this.betweenstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 4, 10, -3, this.betweenstoneBricks, 0, 1, 8, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 5, 10, -3, this.betweenstoneBricks, 0, 1, 7, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 1, 0, 0, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 3, 0, 0, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 5, 0, 0, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 4, 5, -2, this.betweenstoneBricks, 0, 2, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 5, 6, -2, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 6, 15, -3, this.betweenstoneTiles, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 6, 14, -3, this.betweenstoneBrickSlab, 8, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 6, 9, -2, this.betweenstoneTiles, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 6, 8, -2, this.betweenstoneBrickSlab, 8, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 6, 3, 0, this.betweenstoneTiles, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 6, 2, 0, this.betweenstoneBrickSlab, 8, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 1, 3, 0, this.betweenstoneBrickStairs, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 3, 3, 0, this.betweenstoneBrickStairs, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 5, 3, 0, this.betweenstoneBrickStairs, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 5, 9, -2, this.betweenstoneBrickStairs, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 6, 5, -2, this.betweenstoneBrickStairs, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 0, 3, -1, this.betweenstoneBrickStairs, direction == 0 ? 0 : (direction == 1 ? 3 : (direction == 2 ? 1 : 2)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, x, y, z, 0, 3, -3, this.betweenstoneBrickStairs, direction == 0 ? 0 : (direction == 1 ? 3 : (direction == 2 ? 1 : 2)), 1, 1, 1, direction);
    }
}

