/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.feature.structure;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.tileentities.TileEntityLootPot1;
import thebetweenlands.world.loot.LootTables;
import thebetweenlands.world.loot.LootUtil;

public class WorldGenUnderGroundStructures
extends WorldGenerator {
    private static final boolean markReplaceableCheck = false;
    private static final int[] stairSequence = new int[]{0, 3, 1, 2};
    private static final int[] upsideDownStairSequence = new int[]{4, 7, 5, 6};
    private int width = -1;
    private int depth = -1;

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        boolean shouldStop = true;
        while (y > 20) {
            if (world.func_147439_a(x, y - 1, z) == BLBlockRegistry.pitstone && world.func_147439_a(x, y, z) == Blocks.field_150350_a) {
                shouldStop = false;
                break;
            }
            --y;
        }
        if (shouldStop) {
            return false;
        }
        int randomInt = random.nextInt(6);
        switch (randomInt) {
            case 0: {
                return this.structure1(world, random, x, y, z);
            }
            case 1: {
                return this.structure2(world, random, x, y, z);
            }
            case 2: {
                return this.structure3(world, random, x, y, z);
            }
            case 3: {
                return this.structure4(world, random, x, y, z);
            }
            case 4: {
                return this.structure5(world, random, x, y, z);
            }
            case 5: {
                return this.structure6(world, random, x, y, z);
            }
        }
        return false;
    }

    private boolean structure1(World world, Random random, int x, int y, int z) {
        this.width = 7;
        this.depth = 6;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, 1, 4, this.depth, direction) || this.rotatedCubeCantReplace(world, x, y, z, 6, 0, 0, 1, 4, this.depth, direction) || this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, 4, 1, direction) || this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 5, this.width, 4, 1, direction)) {
            return false;
        }
        if (!this.makePitstoneSupport(world, x, y, z, 0, -1, 0, this.width, this.depth, direction, true)) {
            return false;
        }
        this.makePitstoneSupport(world, x, y, z, 0, -1, 0, this.width, this.depth, direction, false);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 0, BLBlockRegistry.pitstoneTiles, 0, 1, 1, 6, direction);
        this.rotatedCubeVolume(world, x, y, z, 6, 0, 0, BLBlockRegistry.pitstoneTiles, 0, 1, 1, 6, direction);
        this.rotatedCubeVolume(world, x, y, z, 5, 0, 0, BLBlockRegistry.pitstoneTiles, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 0, BLBlockRegistry.pitstoneTiles, 0, 2, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 5, BLBlockRegistry.pitstoneTiles, 0, 5, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 0, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 6, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 5, BLBlockRegistry.pitstoneBricks, 0, 5, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1 + random.nextInt(5), 1, 5, BLBlockRegistry.chiseledPitstone, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 6, 1, 0, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 6, direction);
        this.rotatedCubeVolume(world, x, y, z, 6, 1, 2 + random.nextInt(2), Blocks.field_150350_a, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 0, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 6, 2, 0, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 2, 5, BLBlockRegistry.pitstoneBricks, 0, 7, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 2 + random.nextInt(4), 2, 5, Blocks.field_150350_a, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 2, 3, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 2, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 2, 0, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 3, 4, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 2, direction);
        if (random.nextInt(3) == 0) {
            this.rotatedLoot(world, random, x, y, z, 1, 0, 1, direction);
        }
        if (random.nextInt(3) == 0) {
            this.rotatedLoot(world, random, x, y, z, 5, 0, 1, direction);
        }
        if (random.nextInt(3) == 0) {
            this.rotatedLoot(world, random, x, y, z, 1, 0, 4, direction);
        }
        if (random.nextInt(3) == 0) {
            this.rotatedLoot(world, random, x, y, z, 5, 0, 4, direction);
        }
        return true;
    }

    private boolean structure2(World world, Random random, int x, int y, int z) {
        this.width = 9;
        this.depth = 11;
        int direction = random.nextInt(4);
        int height = 6 + random.nextInt(2);
        if (this.rotatedCubeCantReplace(world, x, y, z, 4, height - 3, 0, 5, height - 3, this.depth, direction) || this.rotatedCubeCantReplace(world, x, y, z, 0, height - 3, 6, 4, height - 3, 5, direction)) {
            return false;
        }
        if (!(this.makePitstoneSupport(world, x, y, z, 0, -1, 6, 1, 1, direction, true) && this.makePitstoneSupport(world, x, y, z, 0, -1, 10, 1, 1, direction, true) && this.makePitstoneSupport(world, x, y, z, 4, -1, 6, 1, 1, direction, true) && this.makePitstoneSupport(world, x, y, z, 4, -1, 10, 1, 1, direction, true) && this.makePitstoneSupport(world, x, y, z, 4, -1, 2, 1, 1, direction, true) && this.makePitstoneSupport(world, x, y, z, 8, -1, 6, 1, 1, direction, true) && this.makePitstoneSupport(world, x, y, z, 8, -1, 10, 1, 1, direction, true) && this.makePitstoneSupport(world, x, y, z, 8, -1, 2, 1, 1, direction, true))) {
            return false;
        }
        this.makePitstoneSupport(world, x, y, z, 0, -1, 6, 1, 1, direction, false);
        this.makePitstoneSupport(world, x, y, z, 0, -1, 10, 1, 1, direction, false);
        this.makePitstoneSupport(world, x, y, z, 4, -1, 6, 1, 1, direction, false);
        this.makePitstoneSupport(world, x, y, z, 4, -1, 10, 1, 1, direction, false);
        this.makePitstoneSupport(world, x, y, z, 4, -1, 2, 1, 1, direction, false);
        this.makePitstoneSupport(world, x, y, z, 8, -1, 6, 1, 1, direction, false);
        this.makePitstoneSupport(world, x, y, z, 8, -1, 10, 1, 1, direction, false);
        this.makePitstoneSupport(world, x, y, z, 8, -1, 2, 1, 1, direction, false);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 6, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 10, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, 0, 6, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, 0, 10, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, 0, 2, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 8, 0, 6, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 8, 0, 10, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 8, 0, 2, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 6, (Block)BLBlockRegistry.pitstonePillar, 0, 1, 2 + random.nextInt(3), 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 10, (Block)BLBlockRegistry.pitstonePillar, 0, 1, random.nextInt(3), 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, 1, 6, (Block)BLBlockRegistry.pitstonePillar, 0, 1, height - 3, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, 1, 10, (Block)BLBlockRegistry.pitstonePillar, 0, 1, height - 3, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, 1, 2, (Block)BLBlockRegistry.pitstonePillar, 0, 1, height - 3, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 8, 1, 6, (Block)BLBlockRegistry.pitstonePillar, 0, 1, height - 3, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 8, 1, 10, (Block)BLBlockRegistry.pitstonePillar, 0, 1, height - 3, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 8, 1, 2, (Block)BLBlockRegistry.pitstonePillar, 0, 1, height - 3, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, height - 2, 10, BLBlockRegistry.pitstoneBricks, 0, 8, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 2, height - 2, 9, BLBlockRegistry.pitstoneTiles, 0, 6, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 3, height - 2, 8, BLBlockRegistry.pitstoneTiles, 0, 5, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 2, height - 2, 7, BLBlockRegistry.pitstoneTiles, 0, 6, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, height - 2, 6, BLBlockRegistry.pitstoneBricks, 0, 4, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 8, height - 2, 0, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 10, direction);
        this.rotatedCubeVolume(world, x, y, z, 7, height - 2, 1, BLBlockRegistry.pitstoneTiles, 0, 1, 1, 6, direction);
        this.rotatedCubeVolume(world, x, y, z, 6, height - 2, 2, BLBlockRegistry.pitstoneTiles, 0, 1, 1, 5, direction);
        this.rotatedCubeVolume(world, x, y, z, 5, height - 2, 3, BLBlockRegistry.pitstoneTiles, 0, 1, 1, 4, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, height - 2, 2, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 4, direction);
        this.rotatedCubeVolume(world, x, y, z, 8, height - 1, 10, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 8, height - 1, 1, BLBlockRegistry.pitstoneBrickWall, 0, 1, 1, 9, direction);
        this.rotatedCubeVolume(world, x, y, z, 8, height - 1, 2 + random.nextInt(7), Blocks.field_150350_a, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, height - 1, 2, BLBlockRegistry.pitstoneBrickWall, 0, 1, 1, 4, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, height - 1, 3 + random.nextInt(2), Blocks.field_150350_a, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, height - 1, 6, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 2, height - 1, 10, BLBlockRegistry.pitstoneBrickWall, 0, 6, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 3 + random.nextInt(4), height - 1, 10, Blocks.field_150350_a, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, height - 1, 6, BLBlockRegistry.pitstoneBrickWall, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 3, height - 1, 6, BLBlockRegistry.pitstoneBrickWall, 0, 1, 1, 1, direction);
        if (random.nextBoolean()) {
            this.rotatedCubeVolume(world, x, y, z, 8, height, 10, BLBlockRegistry.chiseledPitstone, 0, 1, 1, 1, direction);
        }
        if (random.nextInt(3) == 0) {
            this.rotatedLoot(world, random, x, y, z, 7, height - 1, 9, direction);
        }
        if (random.nextInt(4) == 0) {
            this.rotatedLoot(world, random, x, y, z, 5, height - 1, 4, direction);
        }
        if (random.nextInt(4) == 0) {
            this.rotatedLoot(world, random, x, y, z, 1, 0, 7, direction);
        }
        if (random.nextInt(4) == 0) {
            this.rotatedLoot(world, random, x, y, z, 7, 0, 9, direction);
        }
        return true;
    }

    private boolean structure3(World world, Random random, int x, int y, int z) {
        this.width = 6;
        this.depth = 6;
        int direction = 0;
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, 7, this.depth, direction)) {
            return false;
        }
        if (!this.makePitstoneSupport(world, x, y, z, 0, -1, 0, this.width, this.depth, direction, true)) {
            return false;
        }
        this.makePitstoneSupport(world, x, y, z, 0, -1, 0, this.width, this.depth, direction, false);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 1, BLBlockRegistry.pitstoneTiles, 0, 4, 1, 4, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 0, BLBlockRegistry.pitstoneBricks, 0, 1, 2, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 5, BLBlockRegistry.pitstoneBricks, 0, 1, 2, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 5, 0, 0, BLBlockRegistry.pitstoneBricks, 0, 1, 2, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 5, 0, 5, BLBlockRegistry.pitstoneBricks, 0, 1, 2, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 0, BLBlockRegistry.pitstoneBrickStairs, 2, 4, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 1, BLBlockRegistry.pitstoneBrickStairs, 0, 1, 1, 4, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 5, BLBlockRegistry.pitstoneBrickStairs, 3, 4, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 5, 0, 1, BLBlockRegistry.pitstoneBrickStairs, 1, 1, 1, 4, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 2, 0, (Block)BLBlockRegistry.pitstonePillar, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 2, 5, (Block)BLBlockRegistry.pitstonePillar, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 5, 2, 0, (Block)BLBlockRegistry.pitstonePillar, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 5, 2, 5, (Block)BLBlockRegistry.pitstonePillar, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 5, 0, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 5, 5, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 5, 5, 0, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 5, 5, 5, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 5, 0, (Block)BLBlockRegistry.pitstoneBrickSlab, 8, 4, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 5, 1, (Block)BLBlockRegistry.pitstoneBrickSlab, 8, 1, 1, 4, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 5, 5, (Block)BLBlockRegistry.pitstoneBrickSlab, 8, 4, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 5, 5, 1, (Block)BLBlockRegistry.pitstoneBrickSlab, 8, 1, 1, 4, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 6, 0, (Block)BLBlockRegistry.pitstoneBrickSlab, 0, 4, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 6, 1, (Block)BLBlockRegistry.pitstoneBrickSlab, 0, 1, 1, 4, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 6, 5, (Block)BLBlockRegistry.pitstoneBrickSlab, 0, 4, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 5, 6, 1, (Block)BLBlockRegistry.pitstoneBrickSlab, 0, 1, 1, 4, direction);
        if (random.nextInt(3) == 0) {
            this.rotatedLoot(world, random, x, y, z, 1, 1, 1, 0);
        }
        if (random.nextInt(3) == 0) {
            this.rotatedLoot(world, random, x, y, z, 4, 1, 1, 0);
        }
        if (random.nextInt(3) == 0) {
            this.rotatedLoot(world, random, x, y, z, 1, 1, 4, 0);
        }
        if (random.nextInt(3) == 0) {
            this.rotatedLoot(world, random, x, y, z, 4, 1, 4, 0);
        }
        return true;
    }

    private boolean structure4(World world, Random random, int x, int y, int z) {
        this.depth = 11;
        this.width = 5;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, 4, this.depth, direction)) {
            return false;
        }
        if (!this.makePitstoneSupport(world, x, y, z, 0, -1, 0, this.width, this.depth, direction, true)) {
            return false;
        }
        this.makePitstoneSupport(world, x, y, z, 0, -1, 0, this.width, this.depth, direction, false);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 0, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 11, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 4, BLBlockRegistry.pitstoneBricks, 0, 1, 4, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 10, BLBlockRegistry.pitstoneBricks, 0, 1, 4, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 3, 0, 4, BLBlockRegistry.pitstoneBricks, 0, 1, 4, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 3, 0, 10, BLBlockRegistry.pitstoneBricks, 0, 1, 4, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, 0, 2, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 9, direction);
        this.rotatedCubeVolume(world, x, y, z, 2, 0, 10, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 2, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 9, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, 1, 3, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 8, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 5, (Block)BLBlockRegistry.pitstoneBrickSlab, 0, 1, 1, 5, direction);
        this.rotatedCubeVolume(world, x, y, z, 3, 1, 5, (Block)BLBlockRegistry.pitstoneBrickSlab, 0, 1, 1, 5, direction);
        this.rotatedCubeVolume(world, x, y, z, 2, 1, 10, BLBlockRegistry.chiseledPitstone, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 2, 5, (Block)BLBlockRegistry.pitstoneBrickSlab, 8, 1, 1, 5, direction);
        this.rotatedCubeVolume(world, x, y, z, 3, 2, 5, (Block)BLBlockRegistry.pitstoneBrickSlab, 8, 1, 1, 5, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 2, 3, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 8, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, 2, 4, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 7, direction);
        this.rotatedCubeVolume(world, x, y, z, 2, 2, 10, BLBlockRegistry.pitstoneBricks, 0, 1, 2, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 2, 2, 4, BLBlockRegistry.pitstoneBrickStairs, this.getMetaFromDirection(3, direction, upsideDownStairSequence), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 3, 4, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 6, direction);
        this.rotatedCubeVolume(world, x, y, z, 2, 3, 4, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 6, direction);
        this.rotatedCubeVolume(world, x, y, z, 3, 3, 4, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 6, direction);
        for (int i = 0; i <= 4; ++i) {
            if (random.nextInt(4) == 0) {
                this.rotatedLoot(world, random, x, y, z, 1, 0, 5 + i, direction);
            }
            if (random.nextInt(4) != 0) continue;
            this.rotatedLoot(world, random, x, y, z, 3, 0, 5 + i, direction);
        }
        return true;
    }

    private boolean structure5(World world, Random random, int x, int y, int z) {
        this.depth = 8;
        this.width = 7;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, 5, this.depth, direction)) {
            return false;
        }
        if (!this.makePitstoneSupport(world, x, y, z, 0, -1, 0, this.width, this.depth, direction, true)) {
            return false;
        }
        this.makePitstoneSupport(world, x, y, z, 0, -1, 0, this.width, this.depth, direction, false);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 0, BLBlockRegistry.pitstoneBricks, 0, 7, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 6, BLBlockRegistry.pitstoneBricks, 0, 7, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 0, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 7, direction);
        this.rotatedCubeVolume(world, x, y, z, 7, 0, 0, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 7, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 2, BLBlockRegistry.pitstoneBrickWall, 0, 1, 2, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 4, BLBlockRegistry.pitstoneBrickWall, 0, 1, 2, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 2, 0, 1, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 3, 0, 1, (Block)BLBlockRegistry.pitstoneBrickSlab, 8, 3, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 6, 0, 1, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 2, 0, 5, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 3, 0, 5, (Block)BLBlockRegistry.pitstoneBrickSlab, 8, 3, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 6, 0, 5, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 0, BLBlockRegistry.pitstoneTiles, 0, 7, 2, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 6, BLBlockRegistry.pitstoneTiles, 0, 7, 2, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 0, BLBlockRegistry.pitstoneTiles, 0, 1, 2, 7, direction);
        this.rotatedCubeVolume(world, x, y, z, 7, 1, 0, BLBlockRegistry.pitstoneTiles, 0, 1, 2, 7, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, 1, 0, BLBlockRegistry.pitstoneBrickWall, 0, 1, 2, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, 1, 6, BLBlockRegistry.pitstoneBrickWall, 0, 1, 2, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 7, 1, 3, BLBlockRegistry.pitstoneBrickWall, 0, 1, 2, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 1, BLBlockRegistry.pitstoneBrickWall, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 5, BLBlockRegistry.pitstoneBrickWall, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 3, Blocks.field_150350_a, 0, 1, 2, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 2, 2, BLBlockRegistry.pitstoneBrickStairs, this.getMetaFromDirection(3, direction, stairSequence), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 2, 3, BLBlockRegistry.pitstoneBrickStairs, this.getMetaFromDirection(0, direction, stairSequence), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 2, 4, BLBlockRegistry.pitstoneBrickStairs, this.getMetaFromDirection(1, direction, stairSequence), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 3, 0, BLBlockRegistry.pitstoneBrickStairs, this.getMetaFromDirection(3, direction, stairSequence), 7, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 3, 1, BLBlockRegistry.pitstoneBrickStairs, this.getMetaFromDirection(0, direction, stairSequence), 1, 1, 6, direction);
        this.rotatedCubeVolume(world, x, y, z, 2, 3, 6, BLBlockRegistry.pitstoneBrickStairs, this.getMetaFromDirection(1, direction, stairSequence), 6, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 7, 3, 1, BLBlockRegistry.pitstoneBrickStairs, this.getMetaFromDirection(2, direction, stairSequence), 1, 1, 5, direction);
        this.rotatedCubeVolume(world, x, y, z, 2, 4, 1, (Block)BLBlockRegistry.pitstoneBrickSlab, 0, 5, 1, 5, direction);
        if (random.nextInt(3) == 0) {
            this.rotatedLoot(world, random, x, y, z, 2, 1, 1, direction);
        }
        if (random.nextInt(3) == 0) {
            this.rotatedLoot(world, random, x, y, z, 2, 1, 5, direction);
        }
        if (random.nextInt(3) == 0) {
            this.rotatedLoot(world, random, x, y, z, 6, 1, 1, direction);
        }
        if (random.nextInt(3) == 0) {
            this.rotatedLoot(world, random, x, y, z, 6, 1, 5, direction);
        }
        return true;
    }

    private boolean structure6(World world, Random random, int x, int y, int z) {
        this.width = 7;
        this.depth = 7;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, 3, 2, 1, direction) || this.rotatedCubeCantReplace(world, x, y, z, 1, 0, 0, 1, 1, 1, direction) || this.rotatedCubeCantReplace(world, x, y, z, 6, 0, 3, 1, 2, 3, direction) || this.rotatedCubeCantReplace(world, x, y, z, 2, 0, 6, 4, 3, 1, direction)) {
            return false;
        }
        if (!this.makePitstoneSupport(world, x, y, z, 0, -1, 0, this.width, this.depth, direction, true)) {
            return false;
        }
        this.makePitstoneSupport(world, x, y, z, 0, -1, 0, this.width, this.depth, direction, false);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 0, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 3, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 0, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 6, 0, 3, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 4, direction);
        this.rotatedCubeVolume(world, x, y, z, 2, 0, 6, BLBlockRegistry.pitstoneBricks, 0, 4, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 0, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 2, direction);
        this.rotatedCubeVolume(world, x, y, z, 6, 1, 4, BLBlockRegistry.pitstoneBricks, 0, 1, 1, 4, direction);
        this.rotatedCubeVolume(world, x, y, z, 3, 1, 6, BLBlockRegistry.pitstoneBricks, 0, 3, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 5, 2, 6, BLBlockRegistry.pitstoneBricks, 0, 2, 1, 1, direction);
        if (random.nextInt(3) == 0) {
            this.rotatedLoot(world, random, x, y, z, 5, 0, 5, direction);
        }
        if (random.nextInt(3) == 0) {
            this.rotatedLoot(world, random, x, y, z, 1, 0, 1, direction);
        }
        return true;
    }

    private void rotatedCubeVolume(World world, int x, int y, int z, int offsetA, int offsetB, int offsetC, Block blockType, int blockMeta, int sizeWidth, int sizeHeight, int sizeDepth, int direction) {
        x -= this.width / 2;
        z -= this.depth / 2;
        switch (direction) {
            case 0: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + offsetA; xx < x + offsetA + sizeWidth; ++xx) {
                        for (int zz = z + offsetC; zz < z + offsetC + sizeDepth; ++zz) {
                            world.func_147465_d(xx, yy, zz, blockType, blockMeta, 2);
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + this.depth - offsetA - 1; zz > z + this.depth - offsetA - sizeWidth - 1; --zz) {
                        for (int xx = x + offsetC; xx < x + offsetC + sizeDepth; ++xx) {
                            world.func_147465_d(xx, yy, zz, blockType, blockMeta, 2);
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + this.width - offsetA - 1; xx > x + this.width - offsetA - sizeWidth - 1; --xx) {
                        for (int zz = z + this.depth - offsetC - 1; zz > z + this.depth - offsetC - sizeDepth - 1; --zz) {
                            world.func_147465_d(xx, yy, zz, blockType, blockMeta, 2);
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + offsetA; zz < z + offsetA + sizeWidth; ++zz) {
                        for (int xx = x + this.width - offsetC - 1; xx > x + this.width - offsetC - sizeDepth - 1; --xx) {
                            world.func_147465_d(xx, yy, zz, blockType, blockMeta, 2);
                        }
                    }
                }
                break;
            }
        }
    }

    private void rotatedLoot(World world, Random rand, int x, int y, int z, int offsetA, int offsetB, int offsetC, int direction) {
        x -= this.width / 2;
        z -= this.depth / 2;
        switch (direction) {
            case 0: {
                this.generateLoot(world, rand, x + offsetA, y + offsetB, z + offsetC);
                break;
            }
            case 1: {
                this.generateLoot(world, rand, x + offsetC, y + offsetB, z + this.depth - offsetA - 1);
                break;
            }
            case 2: {
                this.generateLoot(world, rand, x + this.width - offsetA - 1, y + offsetB, z + this.depth - offsetC - 1);
                break;
            }
            case 3: {
                this.generateLoot(world, rand, x + this.width - offsetC - 1, y + offsetB, z + offsetA);
            }
        }
    }

    private boolean makePitstoneSupport(World world, int x, int y, int z, int offsetA, int offsetB, int offsetC, int sizeWidth, int sizeDepth, int direction, boolean simulate) {
        x -= this.width / 2;
        z -= this.depth / 2;
        switch (direction) {
            case 0: {
                for (int xx = x + offsetA; xx < x + offsetA + sizeWidth; ++xx) {
                    for (int zz = z + offsetC; zz < z + offsetC + sizeDepth; ++zz) {
                        int yy = y + offsetB;
                        int times = 0;
                        while (world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) {
                            if (!simulate) {
                                world.func_147465_d(xx, yy, zz, BLBlockRegistry.pitstone, 0, 2);
                            }
                            --yy;
                            if (++times <= 4) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int zz = z + this.depth - offsetA - 1; zz > z + this.depth - offsetA - sizeWidth - 1; --zz) {
                    for (int xx = x + offsetC; xx < x + offsetC + sizeDepth; ++xx) {
                        int yy = y + offsetB;
                        int times = 0;
                        while (world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) {
                            if (!simulate) {
                                world.func_147465_d(xx, yy, zz, BLBlockRegistry.pitstone, 0, 2);
                            }
                            --yy;
                            if (++times <= 4) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int xx = x + this.width - offsetA - 1; xx > x + this.width - offsetA - sizeWidth - 1; --xx) {
                    for (int zz = z + this.depth - offsetC - 1; zz > z + this.depth - offsetC - sizeDepth - 1; --zz) {
                        int yy = y + offsetB;
                        int times = 0;
                        while (world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) {
                            if (!simulate) {
                                world.func_147465_d(xx, yy, zz, BLBlockRegistry.pitstone, 0, 2);
                            }
                            --yy;
                            if (++times <= 4) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int zz = z + offsetA; zz < z + offsetA + sizeWidth; ++zz) {
                    for (int xx = x + this.width - offsetC - 1; xx > x + this.width - offsetC - sizeDepth - 1; --xx) {
                        int yy = y + offsetB;
                        int times = 0;
                        while (world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) {
                            if (!simulate) {
                                world.func_147465_d(xx, yy, zz, BLBlockRegistry.pitstone, 0, 2);
                            }
                            --yy;
                            if (++times <= 4) continue;
                            return false;
                        }
                    }
                }
                break;
            }
        }
        return true;
    }

    private boolean rotatedCubeCantReplace(World world, int x, int y, int z, int offsetA, int offsetB, int offsetC, int sizeWidth, int sizeHeight, int sizeDepth, int direction) {
        x -= this.width / 2;
        z -= this.depth / 2;
        boolean replaceable = true;
        switch (direction) {
            case 0: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + offsetA; xx < x + offsetA + sizeWidth; ++xx) {
                        for (int zz = z + offsetC; zz < z + offsetC + sizeDepth; ++zz) {
                            if (world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) continue;
                            replaceable = false;
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + this.depth - offsetA - 1; zz > z + this.depth - offsetA - sizeWidth - 1; --zz) {
                        for (int xx = x + offsetC; xx < x + offsetC + sizeDepth; ++xx) {
                            if (world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) continue;
                            replaceable = false;
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + this.width - offsetA - 1; xx > x + this.width - offsetA - sizeWidth - 1; --xx) {
                        for (int zz = z + this.depth - offsetC - 1; zz > z + this.depth - offsetC - sizeDepth - 1; --zz) {
                            if (world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) continue;
                            replaceable = false;
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + offsetA; zz < z + offsetA + sizeWidth; ++zz) {
                        for (int xx = x + this.width - offsetC - 1; xx > x + this.width - offsetC - sizeDepth - 1; --xx) {
                            if (world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) continue;
                            replaceable = false;
                        }
                    }
                }
                break;
            }
        }
        return !replaceable;
    }

    private void generateLoot(World world, Random random, int x, int y, int z) {
        int randDirection = random.nextInt(4) + 2;
        world.func_147465_d(x, y, z, this.getRandomBlock(random), randDirection, 3);
        TileEntityLootPot1 lootPot = (TileEntityLootPot1)world.func_147438_o(x, y, z);
        if (lootPot != null) {
            LootUtil.generateLoot((IInventory)lootPot, random, LootTables.COMMON_POT_LOOT, 1, 2);
        }
    }

    private Block getRandomBlock(Random rand) {
        switch (rand.nextInt(3)) {
            case 0: {
                return BLBlockRegistry.lootPot1;
            }
            case 1: {
                return BLBlockRegistry.lootPot2;
            }
            case 2: {
                return BLBlockRegistry.lootPot3;
            }
        }
        return BLBlockRegistry.lootPot1;
    }

    private int getMetaFromDirection(int start, int direction, int[] sequence) {
        return sequence[(direction + start) % sequence.length];
    }
}

