/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.feature.structure;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.tileentities.TileEntityTarLootPot1;
import thebetweenlands.world.loot.LootTables;
import thebetweenlands.world.loot.LootUtil;
import thebetweenlands.world.loot.WeightedLootList;
import thebetweenlands.world.storage.chunk.storage.StorageHelper;
import thebetweenlands.world.storage.chunk.storage.location.EnumLocationType;

public class WorldGenTarPoolDungeons
extends WorldGenerator {
    public static final WeightedLootList loot = LootTables.DUNGEON_POT_LOOT;

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int zz;
        int height = 10;
        int halfSize = 7;
        if (y + height + 1 >= 80 - height || y - 1 <= 20 + height) {
            return false;
        }
        for (int xx = x - halfSize - 1; xx <= x + halfSize + 1; ++xx) {
            for (int yy = y - 1; yy <= y + height + 1; ++yy) {
                for (zz = z - halfSize - 1; zz <= z + halfSize + 1; ++zz) {
                    Material mat = world.func_147439_a(xx, yy, zz).func_149688_o();
                    if (yy != y - 1 && yy != y + height + 1 || mat.func_76220_a()) continue;
                    return false;
                }
            }
        }
        for (int x1 = x - halfSize; x1 <= x + halfSize; ++x1) {
            for (int z1 = z - halfSize; z1 <= z + halfSize; ++z1) {
                for (int y1 = y; y1 < y + height; ++y1) {
                    double dSq = Math.pow(x1 - x, 2.0) + Math.pow(z1 - z, 2.0) + Math.pow(y1 - y, 2.0);
                    if (Math.round(Math.sqrt(dSq)) > (long)halfSize || y1 < y + 3) continue;
                    world.func_147468_f(x1, y1, z1);
                }
            }
        }
        for (int yy = y + 2; yy >= y; --yy) {
            for (int xx = halfSize * -1; xx <= halfSize; ++xx) {
                for (zz = halfSize * -1; zz <= halfSize; ++zz) {
                    double dSq = xx * xx + zz * zz;
                    if (Math.round(Math.sqrt(dSq)) == (long)(halfSize - 2) && yy >= y + 1) {
                        world.func_147449_b(x + xx, yy, z + zz, BLBlockRegistry.betweenstoneTiles);
                        if (rand.nextBoolean() && yy == y + 2 && (xx % 4 == 0 || zz % 4 == 0 || xx % 3 == 0 || zz % 3 == 0) && world.func_147439_a(x + xx, y + 6, z + zz) == BLBlockRegistry.betweenstone) {
                            this.placePillar(world, x + xx, y + 3, z + zz, rand);
                        }
                    }
                    if (Math.round(Math.sqrt(dSq)) <= (long)halfSize && Math.round(Math.sqrt(dSq)) >= (long)(halfSize - 1) && yy <= y + 2) {
                        world.func_147449_b(x + xx, yy, z + zz, BLBlockRegistry.betweenstone);
                    }
                    if (Math.round(Math.sqrt(dSq)) < (long)(halfSize - 2) && yy >= y + 1) {
                        world.func_147449_b(x + xx, yy, z + zz, BLBlockRegistry.tarFluid);
                    }
                    if (Math.round(Math.sqrt(dSq)) >= (long)(halfSize - 2) || yy != y) continue;
                    if (rand.nextBoolean() && rand.nextBoolean()) {
                        world.func_147449_b(x + xx, yy, z + zz, BLBlockRegistry.solidTar);
                    } else {
                        world.func_147449_b(x + xx, yy, z + zz, BLBlockRegistry.betweenstone);
                    }
                    if (rand.nextInt(18) != 0) continue;
                    int randDirection = rand.nextInt(4) + 2;
                    world.func_147465_d(x + xx, yy, z + zz, this.getRandomBlock(rand), randDirection, 3);
                    TileEntityTarLootPot1 lootPot = (TileEntityTarLootPot1)world.func_147438_o(x + xx, yy, z + zz);
                    if (lootPot == null) continue;
                    LootUtil.generateLoot((IInventory)lootPot, rand, loot, 1, 3);
                }
            }
        }
        world.func_147465_d(x + rand.nextInt(halfSize - 2) - rand.nextInt(halfSize - 2), y, z + rand.nextInt(halfSize - 2) - rand.nextInt(halfSize - 2), BLBlockRegistry.tarBeastSpawner, 0, 3);
        StorageHelper.addArea(world, "translate:tarPoolDungeon", AxisAlignedBB.func_72330_a((double)(x - halfSize), (double)(y - 1), (double)(z - halfSize), (double)(x + halfSize), (double)(y + height), (double)(z + halfSize)).func_72314_b(1.0, 1.0, 1.0), EnumLocationType.DUNGEON, 0);
        return true;
    }

    private void placePillar(World world, int x, int y, int z, Random rand) {
        int randHeight = rand.nextInt(3);
        for (int yy = y; randHeight + y >= yy; ++yy) {
            world.func_147465_d(x, yy, z, BLBlockRegistry.betweenstoneBrickWall, 0, 3);
        }
    }

    private Block getRandomBlock(Random rand) {
        switch (rand.nextInt(3)) {
            case 0: {
                return BLBlockRegistry.tarLootPot1;
            }
            case 1: {
                return BLBlockRegistry.tarLootPot2;
            }
            case 2: {
                return BLBlockRegistry.tarLootPot3;
            }
        }
        return BLBlockRegistry.tarLootPot1;
    }
}

