/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.feature.structure;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.BlockGenericPlanks;
import thebetweenlands.blocks.tree.BlockBLLog;

public class WorldGenSwampHut
extends WorldGenerator {
    Block fence = BLBlockRegistry.weedwoodPlankFence;
    Block door = BLBlockRegistry.doorWeedwood;
    private BlockBLLog log = (BlockBLLog)BLBlockRegistry.weedwoodLog;
    private Block plank = (BlockGenericPlanks)BLBlockRegistry.weedwoodPlanks;
    private Block stairs = BLBlockRegistry.weedwoodPlankStairs;
    private Block roof = BLBlockRegistry.thatchSlope;
    private Block bricks = BLBlockRegistry.betweenstoneBricks;
    private Block thatchBlock = BLBlockRegistry.thatch;
    private int length = 16;
    private int width = 16;
    private int height = 10;
    private int direction = 0;

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        BiomeGenBase biomeBase = world.func_72807_a(x, z);
        this.generateStructure(world, random, x, y, z);
        return true;
    }

    public boolean generateStructure(World world, Random rand, int x, int y, int z) {
        this.verticalBeam(world, rand, x + 5, y, z + 5, (Block)this.log, 0, 4, 0);
        this.verticalBeam(world, rand, x + 10, y, z + 5, (Block)this.log, 0, 4, 0);
        this.verticalBeam(world, rand, x + 5, y, z + 10, (Block)this.log, 0, 4, 0);
        this.verticalBeam(world, rand, x + 10, y, z + 10, (Block)this.log, 0, 4, 0);
        this.verticalBeam(world, rand, x + 4, y + 4, z + 4, (Block)this.log, 0, 3, 0);
        this.verticalBeam(world, rand, x + 11, y + 4, z + 4, (Block)this.log, 0, 3, 0);
        this.verticalBeam(world, rand, x + 4, y + 4, z + 11, (Block)this.log, 0, 3, 0);
        this.verticalBeam(world, rand, x + 11, y + 4, z + 11, (Block)this.log, 0, 3, 0);
        this.verticalBeam(world, rand, x + 4, y + 5, z + 5, (Block)this.log, 0, 4, 0);
        this.verticalBeam(world, rand, x + 11, y + 5, z + 5, (Block)this.log, 0, 4, 0);
        this.verticalBeam(world, rand, x + 4, y + 5, z + 10, (Block)this.log, 0, 4, 0);
        this.verticalBeam(world, rand, x + 11, y + 5, z + 10, (Block)this.log, 0, 4, 0);
        this.verticalBeam(world, rand, x + 5, y + 5, z + 4, (Block)this.log, 0, 4, 0);
        this.verticalBeam(world, rand, x + 10, y + 5, z + 4, (Block)this.log, 0, 4, 0);
        this.verticalBeam(world, rand, x + 5, y + 5, z + 11, (Block)this.log, 0, 4, 0);
        this.verticalBeam(world, rand, x + 10, y + 5, z + 11, (Block)this.log, 0, 4, 0);
        this.verticalBeam(world, rand, x + 4, y + 8, z + 6, (Block)this.log, 0, 2, 0);
        this.verticalBeam(world, rand, x + 11, y + 8, z + 6, (Block)this.log, 0, 2, 0);
        this.verticalBeam(world, rand, x + 4, y + 8, z + 9, (Block)this.log, 0, 2, 0);
        this.verticalBeam(world, rand, x + 11, y + 8, z + 9, (Block)this.log, 0, 2, 0);
        this.verticalBeam(world, rand, x + 6, y + 8, z + 4, (Block)this.log, 0, 2, 0);
        this.verticalBeam(world, rand, x + 9, y + 8, z + 4, (Block)this.log, 0, 2, 0);
        this.verticalBeam(world, rand, x + 6, y + 8, z + 11, (Block)this.log, 0, 2, 0);
        this.verticalBeam(world, rand, x + 9, y + 8, z + 11, (Block)this.log, 0, 2, 0);
        this.verticalBeam(world, rand, x + 4, y + 9, z + 7, (Block)this.log, 0, 2, 0);
        this.verticalBeam(world, rand, x + 11, y + 9, z + 7, (Block)this.log, 0, 2, 0);
        this.verticalBeam(world, rand, x + 4, y + 9, z + 8, (Block)this.log, 0, 2, 0);
        this.verticalBeam(world, rand, x + 11, y + 9, z + 8, (Block)this.log, 0, 2, 0);
        this.verticalBeam(world, rand, x + 7, y + 9, z + 4, (Block)this.log, 0, 2, 0);
        this.verticalBeam(world, rand, x + 7, y + 9, z + 11, (Block)this.log, 0, 2, 0);
        this.verticalBeam(world, rand, x + 8, y + 9, z + 4, (Block)this.log, 0, 2, 0);
        this.verticalBeam(world, rand, x + 8, y + 9, z + 11, (Block)this.log, 0, 2, 0);
        for (int direction = 0; direction < 4; ++direction) {
            this.rotatedBeam(world, rand, x, y, z, 6, 5, this.bricks, direction == 0 || direction == 2 ? 4 : 8, 4, direction);
            this.rotatedBeam(world, rand, x, y + 1, z, 6, 5, this.plank, direction == 0 || direction == 2 ? 4 : 8, 1, direction);
            this.rotatedBeam(world, rand, x, y + 1, z, 7, 5, this.fence, direction == 0 || direction == 2 ? 4 : 8, 2, direction);
            this.rotatedBeam(world, rand, x, y + 1, z, 9, 5, this.plank, direction == 0 || direction == 2 ? 4 : 8, 1, direction);
            this.rotatedBeam(world, rand, x, y + 2, z, 6, 5, this.plank, direction == 0 || direction == 2 ? 4 : 8, 4, direction);
            this.rotatedBeam(world, rand, x, y + 3, z, 6, 5, this.plank, direction == 0 || direction == 2 ? 4 : 8, 4, direction);
            this.rotatedBeam(world, rand, x, y + 4, z, 5, 5, this.plank, direction == 0 || direction == 2 ? 4 : 8, 6, direction);
            this.rotatedBeam(world, rand, x, y + 4, z, 5, 4, this.plank, direction == 0 || direction == 2 ? 4 : 8, 6, direction);
            this.rotatedBeam(world, rand, x, y + 3, z, 4, 4, this.stairs, direction == 0 ? 6 : (direction == 1 ? 4 : (direction == 2 ? 7 : 5)), 8, direction);
            this.rotatedBeam(world, rand, x, y + 5, z, 6, 4, this.plank, direction == 0 || direction == 2 ? 4 : 8, 1, direction);
            this.rotatedBeam(world, rand, x, y + 5, z, 7, 4, this.fence, direction == 0 || direction == 2 ? 4 : 8, 2, direction);
            this.rotatedBeam(world, rand, x, y + 5, z, 9, 4, this.plank, direction == 0 || direction == 2 ? 4 : 8, 1, direction);
            this.rotatedBeam(world, rand, x, y + 6, z, 6, 4, this.fence, direction == 0 || direction == 2 ? 4 : 8, 4, direction);
            this.rotatedBeam(world, rand, x, y + 7, z, 6, 4, this.plank, direction == 0 || direction == 2 ? 4 : 8, 4, direction);
            this.rotatedBeam(world, rand, x, y + 8, z, 7, 4, this.fence, direction == 0 || direction == 2 ? 4 : 8, 2, direction);
            this.rotatedBeam(world, rand, x, y + 7, z, 4, 4, this.plank, direction == 0 || direction == 2 ? 4 : 8, 1, direction);
            this.rotatedBeam(world, rand, x, y + 7, z, 11, 4, this.plank, direction == 0 || direction == 2 ? 4 : 8, 1, direction);
            this.rotatedBeam(world, rand, x, y + 11, z, 3, 7, this.roof, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1)), 4, direction);
            this.rotatedBeam(world, rand, x, y + 10, z, 3, 6, this.roof, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1)), 4, direction);
            this.rotatedBeam(world, rand, x, y + 9, z, 3, 5, this.roof, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1)), 3, direction);
            this.rotatedBeam(world, rand, x, y + 8, z, 3, 4, this.roof, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1)), 2, direction);
            this.rotatedBeam(world, rand, x, y + 10, z, 3, 7, this.roof, direction == 0 ? 7 : (direction == 1 ? 5 : (direction == 2 ? 6 : 4)), 1, direction);
            this.rotatedBeam(world, rand, x, y + 9, z, 3, 6, this.roof, direction == 0 ? 7 : (direction == 1 ? 5 : (direction == 2 ? 6 : 4)), 1, direction);
            this.rotatedBeam(world, rand, x, y + 8, z, 3, 5, this.roof, direction == 0 ? 7 : (direction == 1 ? 5 : (direction == 2 ? 6 : 4)), 1, direction);
            this.rotatedBeam(world, rand, x, y + 11, z, 3, 8, this.roof, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0)), 4, direction);
            this.rotatedBeam(world, rand, x, y + 10, z, 3, 9, this.roof, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0)), 4, direction);
            this.rotatedBeam(world, rand, x, y + 9, z, 3, 10, this.roof, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0)), 3, direction);
            this.rotatedBeam(world, rand, x, y + 8, z, 3, 11, this.roof, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0)), 2, direction);
            this.rotatedBeam(world, rand, x, y + 10, z, 3, 8, this.roof, direction == 0 ? 6 : (direction == 1 ? 4 : (direction == 2 ? 7 : 5)), 1, direction);
            this.rotatedBeam(world, rand, x, y + 9, z, 3, 9, this.roof, direction == 0 ? 6 : (direction == 1 ? 4 : (direction == 2 ? 7 : 5)), 1, direction);
            this.rotatedBeam(world, rand, x, y + 8, z, 3, 10, this.roof, direction == 0 ? 6 : (direction == 1 ? 4 : (direction == 2 ? 7 : 5)), 1, direction);
            this.rotatedBeam(world, rand, x, y + 11, z, 7, 7, this.thatchBlock, direction == 0 || direction == 2 ? 4 : 8, 1, direction);
            this.rotatedBeam(world, rand, x, y + 11, z, 7, 8, this.thatchBlock, direction == 0 || direction == 2 ? 4 : 8, 1, direction);
        }
        System.out.println("Added Hut at: " + x + " " + z);
        boolean leftExtension = rand.nextBoolean();
        boolean rightExtension = rand.nextBoolean();
        boolean frontExtension = rand.nextBoolean();
        boolean backExtension = rand.nextBoolean();
        if (!(leftExtension || rightExtension || frontExtension || backExtension)) {
            System.out.println("Door can only be on main building");
        }
        if (leftExtension) {
            this.addExtention(world, rand, x, y, z, 1);
            System.out.println("Has Left Wing");
        }
        if (backExtension) {
            this.addExtention(world, rand, x, y, z, 2);
            System.out.println("Has Back Wing");
        }
        if (rightExtension) {
            this.addExtention(world, rand, x, y, z, 3);
            System.out.println("Has Right Wing");
        }
        System.out.println("Added Hut at: " + x + " " + z);
        return true;
    }

    private void addExtention(World world, Random rand, int x, int y, int z, int direction) {
        int beamLength;
        this.rotatedBeam(world, rand, x, y + 2, z, 2, 6, (Block)this.log, direction == 0 || direction == 2 ? 4 : 8, 3, direction);
        this.rotatedBeam(world, rand, x, y + 2, z, 2, 9, (Block)this.log, direction == 0 || direction == 2 ? 4 : 8, 3, direction);
        for (int beamHeight = 0; beamHeight < 2; ++beamHeight) {
            this.rotatedBeam(world, rand, x, y + beamHeight, z, 1, 6, (Block)this.log, 0, 1, direction);
            this.rotatedBeam(world, rand, x, y + beamHeight, z, 1, 9, (Block)this.log, 0, 1, direction);
            this.rotatedBeam(world, rand, x, y + beamHeight, z, 4, 6, (Block)this.log, 0, 1, direction);
            this.rotatedBeam(world, rand, x, y + beamHeight, z, 4, 9, (Block)this.log, 0, 1, direction);
        }
        for (beamLength = 0; beamLength < 4; ++beamLength) {
            this.rotatedBeam(world, rand, x, y + 2, z, 1, 6 + beamLength, (Block)this.log, direction == 0 || direction == 2 ? 8 : 4, 1, direction);
        }
        for (beamLength = 0; beamLength < 2; ++beamLength) {
            for (int beamHeight = 0; beamHeight < 3; ++beamHeight) {
                this.rotatedBeam(world, rand, x, y + beamHeight, z, 5, 7 + beamLength, Blocks.field_150350_a, 0, 1, direction);
            }
        }
        for (beamLength = 0; beamLength < 2; ++beamLength) {
            this.rotatedBeam(world, rand, x, y, z, 1, 7 + beamLength, this.bricks, direction == 0 || direction == 2 ? 8 : 4, 1, direction);
            this.rotatedBeam(world, rand, x, y + 1, z, 1, 7 + beamLength, this.fence, direction == 0 || direction == 2 ? 8 : 4, 1, direction);
        }
        this.rotatedBeam(world, rand, x, y, z, 2, 6, this.bricks, direction == 0 || direction == 2 ? 4 : 8, 2, direction);
        this.rotatedBeam(world, rand, x, y + 1, z, 2, 6, this.fence, direction == 0 || direction == 2 ? 4 : 8, 2, direction);
        this.rotatedBeam(world, rand, x, y, z, 2, 9, this.bricks, direction == 0 || direction == 2 ? 4 : 8, 1, direction);
        this.rotatedBeam(world, rand, x, y + 1, z, 2, 9, this.plank, direction == 0 || direction == 2 ? 4 : 8, 1, direction);
    }

    public void rotatedBeam(World world, Random rand, int x, int y, int z, int a, int b, Block blockType, int blockMeta, int size, int direction) {
        switch (direction) {
            case 0: {
                for (int xx = x + a; xx < x + a + size; ++xx) {
                    world.func_147465_d(xx, y, z + b, blockType, blockMeta, 2);
                }
                break;
            }
            case 1: {
                for (int zz = z + a; zz < z + a + size; ++zz) {
                    world.func_147465_d(x + b, y, zz, blockType, blockMeta, 2);
                }
                break;
            }
            case 2: {
                for (int xx = x + this.length - a - 1; xx > x + this.length - a - size - 1; --xx) {
                    world.func_147465_d(xx, y, z + this.length - b - 1, blockType, blockMeta, 2);
                }
                break;
            }
            case 3: {
                for (int zz = z + this.length - a - 1; zz > z + this.length - a - size - 1; --zz) {
                    world.func_147465_d(x + this.length - b - 1, y, zz, blockType, blockMeta, 2);
                }
                break;
            }
        }
    }

    public void verticalBeam(World world, Random rand, int x, int y, int z, Block blockType, int blockMeta, int size, int direction) {
        for (int yy = y; yy < y + size; ++yy) {
            world.func_147465_d(x, yy, z, blockType, blockMeta, 2);
        }
    }

    public void horizontalBeam(World world, Random rand, int x, int y, int z, Block blockType, int blockMeta, int size, int direction) {
        switch (direction) {
            case 0: {
                for (int xx = x; xx < x + size; ++xx) {
                    world.func_147465_d(xx, y, z, blockType, blockMeta, 2);
                }
                break;
            }
            case 1: {
                for (int zz = z; zz < z + size; ++zz) {
                    world.func_147465_d(x, y, zz, blockType, blockMeta, 2);
                }
                break;
            }
        }
    }
}

