/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.feature.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.tileentities.TileEntityLootPot1;
import thebetweenlands.world.biomes.decorators.data.SurfaceType;
import thebetweenlands.world.loot.LootTables;
import thebetweenlands.world.loot.LootUtil;
import thebetweenlands.world.storage.chunk.storage.StorageHelper;
import thebetweenlands.world.storage.chunk.storage.location.EnumLocationType;
import thebetweenlands.world.storage.chunk.storage.location.LocationStorage;

public class WorldGenSmallRuins
extends WorldGenerator {
    private static final boolean markReplaceableCheck = false;
    private static final int[] stairSequence = new int[]{0, 3, 1, 2};
    private static final int[] upsideDownStairSequence = new int[]{4, 7, 5, 6};
    private static final int[] logSequence = new int[]{4, 8};
    private static final Block angryBetweenstone = BLBlockRegistry.angryBetweenstone;
    private static final Block betweenstoneTiles = BLBlockRegistry.betweenstoneTiles;
    private static final Block betweenstoneBricks = BLBlockRegistry.betweenstoneBricks;
    private static final Block betweenstoneBrickStairs = BLBlockRegistry.betweenstoneBrickStairs;
    private static final Block betweenstoneBrickSlab = BLBlockRegistry.betweenstoneBrickSlab;
    private static final Block chiseledBetweenstone = BLBlockRegistry.chiseledBetweenstone;
    private static final Block betweenstonePillar = BLBlockRegistry.betweenstonePillar;
    private static final Block smoothBetweenstoneWall = BLBlockRegistry.smoothBetweenstoneWall;
    private static final Block weedwoodLog = BLBlockRegistry.weedwoodLog;
    private static final Block weedwoodPlankStairs = BLBlockRegistry.weedwoodPlankStairs;
    private static final Block weedwoodPlankSlab = BLBlockRegistry.weedwoodPlankSlab;
    private int width = -1;
    private int depth = -1;

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        ArrayList<RuinLocation> ruinLocations = new ArrayList<RuinLocation>();
        ArrayList<LocationStorage> generatedLocations = new ArrayList<LocationStorage>();
        block18: for (int attempts = 40; attempts >= 0; --attempts) {
            x = x + random.nextInt(16) - 8;
            z = z + random.nextInt(16) - 8;
            y = y + random.nextInt(8) - 3;
            int randomInt = random.nextInt(7);
            switch (randomInt) {
                case 0: {
                    if (!this.structure1(world, random, x, y, z, false, generatedLocations)) continue block18;
                    ruinLocations.add(new RuinLocation(world, random, x, y, z, randomInt));
                    continue block18;
                }
                case 1: {
                    if (!this.structure2(world, random, x, y, z, false, generatedLocations)) continue block18;
                    ruinLocations.add(new RuinLocation(world, random, x, y, z, randomInt));
                    continue block18;
                }
                case 2: {
                    if (!this.structure3(world, random, x, y, z, false, generatedLocations)) continue block18;
                    ruinLocations.add(new RuinLocation(world, random, x, y, z, randomInt));
                    continue block18;
                }
                case 3: {
                    if (!this.structure4(world, random, x, y, z, false, generatedLocations)) continue block18;
                    ruinLocations.add(new RuinLocation(world, random, x, y, z, randomInt));
                    continue block18;
                }
                case 4: {
                    if (!this.structure5(world, random, x, y, z, false, generatedLocations)) continue block18;
                    ruinLocations.add(new RuinLocation(world, random, x, y, z, randomInt));
                    continue block18;
                }
                case 5: {
                    if (!this.structure6(world, random, x, y, z, false, generatedLocations)) continue block18;
                    ruinLocations.add(new RuinLocation(world, random, x, y, z, randomInt));
                    continue block18;
                }
                case 6: {
                    if (!this.structure7(world, random, x, y, z, false, generatedLocations)) continue block18;
                    ruinLocations.add(new RuinLocation(world, random, x, y, z, randomInt));
                }
            }
        }
        if (ruinLocations.size() >= 3) {
            int sx = Integer.MAX_VALUE;
            int sz = Integer.MAX_VALUE;
            int ex = Integer.MIN_VALUE;
            int ez = Integer.MIN_VALUE;
            for (RuinLocation ruinLocation : ruinLocations) {
                switch (ruinLocation.structureID) {
                    case 0: {
                        this.structure1(ruinLocation.world, ruinLocation.random, ruinLocation.x, ruinLocation.y, ruinLocation.z, true, generatedLocations);
                        break;
                    }
                    case 1: {
                        this.structure2(ruinLocation.world, ruinLocation.random, ruinLocation.x, ruinLocation.y, ruinLocation.z, true, generatedLocations);
                        break;
                    }
                    case 2: {
                        this.structure3(ruinLocation.world, ruinLocation.random, ruinLocation.x, ruinLocation.y, ruinLocation.z, true, generatedLocations);
                        break;
                    }
                    case 3: {
                        this.structure4(ruinLocation.world, ruinLocation.random, ruinLocation.x, ruinLocation.y, ruinLocation.z, true, generatedLocations);
                        break;
                    }
                    case 4: {
                        this.structure5(ruinLocation.world, ruinLocation.random, ruinLocation.x, ruinLocation.y, ruinLocation.z, true, generatedLocations);
                        break;
                    }
                    case 5: {
                        this.structure6(ruinLocation.world, ruinLocation.random, ruinLocation.x, ruinLocation.y, ruinLocation.z, true, generatedLocations);
                        break;
                    }
                    case 6: {
                        this.structure7(ruinLocation.world, ruinLocation.random, ruinLocation.x, ruinLocation.y, ruinLocation.z, true, generatedLocations);
                    }
                }
            }
            for (LocationStorage locationStorage : generatedLocations) {
                locationStorage.setSeed(random.nextLong());
            }
            return true;
        }
        return false;
    }

    private boolean structure1(World world, Random random, int x, int y, int z, boolean doGen, List<LocationStorage> generatedLocations) {
        int height = 9 + random.nextInt(2);
        this.width = 8;
        this.depth = 1;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, height, this.depth, direction)) {
            return false;
        }
        if (!this.rotatedCubeMatches(world, x, y, z, 2, -1, 0, 1, 1, 1, direction, SurfaceType.MIXED) || !this.rotatedCubeMatches(world, x, y, z, 6, -1, 0, 1, 1, 1, direction, SurfaceType.MIXED)) {
            return false;
        }
        if (doGen) {
            this.addLocationArea(world, x, y, z, 0, 0, 0, this.width, height, this.depth, direction, generatedLocations);
            this.rotatedCubeVolume(world, x, y, z, 2, 0, 0, betweenstoneTiles, 0, 1, height - 5, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 0, 0, betweenstoneTiles, 0, 1, height - 5, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 2, height - 5, 0, betweenstoneBricks, 0, 1, 2, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, height - 5, 0, betweenstoneBricks, 0, 1, 4, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 1, height - 5, 0, betweenstoneBrickStairs, this.getMetaFromDirection(0, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 0, height - 4, 0, betweenstoneBrickSlab, 0, 2, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 2, height - 3, 0, betweenstoneBrickStairs, this.getMetaFromDirection(0, direction, stairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 3, height - 3, 0, betweenstoneBrickStairs, this.getMetaFromDirection(2, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 4, height - 3, 0, betweenstoneBrickSlab, 8, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 5, height - 3, 0, betweenstoneBrickStairs, this.getMetaFromDirection(0, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 3, height - 2, 0, betweenstoneBrickSlab, 0, 3, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, height - 1, 0, betweenstoneBrickStairs, this.getMetaFromDirection(0, direction, stairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 7, height - 1, 0, betweenstoneBrickStairs, this.getMetaFromDirection(2, direction, upsideDownStairSequence), 1, 1, 1, direction);
            if (random.nextInt(5) == 0) {
                this.rotatedLoot(world, random, x, y, z, 4, height - 2, 0, direction);
            }
        }
        return true;
    }

    private boolean structure2(World world, Random random, int x, int y, int z, boolean doGen, List<LocationStorage> generatedLocations) {
        int height = 13 + random.nextInt(2);
        this.width = 7;
        this.depth = 1;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, height, this.depth, direction)) {
            return false;
        }
        if (!this.rotatedCubeMatches(world, x, y, z, 2, -1, 0, 1, 1, 1, direction, SurfaceType.MIXED) || !this.rotatedCubeMatches(world, x, y, z, 6, -1, 0, 1, 1, 1, direction, SurfaceType.MIXED)) {
            return false;
        }
        if (doGen) {
            this.addLocationArea(world, x, y, z, 0, 0, 0, this.width, height, this.depth, direction, generatedLocations);
            this.rotatedCubeVolume(world, x, y, z, 2, 0, 0, betweenstoneTiles, 0, 1, height - 9, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 0, 0, betweenstoneTiles, 0, 1, height - 9, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 2, height - 9, 0, betweenstoneBricks, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, height - 9, 0, betweenstoneBricks, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 2, height - 8, 0, chiseledBetweenstone, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, height - 8, 0, chiseledBetweenstone, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 2, height - 7, 0, betweenstoneBricks, 0, 1, 5, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, height - 7, 0, betweenstoneBricks, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 3, height - 6, 0, betweenstoneBrickStairs, this.getMetaFromDirection(2, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 4, height - 6, 0, betweenstoneBrickSlab, 8, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 5, height - 6, 0, betweenstoneBrickStairs, this.getMetaFromDirection(0, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, height - 6, 0, betweenstoneBrickStairs, this.getMetaFromDirection(2, direction, stairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 3, height - 5, 0, betweenstoneBrickSlab, 0, 3, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 2, height - 2, 0, betweenstoneBrickStairs, this.getMetaFromDirection(2, direction, stairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 1, height - 2, 0, betweenstoneBrickStairs, this.getMetaFromDirection(0, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 0, height - 1, 0, betweenstoneBrickSlab, 0, 2, 1, 1, direction);
            if (random.nextInt(5) == 0) {
                this.rotatedCubeVolume(world, x, y, z, 0, height - 1, 0, betweenstoneBricks, 0, 1, 1, 1, direction);
                this.rotatedLoot(world, random, x, y, z, 0, height, 0, direction);
            }
        }
        return true;
    }

    private boolean structure3(World world, Random random, int x, int y, int z, boolean doGen, List<LocationStorage> generatedLocations) {
        this.width = 7;
        this.depth = 5;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, 7, this.depth, direction)) {
            return false;
        }
        if (!(this.rotatedCubeMatches(world, x, y, z, 2, -1, 0, 1, 1, 1, direction, SurfaceType.MIXED) && this.rotatedCubeMatches(world, x, y, z, 6, -1, 0, 1, 1, 1, direction, SurfaceType.MIXED) && this.rotatedCubeMatches(world, x, y, z, 2, -1, 4, 1, 1, 1, direction, SurfaceType.MIXED) && this.rotatedCubeMatches(world, x, y, z, 6, -1, 4, 1, 1, 1, direction, SurfaceType.MIXED))) {
            return false;
        }
        if (doGen) {
            this.addLocationArea(world, x, y, z, 0, 0, 0, this.width, 7, this.depth, direction, generatedLocations);
            this.rotatedCubeVolume(world, x, y, z, 2, 0, 0, betweenstoneTiles, 0, 1, 4, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 0, 0, betweenstoneTiles, 0, 1, 4, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 2, 0, 4, betweenstoneTiles, 0, 1, 4, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 0, 4, betweenstoneTiles, 0, 1, 4, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 1, 4, 0, betweenstoneBrickStairs, this.getMetaFromDirection(0, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 1, 4, 4, betweenstoneBrickStairs, this.getMetaFromDirection(0, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 2, 4, 0, betweenstoneBricks, 0, 1, 2, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 4, 0, betweenstoneBricks, 0, 1, 2, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 2, 4, 4, betweenstoneBricks, 0, 1, 2, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 4, 4, betweenstoneBricks, 0, 1, 2, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 0, 5, 0, betweenstoneBrickSlab, 0, 2, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 3, 5, 0, betweenstoneBrickStairs, this.getMetaFromDirection(2, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 3, 5, 4, betweenstoneBrickStairs, this.getMetaFromDirection(2, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 5, 5, 0, betweenstoneBrickStairs, this.getMetaFromDirection(0, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 5, 5, 4, betweenstoneBrickStairs, this.getMetaFromDirection(0, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 2, 5, 1, betweenstoneBrickStairs, this.getMetaFromDirection(1, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 5, 1, betweenstoneBrickStairs, this.getMetaFromDirection(1, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 2, 5, 3, betweenstoneBrickStairs, this.getMetaFromDirection(3, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 5, 3, betweenstoneBrickStairs, this.getMetaFromDirection(3, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 3, 6, 0, betweenstoneBrickSlab, 0, 3, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 3, 6, 4, betweenstoneBrickSlab, 0, 3, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 2, 6, 1, betweenstoneBrickSlab, 0, 1, 1, 3, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 6, 1, betweenstoneBrickSlab, 0, 1, 1, 3, direction);
            if (random.nextInt(5) == 0) {
                this.rotatedLoot(world, random, x, y, z, 2, 6, 0, direction);
            }
            if (random.nextInt(5) == 0) {
                this.rotatedLoot(world, random, x, y, z, 6, 6, 0, direction);
            }
            if (random.nextInt(5) == 0) {
                this.rotatedLoot(world, random, x, y, z, 2, 6, 4, direction);
            }
            if (random.nextInt(5) == 0) {
                this.rotatedLoot(world, random, x, y, z, 6, 6, 4, direction);
            }
        }
        return true;
    }

    private boolean structure4(World world, Random random, int x, int y, int z, boolean doGen, List<LocationStorage> generatedLocations) {
        int height = 9 + random.nextInt(2);
        int width = 6;
        for (int zz = z; zz < z + width; ++zz) {
            for (int yy = y; yy < y + height; ++yy) {
                for (int xx = x; xx > x - width; --xx) {
                    if (world.func_147439_a(xx, yy, zz) == Blocks.field_150350_a || world.func_147439_a(xx, yy, zz) == BLBlockRegistry.swampWater && yy < y + height - 2) continue;
                    return false;
                }
            }
        }
        if (!(SurfaceType.MIXED.matchBlock(world.func_147439_a(x - width, y - 1, z + 1)) && SurfaceType.MIXED.matchBlock(world.func_147439_a(x - width, y - 1, z + width - 1)) && SurfaceType.MIXED.matchBlock(world.func_147439_a(x - 1, y - 1, z + width)) && SurfaceType.MIXED.matchBlock(world.func_147439_a(x - 1, y - 1, z + width)))) {
            return false;
        }
        if (doGen) {
            int yy;
            generatedLocations.addAll(StorageHelper.addArea(world, "translate:ruins", AxisAlignedBB.func_72330_a((double)(x - width), (double)y, (double)z, (double)x, (double)(y + height), (double)(z + width)).func_72314_b(6.0, 6.0, 6.0), EnumLocationType.RUINS, 0));
            for (yy = y; yy < y + height; ++yy) {
                int zz;
                if (yy <= y + height - 5) {
                    if (yy == y) {
                        world.func_147449_b(x - width, yy, z + 1, BLBlockRegistry.betweenstoneTiles);
                    } else {
                        world.func_147449_b(x - width, yy, z + 1, BLBlockRegistry.betweenstoneBrickWall);
                    }
                    world.func_147449_b(x - width + 1, yy, z + 1, BLBlockRegistry.betweenstoneTiles);
                    continue;
                }
                if (yy == y + height - 4) {
                    world.func_147449_b(x - width, yy, z + 1, BLBlockRegistry.betweenstoneBrickWall);
                    world.func_147449_b(x - width + 1, yy, z + 1, BLBlockRegistry.betweenstoneBricks);
                    continue;
                }
                if (yy != y + height - 3) continue;
                world.func_147465_d(x - width + 1, yy, z + 1, BLBlockRegistry.betweenstoneBrickStairs, 2, 3);
                world.func_147465_d(x - width + 1, yy, z + 2, BLBlockRegistry.betweenstoneBrickStairs, 7, 3);
                world.func_147449_b(x - width + 1, yy + 1, z + 2, (Block)BLBlockRegistry.betweenstoneBrickSlab);
                for (zz = z + 3; zz <= z + width - 3; ++zz) {
                    world.func_147449_b(x - width + 1, yy + 1, zz, (Block)BLBlockRegistry.betweenstoneBrickSlab);
                    world.func_147465_d(x - width + 1, yy, zz, (Block)BLBlockRegistry.betweenstoneBrickSlab, 9, 3);
                }
                world.func_147465_d(x - width + 1, yy, zz, BLBlockRegistry.betweenstoneBrickStairs, 6, 3);
                world.func_147449_b(x - width + 1, yy + 1, zz, (Block)BLBlockRegistry.betweenstoneBrickSlab);
            }
            for (yy = y; yy < y + height; ++yy) {
                int xx;
                if (yy <= y + height - 5) {
                    if (yy == y) {
                        world.func_147449_b(x - width, yy, z + width - 1, BLBlockRegistry.betweenstoneTiles);
                        world.func_147449_b(x - width + 1, yy, z + width, BLBlockRegistry.betweenstoneTiles);
                    } else {
                        world.func_147449_b(x - width, yy, z + width - 1, BLBlockRegistry.betweenstoneBrickWall);
                        world.func_147449_b(x - width + 1, yy, z + width, BLBlockRegistry.betweenstoneBrickWall);
                    }
                    world.func_147449_b(x - width + 1, yy, z + width - 1, BLBlockRegistry.betweenstoneTiles);
                    continue;
                }
                if (yy <= y + height - 2) {
                    if (yy == y + height - 4) {
                        world.func_147449_b(x - width, yy, z + width - 1, BLBlockRegistry.betweenstoneBrickWall);
                        world.func_147449_b(x - width + 1, yy, z + width, BLBlockRegistry.betweenstoneBrickWall);
                    }
                    world.func_147449_b(x - width + 1, yy, z + width - 1, BLBlockRegistry.betweenstoneBricks);
                    continue;
                }
                if (yy > y + height - 1) continue;
                world.func_147449_b(x - width + 1, yy, z + width - 1, BLBlockRegistry.betweenstoneBrickStairs);
                world.func_147465_d(x - width + 2, yy, z + width - 1, BLBlockRegistry.betweenstoneBrickStairs, 5, 3);
                world.func_147449_b(x - width + 2, yy + 1, z + width - 1, (Block)BLBlockRegistry.betweenstoneBrickSlab);
                for (xx = x - width + 3; xx <= x - 3; ++xx) {
                    world.func_147465_d(xx, yy, z + width - 1, (Block)BLBlockRegistry.betweenstoneBrickSlab, 9, 3);
                    if (random.nextInt(8) == 0) {
                        this.generateLoot(world, random, xx, yy + 1, z + width - 1);
                        continue;
                    }
                    world.func_147449_b(xx, yy + 1, z + width - 1, (Block)BLBlockRegistry.betweenstoneBrickSlab);
                }
                world.func_147465_d(xx, yy, z + width - 1, BLBlockRegistry.betweenstoneBrickStairs, 4, 3);
                world.func_147449_b(xx, yy + 1, z + width - 1, (Block)BLBlockRegistry.betweenstoneBrickSlab);
            }
            for (yy = y; yy < y + height; ++yy) {
                if (yy <= y + height - 5) {
                    if (yy == y) {
                        world.func_147449_b(x - 1, yy, z + width, BLBlockRegistry.betweenstoneTiles);
                    } else {
                        world.func_147449_b(x - 1, yy, z + width, BLBlockRegistry.betweenstoneBrickWall);
                    }
                    world.func_147449_b(x - 1, yy, z + width - 1, BLBlockRegistry.betweenstoneTiles);
                    continue;
                }
                if (yy <= y + height - 2) {
                    if (yy == y + height - 4) {
                        world.func_147449_b(x - 1, yy, z + width, BLBlockRegistry.betweenstoneBrickWall);
                    }
                    if (yy == y + height - 3) {
                        world.func_147465_d(x, yy, z + width - 1, BLBlockRegistry.betweenstoneBrickStairs, 5, 3);
                    }
                    world.func_147449_b(x - 1, yy, z + width - 1, BLBlockRegistry.betweenstoneBricks);
                    continue;
                }
                if (yy != y + height - 1) continue;
                world.func_147465_d(x - 1, yy, z + width - 1, BLBlockRegistry.betweenstoneBrickStairs, 1, 3);
            }
        }
        return true;
    }

    private boolean structure5(World world, Random random, int x, int y, int z, boolean doGen, List<LocationStorage> generatedLocations) {
        int height = 5 + random.nextInt(2);
        this.width = 1;
        this.depth = 1;
        int direction = 0;
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, height, this.depth, direction)) {
            return false;
        }
        if (!this.rotatedCubeMatches(world, x, y, z, 0, -1, 0, 1, 1, 1, direction, SurfaceType.MIXED)) {
            return false;
        }
        if (doGen) {
            this.addLocationArea(world, x, y, z, 0, 0, 0, this.width, height, this.depth, direction, generatedLocations);
            this.rotatedCubeVolume(world, x, y, z, 0, 0, 0, chiseledBetweenstone, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 0, 1, 0, betweenstonePillar, 0, 1, height - 2, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 0, height - 1, 0, chiseledBetweenstone, 0, 1, 1, 1, direction);
            if (random.nextInt(5) == 0) {
                this.rotatedLoot(world, random, x, y, z, 0, height, 0, direction);
            }
        }
        return true;
    }

    private boolean structure6(World world, Random random, int x, int y, int z, boolean doGen, List<LocationStorage> generatedLocations) {
        this.width = 5 + random.nextInt(2);
        this.depth = 1;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, 1, this.depth, direction)) {
            return false;
        }
        if (!this.rotatedCubeMatches(world, x, y, z, 0, -1, 0, 1, 1, 1, direction, SurfaceType.MIXED) || !this.rotatedCubeMatches(world, x, y, z, this.width - 1, -1, 0, 1, 1, 1, direction, SurfaceType.MIXED)) {
            return false;
        }
        if (doGen) {
            this.addLocationArea(world, x, y, z, 0, 0, 0, this.width, 1, this.depth, direction, generatedLocations);
            this.rotatedCubeVolume(world, x, y, z, 0, 0, 0, chiseledBetweenstone, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 1, 0, 0, betweenstonePillar, direction == 0 || direction == 2 ? 7 : 8, this.width - 2, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, this.width - 1, 0, 0, chiseledBetweenstone, 0, 1, 1, 1, direction);
            if (random.nextInt(5) == 0) {
                this.rotatedLoot(world, random, x, y, z, 0, 1, 0, direction);
            }
            if (random.nextInt(5) == 0) {
                this.rotatedLoot(world, random, x, y, z, this.width - 1, 1, 0, direction);
            }
        }
        return true;
    }

    private boolean structure7(World world, Random random, int x, int y, int z, boolean doGen, List<LocationStorage> generatedLocations) {
        this.width = 12;
        this.depth = 12;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, 13, this.depth, direction)) {
            return false;
        }
        if (!this.rotatedCubeMatches(world, x, y, z, 0, -1, 0, this.width, 1, this.depth, direction, SurfaceType.MIXED)) {
            return false;
        }
        if (doGen) {
            this.addLocationArea(world, x, y, z, 0, 0, 0, this.width, 13, this.depth, direction, generatedLocations);
            this.rotatedCubeVolume(world, x, y, z, 0, 0, 0, betweenstoneBricks, 0, 1, 1, 4, direction);
            this.rotatedCubeVolume(world, x, y, z, 0, 1, 0, betweenstoneBricks, 0, 1, 1, 3, direction);
            this.rotatedCubeVolume(world, x, y, z, 0, 1, 3, betweenstoneBrickStairs, this.getMetaFromDirection(3, direction, stairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 0, 2, 0, betweenstoneBrickStairs, this.getMetaFromDirection(1, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 0, 2, 1, betweenstoneBricks, 0, 1, 1, 2, direction);
            this.rotatedCubeVolume(world, x, y, z, 0, 2, 3, betweenstoneBrickSlab, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 0, 1, betweenstoneTiles, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 1, 1, smoothBetweenstoneWall, 0, 1, 4, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 0, 1, betweenstoneTiles, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 1, 1, smoothBetweenstoneWall, 0, 1, 4, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 0, 2, betweenstoneTiles, 0, 1, 4, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 4, 2, betweenstoneBricks, 0, 1, 4, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 8, 2, betweenstoneBrickStairs, this.getMetaFromDirection(3, direction, stairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 7, 0, 2, betweenstoneBricks, 0, 1, 7, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 7, 7, 2, betweenstoneBrickStairs, this.getMetaFromDirection(2, direction, stairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 8, 0, 2, betweenstoneBricks, 0, 1, 2, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 8, 2, 2, betweenstoneBrickStairs, this.getMetaFromDirection(2, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 8, 3, 2, betweenstoneBricks, 0, 1, 4, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 9, 0, 2, betweenstoneBricks, 0, 1, 5, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 9, 5, 2, betweenstoneBrickSlab, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 0, 2, betweenstoneTiles, 0, 1, 4, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 4, 2, betweenstoneBrickStairs, this.getMetaFromDirection(1, direction, stairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 11, 0, 2, betweenstoneTiles, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 11, 1, 2, smoothBetweenstoneWall, 0, 1, 3, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 5, 3, weedwoodPlankStairs, this.getMetaFromDirection(1, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 8, 3, betweenstoneBrickStairs, this.getMetaFromDirection(1, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 9, 3, betweenstoneBrickSlab, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 7, 5, 3, weedwoodPlankSlab, 8, 3, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 0, 3, betweenstoneBricks, 0, 1, 6, 3, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 3, 3, betweenstoneBrickStairs, this.getMetaFromDirection(1, direction, stairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 6, 3, betweenstoneBrickSlab, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 5, 4, weedwoodPlankSlab, 8, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 8, 4, betweenstoneBrickSlab, 8, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 9, 4, betweenstoneBrickSlab, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 7, 3, 4, (Block)BLBlockRegistry.rope, 0, 1, 2, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 7, 5, 4, weedwoodLog, this.getMetaFromDirection(0, direction, logSequence), 5, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 9, 4, 4, BLBlockRegistry.weedwoodPlankFence, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 2, 4, chiseledBetweenstone, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 6, 4, betweenstoneBricks, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 5, 5, weedwoodPlankStairs, this.getMetaFromDirection(3, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 8, 5, betweenstoneBrickStairs, this.getMetaFromDirection(3, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 9, 5, betweenstoneBrickSlab, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 7, 5, 5, weedwoodPlankSlab, 8, 3, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 6, 5, betweenstoneBrickStairs, this.getMetaFromDirection(3, direction, stairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 2, 0, 6, betweenstoneTiles, 0, 1, 4, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 2, 4, 6, betweenstoneBricks, 0, 1, 4, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 2, 8, 6, betweenstoneBrickStairs, this.getMetaFromDirection(0, direction, stairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 3, 8, 6, betweenstoneBrickStairs, this.getMetaFromDirection(2, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 3, 9, 6, betweenstoneBrickSlab, 0, 3, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 4, 8, 6, betweenstoneBrickSlab, 8, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 5, 8, 6, betweenstoneBrickStairs, this.getMetaFromDirection(0, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 0, 6, betweenstoneTiles, 0, 1, 4, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 4, 6, betweenstoneBricks, 0, 1, 6, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 10, 6, betweenstoneBrickStairs, this.getMetaFromDirection(1, direction, stairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 7, 5, 6, weedwoodPlankSlab, 8, 3, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 9, 0, 6, betweenstoneBricks, 0, 1, 1, 1, direction);
            this.rotatedLoot(world, random, x, y, z, 9, 1, 6, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 0, 6, betweenstoneTiles, 0, 1, 4, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 4, 6, betweenstoneBricks, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 5, 6, betweenstoneBrickStairs, this.getMetaFromDirection(1, direction, stairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 11, 0, 6, betweenstoneTiles, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 11, 1, 6, smoothBetweenstoneWall, 0, 1, 4, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 8, 7, betweenstoneBrickStairs, this.getMetaFromDirection(1, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 9, 7, betweenstoneBrickSlab, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 7, 0, 7, betweenstoneBricks, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 8, 5, 7, weedwoodPlankSlab, 8, 2, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 0, 7, betweenstoneBricks, 0, 1, 6, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 6, 7, betweenstoneBrickSlab, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 5, 0, 8, betweenstoneBricks, 0, 4, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 8, 8, betweenstoneBrickSlab, 8, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 9, 8, betweenstoneBrickSlab, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 9, 4, 8, BLBlockRegistry.weedwoodPlankFence, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 9, 5, 8, weedwoodLog, this.getMetaFromDirection(0, direction, logSequence), 3, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 0, 8, betweenstoneBricks, 0, 1, 2, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 2, 8, chiseledBetweenstone, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 3, 8, betweenstoneBricks, 0, 1, 2, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 6, 8, betweenstoneBrickSlab, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 3, 0, 9, betweenstoneBricks, 0, 4, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 8, 9, betweenstoneBrickStairs, this.getMetaFromDirection(1, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 9, 9, betweenstoneBrickSlab, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 7, 0, 9, angryBetweenstone, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 8, 0, 9, betweenstoneBricks, 0, 2, 1, 1, direction);
            this.rotatedLoot(world, random, x, y, z, 9, 1, 9, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 0, 9, betweenstoneBricks, 0, 1, 5, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 5, 9, betweenstoneBrickStairs, this.getMetaFromDirection(3, direction, stairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 6, 9, betweenstoneBrickSlab, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 2, 0, 10, betweenstoneTiles, 0, 1, 4, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 2, 4, 10, betweenstoneBrickStairs, this.getMetaFromDirection(0, direction, stairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 3, 0, 10, betweenstoneBricks, 0, 7, 2, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 3, 2, 10, betweenstoneBrickStairs, this.getMetaFromDirection(2, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 4, 2, 10, betweenstoneBricks, 0, 2, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 5, 3, 10, betweenstoneBrickStairs, this.getMetaFromDirection(0, direction, stairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 5, 8, 10, betweenstoneBrickStairs, this.getMetaFromDirection(0, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 5, 9, 10, betweenstoneBrickSlab, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 5, 11, 10, betweenstoneBrickStairs, this.getMetaFromDirection(0, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 4, 12, 10, betweenstoneBrickSlab, 0, 2, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 0, 10, betweenstoneTiles, 0, 1, 4, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 4, 10, betweenstoneBrickStairs, this.getMetaFromDirection(3, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 5, 10, betweenstoneBricks, 0, 1, 6, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 6, 11, 10, betweenstoneBrickStairs, this.getMetaFromDirection(2, direction, stairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 7, 2, 10, betweenstoneBrickStairs, this.getMetaFromDirection(2, direction, stairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 7, 6, 10, betweenstoneBrickStairs, this.getMetaFromDirection(2, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 7, 7, 10, betweenstoneBrickSlab, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 8, 2, 10, betweenstoneBrickSlab, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 8, 6, 10, betweenstoneBrickSlab, 8, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 8, 7, 10, betweenstoneBrickSlab, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 9, 2, 10, betweenstoneBricks, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 9, 6, 10, betweenstoneBrickStairs, this.getMetaFromDirection(0, direction, upsideDownStairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 9, 7, 10, betweenstoneBrickSlab, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 0, 10, betweenstoneTiles, 0, 1, 4, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 4, 10, betweenstoneBricks, 0, 1, 2, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 6, 10, betweenstoneBrickStairs, this.getMetaFromDirection(2, direction, stairSequence), 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 11, 0, 10, betweenstoneTiles, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 11, 1, 10, smoothBetweenstoneWall, 0, 1, 4, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 0, 11, betweenstoneTiles, 0, 1, 1, 1, direction);
            this.rotatedCubeVolume(world, x, y, z, 10, 1, 11, smoothBetweenstoneWall, 0, 1, 4, 1, direction);
        }
        return true;
    }

    private void rotatedCubeVolume(World world, int x, int y, int z, int offsetA, int offsetB, int offsetC, Block blockType, int blockMeta, int sizeWidth, int sizeHeight, int sizeDepth, int direction) {
        x -= this.width / 2;
        z -= this.depth / 2;
        switch (direction) {
            case 0: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + offsetA; xx < x + offsetA + sizeWidth; ++xx) {
                        for (int zz = z + offsetC; zz < z + offsetC + sizeDepth; ++zz) {
                            world.func_147465_d(xx, yy, zz, blockType, blockMeta, 2);
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + this.depth - offsetA - 1; zz > z + this.depth - offsetA - sizeWidth - 1; --zz) {
                        for (int xx = x + offsetC; xx < x + offsetC + sizeDepth; ++xx) {
                            world.func_147465_d(xx, yy, zz, blockType, blockMeta, 2);
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + this.width - offsetA - 1; xx > x + this.width - offsetA - sizeWidth - 1; --xx) {
                        for (int zz = z + this.depth - offsetC - 1; zz > z + this.depth - offsetC - sizeDepth - 1; --zz) {
                            world.func_147465_d(xx, yy, zz, blockType, blockMeta, 2);
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + offsetA; zz < z + offsetA + sizeWidth; ++zz) {
                        for (int xx = x + this.width - offsetC - 1; xx > x + this.width - offsetC - sizeDepth - 1; --xx) {
                            world.func_147465_d(xx, yy, zz, blockType, blockMeta, 2);
                        }
                    }
                }
                break;
            }
        }
    }

    private void rotatedLoot(World world, Random rand, int x, int y, int z, int offsetA, int offsetB, int offsetC, int direction) {
        x -= this.width / 2;
        z -= this.depth / 2;
        switch (direction) {
            case 0: {
                this.generateLoot(world, rand, x + offsetA, y + offsetB, z + offsetC);
                break;
            }
            case 1: {
                this.generateLoot(world, rand, x + offsetC, y + offsetB, z + this.depth - offsetA - 1);
                break;
            }
            case 2: {
                this.generateLoot(world, rand, x + this.width - offsetA - 1, y + offsetB, z + this.depth - offsetC - 1);
                break;
            }
            case 3: {
                this.generateLoot(world, rand, x + this.width - offsetC - 1, y + offsetB, z + offsetA);
            }
        }
    }

    private boolean rotatedCubeCantReplace(World world, int x, int y, int z, int offsetA, int offsetB, int offsetC, int sizeWidth, int sizeHeight, int sizeDepth, int direction) {
        x -= this.width / 2;
        z -= this.depth / 2;
        boolean replaceable = true;
        switch (direction) {
            case 0: {
                if (!world.func_72904_c(x + offsetA - 4, y + offsetB, z + offsetC - 4, x + offsetA + sizeWidth + 4, y + offsetB + sizeHeight, z + offsetC + sizeDepth + 4)) {
                    return true;
                }
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + offsetA; xx < x + offsetA + sizeWidth; ++xx) {
                        for (int zz = z + offsetC; zz < z + offsetC + sizeDepth; ++zz) {
                            if (world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) continue;
                            replaceable = false;
                        }
                    }
                }
                break;
            }
            case 1: {
                if (!world.func_72904_c(x + offsetC - 4, y + offsetB, z + this.depth - offsetA - sizeWidth - 1 - 4, x + offsetC + sizeDepth + 4, y + offsetB + sizeHeight, z + this.depth - offsetA - 1 + 4)) {
                    return true;
                }
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + this.depth - offsetA - 1; zz > z + this.depth - offsetA - sizeWidth - 1; --zz) {
                        for (int xx = x + offsetC; xx < x + offsetC + sizeDepth; ++xx) {
                            if (world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) continue;
                            replaceable = false;
                        }
                    }
                }
                break;
            }
            case 2: {
                if (!world.func_72904_c(x + this.width - offsetA - sizeWidth - 1 - 4, y + offsetB, z + this.depth - offsetC - sizeDepth - 1 - 4, x + this.width - offsetA - 1 + 4, y + offsetB + sizeHeight, z + this.depth - offsetC - 1 + 4)) {
                    return true;
                }
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + this.width - offsetA - 1; xx > x + this.width - offsetA - sizeWidth - 1; --xx) {
                        for (int zz = z + this.depth - offsetC - 1; zz > z + this.depth - offsetC - sizeDepth - 1; --zz) {
                            if (world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) continue;
                            replaceable = false;
                        }
                    }
                }
                break;
            }
            case 3: {
                if (!world.func_72904_c(x + this.width - offsetC - sizeDepth - 1 - 4, y + offsetB, z + offsetA - 4, x + this.width - offsetC - 1 + 4, y + offsetB + sizeHeight, z + offsetA + sizeWidth + 4)) {
                    return true;
                }
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + offsetA; zz < z + offsetA + sizeWidth; ++zz) {
                        for (int xx = x + this.width - offsetC - 1; xx > x + this.width - offsetC - sizeDepth - 1; --xx) {
                            if (world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) continue;
                            replaceable = false;
                        }
                    }
                }
                break;
            }
        }
        return !replaceable;
    }

    private boolean rotatedCubeMatches(World world, int x, int y, int z, int offsetA, int offsetB, int offsetC, int sizeWidth, int sizeHeight, int sizeDepth, int direction, SurfaceType type) {
        x -= this.width / 2;
        z -= this.depth / 2;
        switch (direction) {
            case 0: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + offsetA; xx < x + offsetA + sizeWidth; ++xx) {
                        for (int zz = z + offsetC; zz < z + offsetC + sizeDepth; ++zz) {
                            if (type.matchBlock(world.func_147439_a(xx, yy, zz))) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + this.depth - offsetA - 1; zz > z + this.depth - offsetA - sizeWidth - 1; --zz) {
                        for (int xx = x + offsetC; xx < x + offsetC + sizeDepth; ++xx) {
                            if (type.matchBlock(world.func_147439_a(xx, yy, zz))) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + this.width - offsetA - 1; xx > x + this.width - offsetA - sizeWidth - 1; --xx) {
                        for (int zz = z + this.depth - offsetC - 1; zz > z + this.depth - offsetC - sizeDepth - 1; --zz) {
                            if (type.matchBlock(world.func_147439_a(xx, yy, zz))) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + offsetA; zz < z + offsetA + sizeWidth; ++zz) {
                        for (int xx = x + this.width - offsetC - 1; xx > x + this.width - offsetC - sizeDepth - 1; --xx) {
                            if (type.matchBlock(world.func_147439_a(xx, yy, zz))) continue;
                            return false;
                        }
                    }
                }
                break;
            }
        }
        return true;
    }

    private boolean addLocationArea(World world, int x, int y, int z, int offsetA, int offsetB, int offsetC, int sizeWidth, int sizeHeight, int sizeDepth, int direction, List<LocationStorage> addedLocations) {
        x -= this.width / 2;
        z -= this.depth / 2;
        switch (direction) {
            case 0: {
                addedLocations.addAll(StorageHelper.addArea(world, "translate:ruins", AxisAlignedBB.func_72330_a((double)(x + offsetA), (double)(y + offsetB), (double)(z + offsetC), (double)(x + offsetA + sizeWidth), (double)(y + offsetB + sizeHeight), (double)(z + offsetC + sizeDepth)).func_72314_b(6.0, 6.0, 6.0), EnumLocationType.RUINS, 0));
                break;
            }
            case 1: {
                addedLocations.addAll(StorageHelper.addArea(world, "translate:ruins", AxisAlignedBB.func_72330_a((double)(x + offsetC), (double)(y + offsetB), (double)(z + this.depth - offsetA - sizeWidth - 1), (double)(x + offsetC + sizeDepth), (double)(y + offsetB + sizeHeight), (double)(z + this.depth - offsetA - 1)).func_72314_b(6.0, 6.0, 6.0), EnumLocationType.RUINS, 0));
                break;
            }
            case 2: {
                addedLocations.addAll(StorageHelper.addArea(world, "translate:ruins", AxisAlignedBB.func_72330_a((double)(x + this.width - offsetA - sizeWidth - 1), (double)(y + offsetB), (double)(z + this.depth - offsetC - sizeDepth - 1), (double)(x + this.width - offsetA - 1), (double)(y + offsetB + sizeHeight), (double)(z + this.depth - offsetC - 1)).func_72314_b(6.0, 6.0, 6.0), EnumLocationType.RUINS, 0));
                break;
            }
            case 3: {
                addedLocations.addAll(StorageHelper.addArea(world, "translate:ruins", AxisAlignedBB.func_72330_a((double)(x + this.width - offsetC - sizeDepth - 1), (double)(y + offsetB), (double)(z + offsetA), (double)(x + this.width - offsetC - 1), (double)(y + offsetB + sizeHeight), (double)(z + offsetA + sizeWidth)).func_72314_b(6.0, 6.0, 6.0), EnumLocationType.RUINS, 0));
            }
        }
        return true;
    }

    private void generateLoot(World world, Random random, int x, int y, int z) {
        int randDirection = random.nextInt(4) + 2;
        world.func_147465_d(x, y, z, this.getRandomBlock(random), randDirection, 3);
        TileEntityLootPot1 lootPot = (TileEntityLootPot1)world.func_147438_o(x, y, z);
        if (lootPot != null) {
            LootUtil.generateLoot((IInventory)lootPot, random, LootTables.COMMON_POT_LOOT, 1, 2);
        }
    }

    private Block getRandomBlock(Random rand) {
        switch (rand.nextInt(3)) {
            case 0: {
                return BLBlockRegistry.lootPot1;
            }
            case 1: {
                return BLBlockRegistry.lootPot2;
            }
            case 2: {
                return BLBlockRegistry.lootPot3;
            }
        }
        return BLBlockRegistry.lootPot1;
    }

    private int getMetaFromDirection(int start, int direction, int[] sequence) {
        return sequence[(direction + start) % sequence.length];
    }

    private static class RuinLocation {
        World world;
        Random random;
        int x;
        int y;
        int z;
        int structureID;

        RuinLocation(World world, Random random, int x, int y, int z, int structureID) {
            this.world = world;
            this.random = random;
            this.x = x;
            this.y = y;
            this.z = z;
            this.structureID = structureID;
        }
    }
}

