/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.feature.structure;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemDoor;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.BlockBLDoor;
import thebetweenlands.world.biomes.decorators.data.SurfaceType;

public class WorldGenSmallHut
extends WorldGenerator {
    private static int[] ladderSequence = new int[]{3, 5, 2, 4};
    private static int[] slopeSequence = new int[]{0, 3, 1, 2};
    private static int[] upsideDownSlopeSequence = new int[]{4, 7, 5, 6};
    private static int[] doorSequence = new int[]{0, 3, 2, 1};
    private static Block weedwoodPlankFence = BLBlockRegistry.weedwoodPlankFence;
    private static Block weedwoodPlanks = BLBlockRegistry.weedwoodPlanks;
    private static Block weedwoodLog = BLBlockRegistry.weedwoodLog;
    private int width = -1;
    private int depth = -1;

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        return this.hut(world, random, x, y, z);
    }

    public boolean hut(World world, Random random, int x, int y, int z) {
        this.width = 12;
        this.depth = 10;
        int direction = random.nextInt(4);
        this.rotatedCubeVolume(world, x, y, z, 1, 3, 0, BLBlockRegistry.pitstoneBrickStairs, this.getMetaFromDirection(3, direction, slopeSequence), 7, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 3, 1, BLBlockRegistry.pitstoneBrickStairs, this.getMetaFromDirection(0, direction, slopeSequence), 1, 1, 6, direction);
        this.rotatedCubeVolume(world, x, y, z, 2, 3, 6, BLBlockRegistry.pitstoneBrickStairs, this.getMetaFromDirection(1, direction, slopeSequence), 6, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 7, 3, 1, BLBlockRegistry.pitstoneBrickStairs, this.getMetaFromDirection(2, direction, slopeSequence), 1, 1, 5, direction);
        return true;
    }

    public void rotatedCubeVolume(World world, int x, int y, int z, int offsetA, int offsetB, int offsetC, Block blockType, int blockMeta, int sizeWidth, int sizeHeight, int sizeDepth, int direction) {
        x -= this.width / 2;
        z -= this.depth / 2;
        switch (direction) {
            case 0: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + offsetA; xx < x + offsetA + sizeWidth; ++xx) {
                        for (int zz = z + offsetC; zz < z + offsetC + sizeDepth; ++zz) {
                            world.func_147465_d(xx, yy, zz, blockType, blockMeta, 2);
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + this.depth - offsetA - 1; zz > z + this.depth - offsetA - sizeWidth - 1; --zz) {
                        for (int xx = x + offsetC; xx < x + offsetC + sizeDepth; ++xx) {
                            world.func_147465_d(xx, yy, zz, blockType, blockMeta, 2);
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + this.width - offsetA - 1; xx > x + this.width - offsetA - sizeWidth - 1; --xx) {
                        for (int zz = z + this.depth - offsetC - 1; zz > z + this.depth - offsetC - sizeDepth - 1; --zz) {
                            world.func_147465_d(xx, yy, zz, blockType, blockMeta, 2);
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + offsetA; zz < z + offsetA + sizeWidth; ++zz) {
                        for (int xx = x + this.width - offsetC - 1; xx > x + this.width - offsetC - sizeDepth - 1; --xx) {
                            world.func_147465_d(xx, yy, zz, blockType, blockMeta, 2);
                        }
                    }
                }
                break;
            }
        }
    }

    public void rotatedCubeDoor(World world, int x, int y, int z, int offsetA, int offsetB, int offsetC, BlockBLDoor door, int direction) {
        x -= this.width / 2;
        z -= this.depth / 2;
        switch (direction) {
            case 0: {
                ItemDoor.func_150924_a((World)world, (int)(x + offsetA), (int)(y + offsetB), (int)(z + offsetC), (int)this.getMetaFromDirection(1, direction, doorSequence), (Block)door);
                break;
            }
            case 1: {
                ItemDoor.func_150924_a((World)world, (int)(x + offsetC), (int)(y + offsetB), (int)(z + this.depth - offsetA - 1), (int)this.getMetaFromDirection(1, direction, doorSequence), (Block)door);
                break;
            }
            case 2: {
                ItemDoor.func_150924_a((World)world, (int)(x + this.width - offsetA - 1), (int)(y + offsetB), (int)(z + this.depth - offsetC - 1), (int)this.getMetaFromDirection(1, direction, doorSequence), (Block)door);
                break;
            }
            case 3: {
                ItemDoor.func_150924_a((World)world, (int)(x + this.width - offsetC - 1), (int)(y + offsetB), (int)(z + offsetA), (int)this.getMetaFromDirection(1, direction, doorSequence), (Block)door);
            }
        }
    }

    public boolean rotatedCubeCantReplace(World world, int x, int y, int z, int offsetA, int offsetB, int offsetC, int sizeWidth, int sizeHeight, int sizeDepth, int direction) {
        x -= this.width / 2;
        z -= this.depth / 2;
        boolean replaceable = true;
        switch (direction) {
            case 0: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + offsetA; xx < x + offsetA + sizeWidth; ++xx) {
                        for (int zz = z + offsetC; zz < z + offsetC + sizeDepth; ++zz) {
                            if (world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) continue;
                            replaceable = false;
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + this.depth - offsetA - 1; zz > z + this.depth - offsetA - sizeWidth - 1; --zz) {
                        for (int xx = x + offsetC; xx < x + offsetC + sizeDepth; ++xx) {
                            if (world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) continue;
                            replaceable = false;
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + this.width - offsetA - 1; xx > x + this.width - offsetA - sizeWidth - 1; --xx) {
                        for (int zz = z + this.depth - offsetC - 1; zz > z + this.depth - offsetC - sizeDepth - 1; --zz) {
                            if (world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) continue;
                            replaceable = false;
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + offsetA; zz < z + offsetA + sizeWidth; ++zz) {
                        for (int xx = x + this.width - offsetC - 1; xx > x + this.width - offsetC - sizeDepth - 1; --xx) {
                            if (world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) continue;
                            replaceable = false;
                        }
                    }
                }
                break;
            }
        }
        return !replaceable;
    }

    public boolean rotatedCubeMatches(World world, int x, int y, int z, int offsetA, int offsetB, int offsetC, int sizeWidth, int sizeHeight, int sizeDepth, int direction, SurfaceType type) {
        x -= this.width / 2;
        z -= this.depth / 2;
        switch (direction) {
            case 0: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + offsetA; xx < x + offsetA + sizeWidth; ++xx) {
                        for (int zz = z + offsetC; zz < z + offsetC + sizeDepth; ++zz) {
                            if (type.matchBlock(world.func_147439_a(xx, yy, zz))) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + this.depth - offsetA - 1; zz > z + this.depth - offsetA - sizeWidth - 1; --zz) {
                        for (int xx = x + offsetC; xx < x + offsetC + sizeDepth; ++xx) {
                            if (type.matchBlock(world.func_147439_a(xx, yy, zz))) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + this.width - offsetA - 1; xx > x + this.width - offsetA - sizeWidth - 1; --xx) {
                        for (int zz = z + this.depth - offsetC - 1; zz > z + this.depth - offsetC - sizeDepth - 1; --zz) {
                            if (type.matchBlock(world.func_147439_a(xx, yy, zz))) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + offsetA; zz < z + offsetA + sizeWidth; ++zz) {
                        for (int xx = x + this.width - offsetC - 1; xx > x + this.width - offsetC - sizeDepth - 1; --xx) {
                            if (type.matchBlock(world.func_147439_a(xx, yy, zz))) continue;
                            return false;
                        }
                    }
                }
                break;
            }
        }
        return true;
    }

    public int getMetaFromDirection(int start, int direction, int[] sequence) {
        return sequence[(direction + start) % sequence.length];
    }
}

