/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.feature.structure;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.tileentities.TileEntityLootPot1;
import thebetweenlands.world.biomes.decorators.data.SurfaceType;
import thebetweenlands.world.loot.LootTables;
import thebetweenlands.world.loot.LootUtil;

public class WorldGenMudStructures
extends WorldGenerator {
    private static final int[] stairSequence = new int[]{0, 3, 1, 2};
    private static final int[] upsideDownStairSequence = new int[]{4, 7, 5, 6};
    private static final Block mudBrick = BLBlockRegistry.mudBrick;
    private static final Block mudBrickSlab = BLBlockRegistry.mudBrickSlab;
    private static final Block mudBrickStair = BLBlockRegistry.mudBrickStairs;
    private static final Block mudFlowerPot = BLBlockRegistry.mudFlowerPot;
    private static final Block rottenBark = BLBlockRegistry.rottenWeedwoodBark;
    private static final Block mudBrickWall = BLBlockRegistry.mudBrickWall;
    private int width = -1;
    private int depth = -1;

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int randomInt = random.nextInt(3);
        switch (randomInt) {
            case 0: {
                return this.structure1(world, random, x, y, z);
            }
            case 1: {
                return this.structure2(world, random, x, y, z);
            }
            case 2: {
                return this.structure3(world, random, x, y, z);
            }
        }
        return false;
    }

    private boolean structure1(World world, Random random, int x, int y, int z) {
        this.width = 7;
        this.depth = 5;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, 2, this.depth, direction)) {
            return false;
        }
        if (!this.rotatedCubeMatches(world, x, y, z, 0, -1, 0, this.width, 1, this.depth, direction, SurfaceType.MIXED)) {
            return false;
        }
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 0, mudBrick, 0, 4, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 0, mudBrickStair, this.getMetaFromDirection(3, direction, stairSequence), 3, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 3, 1, 0, mudFlowerPot, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 1, mudBrickStair, this.getMetaFromDirection(0, direction, stairSequence), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 1, mudBrick, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 6, 0, 1, mudBrickSlab, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 3, mudBrick, 0, 1, 1, 2, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 3, mudBrickStair, this.getMetaFromDirection(0, direction, stairSequence), 1, 1, 2, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 4, mudBrick, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 4, mudBrickStair, this.getMetaFromDirection(1, direction, stairSequence), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, 0, 4, mudBrick, 0, 3, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, 1, 4, mudBrickSlab, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 5, 1, 4, mudBrickStair, this.getMetaFromDirection(1, direction, stairSequence), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 6, 1, 4, mudBrickStair, this.getMetaFromDirection(2, direction, stairSequence), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 6, 0, 3, mudBrick, 0, 1, 1, 1, direction);
        this.rotatedLoot(world, random, x, y, z, 5, 0, 3, direction, 1, 3, 2);
        return true;
    }

    private boolean structure2(World world, Random random, int x, int y, int z) {
        this.width = 6;
        this.depth = 6;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, 2, this.depth, direction)) {
            return false;
        }
        if (!this.rotatedCubeMatches(world, x, y, z, 0, -1, 0, this.width, 1, this.depth, direction, SurfaceType.MIXED)) {
            return false;
        }
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 0, mudBrick, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 0, mudBrickStair, this.getMetaFromDirection(3, direction, stairSequence), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 1, mudBrick, 0, 1, 1, 5, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 1, mudBrickStair, this.getMetaFromDirection(0, direction, stairSequence), 1, 1, 5, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 1, mudBrick, 0, 1, 2, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 2, 1, mudBrickSlab, 0, 4, 1, 4, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 5, mudBrick, 0, 5, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 5, mudBrickStair, this.getMetaFromDirection(1, direction, stairSequence), 5, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, 0, 1, mudBrick, 0, 1, 2, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 5, 0, 1, mudBrick, 0, 1, 1, 5, direction);
        this.rotatedCubeVolume(world, x, y, z, 5, 1, 1, mudBrickStair, this.getMetaFromDirection(2, direction, stairSequence), 1, 1, 4, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, 0, 0, mudBrick, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, 1, 0, mudBrickStair, this.getMetaFromDirection(3, direction, stairSequence), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 2, mudBrickStair, this.getMetaFromDirection(2, direction, upsideDownStairSequence), 1, 1, 3, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, 1, 2, mudBrickStair, this.getMetaFromDirection(0, direction, upsideDownStairSequence), 1, 1, 3, direction);
        this.rotatedLoot(world, random, x, y, z, 1, 0, 2, direction, 1, 2, 3);
        this.rotatedLoot(world, random, x, y, z, 1, 0, 3, direction, 1, 2, 3);
        this.rotatedLoot(world, random, x, y, z, 1, 0, 4, direction, 1, 2, 3);
        this.rotatedLoot(world, random, x, y, z, 4, 0, 2, direction, 1, 2, 3);
        this.rotatedLoot(world, random, x, y, z, 4, 0, 3, direction, 1, 2, 3);
        this.rotatedLoot(world, random, x, y, z, 4, 0, 4, direction, 1, 2, 3);
        return true;
    }

    private boolean structure3(World world, Random random, int x, int y, int z) {
        this.width = 8;
        this.depth = 8;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, 2, this.depth, direction)) {
            return false;
        }
        if (!this.rotatedCubeMatches(world, x, y, z, 0, -1, 0, this.width, 1, this.depth, direction, SurfaceType.MIXED)) {
            return false;
        }
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 1, mudBrick, 0, 4, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 1, mudBrickStair, this.getMetaFromDirection(3, direction, stairSequence), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 2, 2, 1, rottenBark, 0, 1, 1, 7, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, 1, 1, mudBrick, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, 2, 1, mudBrickStair, this.getMetaFromDirection(0, direction, stairSequence), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 6, 0, 1, mudBrick, 0, 1, 2, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 7, 0, 1, mudBrick, 0, 1, 1, 6, direction);
        this.rotatedCubeVolume(world, x, y, z, 7, 0, 0, mudBrickStair, this.getMetaFromDirection(3, direction, stairSequence), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 2, mudBrick, 0, 3, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 2, mudBrickStair, this.getMetaFromDirection(0, direction, stairSequence), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 2, mudBrick, 0, 2, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 2, 2, mudBrickStair, this.getMetaFromDirection(3, direction, stairSequence), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 3, 2, 2, mudBrickSlab, 8, 1, 1, 4, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 2, 3, mudBrickSlab, 8, 1, 1, 3, direction);
        this.rotatedCubeVolume(world, x, y, z, 2, 0, 3, mudBrick, 0, 1, 2, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 7, 1, 3, mudBrickStair, this.getMetaFromDirection(3, direction, stairSequence), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 4, 2, 4, mudBrickSlab, 8, 1, 1, 2, direction);
        this.rotatedCubeVolume(world, x, y, z, 7, 0, 4, mudBrick, 0, 1, 2, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 2, 0, 5, mudBrick, 0, 1, 2, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 5, 2, 5, rottenBark, 0, 1, 1, 3, direction);
        this.rotatedCubeVolume(world, x, y, z, 6, 0, 5, BLBlockRegistry.geckoCage, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 6, mudBrick, 0, 4, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 6, mudBrickStair, this.getMetaFromDirection(0, direction, stairSequence), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 6, mudBrick, 0, 3, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 1, 2, 6, mudBrick, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 3, 2, 6, mudBrick, 0, 2, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 5, 0, 6, mudBrick, 0, 2, 2, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 6, 2, 6, mudBrickStair, this.getMetaFromDirection(2, direction, stairSequence), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, x, y, z, 7, 1, 6, mudBrickSlab, 0, 1, 1, 1, direction);
        this.rotatedLoot(world, random, x, y, z, 1, 0, 3, direction, 1, 4, 2);
        return true;
    }

    private void rotatedCubeVolume(World world, int x, int y, int z, int offsetA, int offsetB, int offsetC, Block blockType, int blockMeta, int sizeWidth, int sizeHeight, int sizeDepth, int direction) {
        x -= this.width / 2;
        z -= this.depth / 2;
        switch (direction) {
            case 0: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + offsetA; xx < x + offsetA + sizeWidth; ++xx) {
                        for (int zz = z + offsetC; zz < z + offsetC + sizeDepth; ++zz) {
                            world.func_147465_d(xx, yy, zz, blockType, blockMeta, 2);
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + this.depth - offsetA - 1; zz > z + this.depth - offsetA - sizeWidth - 1; --zz) {
                        for (int xx = x + offsetC; xx < x + offsetC + sizeDepth; ++xx) {
                            world.func_147465_d(xx, yy, zz, blockType, blockMeta, 2);
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + this.width - offsetA - 1; xx > x + this.width - offsetA - sizeWidth - 1; --xx) {
                        for (int zz = z + this.depth - offsetC - 1; zz > z + this.depth - offsetC - sizeDepth - 1; --zz) {
                            world.func_147465_d(xx, yy, zz, blockType, blockMeta, 2);
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + offsetA; zz < z + offsetA + sizeWidth; ++zz) {
                        for (int xx = x + this.width - offsetC - 1; xx > x + this.width - offsetC - sizeDepth - 1; --xx) {
                            world.func_147465_d(xx, yy, zz, blockType, blockMeta, 2);
                        }
                    }
                }
                break;
            }
        }
    }

    private void rotatedLoot(World world, Random rand, int x, int y, int z, int offsetA, int offsetB, int offsetC, int direction, int min, int max, int chance) {
        x -= this.width / 2;
        z -= this.depth / 2;
        if (rand.nextInt(chance) == 0) {
            return;
        }
        switch (direction) {
            case 0: {
                this.generateLoot(world, rand, x + offsetA, y + offsetB, z + offsetC, min, max);
                break;
            }
            case 1: {
                this.generateLoot(world, rand, x + offsetC, y + offsetB, z + this.depth - offsetA - 1, min, max);
                break;
            }
            case 2: {
                this.generateLoot(world, rand, x + this.width - offsetA - 1, y + offsetB, z + this.depth - offsetC - 1, min, max);
                break;
            }
            case 3: {
                this.generateLoot(world, rand, x + this.width - offsetC - 1, y + offsetB, z + offsetA, min, max);
            }
        }
    }

    private boolean rotatedCubeCantReplace(World world, int x, int y, int z, int offsetA, int offsetB, int offsetC, int sizeWidth, int sizeHeight, int sizeDepth, int direction) {
        x -= this.width / 2;
        z -= this.depth / 2;
        boolean replaceable = true;
        switch (direction) {
            case 0: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + offsetA; xx < x + offsetA + sizeWidth; ++xx) {
                        for (int zz = z + offsetC; zz < z + offsetC + sizeDepth; ++zz) {
                            if (world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) continue;
                            replaceable = false;
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + this.depth - offsetA - 1; zz > z + this.depth - offsetA - sizeWidth - 1; --zz) {
                        for (int xx = x + offsetC; xx < x + offsetC + sizeDepth; ++xx) {
                            if (world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) continue;
                            replaceable = false;
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + this.width - offsetA - 1; xx > x + this.width - offsetA - sizeWidth - 1; --xx) {
                        for (int zz = z + this.depth - offsetC - 1; zz > z + this.depth - offsetC - sizeDepth - 1; --zz) {
                            if (world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) continue;
                            replaceable = false;
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + offsetA; zz < z + offsetA + sizeWidth; ++zz) {
                        for (int xx = x + this.width - offsetC - 1; xx > x + this.width - offsetC - sizeDepth - 1; --xx) {
                            if (world.func_147439_a(xx, yy, zz).isReplaceable((IBlockAccess)world, xx, yy, zz)) continue;
                            replaceable = false;
                        }
                    }
                }
                break;
            }
        }
        return !replaceable;
    }

    private boolean rotatedCubeMatches(World world, int x, int y, int z, int offsetA, int offsetB, int offsetC, int sizeWidth, int sizeHeight, int sizeDepth, int direction, SurfaceType type) {
        x -= this.width / 2;
        z -= this.depth / 2;
        switch (direction) {
            case 0: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + offsetA; xx < x + offsetA + sizeWidth; ++xx) {
                        for (int zz = z + offsetC; zz < z + offsetC + sizeDepth; ++zz) {
                            if (type.matchBlock(world.func_147439_a(xx, yy, zz))) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + this.depth - offsetA - 1; zz > z + this.depth - offsetA - sizeWidth - 1; --zz) {
                        for (int xx = x + offsetC; xx < x + offsetC + sizeDepth; ++xx) {
                            if (type.matchBlock(world.func_147439_a(xx, yy, zz))) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + this.width - offsetA - 1; xx > x + this.width - offsetA - sizeWidth - 1; --xx) {
                        for (int zz = z + this.depth - offsetC - 1; zz > z + this.depth - offsetC - sizeDepth - 1; --zz) {
                            if (type.matchBlock(world.func_147439_a(xx, yy, zz))) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + offsetA; zz < z + offsetA + sizeWidth; ++zz) {
                        for (int xx = x + this.width - offsetC - 1; xx > x + this.width - offsetC - sizeDepth - 1; --xx) {
                            if (type.matchBlock(world.func_147439_a(xx, yy, zz))) continue;
                            return false;
                        }
                    }
                }
                break;
            }
        }
        return true;
    }

    private void generateLoot(World world, Random random, int x, int y, int z, int min, int max) {
        int randDirection = random.nextInt(4) + 2;
        world.func_147465_d(x, y, z, this.getRandomBlock(random), randDirection, 3);
        TileEntityLootPot1 lootPot = (TileEntityLootPot1)world.func_147438_o(x, y, z);
        if (lootPot != null) {
            LootUtil.generateLoot((IInventory)lootPot, random, LootTables.COMMON_POT_LOOT, min, max);
        }
    }

    private Block getRandomBlock(Random rand) {
        switch (rand.nextInt(3)) {
            case 0: {
                return BLBlockRegistry.lootPot1;
            }
            case 1: {
                return BLBlockRegistry.lootPot2;
            }
            case 2: {
                return BLBlockRegistry.lootPot3;
            }
        }
        return BLBlockRegistry.lootPot1;
    }

    private int getMetaFromDirection(int start, int direction, int[] sequence) {
        return sequence[(direction + start) % sequence.length];
    }
}

