/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.feature.structure;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.utils.confighandler.ConfigHandler;

public class WorldGenDruidCircle
implements IWorldGenerator {
    private final int height = 4;
    private final int baseRadius = 6;
    private final int checkRadius = 32;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == 0) {
            this.generate(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private void generate(World world, Random random, int startX, int startZ) {
        for (int xo = 7; xo <= 25; ++xo) {
            for (int zo = 7; zo <= 25; ++zo) {
                Block block;
                int x = startX + xo;
                int z = startZ + zo;
                if (!world.func_72904_c(x - 6 - 1, 64, z - 6 - 1, x + 6 + 1, 64, z + 6 + 1)) continue;
                BiomeGenBase biomeBase = world.func_72807_a(x, z);
                int newY = world.func_72976_f(x, z);
                if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biomeBase, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || (block = world.func_147439_a(x, newY, z)) == null || block != biomeBase.field_76752_A || random.nextInt(ConfigHandler.DRUID_CIRCLE_FREQUENCY) != 0 || !this.generateStructure(world, random, x, newY + 1, z)) continue;
                return;
            }
        }
    }

    public boolean generateStructure(World world, Random rand, int x, int y, int z) {
        int newZ;
        int newX;
        for (newX = x - 6; newX <= x + 6; ++newX) {
            for (newZ = z - 6; newZ <= z + 6; ++newZ) {
                for (int newY = y + 1; newY < y + 4; ++newY) {
                    if (world.func_147437_c(newX, newY, newZ) || world.func_147439_a(newX, newY, newZ).isReplaceable((IBlockAccess)world, newX, newY, newZ)) continue;
                    return false;
                }
            }
        }
        for (newX = -6; newX <= 6; ++newX) {
            for (newZ = -6; newZ <= 6; ++newZ) {
                double dSq = newX * newX + newZ * newZ;
                if (Math.round(Math.sqrt(dSq)) == 6L && newX % 2 == 0 && newZ % 2 == 0) {
                    this.placePillar(world, x + newX, y, z + newZ, rand);
                } else if (Math.round(Math.sqrt(dSq)) == 6L && newX % 2 != 0 && newZ % 2 != 0) {
                    this.placeAir(world, x + newX, y, z + newZ);
                }
                if (Math.round(Math.sqrt(dSq)) > 6L) continue;
                world.func_147449_b(x + newX, y - 1, z + newZ, (Block)Blocks.field_150349_c);
            }
        }
        world.func_147449_b(x, y, z, BLBlockRegistry.druidAltar);
        world.func_147449_b(x, y - 1, z, BLBlockRegistry.druidSpawner);
        return true;
    }

    private void placeAir(World world, int x, int y, int z) {
        for (int yNew = y; 4 + y >= yNew; ++yNew) {
            world.func_147449_b(x, yNew, z, Blocks.field_150350_a);
        }
    }

    private void placePillar(World world, int x, int y, int z, Random rand) {
        int randHeight = rand.nextInt(3) + 3;
        for (int yy = y; randHeight + y >= yy; ++yy) {
            int randDirection = rand.nextInt(4);
            if (rand.nextBoolean()) {
                world.func_147465_d(x, yy, z, this.getRandomBlock(rand), randDirection, 3);
                continue;
            }
            world.func_147449_b(x, yy, z, Blocks.field_150348_b);
            for (int vineCount = 0; vineCount < 4; ++vineCount) {
                this.setRandomFoliage(world, x, yy, z, rand);
            }
        }
    }

    private void setRandomFoliage(World world, int x, int y, int z, Random rand) {
        switch (rand.nextInt(4)) {
            case 0: {
                if (world.func_147439_a(x + 1, y, z) != Blocks.field_150350_a) break;
                world.func_147465_d(x + 1, y, z, Blocks.field_150395_bd, 2, 3);
                break;
            }
            case 1: {
                if (world.func_147439_a(x - 1, y, z) != Blocks.field_150350_a) break;
                world.func_147465_d(x - 1, y, z, Blocks.field_150395_bd, 8, 3);
                break;
            }
            case 2: {
                if (world.func_147439_a(x, y, z + 1) != Blocks.field_150350_a) break;
                world.func_147465_d(x, y, z + 1, Blocks.field_150395_bd, 4, 3);
                break;
            }
            case 3: {
                if (world.func_147439_a(x, y, z - 1) != Blocks.field_150350_a) break;
                world.func_147465_d(x, y, z - 1, Blocks.field_150395_bd, 1, 3);
            }
        }
    }

    private Block getRandomBlock(Random rand) {
        switch (rand.nextInt(5)) {
            case 0: {
                return BLBlockRegistry.druidStone1;
            }
            case 1: {
                return BLBlockRegistry.druidStone2;
            }
            case 2: {
                return BLBlockRegistry.druidStone3;
            }
            case 3: {
                return BLBlockRegistry.druidStone4;
            }
            case 4: {
                return BLBlockRegistry.druidStone5;
            }
        }
        return Blocks.field_150348_b;
    }
}

