/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.feature.plants;

import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.util.ForgeDirection;
import thebetweenlands.blocks.BLBlockRegistry;

public class WorldGenMossPatch
extends WorldGenerator {
    boolean blockPlaced = false;
    private int mossType = -1;

    public WorldGenMossPatch(int type) {
        super(true);
        this.mossType = type;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        this.placeBlockAt(world, rand, x, y, z);
        if (this.blockPlaced) {
            this.createPatch(world, rand, x, y, z);
        }
        return true;
    }

    private void placeBlockAt(World world, Random rand, int x, int y, int z) {
        int offset = 1;
        int metaMapped = 0;
        int randomiseSide = rand.nextInt(6);
        if (this.mossType == 1) {
            metaMapped += 6;
        }
        switch (randomiseSide) {
            case 0: {
                if (!world.isSideSolid(x, y + offset, z, ForgeDirection.DOWN) || !this.isValidBlock(world, x, y + offset, z)) break;
                world.func_147465_d(x, y, z, BLBlockRegistry.wallPlants, metaMapped + 2, 2);
                this.blockPlaced = true;
                break;
            }
            case 1: {
                if (!world.isSideSolid(x, y - offset, z, ForgeDirection.UP) || !this.isValidBlock(world, x, y - offset, z)) break;
                world.func_147465_d(x, y, z, BLBlockRegistry.wallPlants, metaMapped + 3, 2);
                this.blockPlaced = true;
                break;
            }
            case 2: {
                if (!world.isSideSolid(x, y, z + offset, ForgeDirection.NORTH) || !this.isValidBlock(world, x, y, z + offset)) break;
                world.func_147465_d(x, y, z, BLBlockRegistry.wallPlants, metaMapped + 4, 2);
                this.blockPlaced = true;
                break;
            }
            case 3: {
                if (!world.isSideSolid(x, y, z - offset, ForgeDirection.SOUTH) || !this.isValidBlock(world, x, y, z - offset)) break;
                world.func_147465_d(x, y, z, BLBlockRegistry.wallPlants, metaMapped + 5, 2);
                this.blockPlaced = true;
                break;
            }
            case 4: {
                if (!world.isSideSolid(x + offset, y, z, ForgeDirection.WEST) || !this.isValidBlock(world, x + offset, y, z)) break;
                world.func_147465_d(x, y, z, BLBlockRegistry.wallPlants, metaMapped + 6, 2);
                this.blockPlaced = true;
                break;
            }
            case 5: {
                if (!world.isSideSolid(x - offset, y, z, ForgeDirection.EAST) || !this.isValidBlock(world, x - offset, y, z)) break;
                world.func_147465_d(x, y, z, BLBlockRegistry.wallPlants, metaMapped + 7, 2);
                this.blockPlaced = true;
                break;
            }
            default: {
                this.blockPlaced = false;
            }
        }
    }

    private void createPatch(World world, Random rand, int x, int y, int z) {
        int radius = 2;
        for (int xx = x - radius; xx <= x + radius; ++xx) {
            for (int zz = z - radius; zz <= z + radius; ++zz) {
                for (int yy = y - radius; yy <= y + radius; ++yy) {
                    if (!world.func_147437_c(xx, yy, zz)) continue;
                    for (int attempt = 0; attempt < 3; ++attempt) {
                        this.placeBlockAt(world, rand, xx, yy, zz);
                    }
                }
            }
        }
    }

    private boolean isValidBlock(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).func_149721_r();
    }
}

