/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.feature.gen.cave;

import java.util.ArrayList;
import java.util.Random;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.world.feature.gen.cave.WorldGenCave;

public class WorldGenThorns
extends WorldGenCave {
    private Block thorns = BLBlockRegistry.thorns;
    private static final int MIN_RADIUS = 2;
    private static final int MAX_RADIUS = 3;
    private static final int LENGTH_RANGE = 5;
    private static final int MIN_LENGTH = 2;
    private static final int MAX_HEIGHT = 8;

    public WorldGenThorns() {
        this(false);
    }

    public WorldGenThorns(boolean doBlockNotify) {
        super(doBlockNotify);
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int bz;
        if (!this.isGoodStart(world, x, y, z)) {
            return false;
        }
        int radius = random.nextInt(2) + 2;
        int radiusSq = radius * radius;
        Stack<ChunkCoordinates> searching = new Stack<ChunkCoordinates>();
        ArrayList<ChunkCoordinates> checked = new ArrayList<ChunkCoordinates>();
        ArrayList<WorldGenCave.PlantLocation> locations = new ArrayList<WorldGenCave.PlantLocation>();
        ChunkCoordinates start = new ChunkCoordinates(x, y - 1, z);
        searching.push(start);
        checked.add(start);
        while (!searching.isEmpty()) {
            ChunkCoordinates pos = (ChunkCoordinates)searching.pop();
            float distSq = (pos.field_71574_a - x) * (pos.field_71574_a - x) + (pos.field_71573_c - z) * (pos.field_71573_c - z);
            if (random.nextFloat() > distSq / (float)radiusSq) {
                locations.add(new WorldGenCave.PlantLocation(world, pos));
            }
            for (ForgeDirection dir : this.directions) {
                ChunkCoordinates p;
                int bx = pos.field_71574_a + dir.offsetX;
                bz = pos.field_71573_c + dir.offsetZ;
                if ((bx - x) * (bx - x) + (bz - z) * (bz - z) > radiusSq) continue;
                if (this.supports(world, bx, pos.field_71572_b + 1, bz)) {
                    p = new ChunkCoordinates(bx, pos.field_71572_b, bz);
                    if (checked.contains(p)) continue;
                    searching.push(p);
                    checked.add(p);
                    continue;
                }
                if (!this.supports(world, bx, pos.field_71572_b, bz) || checked.contains(p = new ChunkCoordinates(bx, pos.field_71572_b - 1, bz))) continue;
                searching.push(p);
                checked.add(p);
            }
        }
        if (locations.size() < 5) {
            return false;
        }
        int maximumHeight = 0;
        for (WorldGenCave.PlantLocation location : locations) {
            if (location.getHeight() <= maximumHeight) continue;
            maximumHeight = location.getHeight();
        }
        if (maximumHeight < 3) {
            return false;
        }
        int[] facesWithThorns = new int[4];
        for (WorldGenCave.PlantLocation location : locations) {
            ChunkCoordinates pos = location.getPos();
            int bx = pos.field_71574_a;
            int by = pos.field_71572_b;
            bz = pos.field_71573_c;
            int sideCount = 0;
            int metadata = 0;
            for (int n = 0; n < this.directions.length; ++n) {
                ForgeDirection face = this.directions[n];
                int cx = bx + face.offsetX;
                int cy = by + face.offsetY;
                int cz = bz + face.offsetZ;
                if (!this.isValidBlock(world, cx, cy, cz) || !world.isSideSolid(cx, cy, cz, face)) continue;
                int side = 1 << n;
                facesWithThorns[sideCount++] = side;
                metadata |= side;
            }
            this.func_150516_a(world, bx, by, bz, this.thorns, metadata);
            if (metadata <= 0 || location.getHeight() <= 1) continue;
            int hangingMetadata = facesWithThorns[random.nextInt(sideCount)];
            int length = random.nextInt(location.getHeight() > 8 ? 8 : location.getHeight() - 1) + 1;
            for (int n = 1; n < length; ++n) {
                this.func_150516_a(world, bx, by - n, bz, this.thorns, hangingMetadata);
            }
        }
        return true;
    }
}

