/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.feature.gen.cave;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.Stack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.utils.CubicBezier;
import thebetweenlands.world.feature.gen.cave.WorldGenCave;

public class WorldGenCaveMoss
extends WorldGenCave {
    private static final CubicBezier HEIGHT_CDF = new CubicBezier(0.75f, 0.0f, 0.9f, 1.0f);
    private static final int MIN_RADIUS = 3;
    private static final int MAX_RADIUS = 6;
    private static final int MAX_HEIGHT = 5;

    public WorldGenCaveMoss() {
        super(false);
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int i;
        if (!this.isGoodStart(world, x, y, z)) {
            return false;
        }
        int radius = random.nextInt(4) + 3;
        int radiusSq = radius * radius;
        Stack<ChunkCoordinates> searching = new Stack<ChunkCoordinates>();
        ArrayList<ChunkCoordinates> checked = new ArrayList<ChunkCoordinates>();
        ArrayList<WorldGenCave.PlantLocation> locations = new ArrayList<WorldGenCave.PlantLocation>();
        ChunkCoordinates start = new ChunkCoordinates(x, y - 1, z);
        searching.push(start);
        checked.add(start);
        while (!searching.isEmpty()) {
            ChunkCoordinates pos = (ChunkCoordinates)searching.pop();
            float distSq = (pos.field_71574_a - x) * (pos.field_71574_a - x) + (pos.field_71573_c - z) * (pos.field_71573_c - z);
            if (random.nextFloat() > distSq / (float)radiusSq) {
                locations.add(new WorldGenCave.PlantLocation(world, pos));
            }
            for (ForgeDirection dir : this.directions) {
                ChunkCoordinates p;
                int bx = pos.field_71574_a + dir.offsetX;
                int bz = pos.field_71573_c + dir.offsetZ;
                if ((bx - x) * (bx - x) + (bz - z) * (bz - z) > radiusSq || !this.supports(world, bx, pos.field_71572_b + 1, bz) || checked.contains(p = new ChunkCoordinates(bx, pos.field_71572_b, bz))) continue;
                searching.push(p);
                checked.add(p);
            }
        }
        if (locations.size() < 3) {
            return false;
        }
        float[] heights = new float[locations.size()];
        for (i = 0; i < locations.size(); ++i) {
            heights[i] = HEIGHT_CDF.eval((float)i / (float)(locations.size() - 1));
        }
        Collections.shuffle(locations, random);
        for (i = 0; i < locations.size(); ++i) {
            WorldGenCave.PlantLocation location = (WorldGenCave.PlantLocation)locations.get(i);
            ChunkCoordinates pos = location.getPos();
            int bx = pos.field_71574_a;
            int by = pos.field_71572_b;
            int bz = pos.field_71573_c;
            int height = location.getHeight();
            if (height > 5) {
                height = 5;
            }
            height = (int)(heights[i] * (float)(height - 1) + 1.0f);
            for (int dy = 0; dy < height; ++dy) {
                this.func_150516_a(world, bx, by - dy, bz, BLBlockRegistry.caveMoss, dy < height - 1 ? 0 : 1);
            }
        }
        return true;
    }
}

