/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.feature.gen.cave;

import java.util.ArrayList;
import java.util.Random;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.world.feature.gen.cave.WorldGenCave;

public class WorldGenCaveGrass
extends WorldGenCave {
    private static final int MIN_RADIUS = 2;
    private static final int MAX_RADIUS = 7;

    public WorldGenCaveGrass() {
        super(false);
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        if (!this.canPlaceGrass(world, x, y, z)) {
            return false;
        }
        int radius = random.nextInt(6) + 2;
        int radiusSq = radius * radius;
        Stack<ChunkCoordinates> searching = new Stack<ChunkCoordinates>();
        ArrayList<ChunkCoordinates> checked = new ArrayList<ChunkCoordinates>();
        ArrayList<ChunkCoordinates> locations = new ArrayList<ChunkCoordinates>();
        ChunkCoordinates start = new ChunkCoordinates(x, y, z);
        searching.push(start);
        checked.add(start);
        while (!searching.isEmpty()) {
            ChunkCoordinates pos = (ChunkCoordinates)searching.pop();
            float distSq = (pos.field_71574_a - x) * (pos.field_71574_a - x) + (pos.field_71573_c - z) * (pos.field_71573_c - z);
            if (random.nextFloat() / 1.4f > distSq / (float)radiusSq) {
                locations.add(pos);
            }
            for (ForgeDirection dir : this.directions) {
                ChunkCoordinates p;
                int bx = pos.field_71574_a + dir.offsetX;
                int bz = pos.field_71573_c + dir.offsetZ;
                if ((bx - x) * (bx - x) + (bz - z) * (bz - z) > radiusSq) continue;
                if (this.canPlaceGrass(world, bx, pos.field_71572_b + 1, bz)) {
                    p = new ChunkCoordinates(bx, pos.field_71572_b + 1, bz);
                    if (checked.contains(p)) continue;
                    searching.push(p);
                    checked.add(p);
                    continue;
                }
                if (this.canPlaceGrass(world, bx, pos.field_71572_b, bz)) {
                    p = new ChunkCoordinates(bx, pos.field_71572_b, bz);
                    if (checked.contains(p)) continue;
                    searching.push(p);
                    checked.add(p);
                    continue;
                }
                if (!this.canPlaceGrass(world, bx, pos.field_71572_b - 1, bz) || checked.contains(p = new ChunkCoordinates(bx, pos.field_71572_b - 1, bz))) continue;
                searching.push(p);
                checked.add(p);
            }
        }
        if (locations.size() < 3) {
            return false;
        }
        for (ChunkCoordinates pos : locations) {
            this.func_150516_a(world, pos.field_71574_a, pos.field_71572_b, pos.field_71573_c, (Block)BLBlockRegistry.caveGrass, 0);
        }
        return true;
    }

    private boolean canPlaceGrass(World world, int x, int y, int z) {
        return world.func_147437_c(x, y, z) && BLBlockRegistry.caveGrass.func_149854_a(world.func_147439_a(x, y - 1, z));
    }
}

